/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.PaintChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.IntHolder;
import hu.belicza.andras.sc2gears.util.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class ChartPainter {
    private static final String[] NUMBER_STRINGS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final Color COLOR_BACKGROUND = Color.BLACK;
    private static final Color COLOR_AXIS = Color.YELLOW;
    private static final Color COLOR_ASSIST_LINES = new Color(60, 60, 60);
    private static final Color COLOR_AXIS_LABELS = Color.CYAN;
    private static final Color COLOR_PLAYER_DEFAULT = Color.WHITE;
    private static final Color COLOR_CHART_MARKER = new Color(150, 150, 255);
    private static final Stroke STROKE_DEFAULT = new BasicStroke();
    private static final Stroke STROKE_DASHED = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 1.0f);
    private static final Stroke STROKE_DOUBLE_WIDTH = new BasicStroke(2.0f);
    private static final Stroke STROKE_DOUBLE_WIDTH_ROUNDED = new BasicStroke(2.0f, 0, 1);
    private static final int ASSIST_LINES_MIN_DISTANCE = 20;
    private static final int TIME_LABELS_MIN_DISTANCE = 100;
    private final Graphics2D g2;
    private final PaintChartParams params;
    private final StringBuilder[] descriptionBuilders;
    private int[] xPoints;
    private int[] yPoints;

    public ChartPainter(PaintChartParams paintChartParams) {
        this.g2 = paintChartParams.g2;
        this.params = paintChartParams;
        this.params.calcualteDerivedData(COLOR_PLAYER_DEFAULT);
        this.descriptionBuilders = new StringBuilder[this.params.playerColors.length];
    }

    public void paintChart() {
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setBackground(COLOR_BACKGROUND);
        this.g2.clearRect(0, 0, this.params.width, this.params.height);
        if (this.params.playersCount == 0 || this.params.chartDX <= 0 || this.params.replay.frames == 0) {
            return;
        }
        Details.Player[] players = this.params.replay.details.players;
        int i = 0;
        while (i < this.descriptionBuilders.length) {
            StringBuilder stringBuilder = this.descriptionBuilders[i] = this.params.playerColors[i] == null ? null : new StringBuilder();
            if (this.descriptionBuilders[i] != null) {
                Details.Player player = players[i];
                this.descriptionBuilders[i].append(player.name).append(" (").append((player.race == ReplayConsts.Race.RANDOM ? player.raceString : player.raceString()).charAt(0)).append(')');
            }
            ++i;
        }
        this.paintAxis();
        switch (this.params.chartType) {
            case APM: {
                this.paintApmChart();
                break;
            }
            case HOTKEYS: {
                this.paintHotkeysChart();
                break;
            }
            case BUILDS_TECH: {
                this.paintBuildsTechChart();
                break;
            }
            case BUILDS_TECH_STAT: {
                this.paintBuildsTechStatChart();
            }
        }
        this.paintPlayerDescriptions();
        if (this.params.markerX == null && this.params.markerFrame != null) {
            this.params.markerX = this.params.frameToX(this.params.markerFrame);
        }
        if (this.params.markerX != null) {
            this.g2.setColor(COLOR_CHART_MARKER);
            this.g2.setStroke(STROKE_DASHED);
            this.g2.drawLine(this.params.markerX, 0, this.params.markerX, this.params.height - 1);
            this.g2.setStroke(STROKE_DEFAULT);
        }
    }

    private void paintAxis() {
        this.g2.setColor(COLOR_AXIS);
        int i = this.params.chartsCount - 1;
        while (i >= 0) {
            this.g2.drawLine(25 + this.params.visibleRectangle.x, this.params.chartY1s[i], 25 + this.params.visibleRectangle.x, this.params.chartY2s[i]);
            this.g2.drawLine(25, this.params.chartY2s[i] + 1, this.params.chartX2, this.params.chartY2s[i] + 1);
            --i;
        }
        int fontAscent = this.g2.getFontMetrics().getAscent();
        int labelsCount = this.params.chartWidth < 100 ? 1 : this.params.chartWidth / 100;
        int i2 = this.params.chartsCount - 1;
        while (i2 >= 0) {
            int j = labelsCount;
            while (j >= 0) {
                int x = this.params.chartX1 + j * this.params.chartDX / labelsCount;
                int frame = j == 0 ? 0 : (j == labelsCount ? this.params.replay.frames : this.params.xToFrame(x));
                String label = this.params.displayInSeconds ? ReplayUtils.formatFramesShort(frame) : Integer.toString(frame);
                this.g2.setColor(COLOR_AXIS);
                this.g2.drawLine(x, this.params.chartY2s[i2] + 1, x, this.params.chartY2s[i2] + 3);
                this.g2.setColor(COLOR_AXIS_LABELS);
                this.g2.drawString(label, x - (this.g2.getFontMetrics().stringWidth(label) >> (j == labelsCount ? 0 : 1)), this.params.chartY2s[i2] + fontAscent);
                --j;
            }
            --i2;
        }
    }

    private void paintApmChart() {
        int[] yPoints;
        GameEvents.Action[] actions = this.params.actions;
        int chartPoints = this.params.width / this.params.apmGranularity + (this.params.width % this.params.apmGranularity != 0 ? 1 : 0);
        int[][] yPointss = new int[this.params.playerColors.length][];
        int i = 0;
        while (i < yPointss.length) {
            yPointss[i] = this.params.playerChartIndices[i] < 0 ? null : new int[chartPoints];
            ++i;
        }
        int[] playerActionsCount = new int[this.params.playerColors.length];
        int i2 = actions.length - 1;
        while (i2 >= 0) {
            GameEvents.Action action = actions[i2];
            if (action.type != ReplayConsts.ActionType.INACTION && (yPoints = yPointss[action.player]) != null) {
                int n = (this.params.frameToX(action.frame) - 25) / this.params.apmGranularity;
                yPoints[n] = yPoints[n] + 1;
                byte by = action.player;
                playerActionsCount[by] = playerActionsCount[by] + 1;
            }
            --i2;
        }
        i2 = 0;
        while (i2 < playerActionsCount.length) {
            if (this.descriptionBuilders[i2] != null) {
                int lastActionFrame = this.params.replay.details.players[i2].lastActionFrame;
                this.descriptionBuilders[i2].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.actions", playerActionsCount[i2])).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.apm", lastActionFrame == 0 ? 0L : (long)playerActionsCount[i2] * 3840L / (long)lastActionFrame));
            }
            ++i2;
        }
        int[] maxActionCounts = new int[this.params.playerColors.length];
        int i3 = 0;
        while (i3 < yPointss.length) {
            if (yPointss[i3] != null) {
                maxActionCounts[i3] = GeneralUtils.maxValue(yPointss[i3]);
            }
            ++i3;
        }
        if (this.params.allPlayersOnOneChart) {
            Arrays.fill(maxActionCounts, GeneralUtils.maxValue(maxActionCounts));
        }
        i3 = 0;
        while (i3 < yPointss.length) {
            yPoints = yPointss[i3];
            if (yPoints != null) {
                int chartY2 = this.params.chartY2s[this.params.playerChartIndices[i3]];
                int maxActionsCount = maxActionCounts[i3];
                if (maxActionsCount > 0) {
                    int j = yPoints.length - 1;
                    while (j >= 0) {
                        yPoints[j] = chartY2 - this.params.chartHeight * yPoints[j] / maxActionsCount;
                        --j;
                    }
                } else {
                    Arrays.fill(yPoints, chartY2);
                }
            }
            ++i3;
        }
        int fontAscent = this.g2.getFontMetrics().getAscent();
        int frameGranularity = this.params.xToFrame(25 + this.params.apmGranularity - 1);
        int assistLinesCount = this.params.chartHeight < 20 ? 1 : this.params.chartHeight / 20;
        this.g2.setStroke(STROKE_DASHED);
        int i4 = this.params.chartsCount - 1;
        while (i4 >= 0) {
            int j = assistLinesCount - 1;
            while (j >= 0) {
                int y = this.params.chartY1s[i4] + j * this.params.chartDY / assistLinesCount;
                this.g2.setColor(COLOR_ASSIST_LINES);
                this.g2.drawLine(this.params.chartX1 + 1 + this.params.visibleRectangle.x, y, this.params.chartX2, y);
                this.g2.setColor(COLOR_AXIS_LABELS);
                int apm = (int)(frameGranularity < 1 ? 1L : (long)(assistLinesCount - j) * (long)maxActionCounts[this.params.chartPlayerIndices[i4]] * 3840L / (long)(assistLinesCount * frameGranularity));
                this.g2.drawString(Integer.toString(apm), this.params.visibleRectangle.x, y + (fontAscent >> 1) - 1);
                --j;
            }
            --i4;
        }
        this.g2.setStroke(STROKE_DEFAULT);
        this.g2.setStroke(this.params.apmApproximation == ReplayAnalyzer.GraphApproximation.LINEAR ? STROKE_DOUBLE_WIDTH_ROUNDED : STROKE_DOUBLE_WIDTH);
        int[] xPoints = new int[chartPoints];
        int x = 25 - this.params.apmGranularity;
        int i5 = 0;
        while (i5 < xPoints.length) {
            xPoints[i5] = x += this.params.apmGranularity;
            ++i5;
        }
        i5 = 0;
        while (i5 < yPointss.length) {
            yPoints = yPointss[i5];
            if (yPoints != null) {
                this.g2.setColor(this.params.playerColors[i5]);
                int j1 = Math.max(0, (this.params.visibleRectangle.x - 25) / this.params.apmGranularity);
                int j2 = Math.min(xPoints.length - 1, (this.params.visibleRectangle.x + this.params.visibleRectangle.width - 1) / this.params.apmGranularity + 1);
                switch (this.params.apmApproximation) {
                    case LINEAR: {
                        int j = j1;
                        while (j < j2) {
                            this.g2.drawLine(xPoints[j], yPoints[j], xPoints[j + 1], yPoints[j + 1]);
                            ++j;
                        }
                        break;
                    }
                    case CUBIC: {
                        Rectangle oldClipBounds = this.g2.getClipBounds();
                        if (oldClipBounds == null) {
                            this.g2.setClip(this.params.chartX1, this.params.chartY1s[this.params.playerChartIndices[i5]], this.params.chartWidth, this.params.chartHeight);
                        } else {
                            this.g2.setClip(oldClipBounds.intersection(new Rectangle(this.params.chartX1, this.params.chartY1s[this.params.playerChartIndices[i5]], this.params.chartWidth, this.params.chartHeight)));
                        }
                        CubicCurve2D.Float cubicCurve = new CubicCurve2D.Float();
                        this.xPoints = xPoints;
                        this.yPoints = yPoints;
                        Point2D.Float p = new Point2D.Float();
                        Point2D.Float p1 = new Point2D.Float();
                        Point2D.Float p2 = new Point2D.Float();
                        Point2D.Float p3 = new Point2D.Float();
                        float s = 0.25f;
                        this.getCP(j1, p);
                        this.getCP(j1 + 1, p1);
                        this.getCP(j1 + 2, p2);
                        int j = j1;
                        while (j < j2) {
                            this.getCP(j + 3, p3);
                            cubicCurve.setCurve(p1.x, p1.y, -0.25f * p.x + p1.x + 0.25f * p2.x, -0.25f * p.y + p1.y + 0.25f * p2.y, 0.25f * p1.x + p2.x - 0.25f * p3.x, 0.25f * p1.y + p2.y - 0.25f * p3.y, p2.x, p2.y);
                            this.g2.draw(cubicCurve);
                            Point2D.Float pTemp = p;
                            p = p1;
                            p1 = p2;
                            p2 = p3;
                            p3 = pTemp;
                            ++j;
                        }
                        this.g2.setClip(oldClipBounds);
                    }
                }
            }
            ++i5;
        }
        this.g2.setStroke(STROKE_DEFAULT);
    }

    private void getCP(int i, Point2D.Float p) {
        if (i == 0) {
            p.setLocation(-0.5f * (float)this.xPoints[0] + 1.5f * (float)this.xPoints[1], -0.5f * (float)this.yPoints[0] + 1.5f * (float)this.yPoints[1]);
        } else {
            int l = this.xPoints.length;
            if (i == l + 1) {
                p.setLocation(-0.5f * (float)this.xPoints[l - 1] + 1.5f * (float)this.xPoints[l - 2], -0.5f * (float)this.yPoints[l - 1] + 1.5f * (float)this.yPoints[l - 2]);
            } else {
                p.setLocation(this.xPoints[i - 1], this.yPoints[i - 1]);
            }
        }
    }

    private void paintHotkeysChart() {
        int fontAscent = this.g2.getFontMetrics().getAscent();
        int numberWidth = this.g2.getFontMetrics().charWidth('8');
        boolean chartIsHeightEnough = this.params.chartHeight >= 10 * fontAscent;
        Color[] playerInvertedColors = new Color[this.params.playerColors.length];
        int i = 0;
        while (i < playerInvertedColors.length) {
            Color playerColor = this.params.playerColors[i];
            if (playerColor != null) {
                float[] hsb = Color.RGBtoHSB(playerColor.getRed(), playerColor.getGreen(), playerColor.getBlue(), null);
                playerInvertedColors[i] = new Color(Color.HSBtoRGB(1.0f - hsb[0], hsb[1], 1.0f - hsb[2]));
            }
            ++i;
        }
        int[] playerHotkeysAssignCounts = new int[this.params.playerColors.length];
        int[] playerHotkeysSelectCounts = this.params.showSelectHotkeys ? new int[this.params.playerColors.length] : null;
        GameEvents.Action[] actions = this.params.actions;
        ArrayList<Pair<Rectangle, String>> toolTipList = new ArrayList<Pair<Rectangle, String>>(64);
        Map<Short, String> unitTypeNameMap = this.params.replay.gameEvents.unitTypeNameMap;
        List[] playerSelectionLists = new List[this.params.playerColors.length];
        List[][] playerHotkeysSelectionLists = new List[this.params.playerColors.length][];
        int i2 = 0;
        while (i2 < playerSelectionLists.length) {
            List list = playerSelectionLists[i2] = this.params.playerChartIndices[i2] < 0 ? null : new ArrayList();
            if (this.params.playerChartIndices[i2] < 0) {
                playerHotkeysSelectionLists[i2] = null;
            } else {
                playerHotkeysSelectionLists[i2] = new List[10];
                int j = 0;
                while (j < 10) {
                    playerHotkeysSelectionLists[i2][j] = new ArrayList();
                    ++j;
                }
            }
            ++i2;
        }
        int verticalShift = fontAscent + (chartIsHeightEnough ? this.params.chartHeight / 10 - fontAscent >> 1 : 0) - 2;
        int actionsLength = actions.length;
        int i3 = 0;
        while (i3 < actionsLength) {
            GameEvents.Action action = actions[i3];
            int chartIndex = this.params.playerChartIndices[action.player];
            if (chartIndex >= 0) {
                short unitType;
                List playerSelection;
                if (action instanceof GameEvents.SelectAction) {
                    playerSelection = playerSelectionLists[action.player];
                    GameEvents.SelectAction sa = (GameEvents.SelectAction)action;
                    int removedCounter = 0;
                    int bitmapElement = 0;
                    int bitIndex = 0;
                    while (bitIndex < sa.deselectionBitsCount) {
                        if ((bitIndex & 7) == 0) {
                            bitmapElement = sa.deselectionUnitBitmap[bitIndex >> 3] & 0xFF;
                        }
                        if ((bitmapElement & 0x80) != 0) {
                            if (bitIndex - removedCounter >= playerSelection.size()) break;
                            playerSelection.remove(bitIndex - removedCounter++);
                        }
                        bitmapElement <<= 1;
                        ++bitIndex;
                    }
                    int j = 0;
                    while (j < sa.unitTypes.length) {
                        unitType = sa.unitTypes[j];
                        int k = sa.unitsOfTypeCounts[j];
                        while (k > 0) {
                            playerSelection.add(unitType);
                            --k;
                        }
                        ++j;
                    }
                } else if (action instanceof GameEvents.HotkeyAction) {
                    playerSelection = playerSelectionLists[action.player];
                    boolean isSelect = ((GameEvents.HotkeyAction)action).isSelect;
                    int number = (action.opCode & 0xFF) >> 4;
                    if (isSelect) {
                        playerSelection.clear();
                        playerSelection.addAll(playerHotkeysSelectionLists[action.player][number]);
                    } else {
                        playerHotkeysSelectionLists[action.player][number].clear();
                        playerHotkeysSelectionLists[action.player][number].addAll(playerSelection);
                    }
                    if (this.params.showSelectHotkeys || !isSelect) {
                        this.g2.setColor(this.params.playerColors[action.player]);
                        int x = this.params.frameToX(action.frame);
                        int y = this.params.chartY1s[chartIndex] + (chartIsHeightEnough ? number * this.params.chartHeight / 10 : number * (this.params.chartHeight - fontAscent) / 9) + verticalShift;
                        if (!isSelect) {
                            this.g2.fillRect(x, y - fontAscent + 2, numberWidth, fontAscent);
                            this.g2.setColor(playerInvertedColors[action.player]);
                            StringBuilder tooltipBuilder = new StringBuilder();
                            int index = 0;
                            while (index < playerSelection.size()) {
                                if (tooltipBuilder.length() > 0) {
                                    tooltipBuilder.append(", ");
                                }
                                unitType = (Short)playerSelection.get(index++);
                                int count = 1;
                                while (index < playerSelection.size() && (Short)playerSelection.get(index) == unitType) {
                                    ++count;
                                    ++index;
                                }
                                String unitName = unitTypeNameMap.get(unitType);
                                if (unitName == null) {
                                    tooltipBuilder.append("Unknown[").append(Integer.toHexString(unitType)).append(']');
                                } else {
                                    tooltipBuilder.append(unitName);
                                }
                                if (count <= 1) continue;
                                tooltipBuilder.append(" x").append(count);
                            }
                            toolTipList.add(new Pair<Rectangle, String>(new Rectangle(x, y - fontAscent + 2, numberWidth, fontAscent), tooltipBuilder.toString()));
                        }
                        this.g2.drawString(NUMBER_STRINGS[number], x, y);
                        int[] nArray = isSelect ? playerHotkeysSelectCounts : playerHotkeysAssignCounts;
                        byte by = action.player;
                        nArray[by] = nArray[by] + 1;
                    }
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < playerHotkeysAssignCounts.length) {
            if (this.descriptionBuilders[i3] != null) {
                if (this.params.showSelectHotkeys) {
                    this.descriptionBuilders[i3].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.hotkeys", playerHotkeysAssignCounts[i3] + playerHotkeysSelectCounts[i3])).append(" (").append(Language.getText("module.repAnalyzer.tab.charts.chartText.assign", playerHotkeysAssignCounts[i3])).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.select", playerHotkeysSelectCounts[i3])).append(')');
                } else {
                    this.descriptionBuilders[i3].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.hotkeysAssign", playerHotkeysAssignCounts[i3]));
                }
            }
            ++i3;
        }
        this.params.toolTipProvider = new PaintChartParams.ToolTipProvider(toolTipList);
    }

    private void paintBuildsTechChart() {
        GameEvents.Action[] actions = this.params.actions;
        EnumSet<ReplayConsts.ActionType> displayActionTypeSet = EnumSet.noneOf(ReplayConsts.ActionType.class);
        if (this.params.showBuilds) {
            displayActionTypeSet.add(ReplayConsts.ActionType.BUILD);
        }
        if (this.params.showTrains) {
            displayActionTypeSet.add(ReplayConsts.ActionType.TRAIN);
        }
        if (this.params.showResearches) {
            displayActionTypeSet.add(ReplayConsts.ActionType.RESEARCH);
        }
        if (this.params.showUpgrades) {
            displayActionTypeSet.add(ReplayConsts.ActionType.UPGRADE);
        }
        int entityHeight = this.params.useIcons ? Icons.getBuildingIcon(ReplayConsts.Building.NEXUS, IconHandler.Size.MEDIUM).getIconHeight() : this.g2.getFontMetrics().getAscent();
        int MAX_LEVEL = Math.max(1, (this.params.chartDY - 7) / entityHeight);
        int[] buildCounts = this.params.showBuilds ? new int[this.params.playerColors.length] : null;
        int[] trainCounts = this.params.showTrains ? new int[this.params.playerColors.length] : null;
        int[] workerCounts = this.params.showWorkers ? new int[this.params.playerColors.length] : null;
        int[] researchCounts = this.params.showResearches ? new int[this.params.playerColors.length] : null;
        int[] upgradeCounts = this.params.showUpgrades ? new int[this.params.playerColors.length] : null;
        ArrayList<Pair<Rectangle, String>> toolTipList = this.params.useIcons ? new ArrayList<Pair<Rectangle, String>>(64) : null;
        int[] chartLevelCounters = new int[this.params.allPlayersOnOneChart ? 1 : this.params.chartsCount];
        if (MAX_LEVEL > 2) {
            Arrays.fill(chartLevelCounters, 1);
        }
        int i = 0;
        while (i < actions.length) {
            block22: {
                int chartIndex;
                GameEvents.Action action;
                block23: {
                    ReplayConsts.Unit unit;
                    action = actions[i];
                    chartIndex = this.params.playerChartIndices[action.player];
                    if (chartIndex < 0 || !displayActionTypeSet.contains((Object)action.type)) break block22;
                    if (action.type != ReplayConsts.ActionType.TRAIN || (unit = ((GameEvents.TrainAction)action).unit) != ReplayConsts.Unit.SCV && unit != ReplayConsts.Unit.DRONE && unit != ReplayConsts.Unit.PROBE) break block23;
                    if (!this.params.showWorkers) break block22;
                    byte by = action.player;
                    workerCounts[by] = workerCounts[by] + 1;
                }
                ReplayConsts.Unit entity = action.type == ReplayConsts.ActionType.TRAIN ? ((GameEvents.TrainAction)action).unit : (action.type == ReplayConsts.ActionType.BUILD ? ((GameEvents.BuildAction)action).building : (action.type == ReplayConsts.ActionType.RESEARCH ? ((GameEvents.ResearchAction)action).research : ((GameEvents.UpgradeAction)action).upgrade));
                String text = ((Object)((Object)entity)).toString();
                int[] nArray = action.type == ReplayConsts.ActionType.TRAIN ? trainCounts : (action.type == ReplayConsts.ActionType.BUILD ? buildCounts : (action.type == ReplayConsts.ActionType.RESEARCH ? researchCounts : upgradeCounts));
                byte by = action.player;
                nArray[by] = nArray[by] + 1;
                this.g2.setColor(action.type == ReplayConsts.ActionType.RESEARCH || action.type == ReplayConsts.ActionType.UPGRADE ? this.params.replay.details.players[action.player].getBrighterColor() : this.params.playerColors[action.player]);
                this.g2.setStroke(action.type == ReplayConsts.ActionType.TRAIN ? STROKE_DASHED : STROKE_DEFAULT);
                if (this.params.allPlayersOnOneChart) {
                    chartIndex = 0;
                }
                int x = this.params.frameToX(action.frame);
                int y = this.params.chartY2s[chartIndex] - 7 - chartLevelCounters[chartIndex] * entityHeight;
                int n = chartIndex;
                chartLevelCounters[n] = chartLevelCounters[n] + 1;
                if (chartLevelCounters[n] == MAX_LEVEL) {
                    chartLevelCounters[chartIndex] = 0;
                }
                this.g2.drawLine(x, y + 1, x, this.params.chartY2s[chartIndex]);
                if (this.params.useIcons) {
                    Icon icon = Icons.getEntityIcon((Object)entity, IconHandler.Size.MEDIUM);
                    Icons.getEntityIcon((Object)entity, IconHandler.Size.MEDIUM).paintIcon(this.params.chartCanvas, this.g2, x - (icon.getIconWidth() >> 1), y - icon.getIconHeight());
                    toolTipList.add(new Pair<Rectangle, String>(new Rectangle(x - (icon.getIconWidth() >> 1), y - icon.getIconHeight(), icon.getIconWidth(), icon.getIconHeight()), text));
                } else {
                    this.g2.drawString(text, x - (this.g2.getFontMetrics().stringWidth(text) >> 1), y);
                }
            }
            ++i;
        }
        if (this.params.useIcons) {
            this.params.toolTipProvider = new PaintChartParams.ToolTipProvider(toolTipList);
        }
        if (!displayActionTypeSet.isEmpty()) {
            i = 0;
            while (i < this.params.playerColors.length) {
                if (this.descriptionBuilders[i] != null) {
                    if (this.params.showBuilds) {
                        this.descriptionBuilders[i].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.builds", buildCounts[i]));
                    }
                    if (this.params.showTrains) {
                        this.descriptionBuilders[i].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.trains", trainCounts[i]));
                        if (this.params.showWorkers) {
                            this.descriptionBuilders[i].append(" (").append(Language.getText("module.repAnalyzer.tab.charts.chartText.workers", workerCounts[i])).append(')');
                        }
                    }
                    if (this.params.showResearches) {
                        this.descriptionBuilders[i].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.researches", researchCounts[i]));
                    }
                    if (this.params.showUpgrades) {
                        this.descriptionBuilders[i].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.upgrades", upgradeCounts[i]));
                    }
                }
                ++i;
            }
        }
    }

    private void paintBuildsTechStatChart() {
        PlayerStat ps;
        int maxFrame = this.params.markerFrame == null ? (this.params.markerX == null ? this.params.replay.frames : this.params.xToFrame(this.params.markerX)) : this.params.markerFrame;
        GameEvents.Action[] actions = this.params.actions;
        PlayerStat[] playerStats = new PlayerStat[this.params.playerChartIndices.length];
        int player = 0;
        while (player < this.params.playerChartIndices.length) {
            if (this.params.playerChartIndices[player] >= 0) {
                playerStats[player] = new PlayerStat();
            }
            ++player;
        }
        int i = 0;
        while (i < actions.length) {
            GameEvents.Action action = actions[i];
            ps = playerStats[action.player];
            if (ps != null && action.frame <= maxFrame) {
                IntHolder count = null;
                switch (action.type) {
                    case TRAIN: {
                        ReplayConsts.Unit unit;
                        if (!this.params.showUnitsStat || (count = ps.unitCountMap.get((Object)(unit = ((GameEvents.TrainAction)action).unit))) != null) break;
                        count = new IntHolder();
                        ps.unitCountMap.put(unit, count);
                        ps.unitList.add(unit);
                        break;
                    }
                    case BUILD: {
                        ReplayConsts.Building building;
                        if (!this.params.showBuildingsStat || (count = ps.buildingCountMap.get((Object)(building = ((GameEvents.BuildAction)action).building))) != null) break;
                        count = new IntHolder();
                        ps.buildingCountMap.put(building, count);
                        ps.buildingList.add(building);
                        break;
                    }
                    case RESEARCH: {
                        ReplayConsts.Research research;
                        if (!this.params.showResearchesStat || (count = ps.researchCountMap.get((Object)(research = ((GameEvents.ResearchAction)action).research))) != null) break;
                        count = new IntHolder();
                        ps.researchCountMap.put(research, count);
                        ps.researchList.add(research);
                        break;
                    }
                    case UPGRADE: {
                        ReplayConsts.Upgrade upgrade;
                        if (!this.params.showUpgradesStat || (count = ps.upgradeCountMap.get((Object)(upgrade = ((GameEvents.UpgradeAction)action).upgrade))) != null) break;
                        count = new IntHolder();
                        ps.upgradeCountMap.put(upgrade, count);
                        ps.upgradeList.add(upgrade);
                        break;
                    }
                    default: {
                        ReplayConsts.AbilityGroup abilityGroup;
                        if (!(action instanceof GameEvents.BaseUseAbilityAction) || !this.params.showAbilityGroupsStat || (abilityGroup = ((GameEvents.BaseUseAbilityAction)action).abilityGroup) == null || (count = ps.abilityGroupCountMap.get((Object)abilityGroup)) != null) break;
                        count = new IntHolder();
                        ps.abilityGroupCountMap.put(abilityGroup, count);
                        ps.abilityGroupList.add(abilityGroup);
                    }
                }
                if (count != null) {
                    ++count.value;
                }
            }
            ++i;
        }
        int[][] maxCountss = new int[5][playerStats.length];
        int i2 = 0;
        while (i2 < playerStats.length) {
            ps = playerStats[i2];
            if (ps != null) {
                maxCountss[0][i2] = ChartPainter.maxOfMap(ps.unitCountMap);
                maxCountss[1][i2] = ChartPainter.maxOfMap(ps.buildingCountMap);
                maxCountss[2][i2] = ChartPainter.maxOfMap(ps.researchCountMap);
                maxCountss[3][i2] = ChartPainter.maxOfMap(ps.upgradeCountMap);
                maxCountss[4][i2] = ChartPainter.maxOfMap(ps.abilityGroupCountMap);
            }
            ++i2;
        }
        if (this.params.allPlayersOnOneChart) {
            i2 = 0;
            while (i2 < 5) {
                maxCountss[i2][0] = GeneralUtils.maxValue(maxCountss[i2]);
                int j = 1;
                while (j < maxCountss[i2].length) {
                    maxCountss[i2][j] = maxCountss[i2][0];
                    ++j;
                }
                ++i2;
            }
        }
        int fontAscent = this.g2.getFontMetrics().getAscent();
        int maxBarHeight = Math.max(0, this.params.chartHeight - Icons.getBuildingIcon(ReplayConsts.Building.NEXUS, this.params.barSize).getIconHeight() - fontAscent);
        IntHolder[] xs = new IntHolder[this.params.allPlayersOnOneChart ? 1 : playerStats.length];
        int i3 = 0;
        while (i3 < xs.length) {
            if (playerStats[i3] != null) {
                xs[i3] = new IntHolder(26);
            }
            ++i3;
        }
        ArrayList<Pair<Rectangle, String>> toolTipList = new ArrayList<Pair<Rectangle, String>>(32);
        boolean[][] needSpaceAfterss = new boolean[this.params.allPlayersOnOneChart ? 1 : playerStats.length][5];
        int entity = 0;
        while (entity < 5) {
            int i4 = 0;
            while (i4 < playerStats.length) {
                ps = playerStats[i4];
                if (ps != null) {
                    int y2 = this.params.chartY2s[this.params.playerChartIndices[i4]];
                    IntHolder x = xs[this.params.allPlayersOnOneChart ? 0 : i4];
                    boolean[] needSpaceAfters = needSpaceAfterss[this.params.allPlayersOnOneChart ? 0 : i4];
                    if (entity > 0) {
                        int n = entity;
                        needSpaceAfters[n] = needSpaceAfters[n] | needSpaceAfters[entity - 1];
                    }
                    this.g2.setColor(entity == 2 || entity == 3 ? this.params.replay.details.players[i4].getBrighterColor() : this.params.playerColors[i4]);
                    boolean needSpaceAfter = false;
                    if (entity == 0 && ps.unitList.size() > 0) {
                        needSpaceAfter = true;
                        for (ReplayConsts.Unit unit : ps.unitList) {
                            this.drawStatBar(toolTipList, Icons.getUnitIcon(unit, this.params.barSize), (Object)unit, x, maxBarHeight, ps.unitCountMap.get((Object)((Object)unit)).value, maxCountss[0][i4], y2);
                        }
                    }
                    if (entity == 1 && ps.buildingList.size() > 0) {
                        if (needSpaceAfters[entity - 1]) {
                            x.value += 10;
                            needSpaceAfters[entity - 1] = false;
                        }
                        needSpaceAfter = true;
                        for (ReplayConsts.Building building : ps.buildingList) {
                            this.drawStatBar(toolTipList, Icons.getBuildingIcon(building, this.params.barSize), (Object)building, x, maxBarHeight, ps.buildingCountMap.get((Object)((Object)building)).value, maxCountss[1][i4], y2);
                        }
                    }
                    if (entity == 2 && ps.researchList.size() > 0) {
                        if (needSpaceAfters[entity - 1]) {
                            x.value += 10;
                            needSpaceAfters[entity - 1] = false;
                        }
                        needSpaceAfter = true;
                        for (ReplayConsts.Research research : ps.researchList) {
                            this.drawStatBar(toolTipList, Icons.getResearchIcon(research, this.params.barSize), (Object)research, x, maxBarHeight, ps.researchCountMap.get((Object)((Object)research)).value, maxCountss[2][i4], y2);
                        }
                    }
                    if (entity == 3 && ps.upgradeList.size() > 0) {
                        if (needSpaceAfters[entity - 1]) {
                            x.value += 10;
                            needSpaceAfters[entity - 1] = false;
                        }
                        needSpaceAfter = true;
                        for (ReplayConsts.Upgrade upgrade : ps.upgradeList) {
                            this.drawStatBar(toolTipList, Icons.getUpgradeIcon(upgrade, this.params.barSize), (Object)upgrade, x, maxBarHeight, ps.upgradeCountMap.get((Object)((Object)upgrade)).value, maxCountss[3][i4], y2);
                        }
                    }
                    if (entity == 4 && ps.abilityGroupList.size() > 0) {
                        if (needSpaceAfters[entity - 1]) {
                            x.value += 10;
                            needSpaceAfters[entity - 1] = false;
                        }
                        needSpaceAfter = true;
                        for (ReplayConsts.AbilityGroup abilityGroup : ps.abilityGroupList) {
                            this.drawStatBar(toolTipList, Icons.getAbilityGroupIcon(abilityGroup, this.params.barSize), (Object)abilityGroup, x, maxBarHeight, ps.abilityGroupCountMap.get((Object)((Object)abilityGroup)).value, maxCountss[4][i4], y2);
                        }
                    }
                    int n = entity;
                    needSpaceAfters[n] = needSpaceAfters[n] | needSpaceAfter;
                }
                ++i4;
            }
            ++entity;
        }
        this.params.toolTipProvider = new PaintChartParams.ToolTipProvider(toolTipList);
    }

    private void drawStatBar(List<Pair<Rectangle, String>> toolTipList, Icon icon, Object entity, IntHolder x, int maxBarHeight, int count, int maxCount, int y2) {
        int barWidth = icon.getIconWidth();
        icon.paintIcon(this.params.chartCanvas, this.g2, x.value, y2 - icon.getIconHeight() + 1);
        int bottomY = y2 - icon.getIconHeight();
        int height = maxBarHeight * count / maxCount;
        this.g2.fill3DRect(x.value, bottomY - height, barWidth, height, true);
        Color storedColor = this.g2.getColor();
        this.g2.setColor(COLOR_PLAYER_DEFAULT);
        String label = Integer.toString(count);
        this.g2.drawString(label, x.value + (barWidth - this.g2.getFontMetrics().stringWidth(label) >> 1), bottomY - height - 1);
        this.g2.setColor(storedColor);
        toolTipList.add(new Pair<Rectangle, String>(new Rectangle(x.value, bottomY - height, barWidth, y2 - bottomY + height), entity.toString()));
        x.value += barWidth;
    }

    private static int maxOfMap(Map<?, IntHolder> countMap) {
        int maxCount = 0;
        if (countMap != null) {
            for (IntHolder count : countMap.values()) {
                if (maxCount >= count.value) continue;
                maxCount = count.value;
            }
        }
        return maxCount;
    }

    private void paintPlayerDescriptions() {
        Font oldFont = this.g2.getFont();
        this.g2.setFont(new Font(oldFont.getName(), 1, oldFont.getSize()));
        int fontAscent = this.g2.getFontMetrics().getAscent();
        int i = 0;
        while (i < this.params.chartPlayerIndices.length) {
            int playerIndex = this.params.chartPlayerIndices[i];
            this.g2.setColor(this.params.playerColors[playerIndex]);
            this.g2.drawString(this.descriptionBuilders[playerIndex].toString(), 26 + this.params.visibleRectangle.x, this.params.chartY1s[i] - 1 + (this.params.allPlayersOnOneChart ? i * fontAscent + i : 0));
            ++i;
        }
        this.g2.setFont(oldFont);
    }

    private class PlayerStat {
        final Map<ReplayConsts.Unit, IntHolder> unitCountMap;
        final Map<ReplayConsts.Building, IntHolder> buildingCountMap;
        final Map<ReplayConsts.Research, IntHolder> researchCountMap;
        final Map<ReplayConsts.Upgrade, IntHolder> upgradeCountMap;
        final Map<ReplayConsts.AbilityGroup, IntHolder> abilityGroupCountMap;
        final List<ReplayConsts.Unit> unitList;
        final List<ReplayConsts.Building> buildingList;
        final List<ReplayConsts.Research> researchList;
        final List<ReplayConsts.Upgrade> upgradeList;
        final List<ReplayConsts.AbilityGroup> abilityGroupList;

        private PlayerStat() {
            this.unitCountMap = ((ChartPainter)ChartPainter.this).params.showUnitsStat ? new EnumMap(ReplayConsts.Unit.class) : null;
            this.buildingCountMap = ((ChartPainter)ChartPainter.this).params.showBuildingsStat ? new EnumMap(ReplayConsts.Building.class) : null;
            this.researchCountMap = ((ChartPainter)ChartPainter.this).params.showResearchesStat ? new EnumMap(ReplayConsts.Research.class) : null;
            this.upgradeCountMap = ((ChartPainter)ChartPainter.this).params.showUpgradesStat ? new EnumMap(ReplayConsts.Upgrade.class) : null;
            this.abilityGroupCountMap = ((ChartPainter)ChartPainter.this).params.showAbilityGroupsStat ? new EnumMap(ReplayConsts.AbilityGroup.class) : null;
            this.unitList = new ArrayList<ReplayConsts.Unit>();
            this.buildingList = new ArrayList<ReplayConsts.Building>();
            this.researchList = new ArrayList<ReplayConsts.Research>();
            this.upgradeList = new ArrayList<ReplayConsts.Upgrade>();
            this.abilityGroupList = new ArrayList<ReplayConsts.AbilityGroup>();
        }
    }
}

