/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.icons;

import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Icons {
    private static final String FLAG_ICONS_FOLDER_NAME = "flags";
    private static final Map<String, ImageIcon> LANGUAGE_FLAG_ICON_MAP = new HashMap<String, ImageIcon>();
    public static final ImageIcon SC2GEARS = new ImageIcon(Icons.class.getResource("my/sc2gears.png"));
    public static final ImageIcon SC2GEARS_LOGO = new ImageIcon(Icons.class.getResource("my/sc2gears_logo.png"));
    public static final ImageIcon SC2_BIG = new ImageIcon(Icons.class.getResource("sc2/misc/sc2.png"));
    public static final ImageIcon SC2 = new ImageIcon(SC2_BIG.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon WATCH_REPLAY = new ImageIcon(Icons.class.getResource("sc2/misc/watch_replay.png"));
    public static final ImageIcon APPLICATION_DIALOG = new ImageIcon(Icons.class.getResource("fugue/application-dialog.png"));
    public static final ImageIcon APPLICATION_DOCK_180 = new ImageIcon(Icons.class.getResource("fugue/application-dock-180.png"));
    public static final ImageIcon APPLICATION_DOCK_TAB = new ImageIcon(Icons.class.getResource("fugue/application-dock-tab.png"));
    public static final ImageIcon APPLICATION_DOCK = new ImageIcon(Icons.class.getResource("fugue/application-dock.png"));
    public static final ImageIcon APPLICATION_RESIZE_FULL = new ImageIcon(Icons.class.getResource("fugue/application-resize-full.png"));
    public static final ImageIcon APPLICATION_RESIZE_ACTUAL = new ImageIcon(Icons.class.getResource("fugue/application-resize-actual.png"));
    public static final ImageIcon APPLICATION_SHARE = new ImageIcon(Icons.class.getResource("fugue/application-share.png"));
    public static final ImageIcon APPLICATION_SIDEBAR_LIST = new ImageIcon(Icons.class.getResource("fugue/application-sidebar-list.png"));
    public static final ImageIcon APPLICATION_SIDEBAR = new ImageIcon(Icons.class.getResource("fugue/application-sidebar.png"));
    public static final ImageIcon APPLICATION_SPLIT_TILE = new ImageIcon(Icons.class.getResource("fugue/application-split-tile.png"));
    public static final ImageIcon APPLICATION_TILE_VERTICAL = new ImageIcon(Icons.class.getResource("fugue/application-tile-vertical.png"));
    public static final ImageIcon APPLICATIONS_STACK = new ImageIcon(Icons.class.getResource("fugue/applications-stack.png"));
    public static final ImageIcon ARROW_180 = new ImageIcon(Icons.class.getResource("fugue/arrow-180.png"));
    public static final ImageIcon ARROW_CIRCLE_315 = new ImageIcon(Icons.class.getResource("fugue/arrow-circle-315.png"));
    public static final ImageIcon ARROW_CIRCLE_DOUBLE = new ImageIcon(Icons.class.getResource("fugue/arrow-circle-double.png"));
    public static final ImageIcon BALLOONS = new ImageIcon(Icons.class.getResource("fugue/balloons.png"));
    public static final ImageIcon BINOCULAR = new ImageIcon(Icons.class.getResource("fugue/binocular.png"));
    public static final ImageIcon BINOCULAR_ARROW = new ImageIcon(Icons.class.getResource("fugue/binocular--arrow.png"));
    public static final ImageIcon BROOM = new ImageIcon(Icons.class.getResource("fugue/broom.png"));
    public static final ImageIcon CHART = new ImageIcon(Icons.class.getResource("fugue/chart.png"));
    public static final ImageIcon CROSS_BUTTON = new ImageIcon(Icons.class.getResource("fugue/cross-button.png"));
    public static final ImageIcon CROSS_OCTAGON = new ImageIcon(Icons.class.getResource("fugue/cross-octagon.png"));
    public static final ImageIcon CROSS_SMALL = new ImageIcon(Icons.class.getResource("fugue/cross-small.png"));
    public static final ImageIcon CROSS = new ImageIcon(Icons.class.getResource("fugue/cross.png"));
    public static final ImageIcon CROSS_WHITE = new ImageIcon(Icons.class.getResource("fugue/cross-white.png"));
    public static final ImageIcon DOCUMENT_COPY = new ImageIcon(Icons.class.getResource("fugue/document-copy.png"));
    public static final ImageIcon DOCUMENT_EXPORT = new ImageIcon(Icons.class.getResource("fugue/document-export.png"));
    public static final ImageIcon DOCUMENT_RENAME = new ImageIcon(Icons.class.getResource("fugue/document-rename.png"));
    public static final ImageIcon DOCUMENT_ZIPPER = new ImageIcon(Icons.class.getResource("fugue/document-zipper.png"));
    public static final ImageIcon DISK = new ImageIcon(Icons.class.getResource("fugue/disk.png"));
    public static final ImageIcon DOOR_OPEN_IN = new ImageIcon(Icons.class.getResource("fugue/door-open-in.png"));
    public static final ImageIcon DRIVE_DOWNLOAD = new ImageIcon(Icons.class.getResource("fugue/drive-download.png"));
    public static final ImageIcon EDIT_COLUMN = new ImageIcon(Icons.class.getResource("fugue/edit-column.png"));
    public static final ImageIcon FOLDER = new ImageIcon(Icons.class.getResource("fugue/folder.png"));
    public static final ImageIcon FOLDER_OPEN = new ImageIcon(Icons.class.getResource("fugue/folder-open.png"));
    public static final ImageIcon FOLDERS_STACK = new ImageIcon(Icons.class.getResource("fugue/folders-stack.png"));
    public static final ImageIcon FOLDERS = new ImageIcon(Icons.class.getResource("fugue/folders.png"));
    public static final ImageIcon GLOBE_ARROW = new ImageIcon(Icons.class.getResource("fugue/globe--arrow.png"));
    public static final ImageIcon HOME_ARROW = new ImageIcon(Icons.class.getResource("fugue/home--arrow.png"));
    public static final ImageIcon INFORMATION = new ImageIcon(Icons.class.getResource("fugue/information.png"));
    public static final ImageIcon INFORMATION_BALLOON = new ImageIcon(Icons.class.getResource("fugue/information-balloon.png"));
    public static final ImageIcon LOCALE = new ImageIcon(Icons.class.getResource("fugue/locale.png"));
    public static final ImageIcon MAP = new ImageIcon(Icons.class.getResource("fugue/map.png"));
    public static final ImageIcon MINUS = new ImageIcon(Icons.class.getResource("fugue/minus.png"));
    public static final ImageIcon PLUS = new ImageIcon(Icons.class.getResource("fugue/plus.png"));
    public static final ImageIcon REPORT_EXCLAMATION = new ImageIcon(Icons.class.getResource("fugue/report--exclamation.png"));
    public static final ImageIcon SORT_ALPHABET = new ImageIcon(Icons.class.getResource("fugue/sort-alphabet.png"));
    public static final ImageIcon TABLE_DELETE_ROW = new ImageIcon(Icons.class.getResource("fugue/table-delete-row.png"));
    public static final ImageIcon TABLE_EXPORT = new ImageIcon(Icons.class.getResource("fugue/table-export.png"));
    public static final ImageIcon TABLE = new ImageIcon(Icons.class.getResource("fugue/table.png"));
    public static final ImageIcon UI_FLOW = new ImageIcon(Icons.class.getResource("fugue/ui-flow.png"));
    private static final Map<ReplayConsts.Building, IconHandler> buildingIcons = new EnumMap<ReplayConsts.Building, IconHandler>(ReplayConsts.Building.class);
    private static final Map<ReplayConsts.Unit, IconHandler> unitIcons = new EnumMap<ReplayConsts.Unit, IconHandler>(ReplayConsts.Unit.class);
    private static final Map<ReplayConsts.Upgrade, IconHandler> upgradeIcons = new EnumMap<ReplayConsts.Upgrade, IconHandler>(ReplayConsts.Upgrade.class);
    private static final Map<ReplayConsts.Research, IconHandler> researchIcons = new EnumMap<ReplayConsts.Research, IconHandler>(ReplayConsts.Research.class);
    private static final Map<ReplayConsts.AbilityGroup, IconHandler> abilityGroupIcons = new EnumMap<ReplayConsts.AbilityGroup, IconHandler>(ReplayConsts.AbilityGroup.class);

    private Icons() {
    }

    public static ImageIcon getLanguageIcon(String language) {
        ImageIcon flagIcon = LANGUAGE_FLAG_ICON_MAP.get(language);
        if (flagIcon == null) {
            URL iconResourceUrl = Icons.class.getResource("flags/" + language + ".png");
            if (iconResourceUrl == null) {
                try {
                    iconResourceUrl = new File("Languages/" + language + ".png").toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            flagIcon = iconResourceUrl == null ? new ImageIcon() : new ImageIcon(iconResourceUrl);
            LANGUAGE_FLAG_ICON_MAP.put(language, flagIcon);
        }
        return flagIcon;
    }

    public static Icon getBuildingIcon(ReplayConsts.Building building, IconHandler.Size size) {
        IconHandler iconHandler = buildingIcons.get((Object)building);
        if (iconHandler == null) {
            URL iconResource = Icons.class.getResource("sc2/buildings/" + building.name() + ".jpg");
            iconHandler = new IconHandler(iconResource == null ? null : new ImageIcon(iconResource));
            buildingIcons.put(building, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getUnitIcon(ReplayConsts.Unit unit, IconHandler.Size size) {
        IconHandler iconHandler = unitIcons.get((Object)unit);
        if (iconHandler == null) {
            URL iconResource = Icons.class.getResource("sc2/units/" + unit.name() + ".jpg");
            iconHandler = new IconHandler(iconResource == null ? null : new ImageIcon(iconResource));
            unitIcons.put(unit, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getUpgradeIcon(ReplayConsts.Upgrade upgrade, IconHandler.Size size) {
        IconHandler iconHandler = upgradeIcons.get((Object)upgrade);
        if (iconHandler == null) {
            URL iconResource = Icons.class.getResource("sc2/upgrades/" + upgrade.name() + ".jpg");
            iconHandler = new IconHandler(iconResource == null ? null : new ImageIcon(iconResource));
            upgradeIcons.put(upgrade, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getResearchIcon(ReplayConsts.Research research, IconHandler.Size size) {
        IconHandler iconHandler = researchIcons.get((Object)research);
        if (iconHandler == null) {
            URL iconResource = Icons.class.getResource("sc2/researches/" + research.name() + ".jpg");
            iconHandler = new IconHandler(iconResource == null ? null : new ImageIcon(iconResource));
            researchIcons.put(research, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getAbilityGroupIcon(ReplayConsts.AbilityGroup abilityGroup, IconHandler.Size size) {
        if (abilityGroup == null) {
            return IconHandler.NULL.get((Object)size);
        }
        IconHandler iconHandler = abilityGroupIcons.get((Object)abilityGroup);
        if (iconHandler == null) {
            URL iconResource = Icons.class.getResource("sc2/abilitygroups/" + abilityGroup.name() + ".jpg");
            iconHandler = new IconHandler(iconResource == null ? null : new ImageIcon(iconResource));
            abilityGroupIcons.put(abilityGroup, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getEntityIcon(Object entity, IconHandler.Size size) {
        if (entity instanceof ReplayConsts.Unit) {
            return Icons.getUnitIcon((ReplayConsts.Unit)((Object)entity), size);
        }
        if (entity instanceof ReplayConsts.Building) {
            return Icons.getBuildingIcon((ReplayConsts.Building)((Object)entity), size);
        }
        if (entity instanceof ReplayConsts.AbilityGroup) {
            return Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)((Object)entity), size);
        }
        if (entity instanceof ReplayConsts.Research) {
            return Icons.getResearchIcon((ReplayConsts.Research)((Object)entity), size);
        }
        if (entity instanceof ReplayConsts.Upgrade) {
            return Icons.getUpgradeIcon((ReplayConsts.Upgrade)((Object)entity), size);
        }
        return IconHandler.NULL.get((Object)size);
    }
}

