/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WelcomeFrame
extends JFrame {
    private final JLabel welcomeLabel = new JLabel();
    private final JLabel firstRunLabel = new JLabel();
    private final JLabel chooseLabel = new JLabel();
    private final JLabel thankYouLabel = new JLabel();
    private final JLabel languageLabel = new JLabel();
    private final JButton okButton = new JButton();
    private final JButton cancelButton = new JButton();

    public WelcomeFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                WelcomeFrame.this.cancel();
            }
        });
        this.setIconImage(Icons.SC2GEARS.getImage());
        Box box = Box.createVerticalBox();
        GuiUtils.changeFontToBold(this.welcomeLabel);
        box.add(Box.createVerticalStrut(15));
        box.add(GuiUtils.wrapInPanel(this.welcomeLabel));
        box.add(Box.createVerticalStrut(15));
        box.add(GuiUtils.wrapInPanel(this.firstRunLabel));
        box.add(GuiUtils.wrapInPanel(this.chooseLabel));
        box.add(Box.createVerticalStrut(15));
        box.add(GuiUtils.wrapInPanel(this.thankYouLabel));
        box.add(Box.createVerticalStrut(15));
        JPanel languagePanel = new JPanel();
        languagePanel.add(this.languageLabel);
        final JComboBox<String> languagesComboBox = new JComboBox<String>(Language.getAvailableLanguages());
        languagesComboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object value) {
                return Icons.getLanguageIcon(value.toString());
            }
        });
        languagesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String language = (String)languagesComboBox.getSelectedItem();
                Language.loadLanguage(language);
                WelcomeFrame.this.reassignTexts();
            }
        });
        languagePanel.add(languagesComboBox);
        box.add(languagePanel);
        JPanel buttonsPanel = new JPanel();
        this.okButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                WelcomeFrame.this.dispose();
                Settings.set("settings.language", (String)languagesComboBox.getSelectedItem());
                Settings.saveProperties();
                WelcomeFrame welcomeFrame = WelcomeFrame.this;
                synchronized (welcomeFrame) {
                    WelcomeFrame.this.notify();
                }
            }
        });
        buttonsPanel.add(this.okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WelcomeFrame.this.cancel();
            }
        });
        buttonsPanel.add(this.cancelButton);
        box.add(buttonsPanel);
        box.add(Box.createVerticalStrut(15));
        JPanel panel = new JPanel();
        panel.add(Box.createHorizontalStrut(15));
        panel.add(box);
        panel.add(Box.createHorizontalStrut(15));
        this.getContentPane().add(panel);
        this.setResizable(false);
        this.reassignTexts();
        this.setVisible(true);
        this.okButton.requestFocusInWindow();
    }

    private void reassignTexts() {
        this.setTitle(Language.getText("welcome.welcome"));
        this.welcomeLabel.setText(String.valueOf(Language.getText("welcome.welcome")) + '!');
        this.firstRunLabel.setText(Language.getText("welcome.firstRun", "Sc2gears"));
        this.chooseLabel.setText(Language.getText("welcome.selectLanguage"));
        this.thankYouLabel.setText(Language.getText("welcome.thankYou", "Sc2gears"));
        this.languageLabel.setText(Language.getText("welcome.language"));
        GuiUtils.updateButtonText(this.okButton, "button.ok", new Object[0]);
        GuiUtils.updateButtonText(this.cancelButton, "button.cancel", new Object[0]);
        this.pack();
        GuiUtils.centerWindow(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        this.dispose();
        Language.loadLanguage("English");
        WelcomeFrame welcomeFrame = this;
        synchronized (welcomeFrame) {
            this.notify();
        }
    }
}

