/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay.model;

import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;

public class Details {
    public Player[] players;
    public String mapName;
    public String mapPreviewFileName;
    private int[] teamOrderPlayerIndices;

    public String getPlayerNames() {
        int[] teamOrderPlayerIndices = this.getTeamOrderPlayerIndeces();
        StringBuilder playerNamesBuilder = new StringBuilder();
        int i = 0;
        while (i < teamOrderPlayerIndices.length) {
            if (i > 0) {
                playerNamesBuilder.append(", ");
            }
            playerNamesBuilder.append(this.players[teamOrderPlayerIndices[i]].name);
            ++i;
        }
        return playerNamesBuilder.toString();
    }

    public String getPlayerFullNames() {
        int[] teamOrderPlayerIndices = this.getTeamOrderPlayerIndeces();
        StringBuilder playerNamesBuilder = new StringBuilder();
        int i = 0;
        while (i < teamOrderPlayerIndices.length) {
            if (i > 0) {
                playerNamesBuilder.append(", ");
            }
            playerNamesBuilder.append(this.players[teamOrderPlayerIndices[i]].fullName);
            ++i;
        }
        return playerNamesBuilder.toString();
    }

    public String getRaceMatchup() {
        int[] teamOrderPlayerIndices = this.getTeamOrderPlayerIndeces();
        StringBuilder playerRacesBuilder = new StringBuilder();
        int lastTeam = this.players[teamOrderPlayerIndices[0]].team;
        int i = 0;
        while (i < teamOrderPlayerIndices.length) {
            int team = this.players[teamOrderPlayerIndices[i]].team;
            if (team != lastTeam) {
                playerRacesBuilder.append('v');
                lastTeam = team;
            }
            playerRacesBuilder.append(this.players[teamOrderPlayerIndices[i]].raceString().charAt(0));
            ++i;
        }
        return playerRacesBuilder.toString();
    }

    public String getPlayerRaceFirstLetters() {
        StringBuilder playerRacesBuilder = new StringBuilder();
        int i = 0;
        while (i < this.players.length) {
            playerRacesBuilder.append(this.players[i].raceString().charAt(0));
            ++i;
        }
        return playerRacesBuilder.toString();
    }

    public int[] getTeamOrderPlayerIndeces() {
        if (this.teamOrderPlayerIndices == null) {
            int[][] teamIndexPairs = new int[this.players.length][];
            int i = 0;
            while (i < teamIndexPairs.length) {
                teamIndexPairs[i] = new int[]{this.players[i].team, i};
                ++i;
            }
            Arrays.sort(teamIndexPairs, new Comparator<int[]>(){

                @Override
                public int compare(int[] pair1, int[] pair2) {
                    return pair1[0] - pair2[0];
                }
            });
            this.teamOrderPlayerIndices = new int[this.players.length];
            i = 0;
            while (i < teamIndexPairs.length) {
                this.teamOrderPlayerIndices[i] = teamIndexPairs[i][1];
                ++i;
            }
        }
        return this.teamOrderPlayerIndices;
    }

    public static class Player {
        public static final int TEAM_UNKNOWN = Integer.MAX_VALUE;
        public String name;
        public String fullName;
        public String raceString;
        public final int[] argbColor = new int[4];
        public int lastActionFrame;
        public ReplayConsts.PlayerType type;
        public ReplayConsts.Race race;
        public int team = Integer.MAX_VALUE;

        public String raceString() {
            return this.race == null ? this.raceString : (this.race == ReplayConsts.Race.RANDOM ? String.valueOf(this.race.toString()) + " (" + this.raceString + ")" : this.race.toString());
        }

        public Color getColor() {
            return new Color(this.argbColor[1], this.argbColor[2], this.argbColor[3]);
        }

        public Color getDarkerColor() {
            return new Color(this.argbColor[1] >> 1, this.argbColor[2] >> 1, this.argbColor[3] >> 1);
        }

        public Color getBrighterColor() {
            return new Color(127 + (this.argbColor[1] >> 1), 127 + (this.argbColor[2] >> 1), 127 + (this.argbColor[3] >> 1));
        }

        public String getColorName() {
            return "(" + this.argbColor[1] + "," + this.argbColor[2] + "," + this.argbColor[3] + ")";
        }
    }
}

