/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.logger.Log;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.Consts;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.NormalThread;
import hu.belicza.andras.sc2gears.ui.WelcomeFrame;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.UIManager;

public class Sc2gears {
    private Sc2gears() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) {
        Sc2gears.checkFolders();
        Settings.loadProperties();
        Sc2gears.checkRunningInstance(arguments);
        Log.init();
        Sc2gears.checkAndPerformPostUpdate();
        Sc2gears.installExtraLAFs();
        GuiUtils.setLAF(Settings.getString("settings.laf"));
        if (Settings.doesSettingsFileExist()) {
            Language.loadLanguage(Settings.getString("settings.language"));
        } else {
            WelcomeFrame welcomeFrame;
            WelcomeFrame welcomeFrame2 = welcomeFrame = new WelcomeFrame();
            synchronized (welcomeFrame2) {
                try {
                    welcomeFrame.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        GuiUtils.initFileFilters();
        new MainFrame(arguments);
    }

    private static void checkFolders() {
        String[] folders;
        String[] stringArray = folders = new String[]{"User Content", "User Content/Logs", "User Content/Replay sources", "User Content/Replay lists"};
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            File file = new File(folder);
            if (!file.exists()) {
                file.mkdirs();
            }
            ++n2;
        }
    }

    public static boolean checkAndPerformPostUpdate() {
        File newUpdaterJar = new File(Consts.LIB_UPDATER_FOLDER, "Sc2gearsUpdater2.jar").getAbsoluteFile();
        if (newUpdaterJar.exists()) {
            System.out.println("Performing post-update...");
            File updaterJar = new File(Consts.LIB_UPDATER_FOLDER, "Sc2gearsUpdater.jar").getAbsoluteFile();
            int i = 0;
            while (i < 20) {
                if (!updaterJar.exists() || updaterJar.delete()) {
                    if (newUpdaterJar.renameTo(updaterJar)) {
                        System.out.println("Post-update completed.");
                        return true;
                    }
                    System.err.println("Could not rename file: " + newUpdaterJar.getAbsolutePath());
                    System.err.println("\tto: " + updaterJar.getAbsolutePath());
                    System.err.println("Post-update could not be performed!");
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                ++i;
            }
            System.err.println("Could not delete file: " + updaterJar.getAbsolutePath());
            System.err.println("Post-update could not be performed!");
            return false;
        }
        return true;
    }

    private static void checkRunningInstance(String[] arguments) {
        block21: {
            if (Settings.getBoolean("settings.allowOnlyOneInstance")) {
                boolean argumentsPassed;
                block22: {
                    PrintWriter output;
                    Socket socket;
                    int PORT = 37894;
                    try {
                        final ServerSocket serverSocket = new ServerSocket(37894, 0, InetAddress.getByName("localhost"));
                        new NormalThread("Instance listener"){

                            @Override
                            public void run() {
                                while (true) {
                                    Socket inSocket = null;
                                    BufferedReader input = null;
                                    try {
                                        try {
                                            inSocket = serverSocket.accept();
                                            MainFrame.INSTANCE.restoreMainFrame();
                                            int savedExtendedState = MainFrame.INSTANCE.getExtendedState();
                                            MainFrame.INSTANCE.setExtendedState(1);
                                            MainFrame.INSTANCE.setExtendedState(savedExtendedState);
                                            input = new BufferedReader(new InputStreamReader(inSocket.getInputStream()));
                                            int argumentsCount = Integer.parseInt(input.readLine());
                                            if (argumentsCount > 0) {
                                                String[] inArguments = new String[argumentsCount];
                                                int i = 0;
                                                while (i < argumentsCount) {
                                                    inArguments[i] = input.readLine();
                                                    ++i;
                                                }
                                                MainFrame.INSTANCE.openArguments(inArguments);
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            if (input != null) {
                                                try {
                                                    input.close();
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                            if (inSocket == null) continue;
                                            try {
                                                inSocket.close();
                                            }
                                            catch (Exception exception) {}
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (input != null) {
                                            try {
                                                input.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        if (inSocket != null) {
                                            try {
                                                inSocket.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        throw throwable;
                                    }
                                    if (input != null) {
                                        try {
                                            input.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (inSocket == null) continue;
                                    try {
                                        inSocket.close();
                                    }
                                    catch (Exception exception) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }.start();
                        break block21;
                    }
                    catch (Exception e) {
                        socket = null;
                        output = null;
                        argumentsPassed = false;
                        try {
                            try {
                                socket = new Socket("localhost", 37894);
                                output = new PrintWriter(socket.getOutputStream(), true);
                                output.println(arguments.length);
                                String[] stringArray = arguments;
                                int n = arguments.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String argument = stringArray[n2];
                                    output.println(new File(argument).getAbsolutePath());
                                    ++n2;
                                }
                                argumentsPassed = true;
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                                if (output != null) {
                                    output.close();
                                }
                                if (socket != null) {
                                    try {
                                        socket.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            if (output != null) {
                                output.close();
                            }
                            if (socket != null) {
                                try {
                                    socket.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (output != null) {
                        output.close();
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (argumentsPassed) {
                    System.exit(0);
                }
            }
        }
    }

    private static void installExtraLAFs() {
        UIManager.installLookAndFeel("EaSynthLookAndFeel", "com.easynth.lookandfeel.EaSynthLookAndFeel");
        UIManager.installLookAndFeel("InfoNode", "net.infonode.gui.laf.InfoNodeLookAndFeel");
        UIManager.installLookAndFeel("Office 2003", "org.fife.plaf.Office2003.Office2003LookAndFeel");
        UIManager.installLookAndFeel("Office XP", "org.fife.plaf.OfficeXP.OfficeXPLookAndFeel");
        UIManager.installLookAndFeel("Visual Studio 2005", "org.fife.plaf.VisualStudio2005.VisualStudio2005LookAndFeel");
    }
}

