/*
 * Decompiled with CFR 0.152.
 */
package com.easynth.designer.laf.painter;

import com.easynth.designer.laf.popup.EaSynthComboBoxPopupMenuListener;
import com.easynth.designer.laf.popup.EaSynthPopupFactory;
import com.easynth.designer.laf.utils.EaSynthGraphicsUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class EaSynthPainter
extends SynthPainter {
    private static final Map<JComponent, String> MANAGED_OBJECT_MAP = new WeakHashMap<JComponent, String>();

    public EaSynthPainter() {
        EaSynthPopupFactory.install();
    }

    public static void gradientFillRect(Graphics g, int x, int y, int w, int h, Color clrFrom, Color clrTo, boolean vertical) {
        Graphics2D g2 = (Graphics2D)g.create();
        double deltaRed = clrTo.getRed() - clrFrom.getRed();
        double deltaGreen = clrTo.getGreen() - clrFrom.getGreen();
        double deltaBlue = clrTo.getBlue() - clrFrom.getBlue();
        double deltaAlpha = clrTo.getAlpha() - clrFrom.getAlpha();
        if (vertical) {
            int i = 1;
            while (i <= h) {
                double ratio = (double)i / (double)h;
                Color curColor = new Color(clrFrom.getRed() + (int)(deltaRed * ratio), clrFrom.getGreen() + (int)(deltaGreen * ratio), clrFrom.getBlue() + (int)(deltaBlue * ratio), clrFrom.getAlpha() + (int)(deltaAlpha * ratio));
                g2.setPaint(curColor);
                g2.drawLine(x, y + i - 1, x + w - 1, y + i - 1);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= w) {
                double ratio = (double)i / (double)w;
                Color curColor = new Color(clrFrom.getRed() + (int)(deltaRed * ratio), clrFrom.getGreen() + (int)(deltaGreen * ratio), clrFrom.getBlue() + (int)(deltaBlue * ratio), clrFrom.getAlpha() + (int)(deltaAlpha * ratio));
                g2.setPaint(curColor);
                g2.drawLine(x + i - 1, y, x + i - 1, y + h - 1);
                ++i;
            }
        }
    }

    public void paintButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        int arcWidth = uiDefaults.getInt("EaSynth.button.arc.width");
        int arcHeight = uiDefaults.getInt("EaSynth.button.arc.height");
        Color borderColor = Color.BLACK;
        borderColor = (context.getComponentState() & 0x400) != 0 ? ((context.getComponentState() & 4) != 0 ? uiDefaults.getColor("EaSynth.button.border.color.default.pressed") : ((context.getComponentState() & 8) != 0 ? uiDefaults.getColor("EaSynth.button.border.color.default.disabled") : ((context.getComponentState() & 2) != 0 ? uiDefaults.getColor("EaSynth.button.border.color.default.mouseover") : uiDefaults.getColor("EaSynth.button.border.color.default.enabled")))) : ((context.getComponentState() & 4) != 0 ? uiDefaults.getColor("EaSynth.button.border.color.pressed") : ((context.getComponentState() & 8) != 0 ? uiDefaults.getColor("EaSynth.button.border.color.disabled") : ((context.getComponentState() & 2) != 0 ? uiDefaults.getColor("EaSynth.button.border.color.mouseover") : uiDefaults.getColor("EaSynth.button.border.color.enabled"))));
        g.setColor(borderColor);
        g.drawRoundRect(x, y, w - 1, h - 1, arcWidth, arcHeight);
    }

    public void paintToggleButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintButtonBorder(context, g, x, y, w, h);
    }

    public void paintArrowButtonForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
        StringBuilder iconKeyBuf = new StringBuilder("EaSynth.arrow.");
        switch (direction) {
            case 1: {
                iconKeyBuf.append("up.");
                break;
            }
            case 7: {
                iconKeyBuf.append("left.");
                break;
            }
            case 5: {
                iconKeyBuf.append("down.");
                break;
            }
            case 3: {
                iconKeyBuf.append("right.");
                break;
            }
        }
        if ((context.getComponentState() & 4) != 0) {
            iconKeyBuf.append("pressed");
        } else if ((context.getComponentState() & 8) != 0) {
            iconKeyBuf.append("disabled");
        } else if ((context.getComponentState() & 2) != 0) {
            iconKeyBuf.append("mouseover");
        } else {
            iconKeyBuf.append("enabled");
        }
        ImageIcon icon = (ImageIcon)context.getStyle().getIcon(context, iconKeyBuf.toString());
        if (icon != null) {
            int imgWidth = icon.getIconWidth();
            int imgHeight = icon.getIconHeight();
            int destPosX = (w - imgWidth) / 2;
            int destPosY = (h - imgHeight) / 2;
            g.drawImage(icon.getImage(), destPosX, destPosY, destPosX + imgWidth, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
        }
    }

    public void paintRootPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ImageIcon icon = (ImageIcon)context.getStyle().getIcon(context, "EaSynth.rootpanel.bg.image");
        if (icon != null) {
            Image image = icon.getImage();
            int imgWidth = image.getWidth(null);
            int imgHeight = image.getHeight(null);
            if (imgWidth > 0 && imgHeight > 0) {
                BufferedImage bufImage = new BufferedImage(imgWidth, imgHeight, 1);
                bufImage.createGraphics().drawImage(image, 0, 0, null);
                TexturePaint texturePaint = new TexturePaint(bufImage, new Rectangle(0, 0, bufImage.getWidth(), bufImage.getHeight()));
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setPaint(texturePaint);
                g2.fill(g2.getClip());
            }
        }
    }

    public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        block8: {
            JProgressBar progressBar = (JProgressBar)context.getComponent();
            if (progressBar.isIndeterminate() && progressBar.isStringPainted()) {
                boolean paintTextWhenIndeterminate = context.getStyle().getBoolean(context, "EaSynth.progressbar.indeterminate.paintstring", false);
                String textToPaint = progressBar.getString();
                if (paintTextWhenIndeterminate && textToPaint != null) {
                    Class<?> synthProgBarUIClass = progressBar.getUI().getClass();
                    try {
                        Method paintTextMethod = synthProgBarUIClass.getDeclaredMethod("paintText", SynthContext.class, Graphics.class, String.class);
                        if (paintTextMethod == null) break block8;
                        try {
                            Font font = context.getStyle().getFont(context);
                            FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                            int strLength = context.getStyle().getGraphicsUtils(context).computeStringWidth(context, font, metrics, textToPaint);
                            Rectangle bounds = progressBar.getBounds();
                            Rectangle textRect = new Rectangle(bounds.width / 2 - strLength / 2, (bounds.height - (metrics.getAscent() + metrics.getDescent())) / 2, strLength, metrics.getAscent() + metrics.getDescent());
                            Insets bgInsets = (Insets)context.getStyle().get(context, "EaSynth.progressbar.bg.insets");
                            if (bgInsets == null) {
                                bgInsets = new Insets(0, 0, 0, 0);
                            }
                            if (progressBar.getOrientation() == 0 && textRect.y >= bgInsets.top || progressBar.getOrientation() == 1 && textRect.x >= bgInsets.left) {
                                g.setColor(new Color(224, 212, 192));
                                g.fillRect(textRect.x, textRect.y, textRect.width, textRect.height);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        paintTextMethod.setAccessible(true);
                        paintTextMethod.invoke((Object)progressBar.getUI(), context, g, textToPaint);
                        paintTextMethod.setAccessible(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g.create();
        ImageIcon bgIcon = (ImageIcon)context.getStyle().getIcon(context, "EaSynth.progressbar.background.image");
        Insets bgInsets = (Insets)context.getStyle().get(context, "EaSynth.progressbar.bg.insets");
        if (bgIcon != null) {
            EaSynthGraphicsUtils.drawImageWith9Grids(g, bgIcon.getImage(), x, y, x + w, y + h, bgInsets == null ? new Insets(0, 0, 0, 0) : bgInsets, true);
        } else {
            UIDefaults uiDefaults = UIManager.getDefaults();
            Color bgColor = uiDefaults.getColor("EaSynth.progressbar.background.color");
            if (bgColor != null) {
                int arcWidth = uiDefaults.getInt("EaSynth.progressbar.arc.width");
                int arcHeight = uiDefaults.getInt("EaSynth.progressbar.arc.height");
                g2.setPaint(bgColor);
                g2.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
            }
        }
        JProgressBar progressBar = (JProgressBar)context.getComponent();
        ImageIcon icon = (ImageIcon)context.getStyle().getIcon(context, "EaSynth.progressbar.indication.image");
        if (icon != null && w > 0 && h > 0) {
            int imgWidth = icon.getIconWidth();
            int imgHeight = icon.getIconHeight();
            if (progressBar.getOrientation() == 0) {
                g2.setPaint(new Color(0, 0, 0, 130));
                g2.drawLine(x + imgWidth / 2, (y + h) / 2 - 1, x + w - imgWidth / 2, (y + h) / 2 - 1);
                g2.setPaint(new Color(255, 255, 255, 130));
                g2.drawLine(x + imgWidth / 2, (y + h) / 2 + 1, x + w - imgWidth / 2, (y + h) / 2 + 1);
                g2.setPaint(new Color(0, 0, 0, 180));
                g2.drawLine(x + imgWidth / 2, (y + h) / 2, x + w - imgWidth / 2, (y + h) / 2);
            } else {
                g2.setPaint(new Color(0, 0, 0, 130));
                g2.drawLine((x + w) / 2 - 1, y + imgHeight / 2, (x + w) / 2 - 1, y + h - imgHeight / 2);
                g2.setPaint(new Color(255, 255, 255, 130));
                g2.drawLine((x + w) / 2 + 1, y + imgHeight / 2, (x + w) / 2 + 1, y + h - imgHeight / 2);
                g2.setPaint(new Color(0, 0, 0, 180));
                g2.drawLine((x + w) / 2, y + imgHeight / 2, (x + w) / 2, y + h - imgHeight / 2);
            }
        }
    }

    public void paintProgressBarForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        Graphics2D g2 = (Graphics2D)g.create();
        ImageIcon icon = (ImageIcon)context.getStyle().getIcon(context, "EaSynth.progressbar.indication.image");
        JProgressBar progressBar = (JProgressBar)context.getComponent();
        boolean isDisabled = (context.getComponentState() & 8) != 0;
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color lineColor = uiDefaults.getColor("EaSynth.progressbar.line.color");
        if (lineColor == null) {
            lineColor = new Color(255, 255, 255, 130);
        }
        if (icon != null && w > 0 && h > 0) {
            int imgWidth = icon.getIconWidth();
            int imgHeight = icon.getIconHeight();
            if (orientation == 0) {
                if (!progressBar.isIndeterminate() && w >= imgWidth) {
                    g2.setPaint(lineColor.brighter());
                    g2.drawLine(x + imgWidth / 2, (y + h) / 2 - 1, x + w - imgWidth / 2, (y + h) / 2 - 1);
                    g2.setPaint(lineColor.darker());
                    g2.drawLine(x + imgWidth / 2, (y + h) / 2 + 1, x + w - imgWidth / 2, (y + h) / 2 + 1);
                    g2.setPaint(lineColor);
                    g2.drawLine(x + imgWidth / 2, (y + h) / 2, x + w - imgWidth / 2, (y + h) / 2);
                }
                if (!isDisabled) {
                    int destPosX = x + w - imgWidth;
                    if (progressBar.isIndeterminate()) {
                        int midRange = progressBar.getWidth() - w;
                        int curMid = imgWidth / 2 + (progressBar.getWidth() - imgWidth) * x / midRange;
                        destPosX = curMid - imgWidth / 2;
                    }
                    if (destPosX >= 0) {
                        int destPosY = (y + h - imgHeight) / 2;
                        g.drawImage(icon.getImage(), destPosX, destPosY, destPosX + imgWidth, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
                    }
                }
            } else {
                if (!progressBar.isIndeterminate() && h >= imgHeight) {
                    g2.setPaint(lineColor.brighter());
                    g2.drawLine((x + w) / 2 - 1, y + imgHeight / 2, (x + w) / 2 - 1, y + h - imgHeight / 2);
                    g2.setPaint(lineColor.darker());
                    g2.drawLine((x + w) / 2 + 1, y + imgHeight / 2, (x + w) / 2 + 1, y + h - imgHeight / 2);
                    g2.setPaint(lineColor);
                    g2.drawLine((x + w) / 2, y + imgHeight / 2, (x + w) / 2, y + h - imgHeight / 2);
                }
                if (!isDisabled) {
                    int destPosX = (x + w - imgWidth) / 2;
                    int destPosY = y;
                    if (progressBar.isIndeterminate()) {
                        int midRange = progressBar.getHeight() - h;
                        int curMid = imgHeight / 2 + (progressBar.getHeight() - imgHeight) * y / midRange;
                        destPosY = curMid - imgHeight / 2;
                    }
                    g.drawImage(icon.getImage(), destPosX, destPosY, destPosX + imgWidth, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
                }
            }
        }
    }

    public void paintInternalFrameBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color mainColor = uiDefaults.getColor("EaSynth.internalframe.main.color");
        if (mainColor == null) {
            mainColor = Color.GRAY;
        }
        g.setColor(mainColor.darker());
        g.drawLine(x, y + 1, x, h - 2);
        g.drawLine(x + w - 1, y + 1, x + w - 1, h - 2);
        g.drawLine(x + 1, y, x + w - 2, y);
        g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
        g.setColor(mainColor.brighter());
        g.drawLine(x + 2, y + 3, x + 2, h - 4);
        g.drawLine(x + w - 3, y + 3, x + w - 3, h - 4);
        g.drawLine(x + 3, y + 2, x + w - 4, y + 2);
        g.drawLine(x + 3, y + h - 3, x + w - 4, y + h - 3);
    }

    public void paintInternalFrameTitlePaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color mainColor = uiDefaults.getColor("EaSynth.internalframe.main.color");
        if (mainColor == null) {
            mainColor = Color.GRAY;
        }
        g.setColor(mainColor.darker());
        g.drawLine(x, y + h - 1, x + w, y + h - 1);
    }

    public void paintInternalFrameBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color mainColor = uiDefaults.getColor("EaSynth.internalframe.main.color");
        if (mainColor == null) {
            mainColor = Color.GRAY;
        }
        g.setColor(mainColor);
        g.fillRect(x, y, w, h);
    }

    public void paintInternalFrameTitlePaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintInternalFrameBackground(context, g, x, y, w, h);
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.6") < 0) {
            JInternalFrame frame;
            int titleSpacing = context.getStyle().getInt(context, "InternalFrameTitlePane.titleSpacing", 0);
            Container comp = context.getComponent();
            while (!(comp instanceof JInternalFrame) && comp != null) {
                comp = comp.getParent();
            }
            if (comp instanceof JInternalFrame) {
                frame = (JInternalFrame)comp;
                g.setColor(Color.BLACK);
                g.drawString(frame.getTitle(), 20 + titleSpacing, 15);
            }
            comp = context.getComponent();
            while (!(comp instanceof JInternalFrame.JDesktopIcon) && comp != null) {
                comp = comp.getParent();
            }
            if (comp instanceof JInternalFrame.JDesktopIcon) {
                frame = ((JInternalFrame.JDesktopIcon)comp).getInternalFrame();
                g.setColor(Color.BLACK);
                g.drawString(frame.getTitle(), 20 + titleSpacing, 15);
            }
        }
    }

    public void paintScrollBarTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        JScrollBar scrollBar;
        Color centerColor;
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color sideColor = uiDefaults.getColor("EaSynth.scrollbar.track.sidecolor");
        if (sideColor == null) {
            sideColor = Color.white;
        }
        if ((centerColor = uiDefaults.getColor("EaSynth.scrollbar.track.centercolor")) == null) {
            centerColor = Color.LIGHT_GRAY;
        }
        if ((scrollBar = (JScrollBar)context.getComponent()).getOrientation() == 1) {
            EaSynthPainter.gradientFillRect(g, x, y, w / 2, h, sideColor, centerColor, false);
            EaSynthPainter.gradientFillRect(g, x + w / 2, y, w / 2, h, centerColor, sideColor, false);
        } else {
            EaSynthPainter.gradientFillRect(g, x, y, w, h / 2, sideColor, centerColor, true);
            EaSynthPainter.gradientFillRect(g, x, y + h / 2, w, h / 2, centerColor, sideColor, true);
        }
    }

    public void paintScrollBarTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color borderColor = uiDefaults.getColor("EaSynth.scrollbar.track.bordercolor");
        if (borderColor == null) {
            borderColor = Color.DARK_GRAY;
        }
        g.setColor(borderColor);
        g.draw3DRect(x, y, w - 1, h - 1, false);
    }

    public void paintScrollBarThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        JScrollBar scrollBar;
        boolean isVertical;
        Color centerColor;
        UIDefaults uiDefaults = UIManager.getDefaults();
        int borderThick = uiDefaults.getInt("EaSynth.scrollbar.thumb.borderthick");
        Color sideColor = uiDefaults.getColor("EaSynth.scrollbar.thumb.sidecolor");
        if (sideColor == null) {
            sideColor = Color.LIGHT_GRAY;
        }
        if ((centerColor = uiDefaults.getColor("EaSynth.scrollbar.thumb.centercolor")) == null) {
            centerColor = Color.white;
        }
        boolean bl = isVertical = (scrollBar = (JScrollBar)context.getComponent()).getOrientation() == 1;
        if (isVertical) {
            EaSynthPainter.gradientFillRect(g, x, y, w / 2, h, sideColor, centerColor, false);
            EaSynthPainter.gradientFillRect(g, x + w / 2, y, w / 2, h, centerColor, sideColor, false);
        } else {
            EaSynthPainter.gradientFillRect(g, x, y, w, h / 2, sideColor, centerColor, true);
            EaSynthPainter.gradientFillRect(g, x, y + h / 2, w, h / 2, centerColor, sideColor, true);
        }
        ImageIcon icon = (ImageIcon)context.getStyle().getIcon(context, "EaSynth.scrollbar.thumb.image");
        if (icon != null) {
            int imgWidth = icon.getIconWidth();
            int imgHeight = icon.getIconHeight();
            if (!isVertical && w >= imgWidth + borderThick * 2 || isVertical && h >= imgHeight + borderThick * 2) {
                int destPosX = x + (w - imgWidth) / 2;
                int destPosY = y + (h - imgHeight) / 2;
                g.drawImage(icon.getImage(), destPosX, destPosY, destPosX + imgWidth, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
            }
        }
    }

    public void paintScrollBarThumbBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        int borderThick = uiDefaults.getInt("EaSynth.scrollbar.thumb.borderthick");
        Color borderColor = uiDefaults.getColor("EaSynth.scrollbar.thumb.bordercolor");
        if (borderColor == null) {
            borderColor = Color.DARK_GRAY;
        }
        if ((context.getComponentState() & 8) != 0) {
            borderColor = Color.LIGHT_GRAY;
        } else if ((context.getComponentState() & 2) != 0) {
            borderColor = borderColor.brighter();
        }
        g.setColor(borderColor);
        JScrollBar scrollBar = (JScrollBar)context.getComponent();
        if (scrollBar.getOrientation() == 1) {
            if (h > borderThick * 2) {
                g.fill3DRect(x, y, w, borderThick, true);
                g.fill3DRect(x, y + h - borderThick, w, borderThick, true);
            }
        } else if (w > borderThick * 2) {
            g.fill3DRect(x, y, borderThick, h, true);
            g.fill3DRect(x + w - borderThick, y, borderThick, h, true);
        }
    }

    public void paintScrollBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color bgColor = uiDefaults.getColor("EaSynth.scrollbar.bgcolor");
        if (bgColor == null) {
            bgColor = Color.WHITE;
        }
        g.setColor(bgColor);
        g.fill3DRect(x, y, w, h, true);
    }

    public void paintScrollBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color borderColor = uiDefaults.getColor("EaSynth.scrollbar.bordercolor");
        if (borderColor == null) {
            borderColor = Color.DARK_GRAY;
        }
        g.setColor(borderColor);
        g.draw3DRect(x, y, w - 1, h - 1, true);
    }

    public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color mainColor = uiDefaults.getColor("EaSynth.splitpane.divider.maincolor");
        if (mainColor == null) {
            mainColor = Color.LIGHT_GRAY;
        }
        g.setColor(mainColor);
        g.fill3DRect(x, y, w, h, true);
        ImageIcon icon = (ImageIcon)context.getStyle().getIcon(context, "EaSynth.splitpane.divider.image");
        if (icon != null) {
            int imgWidth = icon.getIconWidth();
            int imgHeight = icon.getIconHeight();
            JSplitPane splitPane = (JSplitPane)context.getComponent();
            if (splitPane.getOrientation() == 1 && h >= imgHeight * 9) {
                int destPosX = x + (w - imgWidth) / 2;
                int destPosY = y + (h - imgHeight * 3) / 2;
                g.drawImage(icon.getImage(), destPosX, destPosY, destPosX + imgWidth, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
                g.drawImage(icon.getImage(), destPosX, destPosY + imgHeight, destPosX + imgWidth, destPosY + imgHeight * 2, 0, 0, imgWidth, imgHeight, null);
                g.drawImage(icon.getImage(), destPosX, destPosY + imgHeight * 2, destPosX + imgWidth, destPosY + imgHeight * 3, 0, 0, imgWidth, imgHeight, null);
            } else if (w >= imgWidth * 9) {
                int destPosX = x + (w - imgWidth * 3) / 2;
                int destPosY = y + (h - imgHeight) / 2;
                g.drawImage(icon.getImage(), destPosX, destPosY, destPosX + imgWidth, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
                g.drawImage(icon.getImage(), destPosX + imgWidth, destPosY, destPosX + imgWidth * 2, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
                g.drawImage(icon.getImage(), destPosX + imgWidth * 2, destPosY, destPosX + imgWidth * 3, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
            }
        }
    }

    public void paintSplitPaneDragDivider(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paintSplitPaneDividerBackground(context, g, x, y, w, h);
    }

    public void paintTableHeaderBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g.create();
        Color lightColor = new Color(255, 255, 255, 90);
        Color darkColor = new Color(60, 60, 60, 90);
        JTableHeader header = (JTableHeader)context.getComponent();
        TableColumnModel model = header.getColumnModel();
        int colCount = model.getColumnCount();
        int curPos = 0;
        int i = 0;
        while (i < colCount) {
            g2.setPaint(lightColor);
            g2.drawLine(x + curPos, y, x + curPos, y + h - 1);
            g2.setPaint(darkColor);
            g2.drawLine(x + (curPos += model.getColumn(i).getWidth() - 1), y, x + curPos, y + h - 1);
            curPos += model.getColumnMargin();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComboBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Map<JComponent, String> map = MANAGED_OBJECT_MAP;
        synchronized (map) {
            if (!MANAGED_OBJECT_MAP.containsKey(context.getComponent()) && context.getComponent() instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)context.getComponent();
                boolean alreadyFixed = false;
                PopupMenuListener[] popupMenuListenerArray = comboBox.getPopupMenuListeners();
                int n = 0;
                int n2 = popupMenuListenerArray.length;
                while (n < n2) {
                    PopupMenuListener l = popupMenuListenerArray[n];
                    if (l instanceof EaSynthComboBoxPopupMenuListener) {
                        alreadyFixed = true;
                        break;
                    }
                    ++n;
                }
                if (!alreadyFixed) {
                    comboBox.addPopupMenuListener(new EaSynthComboBoxPopupMenuListener());
                    MANAGED_OBJECT_MAP.put(comboBox, comboBox.getClass().getName());
                }
            }
        }
        ImageIcon icon = null;
        icon = (context.getComponentState() & 8) != 0 ? (ImageIcon)context.getStyle().getIcon(context, "EaSynth.combobox.bg.image.disabled") : (ImageIcon)context.getStyle().getIcon(context, "EaSynth.combobox.bg.image.enabled");
        if (icon != null) {
            Image image = icon.getImage();
            int imgWidth = image.getWidth(null);
            int imgHeight = image.getHeight(null);
            g.drawImage(icon.getImage(), x, y, x + w, y + h, 0, 0, imgWidth, imgHeight, null);
        }
    }

    public void paintMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Color selectedColor;
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color normalColor = uiDefaults.getColor("EaSynth.menu.bg.color.normal");
        if (normalColor == null) {
            normalColor = Color.LIGHT_GRAY;
        }
        if ((selectedColor = uiDefaults.getColor("EaSynth.menu.bg.color.selected")) == null) {
            selectedColor = Color.GRAY;
        }
        JMenu menu = (JMenu)context.getComponent();
        if ((context.getComponentState() & 0x200) != 0) {
            g.setColor(selectedColor);
            g.fillRect(x, y, w, h);
        } else if ((context.getComponentState() & 8) != 0) {
            if (!(menu.getParent() instanceof JMenuBar)) {
                g.setColor(normalColor);
                g.fillRect(x, y, w, h);
            }
        } else if (!(menu.getParent() instanceof JMenuBar)) {
            g.setColor(normalColor);
            g.fillRect(x, y, w, h);
        }
    }

    public void paintSliderThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        ImageIcon thumbIcon = null;
        thumbIcon = (context.getComponentState() & 8) != 0 ? (ImageIcon)context.getStyle().getIcon(context, "EaSynth.slider.thumb.image.disabled") : ((context.getComponentState() & 2) != 0 ? (ImageIcon)context.getStyle().getIcon(context, "EaSynth.slider.thumb.image.mouseover") : (ImageIcon)context.getStyle().getIcon(context, "EaSynth.slider.thumb.image.normal"));
        if (thumbIcon != null) {
            int imgWidth = thumbIcon.getIconWidth();
            int imgHeight = thumbIcon.getIconHeight();
            int destPosX = x + (w - imgWidth) / 2;
            int destPosY = y + (h - imgHeight) / 2;
            g.drawImage(thumbIcon.getImage(), destPosX, destPosY, destPosX + imgWidth, destPosY + imgHeight, 0, 0, imgWidth, imgHeight, null);
        }
    }

    public void paintToolBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        JToolBar toolbar;
        Color color3;
        Color color2;
        UIDefaults uiDefaults = UIManager.getDefaults();
        Color color1 = uiDefaults.getColor("EaSynth.toolbar.bg.color1");
        if (color1 == null) {
            color1 = Color.LIGHT_GRAY;
        }
        if ((color2 = uiDefaults.getColor("EaSynth.toolbar.bg.color2")) == null) {
            color2 = Color.WHITE;
        }
        if ((color3 = uiDefaults.getColor("EaSynth.toolbar.bg.color3")) == null) {
            color3 = Color.LIGHT_GRAY;
        }
        if ((toolbar = (JToolBar)context.getComponent()).getOrientation() == 1) {
            EaSynthPainter.gradientFillRect(g, x, y, w / 2, h, color1, color2, false);
            EaSynthPainter.gradientFillRect(g, x + w / 2, y, w / 2, h, color2, color3, false);
        } else {
            EaSynthPainter.gradientFillRect(g, x, y, w, h / 2, color1, color2, true);
            EaSynthPainter.gradientFillRect(g, x, y + h / 2, w, h / 2, color2, color3, true);
        }
    }

    public void paintPopupMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ImageIcon bgIcon;
        JPopupMenu popupMenu = (JPopupMenu)context.getComponent();
        JPanel panel = (JPanel)popupMenu.getParent();
        BufferedImage bgImage = (BufferedImage)panel.getClientProperty("POPUP_BACKGROUND_IMAGE");
        if (bgImage != null) {
            g.drawImage(bgImage, x, y, null);
        }
        if ((bgIcon = (ImageIcon)context.getStyle().getIcon(context, "EaSynth.popup.menu.bg")) != null) {
            EaSynthGraphicsUtils.drawImageWith9Grids(g, bgIcon.getImage(), x, y, x + w, y + h, context.getStyle().getInsets(context, null), true);
        }
    }
}

