/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view.textrecognition;

import hu.belicza.andras.bwhfagent.view.textrecognition.CharDef;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class TextRecognizer {
    private static final int VALID_SCREENSHOT_WIDTH = 640;
    private static final int VALID_SCREENSHOT_HEIGHT = 480;
    private static final int FIRST_PLAYER_SLOT_FRAME_Y = 35;
    private static final int PLAYER_SLOT_FRAME_X = 52;
    private static final int PLAYER_SLOT_HEIGHT = 16;
    private static final int GAP_BETWEEN_PLAYER_SLOTS = 2;

    public static String[] readPlayerNamesFromGameLobbyImage(BufferedImage image) {
        ArrayList<String> playerNames = new ArrayList<String>();
        int slot = 0;
        while (slot < 12) {
            if (TextRecognizer.isSlotPlayerSlot(slot, image)) {
                String playerName = TextRecognizer.readString(56, 35 + 18 * slot + 2, image);
                if (playerName == null || playerName.equals("Open") || playerName.equals("Closed") || playerName.equals("Computer")) {
                    playerNames.add(null);
                } else {
                    playerNames.add(playerName);
                }
            }
            ++slot;
        }
        return playerNames.toArray(new String[playerNames.size()]);
    }

    public static boolean isGameLobbyScreenshot(BufferedImage image) {
        if (image.getWidth() != 640 || image.getHeight() != 480) {
            return false;
        }
        int y = 42;
        while (y < 62) {
            if (!TextRecognizer.isPixelFrameColor(image.getRGB(368, y))) {
                return false;
            }
            ++y;
        }
        return true;
    }

    private static boolean isSlotPlayerSlot(int slot, BufferedImage image) {
        int y1 = 35 + 18 * slot + 2;
        int y = y1 + 16 - 5;
        while (y >= y1) {
            if (!TextRecognizer.isPixelFrameColor(image.getRGB(52, y))) {
                return false;
            }
            --y;
        }
        return true;
    }

    private static boolean isPixelFrameColor(int rgb) {
        return (rgb & 0xFF) == 0 && (rgb >> 8 & 0xFF) == 0 && (rgb >> 16 & 0xFF) > 20;
    }

    private static String readString(int x, int y, BufferedImage image) {
        StringBuilder recognizedStringBuilder = new StringBuilder();
        int[] rgbBuffer = new int[11 * CharDef.MAX_CHAR_WIDTH];
        while (true) {
            int width = 0;
            int xPos = x;
            while (x < 216) {
                if (CharDef.isCharColumnEmpty(xPos, y, image)) {
                    width = xPos - x;
                    break;
                }
                ++xPos;
            }
            if (width == 0) break;
            if (width > CharDef.MAX_CHAR_WIDTH) {
                return null;
            }
            image.getRGB(x, y, width, 11, rgbBuffer, 0, CharDef.MAX_CHAR_WIDTH);
            boolean recognizedChar = false;
            CharDef[] charDefArray = CharDef.CHAR_WIDTH_CHAR_DEFS_MAP.get(width);
            int n = charDefArray.length;
            int n2 = 0;
            while (n2 < n) {
                CharDef charDef = charDefArray[n2];
                boolean charDefMatches = true;
                int charY = 0;
                block3: while (charY < 11) {
                    byte[] imageDataRow = charDef.imageData[charY];
                    int rgbBufferIndex = charY * CharDef.MAX_CHAR_WIDTH + width - 1;
                    int charX = width - 1;
                    while (charX >= 0) {
                        byte colorIndex = imageDataRow[charX];
                        int pixelRgb = rgbBuffer[rgbBufferIndex];
                        if (colorIndex == 0) {
                            int colorIndex2 = CharDef.CHAR_IMAGE_HSBS.length - 1;
                            while (colorIndex2 > 1) {
                                if (CharDef.doPixelsMatch(pixelRgb, CharDef.CHAR_IMAGE_HSBS[colorIndex2])) {
                                    charDefMatches = false;
                                    break block3;
                                }
                                --colorIndex2;
                            }
                        } else if (!CharDef.doPixelsMatch(pixelRgb, CharDef.CHAR_IMAGE_HSBS[colorIndex])) {
                            charDefMatches = false;
                            break block3;
                        }
                        --charX;
                        --rgbBufferIndex;
                    }
                    ++charY;
                }
                if (charDefMatches) {
                    recognizedChar = true;
                    recognizedStringBuilder.append(charDef.associatedChar);
                    break;
                }
                ++n2;
            }
            if (!recognizedChar) {
                return null;
            }
            x += width + 1;
        }
        return recognizedStringBuilder.toString();
    }
}

