/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view.textrecognition;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class CharDef {
    public static final int HEIGHT = 11;
    private static final String CHAR_DEFS_FILE_NAME = "chardefs.png";
    public static final float[][] CHAR_IMAGE_HSBS;
    public static final int SPACE_CHAR_WIDTH = 5;
    public final int width;
    public final int height;
    public final char associatedChar;
    public final byte[][] imageData;
    public static final CharDef[] CHAR_DEFS;
    public static final Map<Integer, CharDef[]> CHAR_WIDTH_CHAR_DEFS_MAP;
    public static final int MAX_CHAR_WIDTH;

    static {
        float[][] fArrayArray = new float[6][];
        fArrayArray[1] = Color.RGBtoHSB(120, 216, 80, null);
        fArrayArray[2] = Color.RGBtoHSB(104, 179, 64, null);
        fArrayArray[3] = Color.RGBtoHSB(75, 135, 52, null);
        fArrayArray[4] = Color.RGBtoHSB(45, 85, 29, null);
        fArrayArray[5] = Color.RGBtoHSB(29, 38, 59, null);
        CHAR_IMAGE_HSBS = fArrayArray;
        CHAR_WIDTH_CHAR_DEFS_MAP = new HashMap<Integer, CharDef[]>();
        ArrayList<Character> charsInCharDefsPic = new ArrayList<Character>(100);
        char ch = 'a';
        while (ch <= 'z') {
            charsInCharDefsPic.add(Character.valueOf(ch));
            ch = (char)(ch + 1);
        }
        ch = 'A';
        while (ch <= 'Z') {
            charsInCharDefsPic.add(Character.valueOf(ch));
            ch = (char)(ch + '\u0001');
        }
        ch = '0';
        while (ch <= '9') {
            charsInCharDefsPic.add(Character.valueOf(ch));
            ch = (char)(ch + '\u0001');
        }
        char[] cArray = new char[]{'.', ',', ';', '_', '(', ')', '[', ']', '-', '\"', '!', '@', '#', '$', '%', '\''};
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            ch = cArray[n2];
            charsInCharDefsPic.add(Character.valueOf(ch));
            ++n2;
        }
        CHAR_DEFS = new CharDef[charsInCharDefsPic.size()];
        HashMap<Integer, ArrayList<CharDef>> charWidthCharDefListMap = new HashMap<Integer, ArrayList<CharDef>>();
        int maxCharWidth = 0;
        try {
            BufferedImage charDefsImage = ImageIO.read(CharDef.class.getResource(CHAR_DEFS_FILE_NAME));
            int xPos = 0;
            int i = 0;
            while (i < charsInCharDefsPic.size()) {
                int width = 0;
                int x = xPos + 2;
                while (true) {
                    if (CharDef.isCharColumnEmpty(x, 0, charDefsImage)) break;
                    ++x;
                }
                width = x - xPos;
                Character ch2 = (Character)charsInCharDefsPic.get(i);
                if (ch2.charValue() != 'I') {
                    CharDef charDef;
                    byte[][] imageData = new byte[11][width];
                    int x2 = xPos + width - 1;
                    while (x2 >= xPos) {
                        int y = 10;
                        while (y >= 0) {
                            byte colorIndex = (byte)(CHAR_IMAGE_HSBS.length - 1);
                            while (colorIndex > 0) {
                                if (CharDef.doPixelsMatch(charDefsImage.getRGB(x2, y), CHAR_IMAGE_HSBS[colorIndex])) {
                                    imageData[y][x2 - xPos] = colorIndex;
                                    break;
                                }
                                colorIndex = (byte)(colorIndex - 1);
                            }
                            --y;
                        }
                        --x2;
                    }
                    CharDef.CHAR_DEFS[i] = charDef = new CharDef(width, ch2.charValue(), imageData);
                    ArrayList<CharDef> charDefList = (ArrayList<CharDef>)charWidthCharDefListMap.get(width);
                    if (charDefList == null) {
                        charDefList = new ArrayList<CharDef>();
                        charWidthCharDefListMap.put(width, charDefList);
                    }
                    charDefList.add(charDef);
                    if (width > maxCharWidth) {
                        maxCharWidth = width;
                    }
                }
                xPos += width + 1;
                ++i;
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        for (Map.Entry charWidthCharDefListEntry : charWidthCharDefListMap.entrySet()) {
            List charDefList = (List)charWidthCharDefListEntry.getValue();
            CHAR_WIDTH_CHAR_DEFS_MAP.put((Integer)charWidthCharDefListEntry.getKey(), charDefList.toArray(new CharDef[charDefList.size()]));
        }
        MAX_CHAR_WIDTH = maxCharWidth;
    }

    public CharDef(int width, char associatedChar, byte[][] imageData) {
        this.width = width;
        this.height = 11;
        this.associatedChar = associatedChar;
        this.imageData = imageData;
    }

    public static boolean isCharColumnEmpty(int x, int y, BufferedImage image) {
        int y2 = y + 11;
        while (y < y2) {
            int picRgb = image.getRGB(x, y);
            int colorIndex = CHAR_IMAGE_HSBS.length - 1;
            while (colorIndex > 0) {
                if (CharDef.doPixelsMatch(picRgb, CHAR_IMAGE_HSBS[colorIndex])) {
                    return false;
                }
                --colorIndex;
            }
            ++y;
        }
        return true;
    }

    public static boolean doPixelsMatch(int rgb, float[] hsb) {
        float[] hsb2 = Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, null);
        float diff = hsb[0] - hsb2[0];
        return diff > -0.1f && diff < 0.1f;
    }
}

