/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view.replayfilter;

import hu.belicza.andras.bwhfagent.view.replayfilter.ReplayFilter;

public abstract class NumberIntervalReplayFilter
extends ReplayFilter {
    protected final Number minValidValue;
    protected final Number maxValidValue;

    public NumberIntervalReplayFilter(Number minValidValue, Number maxValidValue) {
        super(COMPLEXITY_NUMBER_INTERVAL);
        this.minValidValue = minValidValue;
        this.maxValidValue = maxValidValue;
    }

    public boolean isValueValid(Number value) {
        if (value instanceof Long) {
            if (this.minValidValue != null && (Long)value < (Long)this.minValidValue) {
                return false;
            }
            if (this.maxValidValue != null && (Long)value > (Long)this.maxValidValue) {
                return false;
            }
        } else if (value instanceof Integer) {
            if (this.minValidValue != null && (Integer)value < (Integer)this.minValidValue) {
                return false;
            }
            if (this.maxValidValue != null && (Integer)value > (Integer)this.maxValidValue) {
                return false;
            }
        } else if (value instanceof Short) {
            if (this.minValidValue != null && (Short)value < (Short)this.minValidValue) {
                return false;
            }
            if (this.maxValidValue != null && (Short)value > (Short)this.maxValidValue) {
                return false;
            }
        } else {
            throw new RuntimeException("Class " + value.getClass() + " is not yet implemented for NumberIntervalReplayFilter!");
        }
        return true;
    }
}

