/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhf.control.BinRepParser;
import hu.belicza.andras.bwhf.model.Replay;
import hu.belicza.andras.bwhf.model.ReplayHeader;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.NormalThread;
import hu.belicza.andras.bwhfagent.view.ProgressLoggedTab;
import hu.belicza.andras.bwhfagent.view.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import swingwt.awt.Component;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JFileChooser;
import swingwtx.swing.JPanel;

public class PlayersNetworkTab
extends ProgressLoggedTab {
    private static final String LOG_FILE_NAME = "players_network.log";
    protected final JCheckBox autoSendInfoAboutLastReplayCheckBox = new JCheckBox("Automatically send info about 'LastReplay.rep' to Players' Network", Boolean.parseBoolean(Utils.settingsProperties.getProperty("autoSendInfoAboutLastRep")));
    private final JButton selectFoldersButton = new JButton("Select folders to send recursively...", (Icon)IconResourceManager.ICON_FOLDER_CHOOSER);
    private final JButton selectFilesButton = new JButton("Select files to send...", (Icon)IconResourceManager.ICON_FILE_CHOOSER);
    private final JButton stopSendingButton = new JButton("Stop sending", (Icon)IconResourceManager.ICON_STOP);
    private volatile boolean requestedToStop;

    public PlayersNetworkTab() {
        super("Players' Network", (Icon)IconResourceManager.ICON_PLAYERS_NETWORK, LOG_FILE_NAME);
        this.buildGUI();
    }

    protected void buildGUI() {
        JButton visitPlayersNetworkButton = new JButton("Visit Players' Network", (Icon)IconResourceManager.ICON_WORLD_GO);
        visitPlayersNetworkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Utils.showURLInBrowser("http://94.199.240.39/hackerdb/players");
            }
        });
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)visitPlayersNetworkButton));
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.autoSendInfoAboutLastReplayCheckBox));
        ActionListener selectFilesAndFoldersActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(MainFrame.getInstance().generalSettingsTab.getReplayStartFolder());
                fileChooser.setExtensionFilters(new String[]{"*.rep", "*.*"}, new String[]{"Replay Files (*.rep)", "All files (*.*)"});
                fileChooser.addChoosableFileFilter(Utils.SWING_REPLAY_FILE_FILTER);
                fileChooser.setFileSelectionMode(event.getSource() == PlayersNetworkTab.this.selectFoldersButton ? 1 : 2);
                fileChooser.setMultiSelectionEnabled(true);
                if (fileChooser.showOpenDialog((Component)PlayersNetworkTab.this.getContent()) == 0) {
                    File[] fileArray;
                    if (event.getSource() == PlayersNetworkTab.this.selectFoldersButton) {
                        File[] fileArray2 = new File[1];
                        fileArray = fileArray2;
                        fileArray2[0] = fileChooser.getSelectedFile();
                    } else {
                        fileArray = fileChooser.getSelectedFiles();
                    }
                    PlayersNetworkTab.this.sendFileAndFolderInfo(fileArray);
                }
            }
        };
        JPanel buttonsPanel = Utils.createWrapperPanel();
        this.selectFilesButton.setMnemonic('f');
        this.selectFilesButton.addActionListener(selectFilesAndFoldersActionListener);
        buttonsPanel.add((Component)this.selectFilesButton);
        this.selectFoldersButton.setMnemonic('d');
        this.selectFoldersButton.addActionListener(selectFilesAndFoldersActionListener);
        buttonsPanel.add((Component)this.selectFoldersButton);
        this.contentBox.add((Component)buttonsPanel);
        this.stopSendingButton.setEnabled(false);
        this.stopSendingButton.setMnemonic('t');
        this.stopSendingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PlayersNetworkTab.this.requestedToStop = true;
                PlayersNetworkTab.this.stopSendingButton.setEnabled(false);
            }
        });
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.stopSendingButton));
        super.buildGUI();
    }

    protected void sendFileAndFolderInfo(final File[] files) {
        if (!this.selectFilesButton.isEnabled()) {
            return;
        }
        this.requestedToStop = false;
        this.selectFoldersButton.setEnabled(false);
        this.selectFilesButton.setEnabled(false);
        this.stopSendingButton.setEnabled(true);
        new NormalThread(){
            final List<File> replayFileList = new ArrayList<File>();
            private final FileFilter IO_REPLAY_FILE_FILTER = new FileFilter(){

                public boolean accept(File pathname) {
                    return Utils.SWING_REPLAY_FILE_FILTER.accept(pathname);
                }
            };

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    PlayersNetworkTab.this.progressBar.setValue(0);
                    PlayersNetworkTab.this.logMessage("\n", false);
                    PlayersNetworkTab.this.logMessage("Counting replays...");
                    this.chooseReplayFiles(files);
                    PlayersNetworkTab.this.progressBar.setMaximum(this.replayFileList.size());
                    if (PlayersNetworkTab.this.requestedToStop) {
                        return;
                    }
                    String sendingMessage = "Sending info about " + this.replayFileList.size() + " replay" + (this.replayFileList.size() == 1 ? "" : "s");
                    PlayersNetworkTab.this.logMessage(String.valueOf(sendingMessage) + "...");
                    long startNanoTime = System.nanoTime();
                    int counter = 0;
                    int skippedRepsCount = 0;
                    for (File replayFile : this.replayFileList) {
                        if (PlayersNetworkTab.this.requestedToStop) {
                            return;
                        }
                        if (!PlayersNetworkTab.this.sendFileInfo(replayFile, null)) {
                            ++skippedRepsCount;
                        }
                        PlayersNetworkTab.this.progressBar.setValue(++counter);
                    }
                    long endNanoTime = System.nanoTime();
                    PlayersNetworkTab.this.logMessage(String.valueOf(sendingMessage) + " done in " + Utils.formatNanoTimeAmount(endNanoTime - startNanoTime));
                    PlayersNetworkTab.this.logMessage("\tSkipped/failed " + skippedRepsCount + " replay" + (skippedRepsCount == 1 ? "" : "s") + ".", false);
                    return;
                }
                finally {
                    if (PlayersNetworkTab.this.requestedToStop) {
                        PlayersNetworkTab.this.logMessage("Sending was manually aborted!");
                    }
                    PlayersNetworkTab.this.stopSendingButton.setEnabled(false);
                    PlayersNetworkTab.this.selectFilesButton.setEnabled(true);
                    PlayersNetworkTab.this.selectFoldersButton.setEnabled(true);
                }
            }

            private void chooseReplayFiles(File[] files2) {
                if (files2 == null) {
                    return;
                }
                File[] fileArray = files2;
                int n = files2.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (PlayersNetworkTab.this.requestedToStop) {
                        return;
                    }
                    if (file.isDirectory()) {
                        this.chooseReplayFiles(file.listFiles(this.IO_REPLAY_FILE_FILTER));
                    } else if (this.IO_REPLAY_FILE_FILTER.accept(file)) {
                        this.replayFileList.add(file);
                    }
                    ++n2;
                }
            }
        }.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean sendFileInfo(File replayFile, Integer gateway) {
        String replayFileAbsolutePath = replayFile.getAbsolutePath();
        this.logMessage("Sending info about " + replayFileAbsolutePath + "...");
        Replay replay = BinRepParser.parseReplay(replayFile, true, false);
        if (replay == null) {
            this.logMessage("Could not parse " + replayFileAbsolutePath + "!");
            return false;
        }
        OutputStreamWriter output = null;
        BufferedReader input = null;
        try {
            URLConnection urlConnection = new URL("http://94.199.240.39/hackerdb/players?op=send").openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            output = new OutputStreamWriter(urlConnection.getOutputStream());
            ReplayHeader replayHeader = replay.replayHeader;
            StringBuilder infoBuilder = new StringBuilder();
            PlayersNetworkTab.appendKeyValue(infoBuilder, "engine", Byte.toString(replayHeader.gameEngine));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "frames", Integer.toString(replayHeader.gameFrames));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "saveTime", Long.toString(replayHeader.saveTime.getTime()));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "name", replayHeader.gameName);
            PlayersNetworkTab.appendKeyValue(infoBuilder, "mapWidth", Short.toString(replayHeader.mapWidth));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "mapHeight", Short.toString(replayHeader.mapHeight));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "speed", Short.toString(replayHeader.gameSpeed));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "type", Short.toString(replayHeader.gameType));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "subType", Short.toString(replayHeader.gameSubType));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "creatorName", replayHeader.creatorName);
            PlayersNetworkTab.appendKeyValue(infoBuilder, "mapName", replayHeader.mapName);
            PlayersNetworkTab.appendKeyValue(infoBuilder, "replayMd5", Utils.calculateFileMd5(replayFile));
            PlayersNetworkTab.appendKeyValue(infoBuilder, "agentVersion", MainFrame.getInstance().applicationVersion);
            if (gateway != null) {
                PlayersNetworkTab.appendKeyValue(infoBuilder, "gateway", Integer.toString(gateway));
            }
            int playerCounter = 0;
            int i = 0;
            while (i < replayHeader.playerNames.length) {
                if (replayHeader.playerNames[i] != null) {
                    PlayersNetworkTab.appendKeyValue(infoBuilder, "playerName" + playerCounter, replayHeader.playerNames[i]);
                    PlayersNetworkTab.appendKeyValue(infoBuilder, "playerRace" + playerCounter, Integer.toString(replayHeader.playerRaces[i] & 0xFF));
                    PlayersNetworkTab.appendKeyValue(infoBuilder, "playerActions" + playerCounter, Integer.toString(replayHeader.playerIds[i] < replayHeader.playerIdActionsCounts.length ? replayHeader.playerIdActionsCounts[replayHeader.playerIds[i]] : 0));
                    PlayersNetworkTab.appendKeyValue(infoBuilder, "playerColor" + playerCounter, Integer.toString(replayHeader.playerColors[i]));
                    ++playerCounter;
                }
                ++i;
            }
            output.write(infoBuilder.toString());
            output.flush();
            input = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            String message = input.readLine();
            output.close();
            if (message.equals("OK")) {
                this.logMessage("Successfully sent " + replayFileAbsolutePath + ".");
                return true;
            }
            this.logMessage("Rejected, reason: " + message);
        }
        catch (Exception e) {
            this.logMessage("Cound not send " + replayFileAbsolutePath + ".");
            return false;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private static void appendKeyValue(StringBuilder builder, String key, String value) {
        if (builder.length() > 0) {
            builder.append('&');
        }
        try {
            builder.append(URLEncoder.encode(key, "UTF-8")).append('=').append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("autoSendInfoAboutLastRep", Boolean.toString(this.autoSendInfoAboutLastReplayCheckBox.isSelected()));
    }
}

