/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhf.control.BinRepParser;
import hu.belicza.andras.bwhf.model.Action;
import hu.belicza.andras.bwhf.model.PlayerActions;
import hu.belicza.andras.bwhf.model.Replay;
import hu.belicza.andras.bwhf.model.ReplayHeader;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.NormalThread;
import hu.belicza.andras.bwhfagent.view.Tab;
import hu.belicza.andras.bwhfagent.view.Utils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.GridLayout;
import swingwt.awt.LayoutManager;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.MouseAdapter;
import swingwt.awt.event.MouseEvent;
import swingwt.awt.event.MouseListener;
import swingwtx.swing.BorderFactory;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JFileChooser;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.JProgressBar;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.JTable;
import swingwtx.swing.border.Border;
import swingwtx.swing.table.DefaultTableModel;
import swingwtx.swing.table.TableModel;

public class PlayerMatcherTab
extends Tab {
    private final JCheckBox dontCompareSameNamesCheckBox = new JCheckBox("Don't compare players with same names", Boolean.parseBoolean(Utils.settingsProperties.getProperty("dontCompareSameNames")));
    private final JComboBox authoritativenessThresholdComboBox;
    private final JComboBox matchingProbabilityThresholdComboBox = new JComboBox(new Object[]{"100%", "90%", "80%", "70%", "60%", "50%", "40%", "30%", "20%", "10%", "0%"});
    private final JButton selectFoldersButton = new JButton("Select folders to analyze recursively...", (Icon)IconResourceManager.ICON_FOLDER_CHOOSER);
    private final JButton selectFilesButton = new JButton("Select files to analyze...", (Icon)IconResourceManager.ICON_FILE_CHOOSER);
    private final JButton repeatAnalysisButton = new JButton("Repeat analysis", (Icon)IconResourceManager.ICON_REPEAT);
    private final JButton stopAnalyzingButton = new JButton("Stop analyzing", (Icon)IconResourceManager.ICON_STOP);
    private volatile boolean requestedToStop;
    private static final String[] RESULT_TABLE_COLUMN_NAMES = new String[]{"Authoritativeness", "Matching probability", "Player #1", "Player #2", "Replay #1", "Replay #2"};
    private static final boolean[] DEFAULT_SORTING_ASCENDNANTS;
    private final JProgressBar progressBar = new JProgressBar();
    private File[] lastAnalysisSourceFiles;
    private final JTable resultTable = new JTable();
    private final List<Comparison> comparisonList = new ArrayList<Comparison>();
    private int lastSortingIndex;
    private boolean lastSortingAscendant;
    private final JLabel resultsCountLabel = new JLabel();

    static {
        boolean[] blArray = new boolean[6];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        DEFAULT_SORTING_ASCENDNANTS = blArray;
    }

    public PlayerMatcherTab() {
        super("Player matcher", (Icon)IconResourceManager.ICON_PLAYER_MATCHER);
        List<AuthoritativenessExtent> authoritativenessExtentList = Arrays.asList(AuthoritativenessExtent.values());
        Collections.reverse(authoritativenessExtentList);
        this.authoritativenessThresholdComboBox = new JComboBox((Object[])authoritativenessExtentList.toArray(new AuthoritativenessExtent[authoritativenessExtentList.size()]));
        this.authoritativenessThresholdComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("authoritativenessThreshold")));
        this.matchingProbabilityThresholdComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("matchingProbabilityThreshold")));
        this.buildGUI();
    }

    protected void buildGUI() {
        JButton visitPlayerMatcherHelpPageButton = new JButton("Visit Player matcher help page", (Icon)IconResourceManager.ICON_WORLD_GO);
        visitPlayerMatcherHelpPageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Utils.showURLInBrowser("http://code.google.com/p/bwhf/wiki/PlayerMatcherInBWHFAgent");
            }
        });
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)visitPlayerMatcherHelpPageButton));
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.dontCompareSameNamesCheckBox));
        JPanel thresholdPanel = new JPanel((LayoutManager)new GridLayout(2, 2, 7, 0));
        thresholdPanel.setBorder((Border)BorderFactory.createTitledBorder((String)"Display thresholds:"));
        thresholdPanel.add((Component)new JLabel("Extent of authoritativeness:"));
        thresholdPanel.add((Component)this.authoritativenessThresholdComboBox);
        thresholdPanel.add((Component)new JLabel("Matching probability:"));
        thresholdPanel.add((Component)this.matchingProbabilityThresholdComboBox);
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)thresholdPanel));
        ActionListener selectFilesAndFoldersActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(MainFrame.getInstance().generalSettingsTab.getReplayStartFolder());
                fileChooser.setExtensionFilters(new String[]{"*.rep", "*.*"}, new String[]{"Replay Files (*.rep)", "All files (*.*)"});
                fileChooser.addChoosableFileFilter(Utils.SWING_REPLAY_FILE_FILTER);
                fileChooser.setFileSelectionMode(event.getSource() == PlayerMatcherTab.this.selectFoldersButton ? 1 : 2);
                fileChooser.setMultiSelectionEnabled(true);
                if (fileChooser.showOpenDialog((Component)PlayerMatcherTab.this.getContent()) == 0) {
                    File[] fileArray;
                    if (event.getSource() == PlayerMatcherTab.this.selectFoldersButton) {
                        File[] fileArray2 = new File[1];
                        fileArray = fileArray2;
                        fileArray2[0] = fileChooser.getSelectedFile();
                    } else {
                        fileArray = fileChooser.getSelectedFiles();
                    }
                    PlayerMatcherTab.this.analyzeFilesAndFolders(fileArray);
                }
            }
        };
        JPanel buttonsPanel = Utils.createWrapperPanel();
        this.selectFilesButton.setMnemonic('f');
        this.selectFilesButton.addActionListener(selectFilesAndFoldersActionListener);
        buttonsPanel.add((Component)this.selectFilesButton);
        this.selectFoldersButton.setMnemonic('d');
        this.selectFoldersButton.addActionListener(selectFilesAndFoldersActionListener);
        buttonsPanel.add((Component)this.selectFoldersButton);
        this.repeatAnalysisButton.setMnemonic('r');
        this.repeatAnalysisButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PlayerMatcherTab.this.analyzeFilesAndFolders(PlayerMatcherTab.this.lastAnalysisSourceFiles);
            }
        });
        buttonsPanel.add((Component)this.repeatAnalysisButton);
        this.contentBox.add((Component)buttonsPanel);
        this.stopAnalyzingButton.setEnabled(false);
        this.stopAnalyzingButton.setMnemonic('t');
        this.stopAnalyzingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PlayerMatcherTab.this.requestedToStop = true;
                PlayerMatcherTab.this.stopAnalyzingButton.setEnabled(false);
            }
        });
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.stopAnalyzingButton));
        this.progressBar.setMaximumSize(Utils.getMaxDimension());
        this.contentBox.add((Component)this.progressBar);
        JPanel panel = Utils.createWrapperPanelLeftAligned();
        panel.add((Component)new JLabel("Comparison result:"));
        panel.add((Component)this.resultsCountLabel);
        this.contentBox.add((Component)panel);
        this.resultTable.setPreferredSize(new Dimension(50, 50));
        this.resultTable.setRowSelectionAllowed(true);
        this.resultTable.getSelectionModel().setSelectionMode(0);
        this.resultTable.setColumnSelectionAllowed(true);
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (PlayerMatcherTab.this.resultTable.getSelectedRow() >= 0 && event.getClickCount() == 2) {
                    String replayPath = event.getButton() == 1 ? ((Comparison)((PlayerMatcherTab)PlayerMatcherTab.this).comparisonList.get((int)((PlayerMatcherTab)PlayerMatcherTab.this).resultTable.getSelectedRow())).analysis1.replayPath : ((Comparison)((PlayerMatcherTab)PlayerMatcherTab.this).comparisonList.get((int)((PlayerMatcherTab)PlayerMatcherTab.this).resultTable.getSelectedRow())).analysis2.replayPath;
                    MainFrame.getInstance().selectTab(MainFrame.getInstance().chartsTab);
                    MainFrame.getInstance().chartsTab.setReplayFile(new File(replayPath));
                }
            }
        });
        this.resultTable.getTableHeader().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                int sortingIndex = PlayerMatcherTab.this.resultTable.getTableHeader().columnAtPoint(event.getPoint());
                boolean sortingAscendant = sortingIndex == PlayerMatcherTab.this.lastSortingIndex ? !PlayerMatcherTab.this.lastSortingAscendant : DEFAULT_SORTING_ASCENDNANTS[sortingIndex];
                PlayerMatcherTab.this.lastSortingIndex = sortingIndex;
                PlayerMatcherTab.this.lastSortingAscendant = sortingAscendant;
                PlayerMatcherTab.this.sortResultTable();
            }
        });
        this.contentBox.add((Component)new JScrollPane((Component)this.resultTable));
    }

    protected void analyzeFilesAndFolders(final File[] files) {
        if (!this.selectFilesButton.isEnabled()) {
            return;
        }
        this.requestedToStop = false;
        this.selectFoldersButton.setEnabled(false);
        this.selectFilesButton.setEnabled(false);
        this.repeatAnalysisButton.setEnabled(false);
        this.stopAnalyzingButton.setEnabled(true);
        this.lastAnalysisSourceFiles = files;
        new NormalThread(){
            final List<File> replayFileList = new ArrayList<File>();
            private final FileFilter IO_REPLAY_FILE_FILTER = new FileFilter(){

                public boolean accept(File pathname) {
                    return Utils.SWING_REPLAY_FILE_FILTER.accept(pathname);
                }
            };

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    boolean compareSameNames = !PlayerMatcherTab.this.dontCompareSameNamesCheckBox.isSelected();
                    float matchingProbabilityThreshold = Float.parseFloat(((String)PlayerMatcherTab.this.matchingProbabilityThresholdComboBox.getSelectedItem()).substring(0, ((String)PlayerMatcherTab.this.matchingProbabilityThresholdComboBox.getSelectedItem()).length() - 1));
                    AuthoritativenessExtent authoritativenessThreshold = (AuthoritativenessExtent)((Object)PlayerMatcherTab.this.authoritativenessThresholdComboBox.getSelectedItem());
                    PlayerMatcherTab.this.resultsCountLabel.setText("Counting...");
                    PlayerMatcherTab.this.progressBar.setValue(0);
                    this.chooseReplayFiles(files);
                    PlayerMatcherTab.this.progressBar.setMaximum(this.replayFileList.size());
                    if (PlayerMatcherTab.this.requestedToStop) {
                        return;
                    }
                    PlayerMatcherTab.this.resultsCountLabel.setText("Analyzing " + this.replayFileList.size() + " replay" + (this.replayFileList.size() == 1 ? "" : "s") + "...");
                    int counter = 0;
                    int skippedRepsCount = 0;
                    ArrayList playerAnalysisList = new ArrayList();
                    PlayerMatcherTab.this.comparisonList.clear();
                    for (File replayFile : this.replayFileList) {
                        if (PlayerMatcherTab.this.requestedToStop) {
                            return;
                        }
                        Replay replay = BinRepParser.parseReplay(replayFile, true, false);
                        if (replay == null) {
                            ++skippedRepsCount;
                        } else {
                            ArrayList<PlayerAnalysis> replayPlayerAnalysisList = new ArrayList<PlayerAnalysis>(replay.replayActions.players.length);
                            PlayerActions[] playerActionsArray = replay.replayActions.players;
                            int n = replay.replayActions.players.length;
                            int n2 = 0;
                            while (n2 < n) {
                                PlayerActions playerActions = playerActionsArray[n2];
                                ReplayHeader replayHeader = replay.replayHeader;
                                int playerIndex = replayHeader.getPlayerIndexByName(playerActions.playerName);
                                int actionsCount = playerActions.actions.length;
                                float actionsCountFloat = actionsCount;
                                int frames = playerActions.actions.length > 0 ? playerActions.actions[actionsCount - 1].iteration : 0;
                                int seconds = ReplayHeader.convertFramesToSeconds(frames);
                                boolean firstTrainThenGather = false;
                                int hotkeysCount = 0;
                                int selectsCount = 0;
                                int shiftSelectsCount = 0;
                                int rallySetsCount = 0;
                                int movesCount = 0;
                                int attackMovesCount = 0;
                                int[] usedHotkeysCounts = new int[10];
                                int commandRepetionTendency = 0;
                                int averageSelectedUnits = 0;
                                if (playerActions.actions.length >= 3) {
                                    int i = 0;
                                    while (i < 2) {
                                        if (playerActions.actions[i].actionNameIndex == 31 || playerActions.actions[i].actionNameIndex == 35) {
                                            firstTrainThenGather = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                                Action lastAction = null;
                                Action[] actionArray = playerActions.actions;
                                int n3 = playerActions.actions.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Action action = actionArray[n4];
                                    switch (action.actionNameIndex) {
                                        case 19: {
                                            ++hotkeysCount;
                                            try {
                                                int hotkey;
                                                int n5 = hotkey = action.parameters.charAt(action.parameters.indexOf(44) + 1) - 48;
                                                usedHotkeysCounts[n5] = usedHotkeysCounts[n5] + 1;
                                            }
                                            catch (Exception hotkey) {}
                                            break;
                                        }
                                        case 9: {
                                            ++selectsCount;
                                            ++averageSelectedUnits;
                                            int i = action.parameters.length() - 1;
                                            while (i >= 0) {
                                                if (action.parameters.charAt(i) == ',') {
                                                    ++averageSelectedUnits;
                                                }
                                                --i;
                                            }
                                            break;
                                        }
                                        case 10: {
                                            ++shiftSelectsCount;
                                            break;
                                        }
                                        case -5: {
                                            ++rallySetsCount;
                                            break;
                                        }
                                        case 20: {
                                            ++movesCount;
                                            break;
                                        }
                                        case -3: {
                                            ++attackMovesCount;
                                            break;
                                        }
                                    }
                                    if (lastAction != null && action.actionNameIndex != -1 && lastAction.actionNameIndex == action.actionNameIndex) {
                                        ++commandRepetionTendency;
                                    }
                                    lastAction = action;
                                    ++n4;
                                }
                                float[] usedHotkeyRates = new float[usedHotkeysCounts.length];
                                int i = usedHotkeyRates.length - 1;
                                while (i >= 0) {
                                    usedHotkeyRates[i] = (float)usedHotkeysCounts[i] / actionsCountFloat;
                                    --i;
                                }
                                PlayerAnalysis playerAnalysis = new PlayerAnalysis(replayFile.getAbsolutePath(), replayHeader.saveTime.getTime(), playerActions.playerName, replayHeader.playerRaces[playerIndex], frames, frames == 0 ? 0 : (seconds == 0 ? 0 : playerActions.actions.length * 60 / seconds), firstTrainThenGather, (float)hotkeysCount / actionsCountFloat, (float)selectsCount / actionsCountFloat, (float)shiftSelectsCount / actionsCountFloat, (float)rallySetsCount / actionsCountFloat, (float)movesCount / actionsCountFloat, (float)attackMovesCount / actionsCountFloat, usedHotkeyRates, (float)commandRepetionTendency / actionsCountFloat, (float)averageSelectedUnits / (float)selectsCount);
                                replayPlayerAnalysisList.add(playerAnalysis);
                                for (PlayerAnalysis playerAnalysis2 : playerAnalysisList) {
                                    if (!compareSameNames && playerAnalysis2.loweredPlayerName.equals(playerAnalysis.loweredPlayerName)) continue;
                                    Comparison comparison = new Comparison(playerAnalysis2, playerAnalysis, authoritativenessThreshold, matchingProbabilityThreshold);
                                    if (!comparison.thresholdReached) continue;
                                    PlayerMatcherTab.this.comparisonList.add(comparison);
                                }
                                ++n2;
                            }
                            playerAnalysisList.addAll(replayPlayerAnalysisList);
                        }
                        PlayerMatcherTab.this.progressBar.setValue(++counter);
                    }
                    PlayerMatcherTab.this.resultsCountLabel.setText(String.valueOf(PlayerMatcherTab.this.comparisonList.size()) + " match" + (PlayerMatcherTab.this.comparisonList.size() == 1 ? "" : "es") + " in " + this.replayFileList.size() + " replay" + (this.replayFileList.size() == 1 ? "" : "s") + (skippedRepsCount > 0 ? " (skipped " + skippedRepsCount + (skippedRepsCount == 1 ? " replay)" : " replays)") : ""));
                    PlayerMatcherTab.this.lastSortingIndex = 0;
                    PlayerMatcherTab.this.lastSortingAscendant = DEFAULT_SORTING_ASCENDNANTS[PlayerMatcherTab.this.lastSortingIndex];
                    PlayerMatcherTab.this.sortResultTable();
                    return;
                }
                finally {
                    if (PlayerMatcherTab.this.requestedToStop) {
                        PlayerMatcherTab.this.resultsCountLabel.setText("Analyzing was manually aborted!");
                    }
                    PlayerMatcherTab.this.stopAnalyzingButton.setEnabled(false);
                    PlayerMatcherTab.this.repeatAnalysisButton.setEnabled(true);
                    PlayerMatcherTab.this.selectFilesButton.setEnabled(true);
                    PlayerMatcherTab.this.selectFoldersButton.setEnabled(true);
                }
            }

            private void chooseReplayFiles(File[] files2) {
                if (files2 == null) {
                    return;
                }
                File[] fileArray = files2;
                int n = files2.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (PlayerMatcherTab.this.requestedToStop) {
                        return;
                    }
                    if (file.isDirectory()) {
                        this.chooseReplayFiles(file.listFiles(this.IO_REPLAY_FILE_FILTER));
                    } else if (this.IO_REPLAY_FILE_FILTER.accept(file)) {
                        this.replayFileList.add(file);
                    }
                    ++n2;
                }
            }
        }.start();
    }

    private void sortResultTable() {
        Collections.sort(this.comparisonList, new Comparator<Comparison>(){

            @Override
            public int compare(Comparison comparison1, Comparison comparison2) {
                switch (PlayerMatcherTab.this.lastSortingIndex) {
                    case 0: {
                        return PlayerMatcherTab.this.lastSortingAscendant ? comparison1.compareTo(comparison2) : -comparison1.compareTo(comparison2);
                    }
                    case 1: {
                        int comparisonResult = Float.compare(comparison1.matchingProbability, comparison2.matchingProbability);
                        if (comparisonResult == 0) {
                            comparisonResult = comparison2.authoritativenessExtent.ordinal() - comparison1.authoritativenessExtent.ordinal();
                        }
                        return PlayerMatcherTab.this.lastSortingAscendant ? comparisonResult : -comparisonResult;
                    }
                    case 2: {
                        int comparisonResult = comparison1.analysis1.loweredPlayerName.compareTo(comparison2.analysis1.loweredPlayerName);
                        if (comparisonResult == 0) {
                            comparisonResult = -comparison1.compareTo(comparison2);
                        }
                        return PlayerMatcherTab.this.lastSortingAscendant ? comparisonResult : -comparisonResult;
                    }
                    case 3: {
                        int comparisonResult = comparison1.analysis2.loweredPlayerName.compareTo(comparison2.analysis2.loweredPlayerName);
                        if (comparisonResult == 0) {
                            comparisonResult = -comparison1.compareTo(comparison2);
                        }
                        return PlayerMatcherTab.this.lastSortingAscendant ? comparisonResult : -comparisonResult;
                    }
                    case 4: {
                        return PlayerMatcherTab.this.lastSortingAscendant ? comparison1.analysis1.replayPath.compareTo(comparison2.analysis1.replayPath) : -comparison1.analysis1.replayPath.compareTo(comparison2.analysis1.replayPath);
                    }
                    case 5: {
                        return PlayerMatcherTab.this.lastSortingAscendant ? comparison1.analysis2.replayPath.compareTo(comparison2.analysis2.replayPath) : -comparison1.analysis2.replayPath.compareTo(comparison2.analysis2.replayPath);
                    }
                }
                return 0;
            }
        });
        this.refreshResultTable();
    }

    private void refreshResultTable() {
        Vector resultDataVector = new Vector(this.comparisonList.size());
        for (Comparison comparison : this.comparisonList) {
            Vector<String> rowVector = new Vector<String>(6);
            rowVector.add(comparison.authoritativenessExtent.toString());
            rowVector.add(String.format("%.1f%%", Float.valueOf(comparison.matchingProbability)));
            rowVector.add(comparison.analysis1.playerName);
            rowVector.add(comparison.analysis2.playerName);
            rowVector.add(comparison.analysis1.replayPath);
            rowVector.add(comparison.analysis2.replayPath);
            resultDataVector.add(rowVector);
        }
        Vector columnNameVector = new Vector(6);
        Collections.addAll(columnNameVector, RESULT_TABLE_COLUMN_NAMES);
        this.resultTable.setModel((TableModel)new DefaultTableModel(resultDataVector, columnNameVector){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
    }

    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("dontCompareSameNames", Boolean.toString(this.dontCompareSameNamesCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("authoritativenessThreshold", Integer.toString(this.authoritativenessThresholdComboBox.getSelectedIndex()));
        Utils.settingsProperties.setProperty("matchingProbabilityThreshold", Integer.toString(this.matchingProbabilityThresholdComboBox.getSelectedIndex()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AuthoritativenessExtent {
        USELESS("Useless"),
        VERY_POOR("Very poor"),
        POOR("Poor"),
        AVERAGE("Average"),
        GOOD("Good"),
        VERY_GOOD("Very good"),
        EXCELLENT("Excellent");

        private final String displayName;

        private AuthoritativenessExtent(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Comparison
    implements Comparable<Comparison> {
        final PlayerAnalysis analysis1;
        final PlayerAnalysis analysis2;
        final AuthoritativenessExtent authoritativenessExtent;
        final float matchingProbability;
        final boolean thresholdReached;
        private static final int FOUR_MINUTES_FRAMES = ReplayHeader.convertSecondsToFrames(240);
        private static final float[] MATCHING_WEIGHTS = new float[]{0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};

        static {
            float sumWeights = 0.0f;
            float[] fArray = MATCHING_WEIGHTS;
            int n = MATCHING_WEIGHTS.length;
            int n2 = 0;
            while (n2 < n) {
                float weight = fArray[n2];
                sumWeights += weight;
                ++n2;
            }
            float mulFactor = 100.0f / sumWeights;
            int i = MATCHING_WEIGHTS.length - 1;
            while (i >= 0) {
                int n3 = i--;
                MATCHING_WEIGHTS[n3] = MATCHING_WEIGHTS[n3] * mulFactor;
            }
        }

        public Comparison(PlayerAnalysis analysis1, PlayerAnalysis analysis2, AuthoritativenessExtent authoritativenessExtentThreshold, float matchingProbabilityThreshold) {
            this.analysis1 = analysis1;
            this.analysis2 = analysis2;
            this.authoritativenessExtent = this.determineAuthoritativenessExtent();
            if (this.authoritativenessExtent.compareTo(authoritativenessExtentThreshold) >= 0) {
                this.matchingProbability = this.calculateMatchingProbability();
                this.thresholdReached = this.matchingProbability >= matchingProbabilityThreshold;
            } else {
                this.matchingProbability = 0.0f;
                this.thresholdReached = false;
            }
        }

        public String toString() {
            return String.format("%-9s %3.1f%% - %s, %s  (%s, %s)", this.authoritativenessExtent.toString(), Float.valueOf(this.matchingProbability), this.analysis1.playerName, this.analysis2.playerName, this.analysis1.replayPath, this.analysis2.replayPath);
        }

        private AuthoritativenessExtent determineAuthoritativenessExtent() {
            float authroitativenessExtent = 1.0f;
            if (this.analysis1.race != this.analysis2.race) {
                authroitativenessExtent *= 0.5f;
            }
            authroitativenessExtent = this.analysis1.realApm < 30 || this.analysis2.realApm < 30 ? 0.0f : (authroitativenessExtent *= Comparison.rate(this.analysis1.realApm, this.analysis2.realApm));
            if (this.analysis1.frames < FOUR_MINUTES_FRAMES) {
                authroitativenessExtent *= (float)this.analysis1.frames / (float)FOUR_MINUTES_FRAMES;
            }
            authroitativenessExtent *= Comparison.rate(this.analysis1.frames, this.analysis2.frames);
            int days = (int)(Math.abs(this.analysis1.replayDate - this.analysis2.replayDate) / 86400000L);
            int extentOrdinal = (int)((authroitativenessExtent *= days < 2000 ? (2000.0f - (float)days) / 2000.0f : 0.0f) * (float)AuthoritativenessExtent.values().length);
            if (extentOrdinal > AuthoritativenessExtent.values().length - 1) {
                return AuthoritativenessExtent.EXCELLENT;
            }
            if (extentOrdinal < 0) {
                return AuthoritativenessExtent.USELESS;
            }
            return AuthoritativenessExtent.values()[extentOrdinal];
        }

        private float calculateMatchingProbability() {
            float matchingProbability = 0.0f;
            int componentIndex = 0;
            matchingProbability += MATCHING_WEIGHTS[componentIndex++] * (this.analysis1.firstTrainThenGather == this.analysis2.firstTrainThenGather ? 1.0f : 0.0f);
            matchingProbability += MATCHING_WEIGHTS[componentIndex++] * Comparison.rate(this.analysis1.hotkeyRate, this.analysis2.hotkeyRate);
            matchingProbability += MATCHING_WEIGHTS[componentIndex++] * Comparison.rate(this.analysis1.selectRate, this.analysis2.selectRate);
            matchingProbability += MATCHING_WEIGHTS[componentIndex++] * Comparison.rate(this.analysis1.shiftSelectRate, this.analysis2.shiftSelectRate);
            matchingProbability += MATCHING_WEIGHTS[componentIndex++] * Comparison.rate(this.analysis1.rallySetRate, this.analysis2.rallySetRate);
            matchingProbability += MATCHING_WEIGHTS[componentIndex++] * Comparison.rate(this.analysis1.moveRate, this.analysis2.moveRate);
            matchingProbability += MATCHING_WEIGHTS[componentIndex++] * Comparison.rate(this.analysis1.attackMoveRate, this.analysis2.attackMoveRate);
            float weightFor1Hotkey = MATCHING_WEIGHTS[componentIndex++] / (float)this.analysis1.usedHotkeyRates.length;
            int i = this.analysis1.usedHotkeyRates.length - 1;
            while (i >= 0) {
                matchingProbability += weightFor1Hotkey * Comparison.rate(this.analysis1.usedHotkeyRates[i], this.analysis2.usedHotkeyRates[i]);
                --i;
            }
            matchingProbability += MATCHING_WEIGHTS[componentIndex++] * Comparison.rate(this.analysis1.commandRepetionTendency, this.analysis2.commandRepetionTendency);
            int n = componentIndex++;
            if ((matchingProbability += MATCHING_WEIGHTS[n] * Comparison.rate(this.analysis1.averageSeletedUnits, this.analysis2.averageSeletedUnits)) < 0.0f) {
                matchingProbability = 0.0f;
            }
            if (matchingProbability > 100.0f) {
                matchingProbability = 100.0f;
            }
            return matchingProbability;
        }

        private static float rate(float value1, float value2) {
            if (value1 <= 0.0f && value2 <= 0.0f) {
                return 1.0f;
            }
            return value1 < value2 ? value1 / value2 : value2 / value1;
        }

        @Override
        public int compareTo(Comparison comparison) {
            if (this.authoritativenessExtent == comparison.authoritativenessExtent) {
                return Float.compare(this.matchingProbability, comparison.matchingProbability);
            }
            return this.authoritativenessExtent.compareTo(comparison.authoritativenessExtent);
        }
    }

    private static class PlayerAnalysis {
        final String replayPath;
        final long replayDate;
        final String playerName;
        final String loweredPlayerName;
        final byte race;
        final int frames;
        final int realApm;
        final boolean firstTrainThenGather;
        final float hotkeyRate;
        final float selectRate;
        final float shiftSelectRate;
        final float rallySetRate;
        final float moveRate;
        final float attackMoveRate;
        final float[] usedHotkeyRates;
        final float commandRepetionTendency;
        final float averageSeletedUnits;

        public PlayerAnalysis(String replayPath, long replayDate, String playerName, byte race, int frames, int realApm, boolean firstTrainThenGather, float hotkeyRate, float selectRate, float shiftSelectRate, float rallySetRate, float moveRate, float attackMoveRate, float[] usedHotkeyRates, float commandRepetionTendency, float averageSelectedUnits) {
            this.replayPath = replayPath;
            this.replayDate = replayDate;
            this.playerName = playerName;
            this.loweredPlayerName = playerName.toLowerCase();
            this.race = race;
            this.frames = frames;
            this.realApm = realApm;
            this.firstTrainThenGather = firstTrainThenGather;
            this.hotkeyRate = hotkeyRate;
            this.selectRate = selectRate;
            this.shiftSelectRate = shiftSelectRate;
            this.rallySetRate = rallySetRate;
            this.moveRate = moveRate;
            this.attackMoveRate = attackMoveRate;
            this.usedHotkeyRates = usedHotkeyRates;
            this.commandRepetionTendency = commandRepetionTendency;
            this.averageSeletedUnits = averageSelectedUnits;
        }
    }
}

