/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhf.control.BinRepParser;
import hu.belicza.andras.bwhf.control.ReplayScanner;
import hu.belicza.andras.bwhf.model.HackDescription;
import hu.belicza.andras.bwhfagent.Consts;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.NormalThread;
import hu.belicza.andras.bwhfagent.view.ProgressLoggedTab;
import hu.belicza.andras.bwhfagent.view.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.Box;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JFileChooser;
import swingwtx.swing.JLabel;
import swingwtx.swing.JOptionPane;
import swingwtx.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualScanTab
extends ProgressLoggedTab {
    private static final String LOG_FILE_NAME = "manual_scan.log";
    private static final String HTML_FILE_EXTENSION = ".html";
    private static final String HACKER_REPS_FLAG = "hack";
    public static final swingwtx.swing.filechooser.FileFilter HTML_FILE_FILTER = new swingwtx.swing.filechooser.FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(ManualScanTab.HTML_FILE_EXTENSION);
        }

        public String getDescription() {
            return "HTML report files (*.html)";
        }
    };
    protected final JButton scanLastReplayButton = new JButton("Scan 'LastReplay.rep'", (Icon)IconResourceManager.ICON_LASTREPLAY);
    private final JButton selectFoldersButton = new JButton("Select folders to scan recursively...", (Icon)IconResourceManager.ICON_FOLDER_CHOOSER);
    private final JButton selectFilesButton = new JButton("Select files to scan...", (Icon)IconResourceManager.ICON_FILE_CHOOSER);
    private final JButton stopScanButton = new JButton("Stop current scan", (Icon)IconResourceManager.ICON_STOP);
    private final JCheckBox flagHackerRepsCheckBox = new JCheckBox("Flag hacker replays by appending 'hack' to the", Boolean.parseBoolean(Utils.settingsProperties.getProperty("flagHackerReps")));
    private final JComboBox flagHackerRepsPositionComboBox = new JComboBox((Object[])Consts.FLAG_HACKER_REPS_POSITION_LABELS);
    private final JCheckBox cleanHackFlagCheckBox = new JCheckBox("Clean the 'hack' flag from replays where no hackers were found during the scan", Boolean.parseBoolean(Utils.settingsProperties.getProperty("cleanHackFlag")));
    private final JCheckBox createHtmlSummaryReportCheckBox = new JCheckBox("Create and open a detailed HTML summary report at the end of scan", Boolean.parseBoolean(Utils.settingsProperties.getProperty("createHtmlSummaryReport")));
    private volatile boolean requestedToStop;

    public ManualScanTab() {
        super("Manual scan", (Icon)IconResourceManager.ICON_MANUAL_SCAN, LOG_FILE_NAME);
        this.buildGUI();
        this.flagHackerRepsPositionComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("flagHackerRepsPosition")));
    }

    @Override
    protected void buildGUI() {
        JButton openPreviousReportButton = new JButton("Open a previous HTML report...", (Icon)IconResourceManager.ICON_HTML);
        openPreviousReportButton.setMnemonic('h');
        openPreviousReportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                File htmlReportDirectory = new File("HTML Reports");
                if (!htmlReportDirectory.exists() || !htmlReportDirectory.isDirectory()) {
                    JOptionPane.showMessageDialog((Container)MainFrame.getInstance(), (Object)"You do not have saved reports!", (String)"Notification", (int)2);
                    return;
                }
                JFileChooser fileChooser = new JFileChooser(htmlReportDirectory);
                fileChooser.setExtensionFilters(new String[]{"*.html", "*.*"}, new String[]{"HTML report files (*.html)", "All files (*.*)"});
                fileChooser.addChoosableFileFilter(HTML_FILE_FILTER);
                fileChooser.setFileSelectionMode(2);
                fileChooser.setMultiSelectionEnabled(false);
                if (fileChooser.showOpenDialog((Component)ManualScanTab.this.getContent()) == 0) {
                    try {
                        Utils.showURLInBrowser(fileChooser.getSelectedFile().toURI().toURL().toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        });
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)openPreviousReportButton));
        ActionListener selectFilesAndFoldersActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(MainFrame.getInstance().generalSettingsTab.getReplayStartFolder());
                fileChooser.setExtensionFilters(new String[]{"*.rep", "*.*"}, new String[]{"Replay Files (*.rep)", "All files (*.*)"});
                fileChooser.addChoosableFileFilter(Utils.SWING_REPLAY_FILE_FILTER);
                fileChooser.setFileSelectionMode(event.getSource() == ManualScanTab.this.selectFoldersButton ? 1 : 2);
                fileChooser.setMultiSelectionEnabled(true);
                if (fileChooser.showOpenDialog((Component)ManualScanTab.this.getContent()) == 0) {
                    File[] fileArray;
                    if (event.getSource() == ManualScanTab.this.selectFoldersButton) {
                        File[] fileArray2 = new File[1];
                        fileArray = fileArray2;
                        fileArray2[0] = fileChooser.getSelectedFile();
                    } else {
                        fileArray = fileChooser.getSelectedFiles();
                    }
                    ManualScanTab.this.scanFilesAndFolders(fileArray, false);
                }
            }
        };
        JPanel selectButtonsPanel = Utils.createWrapperPanel();
        this.scanLastReplayButton.setMnemonic('L');
        this.scanLastReplayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ManualScanTab.this.scanFilesAndFolders(new File[]{new File(MainFrame.getInstance().generalSettingsTab.starcraftFolderTextField.getText(), "maps/replays/LastReplay.rep")}, true);
            }
        });
        selectButtonsPanel.add((Component)this.scanLastReplayButton);
        this.selectFilesButton.setMnemonic('f');
        this.selectFilesButton.addActionListener(selectFilesAndFoldersActionListener);
        selectButtonsPanel.add((Component)this.selectFilesButton);
        this.selectFoldersButton.setMnemonic('d');
        this.selectFoldersButton.addActionListener(selectFilesAndFoldersActionListener);
        selectButtonsPanel.add((Component)this.selectFoldersButton);
        this.contentBox.add((Component)selectButtonsPanel);
        this.stopScanButton.setEnabled(false);
        this.stopScanButton.setMnemonic('t');
        this.stopScanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ManualScanTab.this.requestedToStop = true;
                ManualScanTab.this.stopScanButton.setEnabled(false);
            }
        });
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.stopScanButton));
        Box settingsBox = Box.createVerticalBox();
        Box flagHackerRepsBox = Box.createHorizontalBox();
        flagHackerRepsBox.add((Component)this.flagHackerRepsCheckBox);
        flagHackerRepsBox.add((Component)this.flagHackerRepsPositionComboBox);
        flagHackerRepsBox.add((Component)Utils.wrapInPanel((JComponent)new JLabel("of their names")));
        settingsBox.add((Component)flagHackerRepsBox);
        settingsBox.add((Component)this.cleanHackFlagCheckBox);
        settingsBox.add((Component)this.createHtmlSummaryReportCheckBox);
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)settingsBox));
        super.buildGUI();
    }

    public void scanFilesAndFolders(final File[] files, final boolean isLastReplay) {
        if (!this.selectFilesButton.isEnabled()) {
            return;
        }
        this.requestedToStop = false;
        this.scanLastReplayButton.setEnabled(false);
        this.selectFoldersButton.setEnabled(false);
        this.selectFilesButton.setEnabled(false);
        this.stopScanButton.setEnabled(true);
        new NormalThread(){
            final List<File> replayFileList = new ArrayList<File>();
            private final FileFilter IO_REPLAY_FILE_FILTER = new FileFilter(){

                public boolean accept(File pathname) {
                    return Utils.SWING_REPLAY_FILE_FILTER.accept(pathname);
                }
            };

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            public void run() {
                try {
                    ManualScanTab.this.progressBar.setValue(0);
                    skipLatterActionsOfHackers = MainFrame.getInstance().generalSettingsTab.skipLatterActionsOfHackersCheckBox.isSelected();
                    ManualScanTab.this.logMessage("\n", false);
                    if (!isLastReplay) {
                        ManualScanTab.this.logMessage("Counting replays...");
                    }
                    this.chooseReplayFiles(files);
                    ManualScanTab.this.progressBar.setMaximum(this.replayFileList.size());
                    if (ManualScanTab.access$3(ManualScanTab.this)) {
                        return;
                    }
                    scanningMessage = "Scanning " + (isLastReplay != false ? new File("maps/replays/LastReplay.rep").getName() : String.valueOf(this.replayFileList.size()) + " replay" + (this.replayFileList.size() == 1 ? "" : "s"));
                    ManualScanTab.this.logMessage(String.valueOf(scanningMessage) + "...");
                    startNanoTime = System.nanoTime();
                    startTime = new Date();
                    hackerRepsCount = 0;
                    skippedRepsCount = 0;
                    playerHackerRepsCountMap = new HashMap<String, IntWrapper>();
                    playerNameHackerRepMapMap = ManualScanTab.access$5(ManualScanTab.this).isSelected() != false && isLastReplay == false ? new HashMap<String, HashMap<String, HashMap<String, HashMap<String, HashMap<K, V>>>>>() : null;
                    counter = 0;
                    for (File replayFile : this.replayFileList) {
                        if (ManualScanTab.access$3(ManualScanTab.this)) ** continue;
                        replayFileAbsolutePath = replayFile.getAbsolutePath();
                        hackDescriptionList = null;
                        replay = BinRepParser.parseReplay(replayFile, true, false);
                        if (replay != null) {
                            hackDescriptionList = ReplayScanner.scanReplayForHacks(replay, skipLatterActionsOfHackers);
                        }
                        if (hackDescriptionList == null) {
                            ++skippedRepsCount;
                            ManualScanTab.this.logMessage("Could not scan " + replayFileAbsolutePath + "!");
                        } else if (!hackDescriptionList.isEmpty()) {
                            ++hackerRepsCount;
                            ManualScanTab.this.logMessage("Found " + hackDescriptionList.size() + " hack" + (hackDescriptionList.size() == 1 ? "" : "s") + " in " + replayFileAbsolutePath + ":");
                            hackersOfReplaySet = new HashSet<String>();
                            for (HackDescription hackDescription : hackDescriptionList) {
                                ManualScanTab.this.logMessage("\t" + hackDescription.description, false);
                                lowerCasedHackerName = hackDescription.playerName.toLowerCase();
                                if (!hackersOfReplaySet.contains(lowerCasedHackerName)) {
                                    hackersOfReplaySet.add(lowerCasedHackerName);
                                    playerHackerRepsCount = (IntWrapper)playerHackerRepsCountMap.get(lowerCasedHackerName);
                                    if (playerHackerRepsCount == null) {
                                        playerHackerRepsCount = new IntWrapper();
                                        playerHackerRepsCountMap.put(lowerCasedHackerName, playerHackerRepsCount);
                                    }
                                    ++playerHackerRepsCount.value;
                                }
                                if (playerNameHackerRepMapMap == null) continue;
                                replayNameUsedHackTypeSet = (HashMap<String, HashSet<Integer>>)playerNameHackerRepMapMap.get(lowerCasedHackerName);
                                if (replayNameUsedHackTypeSet == null) {
                                    replayNameUsedHackTypeSet = new HashMap<String, HashSet<Integer>>(1);
                                    playerNameHackerRepMapMap.put(lowerCasedHackerName, replayNameUsedHackTypeSet);
                                }
                                if ((usedHackTypeSet = (HashSet<Integer>)replayNameUsedHackTypeSet.get(replayFileAbsolutePath)) == null) {
                                    usedHackTypeSet = new HashSet<Integer>(1);
                                    replayNameUsedHackTypeSet.put(replayFileAbsolutePath, usedHackTypeSet);
                                }
                                usedHackTypeSet.add(hackDescription.hackType);
                            }
                            if (ManualScanTab.access$6(ManualScanTab.this).isSelected() && !isLastReplay) {
                                replayName = replayFile.getName().substring(0, replayFile.getName().length() - ".rep".length());
                                flaggedReplayName = null;
                                switch (ManualScanTab.access$7(ManualScanTab.this).getSelectedIndex()) {
                                    case 0: {
                                        if (replayName.startsWith("hack - ")) break;
                                        flaggedReplayName = "hack - " + replayName;
                                        break;
                                    }
                                    case 1: {
                                        if (replayName.endsWith(" - hack")) break;
                                        flaggedReplayName = String.valueOf(replayName) + " - " + "hack";
                                    }
                                }
                                if (flaggedReplayName != null) {
                                    replayFile.renameTo(new File(replayFile.getParent(), String.valueOf(flaggedReplayName) + ".rep"));
                                }
                            }
                        } else {
                            ManualScanTab.this.logMessage("Found no hacks in " + replayFileAbsolutePath + ".");
                            if (ManualScanTab.access$8(ManualScanTab.this).isSelected() && !isLastReplay) {
                                replayName = replayFile.getName().substring(0, replayFile.getName().length() - ".rep".length());
                                cleanedReplayName = replayName;
                                if (cleanedReplayName.startsWith("hack - ")) {
                                    cleanedReplayName = cleanedReplayName.substring("hack - ".length());
                                }
                                if (cleanedReplayName.endsWith(" - hack")) {
                                    cleanedReplayName = cleanedReplayName.substring(0, cleanedReplayName.length() - " - hack".length() + 1);
                                }
                                if (replayName.length() != cleanedReplayName.length()) {
                                    replayFile.renameTo(new File(replayFile.getParent(), String.valueOf(cleanedReplayName) + ".rep"));
                                }
                            }
                        }
                        ManualScanTab.this.progressBar.setValue(++counter);
                    }
                    endNanoTime = System.nanoTime();
                    endTime = new Date();
                    infoMessages = new String[3];
                    infoMessages[0] = String.valueOf(scanningMessage) + " done in " + Utils.formatNanoTimeAmount(endNanoTime - startNanoTime);
                    ManualScanTab.this.logMessage(infoMessages[0]);
                    infoMessages[1] = "\tFound " + hackerRepsCount + " hacker replay" + (hackerRepsCount == 1 ? "" : "s") + ".";
                    ManualScanTab.this.logMessage(infoMessages[1], false);
                    infoMessages[2] = "\tSkipped " + skippedRepsCount + " replay" + (skippedRepsCount == 1 ? "" : "s") + ".";
                    ManualScanTab.this.logMessage(infoMessages[2], false);
                    if (!playerHackerRepsCountMap.isEmpty()) {
                        hackersBuilder = new StringBuilder("\tThe following player" + (playerHackerRepsCountMap.size() == 1 ? " was" : "s were") + " found hacking: ");
                        firstHacker = true;
                        for (Map.Entry playerHackerRepsCount : new TreeMap<K, V>(playerHackerRepsCountMap).entrySet()) {
                            if (firstHacker) {
                                firstHacker = false;
                            } else {
                                hackersBuilder.append(", ");
                            }
                            hackersBuilder.append((String)playerHackerRepsCount.getKey());
                            if (((IntWrapper)playerHackerRepsCount.getValue()).value <= 1) continue;
                            hackersBuilder.append(" (x").append(((IntWrapper)playerHackerRepsCount.getValue()).value).append(')');
                        }
                        ManualScanTab.this.logMessage(hackersBuilder.toString(), false);
                    }
                    if (playerNameHackerRepMapMap != null) {
                        ManualScanTab.access$9(ManualScanTab.this, playerNameHackerRepMapMap, startTime, endTime, infoMessages);
                    }
                }
                finally {
                    if (ManualScanTab.access$3(ManualScanTab.this)) {
                        ManualScanTab.this.logMessage("Scan was manually aborted!");
                    }
                    ManualScanTab.access$2(ManualScanTab.this).setEnabled(false);
                    ManualScanTab.access$4(ManualScanTab.this).setEnabled(true);
                    ManualScanTab.access$0(ManualScanTab.this).setEnabled(true);
                    ManualScanTab.this.scanLastReplayButton.setEnabled(true);
                }
            }

            private void chooseReplayFiles(File[] files2) {
                if (files2 == null) {
                    return;
                }
                File[] fileArray = files2;
                int n = files2.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (ManualScanTab.this.requestedToStop) {
                        return;
                    }
                    if (file.isDirectory()) {
                        this.chooseReplayFiles(file.listFiles(this.IO_REPLAY_FILE_FILTER));
                    } else if (this.IO_REPLAY_FILE_FILTER.accept(file)) {
                        this.replayFileList.add(file);
                    }
                    ++n2;
                }
            }
        }.start();
    }

    private void saveAndOpenHtmlSummaryReport(Map<String, Map<String, Set<Integer>>> playerNameHackerRepMapMap, Date scanStartTime, Date scanEndTime, String[] infoMessages) {
        File htmlReportDirectory = new File("HTML Reports");
        File htmlReportFile = new File(htmlReportDirectory, "Manual scan report " + Utils.DATE_FORMAT.format(new Date()) + HTML_FILE_EXTENSION);
        PrintWriter output = null;
        try {
            try {
                if (!htmlReportDirectory.exists()) {
                    htmlReportDirectory.mkdir();
                }
                output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlReportFile), "UTF-8"));
                output.println("<html>");
                output.println("<head>");
                output.println("<title>BWHF Agent Manual Scan Summary Report</title>");
                output.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
                output.println("<style>");
                output.println(".row00 {background:#9999ff;}");
                output.println(".row01 {background:#9999cc;}");
                output.println(".row10 {background:#ff9999;}");
                output.println(".row11 {background:#cc9999;}");
                output.println("</style>");
                output.println("</head>");
                output.println("<body><center>");
                output.println("<h2>BWHF Agent Manual Scan Summary Report</h2>");
                output.println("The manual scan took place between <b>" + DATE_FORMAT.format(scanStartTime) + "</b> and <b>" + DATE_FORMAT.format(scanEndTime) + "</b>");
                output.println("<br><br>");
                String[] stringArray = infoMessages;
                int n = infoMessages.length;
                int n2 = 0;
                while (n2 < n) {
                    String infoMessage = stringArray[n2];
                    output.println(infoMessage);
                    output.println("<br>");
                    ++n2;
                }
                output.println("<br>");
                output.println("<b>The following players were found hacking:</b><br>");
                output.println("(You can use your browser's search function to find a specific name.)");
                output.println("<table border=1>");
                output.println("<tr><th>&nbsp;#&nbsp;<th>Hacker<th>Replays count<th>Replay<th>Hacks used<a href='#hacksUsedNote'>*</a>");
                int counter = 0;
                for (Map.Entry<String, Map<String, Set<Integer>>> playerNameHackerRepMapMapEntry : new TreeMap<String, Map<String, Set<Integer>>>(playerNameHackerRepMapMap).entrySet()) {
                    String playerName = playerNameHackerRepMapMapEntry.getKey();
                    int replayCount = playerNameHackerRepMapMapEntry.getValue().size();
                    output.println("<tr class='row" + (++counter & 1) + "0'><td align=right rowspan=" + replayCount + ">" + counter + "<td rowspan=" + replayCount + ">" + playerName + "<td align=center rowspan=" + replayCount + ">" + replayCount);
                    int counter2 = 0;
                    for (Map.Entry<String, Set<Integer>> replayNameUsedHackTypeSetEntry : playerNameHackerRepMapMapEntry.getValue().entrySet()) {
                        if (counter2++ > 0) {
                            output.print("<tr class='row" + (counter & 1) + (counter2 + 1 & 1) + "'>");
                        }
                        output.print("<td>" + replayNameUsedHackTypeSetEntry.getKey() + "<td>");
                        Iterator<Integer> usedHackTypeIterator = replayNameUsedHackTypeSetEntry.getValue().iterator();
                        while (usedHackTypeIterator.hasNext()) {
                            output.print(String.valueOf(HackDescription.HACK_TYPE_NAMES[usedHackTypeIterator.next()]) + HACKER_REPS_FLAG);
                            if (usedHackTypeIterator.hasNext()) {
                                output.print(", ");
                                continue;
                            }
                            output.println();
                        }
                    }
                }
                output.println("</table>");
                output.println("<a name='hacksUsedNote'><p style='color:#000000;background:#c0f0c0;font-style:italic;'>Note: the list of used hacks might be incomplete if you have fast scanning enabled on the general settings tab (which stops scanning a player if a hack was already found).</p></a>");
                output.println("</center>");
                output.println("<hr>");
                output.println("<table width='100%' border=0>");
                output.println("<tr><td align=left><i>This report was created with BWHF Agent ver <b>" + MainFrame.getInstance().applicationVersion + "</b></i>");
                output.println("<td align=right><i>&copy; Andr&aacute;s Belicza, 2008-2009</i>");
                output.println("</table>");
                output.println("</body></html>");
                output.flush();
                output.close();
                this.logMessage("A detailed HTML summary report has been saved to file '" + htmlReportFile.getAbsolutePath() + "'.");
                Utils.showURLInBrowser(htmlReportFile.toURI().toURL().toString());
            }
            catch (Exception e) {
                this.logMessage("Failed to save HTML summary report to file '" + htmlReportFile.getAbsolutePath() + "'!");
                if (output != null) {
                    output.flush();
                    output.close();
                }
            }
        }
        finally {
            if (output != null) {
                output.flush();
                output.close();
            }
        }
    }

    @Override
    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("flagHackerReps", Boolean.toString(this.flagHackerRepsCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("flagHackerRepsPosition", Integer.toString(this.flagHackerRepsPositionComboBox.getSelectedIndex()));
        Utils.settingsProperties.setProperty("cleanHackFlag", Boolean.toString(this.cleanHackFlagCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("createHtmlSummaryReport", Boolean.toString(this.createHtmlSummaryReportCheckBox.isSelected()));
    }

    static /* synthetic */ JButton access$4(ManualScanTab manualScanTab) {
        return manualScanTab.selectFilesButton;
    }

    static /* synthetic */ JCheckBox access$5(ManualScanTab manualScanTab) {
        return manualScanTab.createHtmlSummaryReportCheckBox;
    }

    static /* synthetic */ JCheckBox access$6(ManualScanTab manualScanTab) {
        return manualScanTab.flagHackerRepsCheckBox;
    }

    static /* synthetic */ JComboBox access$7(ManualScanTab manualScanTab) {
        return manualScanTab.flagHackerRepsPositionComboBox;
    }

    static /* synthetic */ JCheckBox access$8(ManualScanTab manualScanTab) {
        return manualScanTab.cleanHackFlagCheckBox;
    }

    static /* synthetic */ void access$9(ManualScanTab manualScanTab, Map map, Date date, Date date2, String[] stringArray) {
        manualScanTab.saveAndOpenHtmlSummaryReport(map, date, date2, stringArray);
    }

    private static class IntWrapper {
        public int value;

        private IntWrapper() {
        }
    }
}

