/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.Tab;
import hu.belicza.andras.bwhfagent.view.Utils;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Font;
import swingwt.awt.LayoutManager2;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.BorderFactory;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JPanel;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.JTextArea;
import swingwtx.swing.border.Border;

public abstract class LoggedTab
extends Tab {
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\r\n");
    private static final int MESSAGES_COUNT_LIMIT = 2000;
    private final JTextArea logTextArea = new JTextArea(5, 10);
    private final JCheckBox scrollLockCheckBox = new JCheckBox("Scroll Lock");
    private int messagesCount = 0;
    private final String logFileName;
    private FileWriter logFileWriter = null;

    public LoggedTab(String title, Icon icon, String logFileName) {
        super(title, icon);
        this.logFileName = logFileName;
        try {
            this.logFileWriter = new FileWriter(logFileName, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void buildGUI() {
        JPanel logPanel = new JPanel((LayoutManager2)new BorderLayout());
        logPanel.setMaximumSize(Utils.getMaxDimension());
        this.logTextArea.setEditable(false);
        this.logTextArea.setLineWrap(true);
        this.logTextArea.setWrapStyleWord(true);
        this.logTextArea.setTabSize(4);
        this.logTextArea.setFont(new Font("default", 0, 10));
        logPanel.add((Component)new JScrollPane((Component)this.logTextArea), (Object)"Center");
        JPanel controlPanel = Utils.createWrapperPanel();
        controlPanel.add((Component)this.scrollLockCheckBox);
        JButton clearLogButton = new JButton("Clear");
        clearLogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LoggedTab.this.logTextArea.setText("");
                LoggedTab.this.messagesCount = 0;
            }
        });
        controlPanel.add((Component)clearLogButton);
        JButton viewEntireLogButton = new JButton("View entire log", (Icon)IconResourceManager.ICON_VIEW_LOG);
        viewEntireLogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Utils.editFile(LoggedTab.this.logFileName);
            }
        });
        controlPanel.add((Component)viewEntireLogButton);
        logPanel.add((Component)controlPanel, (Object)"South");
        logPanel.setBorder((Border)BorderFactory.createTitledBorder((String)("This content is also saved to file '" + this.logFileName + "'.")));
        this.contentBox.add((Component)logPanel);
    }

    protected void logMessage(String message) {
        this.logMessage(message, true);
    }

    protected void logMessage(String message, boolean appendTimeStamp) {
        if (this.messagesCount++ == 2000) {
            this.logTextArea.setText("    ....auto-clearing log text area (full log is still available)..." + LINE_SEPARATOR);
            this.messagesCount = 0;
        }
        String formattedMessage = String.valueOf(appendTimeStamp ? String.valueOf(DATE_FORMAT.format(new Date())) + " - " : "") + message.replace("\t", "    ") + LINE_SEPARATOR;
        int caretPosition = this.logTextArea.getCaretPosition();
        this.logTextArea.append(formattedMessage);
        if (this.scrollLockCheckBox.isSelected()) {
            this.logTextArea.setCaretPosition(caretPosition);
        }
        if (this.logFileWriter != null) {
            try {
                this.logFileWriter.write(formattedMessage);
                this.logFileWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

