/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.NormalThread;
import hu.belicza.andras.bwhfagent.view.Tab;
import hu.belicza.andras.bwhfagent.view.Utils;
import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import swingwt.awt.BorderLayout;
import swingwt.awt.Color;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.Font;
import swingwt.awt.GridBagConstraints;
import swingwt.awt.GridBagLayout;
import swingwt.awt.GridLayout;
import swingwt.awt.LayoutManager;
import swingwt.awt.LayoutManager2;
import swingwt.awt.Rectangle;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.KeyListener;
import swingwtx.swing.BorderFactory;
import swingwtx.swing.Box;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JLabel;
import swingwtx.swing.JOptionPane;
import swingwtx.swing.JPanel;
import swingwtx.swing.JSlider;
import swingwtx.swing.JTextField;
import swingwtx.swing.border.Border;

public class GeneralSettingsTab
extends Tab {
    private static final String CHECK_UPDATES_BUTTON_TEXT = "Check now";
    private final MainFrame mainFrame = MainFrame.getInstance();
    private final JCheckBox checkUpdatesOnStartupCheckBox = new JCheckBox("Check for updates on startup", Boolean.parseBoolean(Utils.settingsProperties.getProperty("checkUpdatesOnStartup")));
    private final JButton checkUpdatesButton = new JButton("Check now", (Icon)IconResourceManager.ICON_SERVER_CONNECT);
    protected final JTextField starcraftFolderTextField = new JTextField(Utils.settingsProperties.getProperty("starcraftFolder"));
    protected final JTextField replayStartFolderTextField = new JTextField(Utils.settingsProperties.getProperty("defaultReplayStartFolder"));
    protected final JTextField defaultReplayListsFolderTextField = new JTextField(Utils.settingsProperties.getProperty("defaultReplayListsFolder"));
    protected final JTextField replayListToLoadOnStartupTextField = new JTextField(Utils.settingsProperties.getProperty("replayListToLoadOnStartup"));
    protected final JTextField editorProgramTextField = new JTextField(Utils.settingsProperties.getProperty("editorProgram"));
    protected final JCheckBox skipLatterActionsOfHackersCheckBox = new JCheckBox("During a replay scan if a player is found hacking, skip scanning his latter actions", Boolean.parseBoolean(Utils.settingsProperties.getProperty("skipLatterActionsOfHackers")));
    protected final JSlider soundVolumeSlider = new JSlider(0, 100, Integer.parseInt(Utils.settingsProperties.getProperty("soundVolume")));
    protected final JCheckBox enableSystemTrayIconCheckBox = new JCheckBox("Enable system tray icon", Boolean.parseBoolean(Utils.settingsProperties.getProperty("enableSystemTrayIcon")));
    protected final JCheckBox alwaysMinimizeToTrayCheckBox = new JCheckBox("Always minimize to tray", Boolean.parseBoolean(Utils.settingsProperties.getProperty("alwaysMinimizeToTray")));
    protected final JCheckBox startAgentMinimizedToTrayCheckBox = new JCheckBox("Start agent minimized to tray", Boolean.parseBoolean(Utils.settingsProperties.getProperty("startAgentMinimizedToTray")));
    protected final JCheckBox saveWindowPositionCheckBox = new JCheckBox("Save window position", Boolean.parseBoolean(Utils.settingsProperties.getProperty("saveWindowPosition")));

    public GeneralSettingsTab() {
        super("General settings", (Icon)IconResourceManager.ICON_GENERAL_SETTINGS);
        File defaultReplayListsFolder = new File("Replay lists");
        if (!defaultReplayListsFolder.exists()) {
            defaultReplayListsFolder.mkdir();
        }
        this.buildGUI();
        this.checkStarcraftFolder();
        if (this.checkUpdatesOnStartupCheckBox.isSelected()) {
            new Thread(){

                public void run() {
                    try {
                        1.sleep(2000L);
                        GeneralSettingsTab.this.checkUpdatesButton.doClick();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void buildGUI() {
        JPanel panel = Utils.createWrapperPanel();
        panel.add((Component)this.checkUpdatesOnStartupCheckBox);
        this.checkUpdatesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GeneralSettingsTab.this.checkUpdates();
            }
        });
        panel.add((Component)this.checkUpdatesButton);
        this.contentBox.add((Component)panel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel = new JPanel((LayoutManager2)gridBagLayout);
        panel.setBorder((Border)BorderFactory.createTitledBorder((String)"Folder and editor settings:"));
        constraints.fill = 1;
        constraints.gridwidth = 1;
        JLabel label = new JLabel("Starcraft directory:", 7);
        gridBagLayout.setConstraints((Component)label, constraints);
        panel.add((Component)label);
        this.starcraftFolderTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                GeneralSettingsTab.this.checkStarcraftFolder();
            }

            public void keyReleased(KeyEvent event) {
                GeneralSettingsTab.this.checkStarcraftFolder();
            }

            public void keyTyped(KeyEvent event) {
                GeneralSettingsTab.this.checkStarcraftFolder();
            }
        });
        gridBagLayout.setConstraints((Component)this.starcraftFolderTextField, constraints);
        panel.add((Component)this.starcraftFolderTextField);
        constraints.gridwidth = 0;
        JButton button = Utils.createFileChooserButton((Component)this.getContent(), this.starcraftFolderTextField, 1, null, null, new Runnable(){

            public void run() {
                GeneralSettingsTab.this.checkStarcraftFolder();
            }
        });
        gridBagLayout.setConstraints((Component)button, constraints);
        panel.add((Component)button);
        constraints.gridwidth = 1;
        label = new JLabel("Start folder when selecting replay files:", 2);
        gridBagLayout.setConstraints((Component)label, constraints);
        panel.add((Component)label);
        gridBagLayout.setConstraints((Component)this.replayStartFolderTextField, constraints);
        panel.add((Component)this.replayStartFolderTextField);
        constraints.gridwidth = 0;
        button = Utils.createFileChooserButton((Component)this.getContent(), this.replayStartFolderTextField, 1, null, null, new Runnable(){

            public void run() {
                File selectedFolder = new File(GeneralSettingsTab.this.replayStartFolderTextField.getText());
                if (selectedFolder.getAbsolutePath().equals(new File(GeneralSettingsTab.this.starcraftFolderTextField.getText(), "maps/replays").getAbsolutePath())) {
                    GeneralSettingsTab.this.replayStartFolderTextField.setText("maps/replays");
                } else if (selectedFolder.getParentFile() != null && selectedFolder.getParentFile().getAbsolutePath().equals(new File(GeneralSettingsTab.this.starcraftFolderTextField.getText(), "maps/replays").getAbsolutePath())) {
                    GeneralSettingsTab.this.replayStartFolderTextField.setText("maps/replays/" + selectedFolder.getName());
                }
            }
        });
        gridBagLayout.setConstraints((Component)button, constraints);
        panel.add((Component)button);
        constraints.gridwidth = 1;
        label = new JLabel("Default replay lists folder:", 2);
        gridBagLayout.setConstraints((Component)label, constraints);
        panel.add((Component)label);
        gridBagLayout.setConstraints((Component)this.defaultReplayListsFolderTextField, constraints);
        panel.add((Component)this.defaultReplayListsFolderTextField);
        constraints.gridwidth = 0;
        button = Utils.createFileChooserButton((Component)this.getContent(), this.defaultReplayListsFolderTextField, 1, null, null, new Runnable(){

            public void run() {
                File selectedFolder = new File(GeneralSettingsTab.this.defaultReplayListsFolderTextField.getText());
                if (selectedFolder.getAbsolutePath().equals(new File("Replay lists").getAbsolutePath())) {
                    GeneralSettingsTab.this.defaultReplayListsFolderTextField.setText("Replay lists");
                }
            }
        });
        gridBagLayout.setConstraints((Component)button, constraints);
        panel.add((Component)button);
        constraints.gridwidth = 1;
        label = new JLabel("Replay list to load on startup:", 2);
        gridBagLayout.setConstraints((Component)label, constraints);
        panel.add((Component)label);
        gridBagLayout.setConstraints((Component)this.replayListToLoadOnStartupTextField, constraints);
        panel.add((Component)this.replayListToLoadOnStartupTextField);
        constraints.gridwidth = 0;
        button = Utils.createFileChooserButton((Component)this.getContent(), this.replayListToLoadOnStartupTextField, 0, Utils.SWING_TEXT_FILE_FILTER, new String[][]{{"*.txt", "*.*"}, {"Text files (*.txt)", "All files (*.*)"}}, new Runnable(){

            public void run() {
                File selectedFile = new File(GeneralSettingsTab.this.replayListToLoadOnStartupTextField.getText());
                if (selectedFile.getParentFile() != null && selectedFile.getParentFile().getAbsolutePath().equals(new File("Replay lists").getAbsolutePath())) {
                    GeneralSettingsTab.this.replayListToLoadOnStartupTextField.setText("Replay lists/" + selectedFile.getName());
                }
            }
        });
        gridBagLayout.setConstraints((Component)button, constraints);
        panel.add((Component)button);
        label = new JLabel("(Note that if you select a big list with thousands of replays, it might significantly slow down the startup of BWHF Agent.)");
        label.setFont(new Font("Default", 2, 9));
        JPanel wrapperPanel = Utils.wrapInPanel((JComponent)label);
        constraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)wrapperPanel, constraints);
        panel.add((Component)wrapperPanel);
        constraints.gridwidth = 1;
        label = new JLabel("Program to view/edit files:", 7);
        gridBagLayout.setConstraints((Component)label, constraints);
        panel.add((Component)label);
        gridBagLayout.setConstraints((Component)this.editorProgramTextField, constraints);
        panel.add((Component)this.editorProgramTextField);
        constraints.gridwidth = 0;
        button = Utils.createFileChooserButton((Component)this.getContent(), this.editorProgramTextField, 0, null, null, null);
        gridBagLayout.setConstraints((Component)button, constraints);
        panel.add((Component)button);
        Box contentBox2 = Box.createVerticalBox();
        contentBox2.add((Component)panel);
        panel = new JPanel((LayoutManager)new GridLayout(3, 1));
        this.enableSystemTrayIconCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (GeneralSettingsTab.this.enableSystemTrayIconCheckBox.isSelected()) {
                    GeneralSettingsTab.this.mainFrame.installSystemTrayIcon();
                } else {
                    GeneralSettingsTab.this.mainFrame.removeSystemTrayIcon();
                }
                GeneralSettingsTab.this.alwaysMinimizeToTrayCheckBox.setEnabled(GeneralSettingsTab.this.enableSystemTrayIconCheckBox.isSelected());
                GeneralSettingsTab.this.startAgentMinimizedToTrayCheckBox.setEnabled(GeneralSettingsTab.this.enableSystemTrayIconCheckBox.isSelected());
                ((GeneralSettingsTab)GeneralSettingsTab.this).mainFrame.minimizeToTrayButton.setEnabled(GeneralSettingsTab.this.enableSystemTrayIconCheckBox.isSelected());
            }
        });
        panel.add((Component)this.enableSystemTrayIconCheckBox);
        panel.add((Component)this.alwaysMinimizeToTrayCheckBox);
        panel.add((Component)this.startAgentMinimizedToTrayCheckBox);
        this.enableSystemTrayIconCheckBox.doClick();
        JPanel titledPanel = Utils.wrapInPanel((JComponent)panel);
        titledPanel.setBorder((Border)BorderFactory.createTitledBorder((String)"Tray icon settings:"));
        contentBox2.add((Component)titledPanel);
        Box miscBox = Box.createVerticalBox();
        panel = Utils.createWrapperPanel();
        panel.add((Component)new JLabel("Sound volume:"));
        this.soundVolumeSlider.setLabelTable((Dictionary)this.soundVolumeSlider.createStandardLabels(10));
        this.soundVolumeSlider.setPreferredSize(new Dimension(300, 45));
        panel.add((Component)this.soundVolumeSlider);
        JButton testSoundButton = new JButton("Play test sound", (Icon)IconResourceManager.ICON_SOUND);
        testSoundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Utils.playWavFile(new File("sounds", "hacker.wav"), false);
            }
        });
        panel.add((Component)testSoundButton);
        miscBox.add((Component)panel);
        miscBox.add((Component)this.saveWindowPositionCheckBox);
        miscBox.add((Component)this.skipLatterActionsOfHackersCheckBox);
        titledPanel = Utils.wrapInPanel((JComponent)miscBox);
        titledPanel.setBorder((Border)BorderFactory.createTitledBorder((String)"Miscellaneous settings:"));
        contentBox2.add((Component)titledPanel);
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)contentBox2));
        this.contentBox.add((Component)new JPanel((LayoutManager2)new BorderLayout()));
    }

    private void checkUpdates() {
        if (!this.checkUpdatesButton.isEnabled()) {
            return;
        }
        this.checkUpdatesButton.setEnabled(false);
        this.checkUpdatesButton.setText("Checking...");
        this.checkUpdatesButton.getParent().validate();
        new NormalThread(){

            public void run() {
                block8: {
                    try {
                        try {
                            String versionString = Utils.readVersionStringFromStream(new URL("http://bwhf.googlecode.com/svn/trunk/latest_stable_version.txt").openStream());
                            if (versionString == null) {
                                throw new Exception();
                            }
                            if (versionString.equals(MainFrame.getInstance().applicationVersion)) {
                                GeneralSettingsTab.this.checkUpdatesButton.setText("Check now (no new version)");
                                break block8;
                            }
                            GeneralSettingsTab.this.mainFrame.stayInWonderland();
                            if (JOptionPane.showConfirmDialog(null, (Object)"A newer version of BWHF Agent is available.\nWould you like to visit the home page to download it?", (String)"New version available!", (int)192, (int)2) == 64) {
                                Utils.showURLInBrowser("http://code.google.com/p/bwhf/");
                            }
                            GeneralSettingsTab.this.checkUpdatesButton.setText("Check now (new version available!)");
                        }
                        catch (Exception e) {
                            GeneralSettingsTab.this.checkUpdatesButton.setText("Check now (check failed!)");
                            GeneralSettingsTab.this.checkUpdatesButton.setEnabled(true);
                            GeneralSettingsTab.this.checkUpdatesButton.getParent().validate();
                        }
                    }
                    finally {
                        GeneralSettingsTab.this.checkUpdatesButton.setEnabled(true);
                        GeneralSettingsTab.this.checkUpdatesButton.getParent().validate();
                    }
                }
            }
        }.start();
    }

    private void checkStarcraftFolder() {
        if (new File(this.starcraftFolderTextField.getText(), "StarCraft.exe").exists()) {
            this.mainFrame.startScButton.setEnabled(true);
            this.mainFrame.starcraftFolderStatusLabel.setText("Starcraft directory is set correctly.");
            this.mainFrame.starcraftFolderStatusLabel.setForeground(Color.GREEN.darker());
        } else {
            this.mainFrame.startScButton.setEnabled(false);
            this.mainFrame.starcraftFolderStatusLabel.setText("Cannot find 'StarCraft.exe'!");
            this.mainFrame.starcraftFolderStatusLabel.setForeground(Color.RED);
        }
    }

    public File getReplayStartFolder() {
        File replayStartFolder = new File(this.replayStartFolderTextField.getText());
        return replayStartFolder.isAbsolute() ? replayStartFolder : new File(this.starcraftFolderTextField.getText(), this.replayStartFolderTextField.getText());
    }

    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("checkUpdatesOnStartup", Boolean.toString(this.checkUpdatesOnStartupCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("starcraftFolder", this.starcraftFolderTextField.getText());
        Utils.settingsProperties.setProperty("defaultReplayStartFolder", this.replayStartFolderTextField.getText());
        Utils.settingsProperties.setProperty("defaultReplayListsFolder", this.defaultReplayListsFolderTextField.getText());
        Utils.settingsProperties.setProperty("replayListToLoadOnStartup", this.replayListToLoadOnStartupTextField.getText());
        Utils.settingsProperties.setProperty("editorProgram", this.editorProgramTextField.getText());
        Utils.settingsProperties.setProperty("skipLatterActionsOfHackers", Boolean.toString(this.skipLatterActionsOfHackersCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("soundVolume", Integer.toString(this.soundVolumeSlider.getValue()));
        Utils.settingsProperties.setProperty("enableSystemTrayIcon", Boolean.toString(this.enableSystemTrayIconCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("alwaysMinimizeToTray", Boolean.toString(this.alwaysMinimizeToTrayCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("startAgentMinimizedToTray", Boolean.toString(this.startAgentMinimizedToTrayCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("saveWindowPosition", Boolean.toString(this.saveWindowPositionCheckBox.isSelected()));
        if (this.saveWindowPositionCheckBox.isSelected()) {
            if (this.mainFrame.getExtendedState() == 6) {
                Utils.settingsProperties.setProperty("windowPosition", "maximized");
            } else {
                Rectangle bounds = this.mainFrame.getBounds();
                Utils.settingsProperties.setProperty("windowPosition", String.valueOf(bounds.x) + "," + bounds.y + "," + bounds.width + "," + bounds.height);
            }
        }
    }
}

