/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhf.control.BinRepParser;
import hu.belicza.andras.bwhf.model.Replay;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.Tab;
import hu.belicza.andras.bwhfagent.view.Utils;
import hu.belicza.andras.bwhfagent.view.charts.ChartsComponent;
import java.io.File;
import swingwt.awt.Color;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.BorderFactory;
import swingwtx.swing.Box;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JFileChooser;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.border.Border;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public class ChartsTab
extends Tab {
    private final JButton openLastReplayButton = new JButton("Open 'LastReplay.rep'", (Icon)IconResourceManager.ICON_LASTREPLAY);
    private final JButton selectFileButton = new JButton("Select file to open...", (Icon)IconResourceManager.ICON_FILE_CHOOSER);
    private final JButton previousReplayButton = new JButton("Previous replay", (Icon)IconResourceManager.ICON_ARROW_LEFT);
    private final JButton nextReplayButton = new JButton("Next replay", (Icon)IconResourceManager.ICON_ARROW_RIGHT);
    private final JLabel loadedReplayLabel = new JLabel("No replay loaded.");
    private final Integer[] openedIndexFromResultListWrapper = new Integer[1];
    public final JComboBox chartTypeComboBox = new JComboBox((Object[])ChartsComponent.ChartType.values());
    public final JCheckBox allPlayersOnOneChartCheckBox = new JCheckBox("All players on 1 chart", Boolean.parseBoolean(Utils.settingsProperties.getProperty("allPlayersOnOneChart")));
    public final JCheckBox usePlayersColorsCheckBox = new JCheckBox("Use players' in-game colors", Boolean.parseBoolean(Utils.settingsProperties.getProperty("usePlayersInGameColors")));
    public final JCheckBox autoDisableInactivePlayersCheckBox = new JCheckBox("Auto-disable players < 30 APM", Boolean.parseBoolean(Utils.settingsProperties.getProperty("autoDisableInactivePlayers")));
    public final JCheckBox displayActionsInSecondsCheckBox = new JCheckBox("Display actions in seconds", Boolean.parseBoolean(Utils.settingsProperties.getProperty("displayActionsInSeconds")));
    private final ChartsComponent chartsComponent = new ChartsComponent(this);

    public ChartsTab() {
        super("Charts", (Icon)IconResourceManager.ICON_CHARTS);
        this.buildGUI();
        this.chartTypeComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("chartType")));
        this.chartsComponent.setChartType((ChartsComponent.ChartType)((Object)this.chartTypeComboBox.getSelectedItem()));
    }

    private void buildGUI() {
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.loadedReplayLabel));
        Box buttonsPanel = Box.createHorizontalBox();
        JPanel panel = Utils.createWrapperPanel();
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.openLastReplayButton.setMnemonic('l');
        this.openLastReplayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ChartsTab.this.setReplayFile(new File(MainFrame.getInstance().generalSettingsTab.starcraftFolderTextField.getText(), "maps/replays/LastReplay.rep"));
            }
        });
        panel.add((Component)this.openLastReplayButton);
        this.selectFileButton.setMnemonic('f');
        this.selectFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(MainFrame.getInstance().generalSettingsTab.getReplayStartFolder());
                fileChooser.setExtensionFilters(new String[]{"*.rep", "*.*"}, new String[]{"Replay Files (*.rep)", "All files (*.*)"});
                fileChooser.addChoosableFileFilter(Utils.SWING_REPLAY_FILE_FILTER);
                fileChooser.setFileSelectionMode(0);
                if (fileChooser.showOpenDialog((Component)ChartsTab.this.getContent()) == 0) {
                    ChartsTab.this.setReplayFile(fileChooser.getSelectedFile());
                }
            }
        });
        panel.add((Component)this.selectFileButton);
        buttonsPanel.add((Component)panel);
        panel = Utils.createWrapperPanel();
        this.previousReplayButton.setMnemonic('p');
        this.previousReplayButton.setEnabled(false);
        this.previousReplayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ChartsTab.this.setReplayFile(MainFrame.getInstance().replaySearchTab.getPreviousReplayFile(ChartsTab.this.openedIndexFromResultListWrapper));
            }
        });
        panel.add((Component)this.previousReplayButton);
        this.nextReplayButton.setMnemonic('n');
        this.nextReplayButton.setEnabled(false);
        this.nextReplayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ChartsTab.this.setReplayFile(MainFrame.getInstance().replaySearchTab.getNextReplayFile(ChartsTab.this.openedIndexFromResultListWrapper));
            }
        });
        panel.add((Component)this.nextReplayButton);
        buttonsPanel.add((Component)panel);
        this.contentBox.add((Component)buttonsPanel);
        JPanel chartsCommonControlPanel = Utils.createWrapperPanel();
        chartsCommonControlPanel.setBorder((Border)BorderFactory.createTitledBorder((String)"General chart settings:"));
        chartsCommonControlPanel.add((Component)new JLabel("Chart type:"));
        this.chartTypeComboBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                ChartsTab.this.chartsComponent.setChartType((ChartsComponent.ChartType)((Object)ChartsTab.this.chartTypeComboBox.getSelectedItem()));
            }
        });
        chartsCommonControlPanel.add((Component)this.chartTypeComboBox);
        this.allPlayersOnOneChartCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ChartsTab.this.usePlayersColorsCheckBox.setEnabled(!ChartsTab.this.allPlayersOnOneChartCheckBox.isSelected());
                ChartsTab.this.chartsComponent.repaint();
            }
        });
        chartsCommonControlPanel.add((Component)this.allPlayersOnOneChartCheckBox);
        this.usePlayersColorsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ChartsTab.this.chartsComponent.repaint();
            }
        });
        this.usePlayersColorsCheckBox.setEnabled(!this.allPlayersOnOneChartCheckBox.isSelected());
        chartsCommonControlPanel.add((Component)this.usePlayersColorsCheckBox);
        chartsCommonControlPanel.add((Component)this.autoDisableInactivePlayersCheckBox);
        chartsCommonControlPanel.add((Component)this.displayActionsInSecondsCheckBox);
        this.displayActionsInSecondsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ChartsTab.this.chartsComponent.loadPlayerActionsIntoList();
            }
        });
        this.contentBox.add((Component)chartsCommonControlPanel);
        this.contentBox.add((Component)this.chartsComponent.getContentPanel());
    }

    public void initializationEnded() {
        super.initializationEnded();
        this.chartsComponent.initializationEnded();
    }

    public void setReplayFile(File file) {
        this.setReplayFile(file, null);
    }

    public void setReplayFile(File file, Integer indexInResultList) {
        Replay replay;
        if (indexInResultList != null) {
            this.openedIndexFromResultListWrapper[0] = indexInResultList;
        }
        if ((replay = BinRepParser.parseReplay(file, true, false)) == null) {
            this.loadedReplayLabel.setText("Failed to load " + file.getAbsolutePath() + "!");
            this.loadedReplayLabel.setForeground(Color.RED);
        } else {
            this.loadedReplayLabel.setText("Loaded replay: " + file.getAbsolutePath());
            this.loadedReplayLabel.setForeground(Color.BLACK);
        }
        this.chartsComponent.setReplay(replay);
    }

    public void onReplayResultListChange(boolean hasResultReplay) {
        if (!hasResultReplay) {
            this.openedIndexFromResultListWrapper[0] = null;
        }
        this.previousReplayButton.setEnabled(hasResultReplay);
        this.nextReplayButton.setEnabled(hasResultReplay);
    }

    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("chartType", Integer.toString(this.chartTypeComboBox.getSelectedIndex()));
        Utils.settingsProperties.setProperty("allPlayersOnOneChart", Boolean.toString(this.allPlayersOnOneChartCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("usePlayersInGameColors", Boolean.toString(this.usePlayersColorsCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("autoDisableInactivePlayers", Boolean.toString(this.autoDisableInactivePlayersCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("displayActionsInSeconds", Boolean.toString(this.displayActionsInSecondsCheckBox.isSelected()));
        this.chartsComponent.assignUsedProperties();
    }
}

