/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhf.control.BinRepParser;
import hu.belicza.andras.bwhf.control.ReplayScanner;
import hu.belicza.andras.bwhf.model.HackDescription;
import hu.belicza.andras.bwhf.model.Replay;
import hu.belicza.andras.bwhf.model.ReplayHeader;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.LoggedTab;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.NormalThread;
import hu.belicza.andras.bwhfagent.view.Utils;
import hu.belicza.andras.hackerdb.ServerApiConsts;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.GridBagConstraints;
import swingwt.awt.GridBagLayout;
import swingwt.awt.LayoutManager2;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.BorderFactory;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JOptionPane;
import swingwtx.swing.JPanel;
import swingwtx.swing.JTextField;
import swingwtx.swing.border.Border;
import swingwtx.swing.filechooser.FileFilter;

public class AutoscanTab
extends LoggedTab {
    private static final String LOG_FILE_NAME = "autoscan.log";
    private static final long TIME_BETWEEN_CHECKS_FOR_NEW_REPLAY_MS = 2000L;
    private static final String CHECK_KEY_BUTTON_TEXT = "Check key";
    private final JCheckBox autoscanEnabledCheckBox = new JCheckBox("Autoscan enabled", Boolean.parseBoolean(Utils.settingsProperties.getProperty("autoscanEnabled")));
    private final JCheckBox saveHackerRepsCheckBox = new JCheckBox("Save hacker replays to folder:", Boolean.parseBoolean(Utils.settingsProperties.getProperty("saveHackerReps")));
    private final JTextField hackerRepsDestinationTextField = new JTextField(Utils.settingsProperties.getProperty("hackerRepsDestination"));
    private final JCheckBox saveAllRepsCheckBox = new JCheckBox("Save all replays to folder:", Boolean.parseBoolean(Utils.settingsProperties.getProperty("saveAllReps")));
    private final JTextField allRepsDestinationTextField = new JTextField(Utils.settingsProperties.getProperty("allRepsDestination"));
    private final JCheckBox useShortNamesForAutosaveCheckBox = new JCheckBox("Use short names for autosaved replays (short format: 'YYMMDD hhmmss.rep', default: 'YYYY-MM-DD hh-mm-ss LastRep.rep' )", Boolean.parseBoolean(Utils.settingsProperties.getProperty("useShortNamesForAutosave")));
    private final JCheckBox playSoundCheckBox = new JCheckBox("Play sound alert if found hackers", Boolean.parseBoolean(Utils.settingsProperties.getProperty("playSoundIfFoundHackers")));
    private final JCheckBox bringToFrontCheckBox = new JCheckBox("Bring Agent to front if found hackers", Boolean.parseBoolean(Utils.settingsProperties.getProperty("bringToFront")));
    private final JCheckBox reportHackersCheckBox = new JCheckBox("Report hackers to the central hacker database with Battle.net gateway:", Boolean.parseBoolean(Utils.settingsProperties.getProperty("reportHackers")));
    protected final JComboBox gatewayComboBox = new JComboBox();
    private String authorizationKey = Utils.settingsProperties.getProperty("authorizationKey");
    private volatile Boolean lastKeyCheckResult;
    private volatile boolean keyCheckInProgress;

    public AutoscanTab() {
        super("Autoscan", (Icon)IconResourceManager.ICON_AUTOSCAN, LOG_FILE_NAME);
        this.gatewayComboBox.addItem((Object)"<select your gateway>");
        String[] stringArray = ServerApiConsts.GATEWAYS;
        int n = ServerApiConsts.GATEWAYS.length;
        int n2 = 0;
        while (n2 < n) {
            String gateway = stringArray[n2];
            this.gatewayComboBox.addItem((Object)gateway);
            ++n2;
        }
        this.buildGUI();
        this.gatewayComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("gateway")));
        this.startAutoscanner();
    }

    protected void buildGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        final JPanel settingsPanel = new JPanel((LayoutManager2)gridBagLayout);
        settingsPanel.setBorder((Border)BorderFactory.createTitledBorder((String)"Settings:"));
        constraints.fill = 1;
        constraints.gridwidth = 0;
        JPanel wrapperPanel = Utils.wrapInPanel((JComponent)this.autoscanEnabledCheckBox);
        gridBagLayout.setConstraints((Component)wrapperPanel, constraints);
        settingsPanel.add((Component)wrapperPanel);
        constraints.gridwidth = 1;
        gridBagLayout.setConstraints((Component)this.saveHackerRepsCheckBox, constraints);
        settingsPanel.add((Component)this.saveHackerRepsCheckBox);
        gridBagLayout.setConstraints((Component)this.hackerRepsDestinationTextField, constraints);
        settingsPanel.add((Component)this.hackerRepsDestinationTextField);
        constraints.gridwidth = 0;
        JButton button = this.createFileChooserButton(this.hackerRepsDestinationTextField, 1, null, null, null);
        gridBagLayout.setConstraints((Component)button, constraints);
        settingsPanel.add((Component)button);
        constraints.gridwidth = 1;
        gridBagLayout.setConstraints((Component)this.saveAllRepsCheckBox, constraints);
        settingsPanel.add((Component)this.saveAllRepsCheckBox);
        gridBagLayout.setConstraints((Component)this.allRepsDestinationTextField, constraints);
        settingsPanel.add((Component)this.allRepsDestinationTextField);
        constraints.gridwidth = 0;
        button = this.createFileChooserButton(this.allRepsDestinationTextField, 1, null, null, null);
        gridBagLayout.setConstraints((Component)button, constraints);
        settingsPanel.add((Component)button);
        constraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)this.useShortNamesForAutosaveCheckBox, constraints);
        settingsPanel.add((Component)this.useShortNamesForAutosaveCheckBox);
        constraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)this.playSoundCheckBox, constraints);
        settingsPanel.add((Component)this.playSoundCheckBox);
        constraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)this.bringToFrontCheckBox, constraints);
        settingsPanel.add((Component)this.bringToFrontCheckBox);
        constraints.gridwidth = 2;
        final JButton checkKeyButton = new JButton(CHECK_KEY_BUTTON_TEXT, (Icon)IconResourceManager.ICON_SERVER_CONNECT);
        JPanel panel = new JPanel((LayoutManager2)new BorderLayout());
        this.reportHackersCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (AutoscanTab.this.reportHackersCheckBox.isSelected()) {
                    AutoscanTab.this.reportHackersCheckBox.setSelected(false);
                    if (AutoscanTab.this.gatewayComboBox.getSelectedIndex() == 0) {
                        JOptionPane.showMessageDialog((Container)AutoscanTab.this.getContent(), (Object)"Please select your gateway corresponding to where you play in order to report hackers!", (String)"Error", (int)1);
                        return;
                    }
                    AutoscanTab.this.reportHackersCheckBox.setEnabled(false);
                    AutoscanTab.this.gatewayComboBox.setEnabled(false);
                    new NormalThread(){

                        public void run() {
                            checkKeyButton.doClick();
                            while (AutoscanTab.this.keyCheckInProgress) {
                                try {
                                    1.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (AutoscanTab.this.lastKeyCheckResult == null || !AutoscanTab.this.lastKeyCheckResult.booleanValue()) {
                                AutoscanTab.this.reportHackersCheckBox.setSelected(false);
                                JOptionPane.showMessageDialog((Container)AutoscanTab.this.getContent(), (Object)("You need a valid authorization key to report hackers!\n" + (AutoscanTab.this.lastKeyCheckResult == null ? "Failed to check the authorization key." : "The supplied authorization key is invalid.")), (String)"Error", (int)1);
                            } else {
                                AutoscanTab.this.reportHackersCheckBox.setSelected(true);
                            }
                            (this).AutoscanTab.this.gatewayComboBox.setEnabled(true);
                            AutoscanTab.this.reportHackersCheckBox.setEnabled(true);
                        }
                    }.start();
                }
            }
        });
        panel.add((Component)this.reportHackersCheckBox, (Object)"West");
        panel.add((Component)this.gatewayComboBox, (Object)"Center");
        gridBagLayout.setConstraints((Component)panel, constraints);
        settingsPanel.add((Component)panel);
        constraints.gridwidth = 0;
        panel = new JPanel((LayoutManager2)new BorderLayout());
        button = new JButton("Change key...", (Icon)IconResourceManager.ICON_KEY);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Object newAuthorizationKeyObject = JOptionPane.showInputDialog((Component)AutoscanTab.this.getContent(), (Object)"Enter your authorization key:", (String)"Changing key", (int)4, null, null, (Object)AutoscanTab.this.authorizationKey);
                if (newAuthorizationKeyObject != null) {
                    AutoscanTab.this.authorizationKey = ((String)newAuthorizationKeyObject).trim();
                    checkKeyButton.doClick();
                }
            }
        });
        panel.add((Component)button, (Object)"Center");
        checkKeyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (AutoscanTab.this.keyCheckInProgress) {
                    return;
                }
                AutoscanTab.this.keyCheckInProgress = true;
                checkKeyButton.setEnabled(false);
                checkKeyButton.setText("Checking...");
                new NormalThread(){

                    public void run() {
                        AutoscanTab.this.lastKeyCheckResult = Utils.checkAuthorizationKey(AutoscanTab.this.authorizationKey);
                        checkKeyButton.setText(AutoscanTab.CHECK_KEY_BUTTON_TEXT + (AutoscanTab.this.lastKeyCheckResult == null ? " (check failed!)" : (AutoscanTab.this.lastKeyCheckResult != false ? " (valid)" : " (invalid)")));
                        checkKeyButton.setEnabled(true);
                        settingsPanel.getParent().validate();
                        AutoscanTab.this.keyCheckInProgress = false;
                    }
                }.start();
            }
        });
        panel.add((Component)checkKeyButton, (Object)"East");
        gridBagLayout.setConstraints((Component)panel, constraints);
        settingsPanel.add((Component)panel);
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)settingsPanel));
        super.buildGUI();
    }

    private JButton createFileChooserButton(JTextField targetTextField, int fileSelectionMode, FileFilter choosableFileFilter, String[][] choosableFileFilterWT, Runnable taskOnApprove) {
        return Utils.createFileChooserButton((Component)this.getContent(), targetTextField, fileSelectionMode, choosableFileFilter, choosableFileFilterWT, taskOnApprove);
    }

    private void startAutoscanner() {
        new NormalThread(){

            public void run() {
                JTextField starcraftFolderTextField = MainFrame.getInstance().generalSettingsTab.starcraftFolderTextField;
                JCheckBox skipLatterActionsOfHackersCheckBox = MainFrame.getInstance().generalSettingsTab.skipLatterActionsOfHackersCheckBox;
                Date autoscanEnabledTime = null;
                long lastModifiedOfLastChecked = new File(starcraftFolderTextField.getText(), "maps/replays/LastReplay.rep").lastModified();
                while (true) {
                    try {
                        while (true) {
                            File lastReplayFile;
                            long newLastReplayLastModified;
                            if (AutoscanTab.this.autoscanEnabledCheckBox.isSelected()) {
                                if (autoscanEnabledTime == null) {
                                    autoscanEnabledTime = new Date();
                                }
                            } else {
                                autoscanEnabledTime = null;
                            }
                            if ((newLastReplayLastModified = (lastReplayFile = new File(starcraftFolderTextField.getText(), "maps/replays/LastReplay.rep")).lastModified()) != lastModifiedOfLastChecked && newLastReplayLastModified > 0L) {
                                4.sleep(1500L);
                                lastModifiedOfLastChecked = newLastReplayLastModified = lastReplayFile.lastModified();
                                if (MainFrame.getInstance().playersNetworkTab.autoSendInfoAboutLastReplayCheckBox.isSelected()) {
                                    new NormalThread(){

                                        public void run() {
                                            MainFrame.getInstance().playersNetworkTab.sendFileInfo(lastReplayFile, (this).AutoscanTab.this.gatewayComboBox.getSelectedIndex() > 0 ? Integer.valueOf((this).AutoscanTab.this.gatewayComboBox.getSelectedIndex() - 1) : null);
                                        }
                                    }.start();
                                }
                                if (autoscanEnabledTime != null && newLastReplayLastModified >= autoscanEnabledTime.getTime()) {
                                    String autosavedFileName;
                                    if (autoscanEnabledTime == null) {
                                        autoscanEnabledTime = new Date();
                                    }
                                    String string = autosavedFileName = AutoscanTab.this.useShortNamesForAutosaveCheckBox.isSelected() ? String.valueOf(Utils.SHORT_DATE_FORMAT.format(new Date())) + ".rep" : String.valueOf(Utils.DATE_FORMAT.format(new Date())) + " LastRep.rep";
                                    if (AutoscanTab.this.saveAllRepsCheckBox.isSelected()) {
                                        Utils.copyFile(lastReplayFile, new File(AutoscanTab.this.allRepsDestinationTextField.getText()), autosavedFileName);
                                    }
                                    AutoscanTab.this.logMessage("LastReplay.rep was modified - proceeding to scan...");
                                    List<HackDescription> hackDescriptionList = null;
                                    Replay replay = BinRepParser.parseReplay(lastReplayFile, true, false);
                                    if (replay != null) {
                                        hackDescriptionList = ReplayScanner.scanReplayForHacks(replay, skipLatterActionsOfHackersCheckBox.isSelected());
                                    }
                                    if (hackDescriptionList == null) {
                                        AutoscanTab.this.logMessage("Could not scan LastReplay.rep!");
                                    } else if (!hackDescriptionList.isEmpty()) {
                                        if (AutoscanTab.this.bringToFrontCheckBox.isSelected()) {
                                            MainFrame.getInstance().selectTab(AutoscanTab.this);
                                            MainFrame.getInstance().toFront();
                                        }
                                        HashSet<String> hackerSet = new HashSet<String>();
                                        AutoscanTab.this.logMessage("Found " + hackDescriptionList.size() + " hack" + (hackDescriptionList.size() == 1 ? "" : "s") + " in LastReplay.rep:");
                                        for (HackDescription hackDescription : hackDescriptionList) {
                                            AutoscanTab.this.logMessage("\t" + hackDescription.description, false);
                                            hackerSet.add(hackDescription.playerName);
                                        }
                                        if (AutoscanTab.this.saveHackerRepsCheckBox.isSelected()) {
                                            Utils.copyFile(lastReplayFile, new File(AutoscanTab.this.hackerRepsDestinationTextField.getText()), autosavedFileName);
                                        }
                                        if (AutoscanTab.this.playSoundCheckBox.isSelected()) {
                                            ReplayHeader replayHeader = replay.replayHeader;
                                            for (String hacker : hackerSet) {
                                                Utils.playWavFile(new File("sounds", "hacker.wav"), true);
                                                int playerIndex = replayHeader.getPlayerIndexByName(hacker);
                                                if (playerIndex < 0) continue;
                                                if (replayHeader.playerColors[playerIndex] < 8) {
                                                    Utils.playWavFile(new File("sounds", String.valueOf(ReplayHeader.IN_GAME_COLOR_NAMES[replayHeader.playerColors[playerIndex]]) + ".wav"), true);
                                                } else {
                                                    Utils.playWavFile(new File("sounds", "unique.wav"), true);
                                                }
                                                if (replayHeader.playerRaces[playerIndex] >= ReplayHeader.RACE_NAMES.length) continue;
                                                Utils.playWavFile(new File("sounds", String.valueOf(ReplayHeader.RACE_NAMES[replayHeader.playerRaces[playerIndex]].toLowerCase()) + ".wav"), true);
                                            }
                                        }
                                        if (AutoscanTab.this.reportHackersCheckBox.isSelected()) {
                                            if (AutoscanTab.this.gatewayComboBox.getSelectedIndex() == 0) {
                                                AutoscanTab.this.logMessage("Error! Hacker report was not sent due to no gateway is selected!");
                                            } else {
                                                AutoscanTab.this.logMessage("Sending hacker report...");
                                                HashSet<String> playerNameSet = new HashSet<String>(8);
                                                for (HackDescription hackDescription : hackDescriptionList) {
                                                    playerNameSet.add(hackDescription.playerName);
                                                }
                                                String message = Utils.sendHackerReport(AutoscanTab.this.authorizationKey, AutoscanTab.this.gatewayComboBox.getSelectedIndex() - 1, replay.replayHeader.gameEngine & 0xFF, replay.replayHeader.mapName, Utils.calculateFileMd5(lastReplayFile), replay.replayHeader.saveTime.getTime(), playerNameSet);
                                                if (message == null) {
                                                    AutoscanTab.this.logMessage("Sending hacker report succeeded.");
                                                } else {
                                                    AutoscanTab.this.logMessage("Sending hacker report failed: " + message);
                                                }
                                            }
                                        }
                                    } else {
                                        AutoscanTab.this.logMessage("Found no hacks in 'LastReplay.rep.'");
                                    }
                                }
                            }
                            4.sleep(2000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("autoscanEnabled", Boolean.toString(this.autoscanEnabledCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("saveHackerReps", Boolean.toString(this.saveHackerRepsCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("hackerRepsDestination", this.hackerRepsDestinationTextField.getText());
        Utils.settingsProperties.setProperty("saveAllReps", Boolean.toString(this.saveAllRepsCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("allRepsDestination", this.allRepsDestinationTextField.getText());
        Utils.settingsProperties.setProperty("useShortNamesForAutosave", Boolean.toString(this.useShortNamesForAutosaveCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("playSoundIfFoundHackers", Boolean.toString(this.playSoundCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("bringToFront", Boolean.toString(this.bringToFrontCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("reportHackers", Boolean.toString(this.reportHackersCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("gateway", Integer.toString(this.gatewayComboBox.getSelectedIndex()));
        Utils.settingsProperties.setProperty("authorizationKey", this.authorizationKey);
    }
}

