/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhf.model;

import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;

public class ReplayHeader {
    public static final byte GAME_ENGINE_STARCRAFT = 0;
    public static final byte GAME_ENGINE_BROODWAR = 1;
    public static final String[] GAME_ENGINE_NAMES = new String[]{"Starcraft", "Broodwar"};
    public static final String[] GAME_ENGINE_SHORT_NAMES = new String[]{"SC", "BW"};
    public static final byte RACE_ZERG = 0;
    public static final byte RACE_TERRAN = 1;
    public static final byte RACE_PROTOSS = 2;
    public static final String[] RACE_NAMES = new String[]{"Zerg", "Terran", "Protoss"};
    public static final char[] RACE_CHARACTERS = new char[]{'Z', 'T', 'P'};
    public static final String[] IN_GAME_COLOR_NAMES = new String[]{"red", "blue", "teal", "purple", "orange", "brown", "white", "yellow", "green", "pale yellow", "tan", "aqua", "pale green", "blueish gray", "pale yellow", "cyan"};
    public static final String[] GAME_TYPE_NAMES;
    public static final short GAME_TYPE_MELEE = 2;
    public static final short GAME_TYPE_FFA = 3;
    public static final short GAME_TYPE_ONE_ON_ONE = 4;
    public static final short GAME_TYPE_CTF = 5;
    public static final short GAME_TYPE_GREED = 6;
    public static final short GAME_TYPE_SLAUGHTER = 7;
    public static final short GAME_TYPE_SUDDEN_DEATH = 8;
    public static final short GAME_TYPE_UMS = 10;
    public static final short GAME_TYPE_TEAM_MELEE = 11;
    public static final short GAME_TYPE_TEAM_FFA = 12;
    public static final short GAME_TYPE_TEAM_CTF = 13;
    public static final short GAME_TYPE_TVB = 15;
    public byte gameEngine;
    public int gameFrames;
    public Date saveTime;
    public String gameName;
    public short mapWidth;
    public short mapHeight;
    public short gameSpeed;
    public short gameType;
    public short gameSubType;
    public String creatorName;
    public String mapName;
    public byte[] playerRecords = new byte[432];
    public int[] playerColors = new int[8];
    public byte[] playerSpotIndices = new byte[8];
    public String[] playerNames = new String[12];
    public byte[] playerRaces = new byte[12];
    public int[] playerIds = new int[12];
    public int[] playerIdActionsCounts = new int[12];
    public static final String[] VERSION_NAMES;
    public static final long[] VERSION_RELEASE_DATES;
    public String guessedVersion;

    static {
        String[] stringArray = new String[16];
        stringArray[2] = "Melee";
        stringArray[3] = "Free for all";
        stringArray[4] = "One on one";
        stringArray[5] = "Capture the flag";
        stringArray[6] = "Greed";
        stringArray[7] = "Slaughter";
        stringArray[9] = "Sudden death";
        stringArray[10] = "Use map settings";
        stringArray[11] = "Team melee";
        stringArray[12] = "Team free for all";
        stringArray[13] = "Team capture the flag";
        stringArray[15] = "Top vs bottom";
        GAME_TYPE_NAMES = stringArray;
        VERSION_NAMES = new String[]{"1.0", "1.07", "1.08", "1.08b", "1.09", "1.09b", "1.10", "1.11", "1.11b", "1.12", "1.12b", "1.13", "1.13b", "1.13c", "1.13d", "1.13e", "1.13f", "1.14", "1.15", "1.15.1", "1.15.2", "1.15.3", "1.16", "1.16.1 or higher"};
        VERSION_RELEASE_DATES = new long[VERSION_NAMES.length];
        String[] versionReleaseDateStrings = new String[]{"1998-01-01", "1999-11-02", "2001-05-18", "2001-05-20", "2002-02-06", "2002-02-25", "2003-10-14", "2004-04-29", "2004-06-01", "2005-02-17", "2005-02-24", "2005-06-30", "2005-08-12", "2005-08-22", "2005-09-06", "2005-09-12", "2006-04-21", "2006-08-01", "2007-05-15", "2007-08-20", "2008-01-16", "2008-09-11", "2008-11-25", "2009-01-21"};
        try {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            int i = 0;
            while (i < versionReleaseDateStrings.length) {
                ReplayHeader.VERSION_RELEASE_DATES[i] = SDF.parse(versionReleaseDateStrings[i]).getTime();
                ++i;
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
    }

    public static int convertFramesToSeconds(int frames) {
        return (int)((long)frames * 42L / 1000L);
    }

    public static int convertSecondsToFrames(int seconds) {
        return (int)((long)seconds * 1000L / 42L);
    }

    public int getDurationSeconds() {
        return ReplayHeader.convertFramesToSeconds(this.gameFrames);
    }

    public static StringBuilder formatFrames(int frames, StringBuilder formatBuilder, boolean longFormat) {
        int seconds = ReplayHeader.convertFramesToSeconds(frames);
        int hours = seconds / 3600;
        if (longFormat || hours > 0) {
            if (longFormat && hours < 10) {
                formatBuilder.append(0);
            }
            formatBuilder.append(hours).append(':');
        }
        int minutes = (seconds %= 3600) / 60;
        if ((longFormat || hours > 0) && minutes < 10) {
            formatBuilder.append(0);
        }
        formatBuilder.append(minutes).append(':');
        if ((seconds %= 60) < 10) {
            formatBuilder.append(0);
        }
        formatBuilder.append(seconds);
        return formatBuilder;
    }

    public String getDurationString(boolean longFormat) {
        return ReplayHeader.formatFrames(this.gameFrames, new StringBuilder(), longFormat).toString();
    }

    public String getGameEngineString() {
        return this.gameEngine == 1 ? "Broodwar" : "Starcraft";
    }

    public String getMapSize() {
        return String.valueOf(this.mapWidth) + "x" + this.mapHeight;
    }

    public String getPlayerNamesString() {
        StringBuilder playerNamesBuilder = new StringBuilder();
        String[] stringArray = this.playerNames;
        int n = this.playerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String playerName = stringArray[n2];
            if (playerName != null) {
                if (playerNamesBuilder.length() > 0) {
                    playerNamesBuilder.append(", ");
                }
                playerNamesBuilder.append(playerName);
            }
            ++n2;
        }
        return playerNamesBuilder.toString();
    }

    public String getPlayerDescription(String playerName) {
        int playerIndex = this.getPlayerIndexByName(playerName);
        if (playerIndex < 0) {
            return null;
        }
        int actionsCount = this.playerIds[playerIndex] < this.playerIdActionsCounts.length ? this.playerIdActionsCounts[this.playerIds[playerIndex]] : 0;
        Integer apm = actionsCount * 60 / Math.max(this.getDurationSeconds(), 1);
        return String.valueOf(this.playerNames[playerIndex]) + " (" + RACE_CHARACTERS[this.playerRaces[playerIndex]] + "), actions: " + actionsCount + ", APM: " + apm;
    }

    public int getPlayerIndexByName(String playerName) {
        int i = 0;
        while (i < this.playerNames.length) {
            if (this.playerNames[i] != null && this.playerNames[i].equals(playerName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void printHeaderInformation(PrintWriter output) {
        output.println("Game engine: " + this.getGameEngineString());
        output.println("Duration: " + this.getDurationString(false));
        output.println("Saved on: " + this.saveTime);
        output.println("Version: " + this.guessVersionFromDate());
        output.println("Game name: " + this.gameName);
        output.println("Map size: " + this.getMapSize());
        output.println("Creator name: " + this.creatorName);
        output.println("Map name: " + this.mapName);
        output.println("Players: ");
        int seconds = this.getDurationSeconds();
        ArrayList<Object[]> playerDescriptionList = new ArrayList<Object[]>(12);
        int i = 0;
        while (i < this.playerNames.length) {
            if (this.playerNames[i] != null) {
                String colorName;
                try {
                    colorName = IN_GAME_COLOR_NAMES[this.playerColors[i]];
                }
                catch (Exception e) {
                    colorName = "<unknown>";
                }
                int actionsCount = this.playerIds[i] < this.playerIdActionsCounts.length ? this.playerIdActionsCounts[this.playerIds[i]] : 0;
                String playerDescription = "    " + this.playerNames[i] + " (" + RACE_CHARACTERS[this.playerRaces[i]] + "), color: " + colorName + ", actions: " + actionsCount + ", APM: " + actionsCount * 60 / Math.max(seconds, 1);
                playerDescriptionList.add(new Object[]{actionsCount, playerDescription});
            }
            ++i;
        }
        Collections.sort(playerDescriptionList, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] object1, Object[] object2) {
                return -((Integer)object1[0]).compareTo((Integer)object2[0]);
            }
        });
        for (Object[] playerDescription : playerDescriptionList) {
            output.println((String)playerDescription[1]);
        }
        output.flush();
    }

    public String guessVersionFromDate() {
        if (this.guessedVersion == null) {
            long saveTime_ = this.saveTime.getTime();
            int i = VERSION_RELEASE_DATES.length - 1;
            while (i >= 0) {
                if (saveTime_ > VERSION_RELEASE_DATES[i]) {
                    this.guessedVersion = VERSION_NAMES[i];
                    break;
                }
                --i;
            }
            if (this.guessedVersion == null) {
                this.guessedVersion = "<unknown>";
            }
        }
        return this.guessedVersion;
    }
}

