/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhf.control;

import hu.belicza.andras.bwhf.model.Action;
import hu.belicza.andras.bwhf.model.HackDescription;
import hu.belicza.andras.bwhf.model.PlayerActions;
import hu.belicza.andras.bwhf.model.Replay;
import hu.belicza.andras.bwhf.model.ReplayHeader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayScanner {
    public static List<HackDescription> scanReplayForHacks(Replay replay, boolean skipLatterActionsOfHackers) {
        ArrayList<HackDescription> hackDescriptionList = new ArrayList<HackDescription>();
        PlayerActions[] playerActionsArray = replay.replayActions.players;
        int n = replay.replayActions.players.length;
        int n2 = 0;
        while (n2 < n) {
            PlayerActions playerActions = playerActionsArray[n2];
            ReplayScanner.scanPlayerForHacks(replay.replayHeader, playerActions, hackDescriptionList, skipLatterActionsOfHackers);
            ++n2;
        }
        return hackDescriptionList;
    }

    private static void scanPlayerForHacks(ReplayHeader replayHeader, PlayerActions player, List<HackDescription> hackDescriptionList, boolean skipLatterActionsOfHackers) {
        boolean STANDARD_MAP_SIZE = !replayHeader.mapName.toLowerCase().contains("carthage");
        Action[] playerActions = player.actions;
        int actionsCount = playerActions.length;
        int initialHackDescriptionListSize = hackDescriptionList.size();
        int actionsAtIteration5Count = 0;
        int actionIndex = 0;
        while (actionIndex < actionsCount && actionIndex < 25) {
            if (playerActions[actionIndex].iteration != 5) break;
            if (playerActions[actionIndex].actionNameIndex != -1) {
                ++actionsAtIteration5Count;
            }
            ++actionIndex;
        }
        if (actionsAtIteration5Count > 1) {
            boolean hasActionAtIteration10 = false;
            int actionIndex2 = 0;
            while (actionIndex2 < actionsCount && playerActions[actionIndex2].iteration <= 10) {
                if (playerActions[actionIndex2].iteration == 10 && playerActions[actionIndex2].actionNameIndex != 87) {
                    hasActionAtIteration10 = true;
                    break;
                }
                ++actionIndex2;
            }
            if (actionsAtIteration5Count > 10 || !hasActionAtIteration10) {
                hackDescriptionList.add(new HackDescription(player.playerName, 0, 5));
            }
        }
        int lastIteration = -1;
        int actionsCountForGeneralMulticommandHack = 0;
        Action lastAction = null;
        boolean foundTerranComsatCancelHack = false;
        Action lastSelectAction = null;
        Action[] lastSelectActionSetAsHotkeys = new Action[11];
        int actionIndex3 = 0;
        while (actionIndex3 < actionsCount) {
            Action.Size buildingSize;
            Action action = playerActions[actionIndex3];
            if (action.actionNameIndex == 18 && replayHeader.gameType != 2 && replayHeader.gameType != 3 && replayHeader.gameType != 10) {
                hackDescriptionList.add(new HackDescription(player.playerName, 11, action.iteration));
            }
            if (replayHeader.gameType != 10) {
                if (action.actionNameIndex == 14 && !ReplayScanner.checkAllyParams(action.parameters)) {
                    hackDescriptionList.add(new HackDescription(player.playerName, 9, action.iteration));
                }
                if (action.actionNameIndex == 13 && !ReplayScanner.checkVisionParams(action.parameters)) {
                    hackDescriptionList.add(new HackDescription(player.playerName, 9, action.iteration));
                }
            }
            if (action.actionNameIndex == 12 && action.parameters != null && action.parameters.length() > 0 && action.parameterBuildingNameIndex != -1 && STANDARD_MAP_SIZE && (buildingSize = Action.BUILDING_ID_SIZE_MAP.get(action.parameterBuildingNameIndex)) != null) {
                try {
                    int commaIndex = action.parameters.indexOf(44);
                    int x = Integer.parseInt(action.parameters.substring(action.parameters.indexOf(40) + 1, commaIndex));
                    int y = Integer.parseInt(action.parameters.substring(commaIndex + 1, action.parameters.indexOf(41, commaIndex)));
                    if (x > replayHeader.mapWidth - buildingSize.width || y > replayHeader.mapHeight - buildingSize.height - 1) {
                        hackDescriptionList.add(new HackDescription(player.playerName, 10, action.iteration));
                    }
                }
                catch (Exception commaIndex) {
                    // empty catch block
                }
            }
            if (!(action.actionNameIndex != 9 && action.actionNameIndex != -2 || action.parameterBuildingNameIndex == -1 || action.parameterBuildingNameIndex >= 131 && action.parameterBuildingNameIndex <= 149 || action.parameters.length() == Action.UNIT_ID_NAME_MAP.get((byte)action.parameterBuildingNameIndex).length() || !action.parameters.startsWith(String.valueOf(Action.UNIT_ID_NAME_MAP.get((byte)action.parameterBuildingNameIndex)) + "(x"))) {
                hackDescriptionList.add(new HackDescription(player.playerName, 1, action.iteration));
            }
            if (action.actionNameIndex == 51) {
                if (lastSelectAction.parameterUnitNameIndex == 64) {
                    hackDescriptionList.add(new HackDescription(player.playerName, 2, action.iteration));
                } else if (lastSelectAction.parameterUnitNameIndex == 41) {
                    hackDescriptionList.add(new HackDescription(player.playerName, 3, action.iteration));
                } else if (lastSelectAction.parameterBuildingNameIndex == -1) {
                    hackDescriptionList.add(new HackDescription(player.playerName, 4, action.iteration));
                }
            }
            if (!foundTerranComsatCancelHack && action.actionNameIndex == 32 && action.parameters.equals("00 00") && lastAction != null && lastAction.actionNameIndex == 31 && (lastAction.parameterBuildingNameIndex == 107 || lastAction.parameterBuildingNameIndex == 115)) {
                foundTerranComsatCancelHack = true;
                hackDescriptionList.add(new HackDescription(player.playerName, 5, action.iteration));
            }
            if (actionIndex3 + 3 < actionsCount) {
                Action actionAhead1 = playerActions[actionIndex3 + 1];
                Action actionAhead2 = playerActions[actionIndex3 + 2];
                Action actionAhead3 = playerActions[actionIndex3 + 3];
                if (action.parameters != null && actionAhead1.parameters != null && actionAhead2.parameters != null && actionAhead2.parameters != null && action.iteration == actionAhead1.iteration && action.iteration == actionAhead2.iteration && action.iteration == actionAhead3.iteration && action.actionNameIndex == 9 && actionAhead2.actionNameIndex == 9 && (actionAhead1.actionNameIndex == 20 || actionAhead1.actionNameIndex == -3) && actionAhead1.actionNameIndex == actionAhead3.actionNameIndex && actionAhead1.parameters.equals(actionAhead3.parameters)) {
                    if (action.parameterBuildingNameIndex == -1) {
                        hackDescriptionList.add(new HackDescription(player.playerName, 6, action.iteration));
                    } else {
                        hackDescriptionList.add(new HackDescription(player.playerName, 7, action.iteration));
                    }
                }
            }
            if (action.actionNameIndex == -2 && action.parameters.startsWith("00 15")) {
                hackDescriptionList.add(new HackDescription(player.playerName, 2, action.iteration));
            }
            if (action.actionNameIndex == 32 && (action.parameters.equals("FE 00") || action.parameters.equals("00 00")) && lastAction != null && lastAction.actionNameIndex == 35) {
                hackDescriptionList.add(new HackDescription(player.playerName, 3, action.iteration));
            }
            if (action.actionNameIndex == 39) {
                int HACK_COUNT_LIMIT = 3;
                int minTestIteration = action.iteration - 240;
                int patternSubunitBuildsCount = 0;
                int allSubunitBuildsCount = 0;
                int testIndex = actionIndex3;
                int testIteration = action.iteration;
                Action testAction = null;
                do {
                    testAction = playerActions[testIndex];
                    if (testAction.actionNameIndex == 39) {
                        ++allSubunitBuildsCount;
                    }
                    if (testAction.iteration == testIteration) {
                        if (testAction.actionNameIndex != 39) continue;
                        ++patternSubunitBuildsCount;
                        testIteration -= 120;
                        continue;
                    }
                    if (testAction.iteration < testIteration) break;
                } while (testIndex-- > 0 && testAction.iteration >= minTestIteration);
                if (patternSubunitBuildsCount >= 3 && allSubunitBuildsCount == patternSubunitBuildsCount) {
                    hackDescriptionList.add(new HackDescription(player.playerName, 12, action.iteration));
                }
            }
            if (lastIteration == action.iteration && lastAction.actionNameIndex != action.actionNameIndex && action.actionNameIndex != 19 && action.actionNameIndex != 14 && action.actionNameIndex != 13) {
                ++actionsCountForGeneralMulticommandHack;
            } else {
                if (actionsCountForGeneralMulticommandHack > 20) {
                    hackDescriptionList.add(new HackDescription(player.playerName, 8, lastAction.iteration));
                }
                lastIteration = action.iteration;
                actionsCountForGeneralMulticommandHack = 0;
            }
            if (action.actionNameIndex == 9) {
                lastSelectAction = action;
            }
            if (action.actionNameIndex == 19) {
                try {
                    int hotkey = Integer.parseInt(action.parameters.substring(action.parameters.indexOf(44) + 1));
                    if (action.parameters.startsWith("Assign") || action.parameters.startsWith("Add")) {
                        lastSelectActionSetAsHotkeys[hotkey] = lastSelectAction;
                    } else if (action.parameters.startsWith("Select")) {
                        lastSelectAction = lastSelectActionSetAsHotkeys[hotkey];
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            lastAction = action;
            if (skipLatterActionsOfHackers && initialHackDescriptionListSize != hackDescriptionList.size()) break;
            ++actionIndex3;
        }
    }

    private static boolean checkAllyParams(String parameters) {
        if (!parameters.endsWith("0 00")) {
            return false;
        }
        if (parameters.charAt(6) != '8' && parameters.charAt(6) != '4') {
            return false;
        }
        return !parameters.startsWith("00 00");
    }

    private static boolean checkVisionParams(String parameters) {
        if (parameters.charAt(3) != '0' || parameters.charAt(4) != '0') {
            return false;
        }
        return parameters.charAt(0) != '0' || parameters.charAt(1) != '0';
    }
}

