/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhf.control;

import hu.belicza.andras.bwhf.control.ParseException;
import hu.belicza.andras.bwhf.model.Action;
import hu.belicza.andras.bwhf.model.ReplayActions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayActionsParser {
    public static ReplayActions parseBWChartExportString(String replayActions) throws ParseException {
        HashMap<String, List<Action>> playerNameActionListMap = new HashMap<String, List<Action>>();
        int lineCounter = 0;
        int fromIndex = 0;
        int toIndex = -1;
        int replayActionsLength = replayActions.length() - 2;
        try {
            while (toIndex < replayActionsLength) {
                ++lineCounter;
                fromIndex = toIndex + 1;
                toIndex = replayActions.indexOf(9, fromIndex);
                int iteration = Integer.parseInt(replayActions.substring(fromIndex, toIndex));
                fromIndex = toIndex + 1;
                toIndex = replayActions.indexOf(9, fromIndex);
                String playerName = replayActions.substring(fromIndex, toIndex);
                fromIndex = toIndex + 1;
                toIndex = replayActions.indexOf(9, fromIndex);
                String name = replayActions.substring(fromIndex, toIndex);
                fromIndex = toIndex + 1;
                toIndex = replayActions.indexOf(9, fromIndex);
                String parameters = replayActions.substring(fromIndex, toIndex).trim();
                fromIndex = toIndex + 1;
                toIndex = replayActions.indexOf(9, fromIndex);
                fromIndex = toIndex + 1;
                toIndex = replayActions.indexOf(10, fromIndex);
                String unitIds = replayActions.substring(fromIndex, toIndex);
                ReplayActionsParser.addActionToPlayerMap(playerName, new Action(iteration, name, parameters, unitIds), playerNameActionListMap);
            }
        }
        catch (Exception e) {
            throw new ParseException(lineCounter);
        }
        return new ReplayActions(playerNameActionListMap);
    }

    public static ReplayActions parseBWChartExportFile(File replayExportFile) throws ParseException {
        HashMap<String, List<Action>> playerNameActionListMap = new HashMap<String, List<Action>>();
        BufferedReader reader = null;
        try {
            try {
                String line;
                reader = new LineNumberReader(new FileReader(replayExportFile));
                while ((line = ((LineNumberReader)reader).readLine()) != null) {
                    int fromIndex = 0;
                    int toIndex = line.indexOf(9, fromIndex);
                    int iteration = Integer.parseInt(line.substring(fromIndex, toIndex));
                    fromIndex = toIndex + 1;
                    toIndex = line.indexOf(9, fromIndex);
                    String playerName = line.substring(fromIndex, toIndex);
                    fromIndex = toIndex + 1;
                    toIndex = line.indexOf(9, fromIndex);
                    String name = line.substring(fromIndex, toIndex);
                    fromIndex = toIndex + 1;
                    toIndex = line.indexOf(9, fromIndex);
                    String parameters = line.substring(fromIndex, toIndex).trim();
                    fromIndex = toIndex + 1;
                    toIndex = line.indexOf(9, fromIndex);
                    fromIndex = toIndex + 1;
                    String unitIds = line.substring(fromIndex);
                    ReplayActionsParser.addActionToPlayerMap(playerName, new Action(iteration, name, parameters, unitIds), playerNameActionListMap);
                }
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                throw new ParseException();
            }
            catch (IOException ie) {
                throw new ParseException();
            }
            catch (Exception e) {
                if (reader != null) {
                    throw new ParseException(((LineNumberReader)reader).getLineNumber());
                }
                throw new ParseException();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return new ReplayActions(playerNameActionListMap);
    }

    private static void addActionToPlayerMap(String playerName, Action action, Map<String, List<Action>> playerNameActionListMap) {
        List<Action> playerActionList = playerNameActionListMap.get(playerName);
        if (playerActionList == null) {
            playerActionList = new ArrayList<Action>();
            playerNameActionListMap.put(playerName, playerActionList);
        }
        playerActionList.add(action);
    }
}

