/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhf.control;

import hu.belicza.andras.bwhf.control.BinReplayUnpacker;
import hu.belicza.andras.bwhf.model.Action;
import hu.belicza.andras.bwhf.model.Replay;
import hu.belicza.andras.bwhf.model.ReplayActions;
import hu.belicza.andras.bwhf.model.ReplayHeader;
import java.io.File;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinRepParser {
    public static final int HEADER_SIZE = 633;

    public static void main(String[] arguments) {
        String[] replayNames;
        String[] stringArray = replayNames = new String[]{"w:/rep/4 - hack.rep"};
        int n = replayNames.length;
        int n2 = 0;
        while (n2 < n) {
            String replayName = stringArray[n2];
            Replay replay = BinRepParser.parseReplay(new File(replayName), true, false);
            if (replay != null) {
                replay.replayHeader.printHeaderInformation(new PrintWriter(System.out));
            } else {
                System.out.println("Could not parse " + replayName + "!");
            }
            System.out.println();
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Replay parseReplay(File replayFile, boolean parseCommandsSection, boolean gameChatOnly) {
        BinReplayUnpacker unpacker = null;
        try {
            List<E>[] playerActionLists;
            GameChatWrapper gameChatWrapper;
            unpacker = new BinReplayUnpacker(replayFile);
            if (Integer.reverseBytes(ByteBuffer.wrap(unpacker.unpackSection(4)).getInt()) != 1397908850) {
                return null;
            }
            byte[] headerData = unpacker.unpackSection(633);
            ByteBuffer headerBuffer = ByteBuffer.wrap(headerData);
            headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
            ReplayHeader replayHeader = new ReplayHeader();
            replayHeader.gameEngine = headerData[0];
            replayHeader.gameFrames = headerBuffer.getInt(1);
            replayHeader.saveTime = new Date((long)headerBuffer.getInt(8) * 1000L);
            replayHeader.gameName = BinRepParser.getZeroPaddedString(headerData, 24, 28);
            replayHeader.mapWidth = headerBuffer.getShort(52);
            replayHeader.mapHeight = headerBuffer.getShort(54);
            replayHeader.gameSpeed = headerBuffer.getShort(58);
            replayHeader.gameType = headerBuffer.getShort(60);
            replayHeader.gameSubType = headerBuffer.getShort(62);
            replayHeader.creatorName = BinRepParser.getZeroPaddedString(headerData, 72, 24);
            replayHeader.mapName = BinRepParser.getZeroPaddedString(headerData, 97, 26);
            replayHeader.playerRecords = Arrays.copyOfRange(headerData, 161, 593);
            int i = 0;
            while (i < replayHeader.playerColors.length) {
                replayHeader.playerColors[i] = headerBuffer.getInt(593 + i * 4);
                ++i;
            }
            replayHeader.playerSpotIndices = Arrays.copyOfRange(headerData, 625, 633);
            i = 0;
            while (i < 12) {
                String playerName = BinRepParser.getZeroPaddedString(replayHeader.playerRecords, i * 36 + 11, 25);
                if (playerName.length() > 0) {
                    replayHeader.playerNames[i] = playerName;
                }
                replayHeader.playerRaces[i] = replayHeader.playerRecords[i * 36 + 9];
                replayHeader.playerIds[i] = replayHeader.playerRecords[i * 36 + 4] & 0xFF;
                ++i;
            }
            if (!parseCommandsSection) {
                Replay replay = new Replay(replayHeader, null, null);
                return replay;
            }
            int playerCommandsLength = Integer.reverseBytes(ByteBuffer.wrap(unpacker.unpackSection(4)).getInt());
            ByteBuffer commandsBuffer = ByteBuffer.wrap(unpacker.unpackSection(playerCommandsLength));
            commandsBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (gameChatOnly) {
                gameChatWrapper = new GameChatWrapper(replayHeader.playerNames, replayHeader.playerIds);
                playerActionLists = null;
            } else {
                gameChatWrapper = null;
                playerActionLists = new ArrayList[replayHeader.playerNames.length];
                int i2 = 0;
                while (i2 < playerActionLists.length) {
                    playerActionLists[i2] = new ArrayList();
                    ++i2;
                }
            }
            while (commandsBuffer.position() < playerCommandsLength) {
                int frame = commandsBuffer.getInt();
                int commandBlocksLength = commandsBuffer.get() & 0xFF;
                int commandBlocksEndPos = commandsBuffer.position() + commandBlocksLength;
                while (commandsBuffer.position() < commandBlocksEndPos) {
                    int playerId = commandsBuffer.get() & 0xFF;
                    Action action = BinRepParser.readNextAction(frame, commandsBuffer, commandBlocksEndPos, gameChatWrapper);
                    if (action == null) continue;
                    int n = playerId;
                    replayHeader.playerIdActionsCounts[n] = replayHeader.playerIdActionsCounts[n] + 1;
                    if (playerActionLists == null) continue;
                    playerActionLists[playerId].add(action);
                }
            }
            if (gameChatWrapper != null) {
                Replay replay = new Replay(replayHeader, null, gameChatWrapper.gameChatBuilder.toString());
                return replay;
            }
            HashMap<String, List<Action>> playerNameActionListMap = new HashMap<String, List<Action>>();
            int i3 = 0;
            while (i3 < replayHeader.playerNames.length) {
                if (replayHeader.playerNames[i3] != null && replayHeader.playerIds[i3] != 255) {
                    playerNameActionListMap.put(replayHeader.playerNames[i3], playerActionLists[replayHeader.playerIds[i3]]);
                }
                ++i3;
            }
            ReplayActions replayActions = new ReplayActions(playerNameActionListMap);
            Replay replay = new Replay(replayHeader, replayActions, null);
            return replay;
        }
        catch (Exception e) {
            return null;
        }
        finally {
            if (unpacker != null) {
                unpacker.close();
            }
        }
    }

    private static String getZeroPaddedString(byte[] data, int offset, int length) {
        String string = new String(data, offset, length);
        int firstNullCharPos = string.indexOf(0);
        if (firstNullCharPos >= 0) {
            string = string.substring(0, firstNullCharPos);
        }
        return string;
    }

    private static Action readNextAction(int frame, ByteBuffer commandsBuffer, int commandBlocksEndPos, GameChatWrapper gameChatWrapper) {
        byte blockId = commandsBuffer.get();
        Action action = null;
        int skipBytes = 0;
        switch (blockId) {
            case 9: 
            case 10: 
            case 11: {
                int unitsCount = commandsBuffer.get() & 0xFF;
                StringBuilder parametersBuilder = new StringBuilder();
                while (unitsCount > 0) {
                    parametersBuilder.append(commandsBuffer.getShort());
                    if (unitsCount > 1) {
                        parametersBuilder.append(',');
                    }
                    --unitsCount;
                }
                action = new Action(frame, parametersBuilder.toString(), blockId);
                break;
            }
            case 12: {
                commandsBuffer.get();
                short posX = commandsBuffer.getShort();
                short posY = commandsBuffer.getShort();
                short unitId = commandsBuffer.getShort();
                action = new Action(frame, "(" + posX + "," + posY + ")," + Action.UNIT_ID_NAME_MAP.get(unitId), blockId, -1, unitId);
                break;
            }
            case 13: {
                byte data1 = commandsBuffer.get();
                byte data2 = commandsBuffer.get();
                action = new Action(frame, BinRepParser.convertToHexString(data1, data2), blockId);
                break;
            }
            case 14: {
                byte data1 = commandsBuffer.get();
                byte data2 = commandsBuffer.get();
                byte data3 = commandsBuffer.get();
                byte data4 = commandsBuffer.get();
                action = new Action(frame, BinRepParser.convertToHexString(data1, data2, data3, data4), blockId);
                break;
            }
            case 15: {
                byte speed = commandsBuffer.get();
                action = new Action(frame, Action.GAME_SPEED_MAP.get(speed), blockId);
                break;
            }
            case 19: {
                byte type = commandsBuffer.get();
                action = new Action(frame, String.valueOf(type == 0 ? "Assign" : "Select") + "," + commandsBuffer.get(), blockId);
                break;
            }
            case 20: {
                short posX = commandsBuffer.getShort();
                short posY = commandsBuffer.getShort();
                commandsBuffer.getShort();
                skipBytes = 3;
                action = new Action(frame, String.valueOf(posX) + "," + posY, 20);
                break;
            }
            case 21: {
                byte actionNameIndex;
                short posX = commandsBuffer.getShort();
                short posY = commandsBuffer.getShort();
                commandsBuffer.getShort();
                commandsBuffer.getShort();
                byte type = commandsBuffer.get();
                switch (type) {
                    case 0: 
                    case 6: {
                        actionNameIndex = 20;
                        break;
                    }
                    case 9: 
                    case 79: 
                    case 80: {
                        actionNameIndex = -4;
                        break;
                    }
                    case 14: {
                        actionNameIndex = -3;
                        break;
                    }
                    case 40: {
                        actionNameIndex = -5;
                        break;
                    }
                    default: {
                        actionNameIndex = -1;
                    }
                }
                commandsBuffer.get();
                action = new Action(frame, String.valueOf(posX) + "," + posY, actionNameIndex, type, -1, -1);
                break;
            }
            case 31: {
                short unitId = commandsBuffer.getShort();
                action = new Action(frame, Action.UNIT_ID_NAME_MAP.get(unitId), blockId, unitId, -1);
                break;
            }
            case 32: {
                skipBytes = 2;
                action = new Action(frame, "", blockId);
                break;
            }
            case 35: {
                short unitId = commandsBuffer.getShort();
                action = new Action(frame, Action.UNIT_ID_NAME_MAP.get(unitId), blockId, unitId, -1);
                break;
            }
            case 48: {
                byte researchId = commandsBuffer.get();
                action = new Action(frame, Action.RESEARCH_ID_NAME_MAP.get(researchId), blockId);
                break;
            }
            case 50: {
                byte upgradeId = commandsBuffer.get();
                action = new Action(frame, Action.UPGRADE_ID_NAME_MAP.get(upgradeId), blockId);
                break;
            }
            case 26: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 45: {
                byte data = commandsBuffer.get();
                String params = blockId == 26 || blockId == 30 || blockId == 40 || blockId == 43 ? (data == 0 ? "Instant" : "Queued") : "";
                action = new Action(frame, params, blockId);
                break;
            }
            case 53: {
                short unitId = commandsBuffer.getShort();
                action = new Action(frame, Action.UNIT_ID_NAME_MAP.get(unitId), blockId, unitId, unitId);
                break;
            }
            case 87: {
                byte reason = commandsBuffer.get();
                action = new Action(frame, reason == 1 ? "Quit" : (reason == 6 ? "Dropped" : ""), blockId);
                break;
            }
            case 41: {
                skipBytes = 2;
                action = new Action(frame, "", blockId);
                break;
            }
            case 88: {
                short posX = commandsBuffer.getShort();
                short posY = commandsBuffer.getShort();
                action = new Action(frame, "(" + posX + "," + posY + ")", blockId);
                break;
            }
            case 18: 
            case 47: {
                byte data1 = commandsBuffer.get();
                byte data2 = commandsBuffer.get();
                byte data3 = commandsBuffer.get();
                byte data4 = commandsBuffer.get();
                action = new Action(frame, BinRepParser.convertToHexString(data1, data2, data3, data4), blockId);
                break;
            }
            case 24: 
            case 25: 
            case 39: 
            case 42: 
            case 46: 
            case 49: 
            case 54: 
            case 90: {
                action = new Action(frame, "", blockId);
                break;
            }
            case 92: {
                if (gameChatWrapper == null) {
                    skipBytes = 81;
                    break;
                }
                if (gameChatWrapper.gameChatBuilder.length() > 0) {
                    gameChatWrapper.gameChatBuilder.append("\r\n");
                }
                ReplayHeader.formatFrames(frame, gameChatWrapper.gameChatBuilder, false);
                gameChatWrapper.gameChatBuilder.append(" - ").append(gameChatWrapper.playerIndexNameMap.get(commandsBuffer.get() & 0xFF));
                commandsBuffer.get(gameChatWrapper.messageBuffer);
                gameChatWrapper.gameChatBuilder.append(": ").append(BinRepParser.getZeroPaddedString(gameChatWrapper.messageBuffer, 0, gameChatWrapper.messageBuffer.length));
                break;
            }
            default: {
                skipBytes = commandBlocksEndPos - commandsBuffer.position();
            }
        }
        if (skipBytes > 0) {
            commandsBuffer.position(commandsBuffer.position() + skipBytes);
        }
        if (blockId == 92) {
            return null;
        }
        if (action == null) {
            action = new Action(frame, "", -1);
        }
        return action;
    }

    private static String convertToHexString(byte ... data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        int i = 0;
        while (i < data.length) {
            sb.append(Integer.toHexString(data[i] >> 4 & 0xF).toUpperCase());
            sb.append(Integer.toHexString(data[i] & 0xF).toUpperCase());
            if (++i >= data.length) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static class GameChatWrapper {
        public final StringBuilder gameChatBuilder;
        public final Map<Integer, String> playerIndexNameMap;
        public final byte[] messageBuffer = new byte[80];

        public GameChatWrapper(String[] playerNames, int[] playerIds) {
            this.gameChatBuilder = new StringBuilder();
            this.playerIndexNameMap = new HashMap<Integer, String>();
            int i = 0;
            while (i < playerNames.length) {
                if (playerNames[i] != null && playerIds[i] != 255) {
                    this.playerIndexNameMap.put(i, playerNames[i]);
                }
                ++i;
            }
        }
    }
}

