/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.tree;

import swingwtx.swing.event.EventListenerList;
import swingwtx.swing.event.TreeModelEvent;
import swingwtx.swing.event.TreeModelListener;
import swingwtx.swing.tree.MutableTreeNode;
import swingwtx.swing.tree.TreeModel;
import swingwtx.swing.tree.TreeNode;
import swingwtx.swing.tree.TreePath;

public class DefaultTreeModel
implements TreeModel {
    protected TreeNode root;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean asksAllowsChildren;

    public DefaultTreeModel(TreeNode root) {
        this(root, false);
    }

    public DefaultTreeModel(TreeNode root, boolean asksAllowsChildren) {
        this.root = root;
        this.asksAllowsChildren = asksAllowsChildren;
    }

    public void setRoot(TreeNode root) {
        TreeNode lastRoot = this.root;
        this.root = root;
        if (root == null && lastRoot != null) {
            this.fireTreeStructureChanged(this, null, null, null);
        } else {
            this.nodeStructureChanged(root);
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public void setAsksAllowsChildren(boolean newValue) {
        this.asksAllowsChildren = newValue;
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        if (this.asksAllowsChildren) {
            return !((TreeNode)node).getAllowsChildren();
        }
        return ((TreeNode)node).isLeaf();
    }

    public void reload() {
        this.reload(this.root);
    }

    public void reload(TreeNode node) {
        this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        MutableTreeNode node = (MutableTreeNode)path.getLastPathComponent();
        node.setUserObject(newValue);
        this.nodeChanged(node);
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        parent.insert(newChild, index);
        int[] newIndexs = new int[]{index};
        this.nodesWereInserted(parent, newIndexs);
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    public void nodeChanged(TreeNode node) {
        if (this.listenerList.getListenerCount() > 0 && node != null) {
            TreeNode parent = node.getParent();
            if (parent != null) {
                int anIndex = parent.getIndex(node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.listenerList.getListenerCount() > 0 && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public void nodesChanged(TreeNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] nodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            nodes = new TreeNode[depth];
        } else {
            nodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            nodes[nodes.length - depth] = aNode;
        }
        return nodes;
    }

    public Object[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelListener[] listenerz = this.getTreeModelListeners();
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        for (int i = 0; i < listenerz.length; ++i) {
            listenerz[i].treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelListener[] listenerz = this.getTreeModelListeners();
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        for (int i = 0; i < listenerz.length; ++i) {
            listenerz[i].treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelListener[] listenerz = this.getTreeModelListeners();
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        for (int i = 0; i < listenerz.length; ++i) {
            listenerz[i].treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelListener[] listenerz = this.getTreeModelListeners();
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        for (int i = 0; i < listenerz.length; ++i) {
            listenerz[i].treeStructureChanged(e);
        }
    }
}

