/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.swt.widgets.TreeItem;
import swingwtx.swing.tree.MutableTreeNode;
import swingwtx.swing.tree.TreeNode;

public class DefaultMutableTreeNode
implements MutableTreeNode {
    public TreeItem peer = null;
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public Object nextElement() {
            throw new NoSuchElementException("No elements");
        }

        public boolean hasMoreElements() {
            return false;
        }
    };
    protected MutableTreeNode parent;
    protected boolean allowsChildren;
    protected Vector children;
    protected Object userObject;

    public DefaultMutableTreeNode() {
        this(null);
    }

    public DefaultMutableTreeNode(Object userObject) {
        this(userObject, true);
    }

    public DefaultMutableTreeNode(Object userObject, boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
        this.userObject = userObject;
        this.parent = null;
    }

    public void insert(MutableTreeNode newChild, int childIndex) {
        MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void add(MutableTreeNode newChild) {
        if (newChild.getParent() == this && newChild != null) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void removeFromParent() {
        MutableTreeNode parent = (MutableTreeNode)this.getParent();
        parent.remove(this);
    }

    public TreeNode getChildAt(int index) {
        return (TreeNode)this.children.elementAt(index);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(TreeNode aChild) {
        return this.children.indexOf(aChild);
    }

    public Enumeration children() {
        if (this.children != null) {
            return this.children.elements();
        }
        return EMPTY_ENUMERATION;
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setAllowsChildren(boolean allows) {
        if (allows != this.allowsChildren) {
            this.allowsChildren = allows;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void remove(MutableTreeNode aChild) {
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public boolean isLeaf() {
        return this.getChildCount() > 0;
    }

    public TreeNode[] getPath() {
        ArrayList<DefaultMutableTreeNode> path = new ArrayList<DefaultMutableTreeNode>();
        for (TreeNode current = this; current != null; current = current.getParent()) {
            path.add(0, (DefaultMutableTreeNode)current);
        }
        return path.toArray(new TreeNode[0]);
    }

    public boolean isNodeAncestor(TreeNode anotherNode) {
        for (TreeNode ancestor = this; ancestor != null; ancestor = ancestor.getParent()) {
            if (ancestor != anotherNode) continue;
            return true;
        }
        return false;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode anotherNode) {
        return anotherNode.isNodeAncestor(this);
    }

    public TreeNode getRoot() {
        TreeNode anc;
        DefaultMutableTreeNode previous = anc = this;
        while (anc != null) {
            anc = anc.getParent();
        }
        return previous;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public Enumeration depthFirstEnumeration() {
        Vector v = DefaultMutableTreeNode.buildDepthFirstVector(this, new Vector());
        return v.elements();
    }

    public int getLeafCount() {
        Vector v = DefaultMutableTreeNode.buildLeafOnlyVector(this, new Vector());
        return v.size();
    }

    private static Vector buildDepthFirstVector(TreeNode node, Vector v) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode.buildDepthFirstVector(node.getChildAt(i), v);
        }
        v.add(node);
        return v;
    }

    private static Vector buildLeafOnlyVector(TreeNode node, Vector v) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode.buildLeafOnlyVector(node.getChildAt(i), v);
        }
        if (node.isLeaf()) {
            v.add(node);
        }
        return v;
    }

    public Object[] getUserObjectPath() {
        ArrayList<Object> path = new ArrayList<Object>();
        for (TreeNode current = this; current != null; current = current.getParent()) {
            path.add(0, current.getUserObject());
        }
        return path.toArray();
    }

    public TreeNode getChildAfter(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("child is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("not a child");
        }
        if (index < this.getChildCount() - 1) {
            return this.getChildAt(index + 1);
        }
        return null;
    }

    public TreeNode getChildBefore(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("child is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("not a child");
        }
        if (index > 0) {
            return this.getChildAt(index - 1);
        }
        return null;
    }

    public TreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("this not has no children");
        }
        return this.getChildAt(0);
    }

    public TreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("this not has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }
}

