/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.editorpanes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Color;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.editorpanes.EditorPane;
import swingwtx.swing.event.DocumentListener;
import swingwtx.swing.event.HyperlinkEvent;
import swingwtx.swing.event.HyperlinkListener;
import swingwtx.swing.event.UndoableEditListener;
import swingwtx.swing.text.AttributeSet;
import swingwtx.swing.text.BadLocationException;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.EditorKit;
import swingwtx.swing.text.Element;
import swingwtx.swing.text.HTMLEditorKit;
import swingwtx.swing.text.JTextComponent;
import swingwtx.swing.text.Position;
import swingwtx.swing.text.Segment;
import swingwtx.swing.text.StyleConstants;

public class PlatformBrowserEditorPane
extends JTextComponent
implements EditorPane {
    protected Document doc = new EditorPaneHTMLDocument();
    protected Vector hyperListeners = new Vector();
    protected Color selectionColor = Color.BLACK;
    protected URL pUrl = null;
    protected Browser ppeer = null;

    public void addHyperlinkListener(HyperlinkListener l) {
        this.hyperListeners.add(l);
    }

    public Dimension calculatePreferredSize() {
        Dimension size = new Dimension(300, 200);
        this.setSize(size);
        return size;
    }

    public int getCaretPosition() {
        return 0;
    }

    public String getContentType() {
        return "text/html";
    }

    public Document getDocument() {
        return this.doc;
    }

    public EditorKit getEditorKit() {
        return new HTMLEditorKit();
    }

    public JComponent getJComponent() {
        return this;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public int getSelectionEnd() {
        return 0;
    }

    public int getSelectionStart() {
        return 0;
    }

    public String getText() {
        return this.getPageText(this.pUrl);
    }

    public boolean isEditable() {
        return false;
    }

    public void removeHyperlinkListener(HyperlinkListener l) {
        this.hyperListeners.remove(l);
    }

    public void setCaretPosition(int pos) {
    }

    public void setContentType(String contentType) {
    }

    public void setDocument(Document newdoc) {
        throw new RuntimeException("PlatformBrowserEditorPane does not support setDocument");
    }

    public void setEditable(boolean b) {
    }

    public void setEditorKit(EditorKit k) {
    }

    public void setPage(URL url) throws IOException {
        if (this.pUrl != null && this.pUrl.equals(url)) {
            return;
        }
        this.pUrl = url;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    PlatformBrowserEditorPane.this.ppeer.setUrl(PlatformBrowserEditorPane.this.pUrl.toString());
                }
            });
        }
    }

    public void setPage(String url) throws IOException {
        this.setPage(new URL(url));
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        try {
            this.ppeer = new Browser(parent.getComposite(), 0);
            this.peer = this.ppeer;
            if (this.pText != null && !this.pText.equals("")) {
                this.setText(this.pText);
            }
            if (this.pUrl != null && !this.pUrl.toString().equals("")) {
                this.ppeer.setUrl(this.pUrl.toString());
            }
            this.registerHyperLinkEvents();
            this.parent = parent;
        }
        catch (SWTError e) {
            if (!SwingWTUtils.isMacOSX() && !SwingWTUtils.isWindows()) {
                System.out.println("SwingWT JEditorPane/SWT Browser requires at least Mozilla 1.4 to operate.");
                System.out.println("If you have it installed, then you need to set the following");
                System.out.println("environment variables before starting this application:\n");
                System.out.println("export MOZILLA_FIVE_HOME=/usr/lib/mozilla");
                System.out.println("export LD_LIBRARY_PATH=/usr/lib/mozilla\n");
                System.out.println("Where /usr/lib/mozilla is the path to your mozilla installation.\n");
                System.out.println("Error was: " + e.getMessage());
            }
            e.printStackTrace();
        }
    }

    public void setText(String text) {
        this.pText = text;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    PlatformBrowserEditorPane.this.ppeer.setText(PlatformBrowserEditorPane.this.pText);
                }
            });
        }
    }

    private String getPageText(URL url) {
        try {
            int ch;
            String pageText = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer buf = new StringBuffer();
            while ((ch = ((Reader)in).read()) > -1) {
                buf.append((char)ch);
            }
            ((Reader)in).close();
            pageText = buf.toString();
            return pageText;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void registerHyperLinkEvents() {
        this.ppeer.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                PlatformBrowserEditorPane.this.processHyperlinkEvent(event.location, HyperlinkEvent.EventType.ACTIVATED);
            }

            public void changing(LocationEvent event) {
            }
        });
        this.ppeer.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                PlatformBrowserEditorPane.this.processHyperlinkEvent(event.text, HyperlinkEvent.EventType.ENTERED);
            }
        });
    }

    protected void processHyperlinkEvent(String location, HyperlinkEvent.EventType eventType) {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (Exception e) {
            // empty catch block
        }
        HyperlinkEvent e = new HyperlinkEvent(this, eventType, url, location);
        Iterator i = this.hyperListeners.iterator();
        while (i.hasNext()) {
            ((HyperlinkListener)i.next()).hyperlinkUpdate(e);
        }
    }

    public Control getSWTPeer() {
        return this.ppeer;
    }

    public void scrollToReference(String reference) {
    }

    private class EditorPaneHTMLDocument
    implements Document {
        String docText = "";

        private EditorPaneHTMLDocument() {
        }

        public Position getEndPosition() {
            return new EditorPaneHTMLDocPosition(this.docText.length());
        }

        public Position getStartPosition() {
            return new EditorPaneHTMLDocPosition(0);
        }

        public void remove(int i, int j) {
            StringBuffer buffer = new StringBuffer(this.docText);
            buffer.replace(i, j, "");
            this.docText = buffer.toString();
            this.convertText();
        }

        private void convertText() {
            PlatformBrowserEditorPane.this.pText = "<HTML><BODY>" + this.docText + "<A name=\"1\"/></BODY></HTML>";
            PlatformBrowserEditorPane.this.setText(PlatformBrowserEditorPane.this.pText);
        }

        public void insertString(int i, String string, AttributeSet as) {
            StringBuffer buffer = new StringBuffer(this.docText);
            StringBuffer nb = new StringBuffer(string);
            Color foreground = (Color)as.getAttribute(StyleConstants.ColorConstants.Foreground);
            int index = SwingWTUtils.getStringBufferIndexOf(nb, ">");
            while (index > -1) {
                nb.replace(index, index + 1, "&gt;");
                index = SwingWTUtils.getStringBufferIndexOf(nb, ">");
            }
            index = SwingWTUtils.getStringBufferIndexOf(nb, "<");
            while (index > -1) {
                nb.replace(index, index + 1, "&lt;");
                SwingWTUtils.getStringBufferIndexOf(nb, "<");
            }
            SwingWTUtils.getStringBufferIndexOf(nb, "http://");
            while (index > -1) {
                int end = Math.min(SwingWTUtils.getStringBufferIndexOf(nb, " ", index), SwingWTUtils.getStringBufferIndexOf(nb, "\n", index));
                if (end == -1) {
                    end = nb.length() - 1;
                }
                String url = nb.substring(index, end);
                nb.replace(index, end, "<A HREF=\"" + url + "\" " + ">" + url + "</A> ");
                index = SwingWTUtils.getStringBufferIndexOf(nb, "http://", end + (end - index) + 32);
            }
            if (foreground != null) {
                nb.insert(0, "<font color=\"" + this.encodeColor(foreground) + "\">");
                nb.append("</font> ");
            }
            index = SwingWTUtils.getStringBufferIndexOf(nb, "\n");
            while (index > -1) {
                nb.replace(index, index + 1, "<br> ");
                SwingWTUtils.getStringBufferIndexOf(nb, "\n");
            }
            if (i <= 0) {
                buffer.append(nb.toString());
            } else {
                buffer.insert(i, nb.toString());
            }
            this.docText = buffer.toString();
            this.convertText();
        }

        private String encodeColor(Color foreground) {
            return "#" + Integer.toHexString(foreground.getRed()) + Integer.toHexString(foreground.getGreen()) + Integer.toHexString(foreground.getBlue());
        }

        public void addDocumentListener(DocumentListener listener) {
        }

        public void addUndoableEditListener(UndoableEditListener listener) {
        }

        public Position createPosition(int offs) throws BadLocationException {
            return new EditorPaneHTMLDocPosition(offs);
        }

        public Element getDefaultRootElement() {
            return null;
        }

        public int getLength() {
            return this.docText.length();
        }

        public Object getProperty(Object key) {
            return null;
        }

        public Element[] getRootElements() {
            return null;
        }

        public String getText(int offset, int length) throws BadLocationException {
            String ret = null;
            try {
                ret = this.docText.substring(offset, offset + length);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new BadLocationException("Invalid range", offset);
            }
            return ret;
        }

        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            String ret = null;
            try {
                ret = this.docText.substring(offset, offset + length);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new BadLocationException("Invalid range", offset);
            }
            txt.array = this.docText.toCharArray();
            txt.offset = offset;
            txt.count = length;
        }

        public void putProperty(Object key, Object value) {
        }

        public void removeDocumentListener(DocumentListener listener) {
        }

        public void removeUndoableEditListener(UndoableEditListener listener) {
        }

        public void render(Runnable r) {
        }
    }

    private class EditorPaneHTMLDocPosition
    implements Position {
        private int offset = 0;

        public EditorPaneHTMLDocPosition(int pos) {
            this.offset = pos;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

