/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.FontMetrics;
import swingwt.awt.Point;
import swingwt.awt.Window;
import swingwtx.accessibility.Accessible;
import swingwtx.swing.InputMap;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingWTUtils;

public abstract class SwingUtilities
implements SwingConstants {
    public static void invokeAndWait(Runnable run) {
        SwingUtilities.invokeSync(run);
    }

    public static void invokeLater(Runnable run) {
        SwingUtilities.invokeAsync(run);
    }

    public static boolean isEventDispatchThread() {
        SwingWTUtils.checkEventDispatcher();
        return Thread.currentThread().equals(SwingWTUtils.getDisplay().getThread());
    }

    public static void invokeAsync(Runnable run) {
        SwingWTUtils.checkEventDispatcher();
        SwingWTUtils.getDisplay().asyncExec(run);
    }

    public static void invokeSync(Runnable run) {
        SwingWTUtils.checkEventDispatcher();
        if (Thread.currentThread().equals(SwingWTUtils.getDisplay().getThread())) {
            run.run();
        } else {
            SwingWTUtils.getDisplay().syncExec(run);
        }
    }

    public static Object invokeSyncReturn(Task task) {
        SwingUtilities.invokeSync(task);
        return task.retValue;
    }

    public static int computeStringWidth(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return fontMetrics.stringWidth(string);
    }

    public static void invokeIn(Runnable run, int milliseconds) {
        SwingWTUtils.checkEventDispatcher();
        SwingWTUtils.getDisplay().timerExec(milliseconds, run);
    }

    public static void updateComponentTreeUI(Component c) {
        if (c instanceof Container) {
            ((Container)c).invalidate();
        }
        c.repaint();
    }

    public static Container getAncestorOfClass(Class c, Component comp) {
        Container parent;
        if (comp == null || c == null) {
            return null;
        }
        for (parent = comp.getParent(); parent != null && !c.isInstance(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    public static int getAccessibleChildrenCount(Component component) {
        return 0;
    }

    public static Accessible getAccessibleChild(Component component, int i) {
        return component.getAccessibleContext().getAccessibleChild(i);
    }

    public static void convertPointToScreen(Point p, Component c) {
    }

    public static InputMap getUIInputMap(JComponent component, int condition) {
        InputMap iMap = new InputMap();
        return iMap;
    }

    public static Point convertPoint(Component source, int x, int y, Component destination) {
        return new Point(0, 0);
    }

    public static Point convertPoint(Component source, Point aPoint, Component destination) {
        return new Point(0, 0);
    }

    public static Component getDeepestComponentAt(Container parent, int x, int y) {
        return null;
    }

    public static Window getWindowAncestor(Component c) {
        Window w = null;
        for (Container cont = c.getParent(); cont != null; cont = cont.getParent()) {
            if (!(cont instanceof Window)) continue;
            w = (Window)cont;
            break;
        }
        return w;
    }

    public static Window windowForComponent(Component c) {
        return SwingUtilities.getWindowAncestor(c);
    }

    public static void convertPointFromScreen(Point p, Component c) {
    }

    public static abstract class Task
    implements Runnable {
        Object retValue;

        public void run() {
            this.retValue = this.exec();
        }

        public abstract Object exec();
    }
}

