/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JSplitPane
extends JComponent {
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    protected int pOrientation = 1;
    protected double pResizeWeight = 0.0;
    protected Component leftComponent = null;
    protected Component rightComponent = null;
    private SashForm ppeer = null;

    public JSplitPane() {
    }

    public JSplitPane(int newOrientation) {
        this(newOrientation, false);
    }

    public JSplitPane(int newOrientation, boolean newContinuousLayout) {
        this(newOrientation, newContinuousLayout, null, null);
    }

    public JSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, false, newLeftComponent, newRightComponent);
    }

    public JSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        this.pOrientation = newOrientation;
        if (this.pOrientation != 1 && this.pOrientation != 0) {
            throw new IllegalArgumentException("Invalid orientation.");
        }
        if (newLeftComponent != null) {
            this.setLeftComponent(newLeftComponent);
        }
        if (newRightComponent != null) {
            this.setRightComponent(newRightComponent);
        }
    }

    public void setLeftComponent(Component comp) {
        this.leftComponent = comp;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.addLeft();
        }
    }

    public void setRightComponent(Component comp) {
        this.rightComponent = comp;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.addRight();
        }
    }

    public void add(Component c, Object layoutModifier) {
        if (layoutModifier != null) {
            if (layoutModifier.equals(LEFT)) {
                this.setLeftComponent(c);
                return;
            }
            if (layoutModifier.equals(RIGHT)) {
                this.setRightComponent(c);
                return;
            }
        }
        super.add(c, layoutModifier);
    }

    void addLeft() {
        final JSplitPane me = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                try {
                    JSplitPane.this.leftComponent.setSwingWTParent(me);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    void addRight() {
        final JSplitPane me = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                try {
                    JSplitPane.this.rightComponent.setSwingWTParent(me);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new SashForm(parent.getComposite(), 2048);
        this.peer = this.ppeer;
        this.composite = this.ppeer;
        this.parent = parent;
        this.ppeer.setOrientation(this.pOrientation == 0 ? 512 : 256);
        if (this.leftComponent != null) {
            this.addLeft();
            if (this.rightComponent != null) {
                this.addRight();
            }
        }
        if (this.pResizeWeight != 0.0) {
            this.setResizeWeight(this.pResizeWeight);
        }
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public void setTopComponent(Component comp) {
        this.setLeftComponent(comp);
    }

    public Component getTopComponent() {
        return this.leftComponent;
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public void setBottomComponent(Component comp) {
        this.setRightComponent(comp);
    }

    public Component getBottomComponent() {
        return this.rightComponent;
    }

    public int getOrientation() {
        return this.pOrientation;
    }

    public void setContinuousLayout(boolean b) {
    }

    public int getDividerSize() {
        return 2;
    }

    public int getDividerLocation() {
        if (this.leftComponent != null) {
            return this.leftComponent.getWidth();
        }
        return 0;
    }

    public void setDividerSize(int newSize) {
    }

    public void setOrientation(final int newOrientation) {
        if (this.pOrientation != 1 && this.pOrientation != 0) {
            throw new IllegalArgumentException("Invalid orientation.");
        }
        this.pOrientation = newOrientation;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JSplitPane.this.ppeer)) {
                    JSplitPane.this.ppeer.setOrientation(newOrientation == 0 ? 512 : 256);
                }
            }
        });
    }

    public void setResizeWeight(final double value) {
        this.pResizeWeight = value;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JSplitPane.this.ppeer) && JSplitPane.this.leftComponent != null && JSplitPane.this.rightComponent != null) {
                    int leftWeight = (int)(value * 10.0);
                    int rightWeight = 10 - leftWeight;
                    JSplitPane.this.ppeer.setWeights(new int[]{leftWeight, rightWeight});
                }
            }
        });
    }

    public double getResizeWeight() {
        return this.pResizeWeight;
    }

    public void setOneTouchExpandable(boolean newValue) {
    }

    public void resetToPreferredSizes() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer) && this.leftComponent != null && this.rightComponent != null) {
            this.setPreferredSize(new Dimension(this.leftComponent.getPreferredSize().width + this.rightComponent.getPreferredSize().width, this.leftComponent.getPreferredSize().height + this.rightComponent.getPreferredSize().height));
        }
    }

    public void setDividerLocation(double proportionalLocation) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer) && this.leftComponent != null) {
            this.setResizeWeight(proportionalLocation);
        }
    }

    public void setDividerLocation(int location) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer) && this.leftComponent != null) {
            this.setResizeWeight((double)location / (double)this.getWidth());
        }
    }
}

