/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.KeyListener;
import swingwt.awt.event.MouseEvent;
import swingwt.awt.event.MouseListener;
import swingwtx.swing.AbstractButton;
import swingwtx.swing.ButtonGroup;
import swingwtx.swing.ButtonModel;
import swingwtx.swing.Icon;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JCheckBox
extends AbstractButton
implements ButtonModel,
SwingConstants {
    private boolean bRetVal;
    private boolean isAWTRadio = false;

    public JCheckBox() {
        this("");
    }

    public JCheckBox(String text) {
        this(text, false);
    }

    public JCheckBox(String text, Icon icon) {
        this(text, false);
    }

    public JCheckBox(String text, boolean selected) {
        this.pText = text;
        this.pSelection = selected;
        this.setModel(this);
        this.showMnemonic();
    }

    public JCheckBox(String text, boolean selected, ButtonGroup bg) {
        this.pText = text;
        this.pSelection = selected;
        this.isAWTRadio = true;
        this.setModel(this);
        this.showMnemonic();
    }

    public void processMouseEvent(MouseEvent e) {
        Iterator i = this.mouseListeners.iterator();
        while (i.hasNext()) {
            MouseListener ml = (MouseListener)i.next();
            int eventID = e.getID();
            if (eventID == 500) {
                ml.mouseClicked(e);
                this.processItemEvent();
            }
            if (eventID == 504) {
                ml.mouseEntered(e);
            }
            if (eventID == 505) {
                ml.mouseExited(e);
            }
            if (eventID == 501) {
                ml.mousePressed(e);
            }
            if (eventID != 502) continue;
            ml.mouseReleased(e);
        }
    }

    public void processKeyEvent(KeyEvent e) {
        Iterator i = this.keyListeners.iterator();
        while (i.hasNext()) {
            KeyListener ml = (KeyListener)i.next();
            if (e.eventID == 401) {
                ml.keyTyped(e);
                this.processItemEvent();
            }
            if (e.eventID == 402) {
                ml.keyReleased(e);
            }
            if (e.eventID != 401) continue;
            ml.keyPressed(e);
        }
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(SwingWTUtils.getRenderStringWidth(this.pText) + 6, SwingWTUtils.getRenderStringHeight(this.pText) + 6);
        this.setSize(size);
        return size;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = this.isAWTRadio ? new Button(parent.getComposite(), 16) : new Button(parent.getComposite(), 32);
        this.ppeer.setText(this.pText);
        this.ppeer.setSelection(this.pSelection);
        this.ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(this.pVAlign) | SwingWTUtils.translateSwingAlignmentConstant(this.pHAlign));
        this.peer = this.ppeer;
        this.parent = parent;
    }

    public boolean isSelected() {
        this.bRetVal = false;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JCheckBox.this.ppeer)) {
                    JCheckBox.this.bRetVal = JCheckBox.this.pSelection;
                } else {
                    JCheckBox.this.bRetVal = JCheckBox.this.ppeer.getSelection();
                }
            }
        });
        return this.bRetVal;
    }

    public void setSelected(final boolean b) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JCheckBox.this.ppeer)) {
                    JCheckBox.this.ppeer.setSelection(b);
                } else {
                    JCheckBox.this.pSelection = b;
                }
            }
        });
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public int getMnemonic() {
        return 0;
    }

    public boolean isArmed() {
        return false;
    }

    public boolean isPressed() {
        return false;
    }

    public boolean isRollover() {
        return false;
    }

    public void setArmed(boolean b) {
    }

    public void setPressed(boolean b) {
    }

    public void setRollover(boolean b) {
    }
}

