/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.custom.validation;

import java.util.Vector;
import swingwt.awt.BorderLayout;
import swingwt.awt.Color;
import swingwt.awt.Component;
import swingwt.awt.Font;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.FocusAdapter;
import swingwt.awt.event.FocusEvent;
import swingwt.awt.event.FocusListener;
import swingwt.awt.event.KeyListener;
import swingwt.awt.event.MouseListener;
import swingwtx.custom.validation.ValidationGroup;
import swingwtx.swing.JComponent;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.ValidationEvent;
import swingwtx.swing.event.ValidationListener;

public abstract class ValidatableComponent
extends JPanel {
    protected JComponent comp = null;
    protected JLabel errorOutput = new JLabel();
    protected ValidationGroup validationGroup = null;
    protected boolean isValid = true;
    protected String errorMessage = "";
    protected Vector validationListeners = new Vector();

    public void dispose() {
        this.comp.dispose();
        this.errorOutput.dispose();
        super.dispose();
    }

    public JComponent getComponent() {
        return this.comp;
    }

    public void addValidationListener(ValidationListener l) {
        this.validationListeners.add(l);
    }

    public void removeValidationListener(ValidationListener l) {
        this.validationListeners.remove(l);
    }

    public void setupComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.comp, "Center");
        this.add((Component)this.errorOutput, "East");
        this.errorOutput.setIcon(SwingWTUtils.getPixmap(ValidatableComponent.class, "blankicon.gif"));
        this.comp.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ValidatableComponent.this.fireValidation(false);
            }
        });
    }

    public void setIsValid(boolean b) {
        this.isValid = b;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setErrorMessage(String s) {
        this.errorMessage = s;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void fireValidation(boolean forcePass) {
        for (int i = 0; i < this.validationListeners.size(); ++i) {
            ValidationEvent e = new ValidationEvent(this);
            if (!forcePass) {
                ((ValidationListener)this.validationListeners.get(i)).validating(e);
                this.isValid = e.isValid();
                this.errorMessage = e.getErrorMessage();
            } else {
                this.isValid = true;
            }
            if (this.isValid) {
                this.errorOutput.setIcon(SwingWTUtils.getPixmap(class$swingwtx$custom$validation$ValidatableComponent == null ? ValidatableComponent.class$("swingwtx.custom.validation.ValidatableComponent") : class$swingwtx$custom$validation$ValidatableComponent, "blankicon.gif"));
                this.errorOutput.setToolTipText("");
            } else {
                this.errorOutput.setIcon(this.validationGroup.getIcon());
                this.errorOutput.setToolTipText(this.errorMessage);
            }
            this.invalidate();
        }
    }

    public void setVisible(boolean b) {
        this.comp.setVisible(b);
    }

    public boolean isVisible() {
        return this.comp.isVisible();
    }

    public void setEnabled(boolean b) {
        this.comp.setEnabled(b);
    }

    public boolean isEnabled() {
        return this.comp.isEnabled();
    }

    public void requestFocus() {
        this.comp.requestFocus();
    }

    public void grabFocus() {
        this.comp.grabFocus();
    }

    public Color getBackground() {
        return this.comp.getBackground();
    }

    public void setBackground(Color c) {
        this.comp.setBackground(c);
    }

    public Color getForeground() {
        return this.comp.getForeground();
    }

    public void setForeground(Color c) {
        this.comp.setForeground(c);
    }

    public Font getFont() {
        return this.comp.getFont();
    }

    public void setFont(Font f) {
        this.comp.setFont(f);
    }

    public String getToolTipText() {
        return this.comp.getToolTipText();
    }

    public void setToolTipText(String text) {
        this.comp.setToolTipText(text);
    }

    public void addActionListener(ActionListener l) {
        this.comp.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.comp.removeActionListener(l);
    }

    public void addMouseListener(MouseListener l) {
        this.comp.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.comp.removeMouseListener(l);
    }

    public void addKeyListener(KeyListener l) {
        this.comp.addKeyListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.comp.removeKeyListener(l);
    }

    public void addFocusListener(FocusListener l) {
        this.comp.addFocusListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.comp.removeFocusListener(l);
    }

    public ValidationGroup getValidationGroup() {
        return this.validationGroup;
    }

    public void setValidationGroup(ValidationGroup validationGroup) {
        this.validationGroup = validationGroup;
    }
}

