/*
 * Decompiled with CFR 0.152.
 */
package swingwt.sound;

import java.io.File;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import swingwt.applet.AudioClip;

public class AudioClipPlayer
implements LineListener,
AudioClip {
    private URL url = null;
    private AudioInputStream audioInputStream = null;
    private Clip clip;
    private boolean clipIsPlaying = false;
    private boolean clipIsLoading = false;

    public AudioClipPlayer(URL url) {
        this.url = url;
    }

    private void loadInputStream() {
        this.clipIsLoading = true;
        File clipFile = new File(this.url.getFile());
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(clipFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.audioInputStream != null) {
            AudioFormat format = this.audioInputStream.getFormat();
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                this.audioInputStream = AudioSystem.getAudioInputStream(tmp, this.audioInputStream);
                format = tmp;
            }
            DataLine.Info info = new DataLine.Info(Clip.class, this.audioInputStream.getFormat(), (int)this.audioInputStream.getFrameLength() * format.getFrameSize());
            try {
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.addLineListener(this);
                this.clipIsLoading = false;
            }
            catch (Exception e) {}
        } else {
            System.out.println("can't get data from file " + clipFile.getName());
        }
    }

    private void openClip() {
        try {
            this.clip.open(this.audioInputStream);
            this.clip.setFramePosition(0);
        }
        catch (Exception exe) {
            exe.printStackTrace();
        }
    }

    private void restartClip() {
        this.clip.setFramePosition(0);
    }

    public void update(LineEvent event) {
        if (event.getType().equals(LineEvent.Type.STOP)) {
            this.clipIsPlaying = false;
        } else if (event.getType().equals(LineEvent.Type.CLOSE)) {
            // empty if block
        }
    }

    public void play() {
        if (this.clipIsLoading) {
            return;
        }
        if (this.clip == null) {
            this.loadInputStream();
            this.openClip();
        }
        if (this.clipIsPlaying) {
            return;
        }
        new Thread(){

            public void run() {
                try {
                    if (!AudioClipPlayer.this.clipIsPlaying) {
                        AudioClipPlayer.this.clipIsPlaying = true;
                        AudioClipPlayer.this.restartClip();
                        AudioClipPlayer.this.clip.start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void loop() {
    }

    public void stop() {
        this.clip.stop();
    }
}

