/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import swingwt.awt.Component;
import swingwt.awt.Composite;
import swingwt.awt.Container;
import swingwt.awt.Cursor;
import swingwt.awt.Dimension;
import swingwt.awt.Frame;
import swingwt.awt.GraphicsConfiguration;
import swingwt.awt.Image;
import swingwt.awt.LayoutManager;
import swingwt.awt.LayoutManager2;
import swingwt.awt.MenuBar;
import swingwt.awt.Point;
import swingwt.awt.Rectangle;
import swingwt.awt.event.MouseListener;
import swingwt.awt.event.WindowEvent;
import swingwt.awt.event.WindowListener;
import swingwt.awt.swtcustomlayout.SWTBorderLayout;
import swingwtx.swing.JButton;
import swingwtx.swing.JMenuBar;
import swingwtx.swing.JRootPane;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class Window
extends Container {
    protected Shell peer = null;
    protected Display display = null;
    protected Vector windowListeners = new Vector();
    protected boolean isClosed = false;
    protected boolean hasBeenOpened = false;
    protected boolean isIcon = false;
    protected JRootPane rootPane = null;
    protected String title;
    protected Image iconImage;
    protected JMenuBar pMenu;
    protected MenuBar pMenuBar;
    protected boolean delayPack = false;
    protected static final int FRAME_DECORATION_HEIGHT = 34;
    protected static final int FRAME_DECORATION_WIDTH = 8;
    private Object retval = null;
    GraphicsConfiguration graphicsConfig = null;

    public Window(Frame parent) {
        this.parent = parent;
        this.init();
    }

    public Window(Window parent) {
        this.parent = parent;
        this.init();
    }

    public Window(Window parent, GraphicsConfiguration gc) {
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.graphicsConfig = this.parent == null ? null : this.parent.getGraphicsConfiguration();
        this.rootPane = new JRootPane(this);
        this.rootPane.parent = this;
    }

    protected int getSWTFrameType() {
        return 8;
    }

    public void createSWTWindow() {
        this.create();
    }

    protected void create() {
        this.create(this.getSWTFrameType());
    }

    protected void create(final int SWTFrameType) {
        SwingWTUtils.incrementWindowReferences();
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                Window.this.createImpl(SWTFrameType);
            }
        });
    }

    private void createImpl(int SWTFrameType) {
        this.display = SwingWTUtils.getDisplay();
        this.peer = this.parent == null ? new Shell(this.display, SWTFrameType) : new Shell((Shell)this.parent.getSWTPeer(), SWTFrameType);
        this.composite = this.peer;
        this.peer.setLayout((Layout)new SWTBorderLayout());
        this.peer.setLayoutData((Object)SWTBorderLayout.CENTER);
        this.registerWindowEvents();
        this.setCachedProperties();
        try {
            this.rootPane.setSwingWTParent(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isClosed = false;
    }

    public void setCachedProperties() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            return;
        }
        if (this.title != null) {
            this.peer.setText(this.title);
        }
        if (this.iconImage != null) {
            this.peer.setImage(this.iconImage.image);
        }
        if (this.pMenu != null) {
            this.setJMenuBar(this.pMenu);
        }
        if (this.pLocation != null) {
            this.setLocation(this.pLocation);
        }
        if (this.pSize != null) {
            this.setSize(this.pSize);
        }
        if (this.delayPack) {
            this.pack();
        }
    }

    public void setLocation(final Point p) {
        this.pLocation = p;
        if (SwingWTUtils.isMacOSX() && p.y == 0) {
            p.y = SwingWTUtils.MACOSX_MENUBAR_BOTTOM;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)Window.this.peer)) {
                    Window.this.peer.setBounds(p.x, p.y, Window.this.peer.getSize().x, Window.this.peer.getSize().y);
                }
            }
        });
    }

    public Point getLocationOnScreen() {
        return this.getLocation();
    }

    public Component add(Component c) {
        this.rootPane.getContentPane().add(c);
        return c;
    }

    public void add(Component c, Object layoutModifier) {
        this.rootPane.getContentPane().add(c, layoutModifier);
    }

    public void remove(Component c) {
        this.rootPane.getContentPane().remove(c);
    }

    public LayoutManager getLayout() {
        return this.rootPane.getContentPane().getLayout();
    }

    public void addMouseListener(MouseListener l) {
        this.rootPane.getContentPane().addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.rootPane.getContentPane().removeMouseListener(l);
    }

    public void setLayout(LayoutManager l) {
        this.rootPane.getContentPane().setLayout(l);
    }

    public void setLayout(LayoutManager2 l) {
        this.rootPane.getContentPane().setLayout(l);
    }

    public void pack() {
        Window me = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)Window.this.peer)) {
                    Dimension d = Window.this.rootPane.getContentPane().getPreferredSize();
                    d.width += 8;
                    d.height += 34;
                    Window.this.peer.setSize(d.width, d.height);
                    Window.this.pSize = d;
                } else {
                    Window.this.delayPack = true;
                }
            }
        });
    }

    public void setLocation(int x, int y) {
        if (SwingWTUtils.isMacOSX() && y == 0) {
            y = SwingWTUtils.MACOSX_MENUBAR_BOTTOM;
        }
        this.pLocation = new Point(x, y);
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.peer.setLocation(Window.this.pLocation.x, Window.this.pLocation.y);
                }
            });
        }
    }

    public void setLocationRelativeTo(Component c) {
        Dimension paneSize = this.getSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    public Dimension getSize() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.retval = (Object)new Dimension(Window.this.peer.getBounds().width, Window.this.peer.getBounds().height);
                }
            });
        } else {
            this.retval = this.pSize;
        }
        if (this.retval == null) {
            this.retval = new Dimension(0, 0);
        }
        return (Dimension)this.retval;
    }

    public Rectangle getBounds() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.retval = (Object)new Rectangle(Window.this.peer.getLocation().x, Window.this.peer.getLocation().y, Window.this.peer.getSize().x, Window.this.peer.getSize().y);
                }
            });
        } else {
            this.retval = this.pLocation == null ? new Rectangle(0, 0, 0, 0) : new Rectangle(this.pLocation.x, this.pLocation.y, this.pSize.width, this.pSize.height);
        }
        return (Rectangle)this.retval;
    }

    public void setSize(int width, int height) {
        this.setSize(new Dimension(width, height));
    }

    public void setSize(Dimension d) {
        this.pSize = d;
        this.delayPack = false;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.peer.setSize(Window.this.pSize.width, Window.this.pSize.height);
                }
            });
        }
    }

    public void setBounds(int x, int y, final int width, final int height) {
        if (SwingWTUtils.isMacOSX() && y == 0) {
            y = SwingWTUtils.MACOSX_MENUBAR_BOTTOM;
        }
        this.pLocation = new Point(x, y);
        this.pSize = new Dimension(width, height);
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.peer.setLocation(Window.this.pLocation.x, Window.this.pLocation.y);
                    Window.this.peer.setSize(width, height);
                }
            });
        }
    }

    public void setBounds(final Rectangle r) {
        if (SwingWTUtils.isMacOSX() && r.y == 0) {
            r.y = SwingWTUtils.MACOSX_MENUBAR_BOTTOM;
        }
        this.pLocation = new Point(r.x, r.y);
        this.pSize = new Dimension(r.width, r.height);
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.peer.setLocation(r.x, r.y);
                    Window.this.peer.setSize(r.width, r.height);
                }
            });
        }
    }

    public boolean isActive() {
        final boolean[] ret = new boolean[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                ret[0] = SwingWTUtils.getDisplay().getActiveShell() == Window.this.peer;
            }
        });
        return ret[0];
    }

    public void show() {
        this.invalidate();
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void addWindowListener(WindowListener l) {
        this.windowListeners.add(l);
    }

    public void removeWindowListener(WindowListener l) {
        this.windowListeners.remove(l);
    }

    public void setCursor(final Cursor c) {
        this.pCursor = c;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                try {
                    if (SwingWTUtils.isSWTControlAvailable((Control)Window.this.peer)) {
                        if (c != null) {
                            Window.this.peer.setCursor(c.getSWTCursor());
                        } else {
                            Window.this.peer.setCursor(null);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setVisible(final boolean b) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (b) {
                    if (!SwingWTUtils.isSWTControlAvailable((Control)Window.this.peer)) {
                        Window.this.create();
                    }
                    if (!Window.this.hasBeenOpened) {
                        Window.this.peer.open();
                        Window.this.processWindowEvent(200);
                        Window.this.repaintFix();
                        Window.this.hasBeenOpened = true;
                    } else {
                        Window.this.peer.setVisible(true);
                    }
                } else if (Window.this.hasBeenOpened) {
                    Window.this.peer.setVisible(false);
                }
            }
        });
    }

    public void dispose() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (Window.this.isClosed) {
                    return;
                }
                if (SwingWTUtils.isSWTControlAvailable((Control)Window.this.peer)) {
                    Window.this.peer.dispose();
                }
            }
        });
        super.dispose();
    }

    public String getTitle() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.retval = (Object)Window.this.peer.getText();
                }
            });
        } else {
            this.retval = this.title;
        }
        return this.retval.toString();
    }

    public void setTitle(String s) {
        this.title = s;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.peer.setText(Window.this.title);
                }
            });
        }
    }

    public Image getIconImage() {
        final Image[] ret = new Image[1];
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    ret[0] = new Image();
                    ret[0].image = Window.this.peer.getImage();
                }
            });
        } else {
            ret[0] = this.iconImage;
        }
        return ret[0];
    }

    public void setIconImage(final Image icon) {
        this.iconImage = icon;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Window.this.peer.setImage(icon.image);
                }
            });
        }
    }

    public void setJMenuBar(JMenuBar menu) {
        this.pMenu = menu;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            this.rootPane.setJMenuBar(menu);
        }
    }

    public JMenuBar getJMenuBar() {
        this.retval = SwingWTUtils.isSWTControlAvailable((Control)this.peer) ? this.rootPane.getJMenuBar() : this.pMenu;
        return (JMenuBar)this.retval;
    }

    public void setMenuBar(MenuBar menu) {
        this.pMenuBar = menu;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            this.rootPane.setMenuBar(menu);
        }
    }

    public MenuBar getMenuBar() {
        this.retval = SwingWTUtils.isSWTControlAvailable((Control)this.peer) ? this.rootPane.getMenuBar() : this.pMenuBar;
        return (MenuBar)this.retval;
    }

    public void setDefaultButton(JButton button) {
        this.rootPane.setDefaultButton(button);
    }

    public JButton getDefaultButton() {
        return this.rootPane.getDefaultButton();
    }

    public void registerWindowEvents() {
        this.peer.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent e) {
                Window.this.processWindowEvent(205);
            }

            public void shellClosed(ShellEvent e) {
                Window.this.isClosed = true;
                Window.this.processWindowEvent(201);
                Window.this.processWindowEvent(202);
                SwingWTUtils.decrementWindowReferences();
            }

            public void shellDeactivated(ShellEvent e) {
                Window.this.processWindowEvent(206);
            }

            public void shellDeiconified(ShellEvent e) {
                Window.this.isIcon = false;
                Window.this.processWindowEvent(204);
            }

            public void shellIconified(ShellEvent e) {
                Window.this.isIcon = true;
                Window.this.processWindowEvent(203);
            }
        });
    }

    protected void processWindowEvent(int id) {
        WindowEvent we = new WindowEvent(this, id);
        Iterator i = this.windowListeners.iterator();
        while (i.hasNext()) {
            WindowListener l = (WindowListener)i.next();
            switch (id) {
                case 205: {
                    l.windowActivated(we);
                    break;
                }
                case 202: {
                    l.windowClosed(we);
                    break;
                }
                case 201: {
                    l.windowClosing(we);
                    break;
                }
                case 206: {
                    l.windowDeactivated(we);
                    break;
                }
                case 204: {
                    l.windowDeiconified(we);
                    break;
                }
                case 203: {
                    l.windowIconified(we);
                    break;
                }
                case 200: {
                    l.windowOpened(we);
                }
            }
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        WindowEvent we = e;
        Iterator i = this.windowListeners.iterator();
        while (i.hasNext()) {
            WindowListener l = (WindowListener)i.next();
            switch (e.getID()) {
                case 205: {
                    l.windowActivated(we);
                    break;
                }
                case 202: {
                    l.windowClosed(we);
                    break;
                }
                case 201: {
                    l.windowClosing(we);
                    break;
                }
                case 206: {
                    l.windowDeactivated(we);
                    break;
                }
                case 204: {
                    l.windowDeiconified(we);
                    break;
                }
                case 203: {
                    l.windowIconified(we);
                    break;
                }
                case 200: {
                    l.windowOpened(we);
                }
            }
        }
    }

    protected void dispatchEvents() {
        while (!this.peer.isDisposed()) {
            try {
                if (!this.display.readAndDispatch()) {
                    this.display.sleep();
                }
                if (!SwingWTUtils.isRetardDispatchThread()) continue;
                try {
                    Thread.sleep(SwingWTUtils.getRetardationInterval());
                }
                catch (InterruptedException e) {
                }
            }
            catch (Error e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void toFront() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)Window.this.peer)) {
                    Window.this.peer.forceActive();
                }
            }
        });
    }

    public void toBack() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)Window.this.peer)) {
                    Shell[] s = SwingWTUtils.getDisplay().getShells();
                    for (int i = 0; i < s.length; ++i) {
                        if (s[i].equals(Window.this.peer)) continue;
                        s[i].forceActive();
                    }
                }
            }
        });
    }

    protected void repaintFix() {
        SwingUtilities.invokeIn(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)Window.this.peer)) {
                    Window.this.peer.layout(true);
                }
                SwingUtilities.invokeIn(new Runnable(){

                    public void run() {
                        if (SwingWTUtils.isSWTControlAvailable((Control)(this).Window.this.peer) && (this).Window.this.peer.getSize().x < 40 && (this).Window.this.peer.getSize().y < 40) {
                            (this).Window.this.peer.setSize((this).Window.this.pSize.width, (this).Window.this.pSize.height);
                        }
                    }
                }, 75);
            }
        }, 10);
    }

    public Control getSWTPeer() {
        return this.peer;
    }

    public void setSwingWTParent(Composite parent) throws Exception {
        throw new Exception("Window can't have parent.");
    }

    public final void setAlwaysOnTop(boolean alwaysOnTop) throws SecurityException {
        this.toFront();
    }

    public Component getFocusOwner() {
        return SwingWTUtils.getFocusedComponent();
    }

    public Window getOwner() {
        Window win = null;
        try {
            if (this.parent != null && this.parent instanceof Window) {
                win = (Window)this.parent;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return win;
    }
}

