/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import swingwt.awt.Dimension;
import swingwt.awt.EventQueue;
import swingwt.awt.Font;
import swingwt.awt.FontMetrics;
import swingwt.awt.Frame;
import swingwt.awt.GraphicsConfiguration;
import swingwt.awt.HeadlessException;
import swingwt.awt.Image;
import swingwt.awt.Insets;
import swingwt.awt.PrintJob;
import swingwt.awt.SWTImageConsumer;
import swingwt.awt.SwingWTToolkit;
import swingwt.awt.datatransfer.Clipboard;
import swingwt.awt.event.AWTEventListener;
import swingwt.awt.image.ImageProducer;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public abstract class Toolkit {
    private static Toolkit toolkit = null;
    private static Object retval;
    private static Hashtable desktopProperties;
    private int isMac = 0;

    protected Toolkit() {
    }

    public static synchronized Toolkit getDefaultToolkit() {
        if (toolkit == null) {
            toolkit = Toolkit.createToolkit();
        }
        return toolkit;
    }

    public static synchronized Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    private static Toolkit createToolkit() {
        return new SwingWTToolkit();
    }

    public Image getImage(String filename) {
        return new ImageIcon(filename).getImage();
    }

    public Image getImage(URL url) {
        return new ImageIcon(url).getImage();
    }

    public int getScreenResolution() {
        return SwingWTUtils.getDisplay().getDepth();
    }

    public Insets getScreenInsets(GraphicsConfiguration gc) throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getScreenInsets(gc);
        }
        return new Insets(0, 0, 0, 0);
    }

    public FontMetrics getFontMetrics(Font f) {
        return new FontMetrics(f);
    }

    private boolean isMac() {
        if (this.isMac == 0) {
            String vers = System.getProperty("os.name").toLowerCase();
            this.isMac = vers.indexOf("mac") != -1 ? 1 : -1;
        }
        return this.isMac > 0;
    }

    public int getMenuShortcutKeyMask() throws HeadlessException {
        if (this.isMac()) {
            return 4;
        }
        return 2;
    }

    public Dimension getScreenSize() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                retval = new Dimension(SwingWTUtils.getDisplay().getBounds().width, SwingWTUtils.getDisplay().getBounds().height);
            }
        });
        return (Dimension)retval;
    }

    public Image createImage(ImageProducer producer) {
        SWTImageConsumer tki = new SWTImageConsumer();
        producer.startProduction(tki);
        ImageData imageData = tki.getImageData();
        Image image = new Image();
        image.image = new org.eclipse.swt.graphics.Image((Device)SwingWTUtils.getDisplay(), imageData);
        return image;
    }

    public Image createImage(byte[] imagedata) {
        return new ImageIcon(imagedata).getImage();
    }

    public Image createImage(byte[] imagedata, int imageoffset, int imagelength) {
        byte[] im2 = new byte[imagelength];
        for (int i = imageoffset; i < imagelength; ++i) {
            im2[i - imageoffset] = imagedata[i];
        }
        return new ImageIcon(im2).getImage();
    }

    public Image createImage(String filename) {
        return this.getImage(filename);
    }

    public Image createImage(URL url) {
        return this.getImage(url);
    }

    public Clipboard getSystemClipboard() {
        return new Clipboard();
    }

    public void beep() {
    }

    public final Object getDesktopProperty(String propertyName) {
        return desktopProperties.get(propertyName);
    }

    protected final void setDesktopProperty(String propertyName, Object value) {
        desktopProperties.put(propertyName, value);
    }

    public static String getProperty(String key, String defaultValue) {
        return defaultValue;
    }

    public EventQueue getSystemEventQueue() {
        return EventQueue.singleton;
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
    }

    public Dimension getBestCursorSize(int preferredWidth, int preferredHeight) throws HeadlessException {
        return new Dimension(0, 0);
    }

    public boolean getLockingKeyState(int keyCode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public PrintJob getPrintJob(Frame frame, String jobtitle, Properties props) {
        return null;
    }

    public void addAWTEventListener(AWTEventListener listener, long eventMask) {
    }

    public void removeAWTEventListener(AWTEventListener listener) {
    }

    public abstract void sync();

    static {
        desktopProperties = new Hashtable();
    }
}

