/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Arrays;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import swingwt.awt.Font;
import swingwt.awt.Graphics;
import swingwt.awt.Rectangle;
import swingwt.awt.font.LineMetrics;
import swingwt.awt.geom.Rectangle2D;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class FontMetrics {
    protected Font font;
    protected GC gc = null;
    protected Image im = null;
    int[] widths;

    protected FontMetrics(Font font) {
        this.font = font;
        this.widths = new int[256];
        Arrays.fill(this.widths, -1);
    }

    private void checkGC() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (FontMetrics.this.gc != null) {
                    return;
                }
                FontMetrics.this.im = new Image((Device)SwingWTUtils.getDisplay(), 100, 100);
                FontMetrics.this.gc = new GC((Drawable)FontMetrics.this.im);
            }
        });
    }

    public Font getFont() {
        return this.font;
    }

    public int getLeading() {
        return 0;
    }

    public int getAscent() {
        final int[] ret = new int[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                FontMetrics.this.checkGC();
                ret[0] = FontMetrics.this.gc.stringExtent((String)"I").y;
            }
        });
        return ret[0];
    }

    public int getDescent() {
        return 0;
    }

    public int getHeight() {
        return this.getLeading() + this.getAscent() + this.getDescent();
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int charWidth(int ch) {
        return this.charWidth((char)ch);
    }

    public int charWidth(char ch) {
        if (ch < '\u0100') {
            return this.getWidths()[ch];
        }
        char[] data = new char[]{ch};
        return this.charsWidth(data, 0, 1);
    }

    public int stringWidth(final String str) {
        final int[] ret = new int[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                FontMetrics.this.checkGC();
                ret[0] = FontMetrics.this.gc.stringExtent((String)str).x;
            }
        });
        return ret[0];
    }

    public int charsWidth(char[] data, int off, int len) {
        return this.stringWidth(new String(data, off, len));
    }

    public int bytesWidth(byte[] data, int off, int len) {
        return this.stringWidth(new String(data).substring(off, off + len));
    }

    public int[] getWidths() {
        for (char ch = '\u0000'; ch < '\u0100'; ch = (char)((char)(ch + 1))) {
            if (this.widths[ch] != -1) continue;
            this.widths[ch] = this.stringWidth("" + ch);
        }
        return this.widths;
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    public LineMetrics getLineMetrics(String str, Graphics context) {
        return new LineMetrics(str.length(), this.getHeight());
    }

    public LineMetrics getLineMetrics(String str, int beginIndex, int limit, Graphics context) {
        return new LineMetrics(limit - beginIndex, this.getHeight());
    }

    public LineMetrics getLineMetrics(char[] chars, int beginIndex, int limit, Graphics context) {
        return this.getLineMetrics(new String(chars), beginIndex, limit, context);
    }

    public Rectangle2D getStringBounds(final String str, Graphics context) {
        final Rectangle[] ret = new Rectangle[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                FontMetrics.this.checkGC();
                Point p = FontMetrics.this.gc.stringExtent(str);
                ret[0] = new Rectangle(p.x, p.y);
            }
        });
        return ret[0];
    }

    public Rectangle2D getStringBounds(String str, int beginIndex, int limit, Graphics context) {
        return this.getStringBounds(str, context);
    }

    public Rectangle2D getStringBounds(char[] chars, int beginIndex, int limit, Graphics context) {
        return this.getStringBounds(new String(chars), context);
    }

    public Rectangle2D getMaxCharBounds(Graphics context) {
        return new Rectangle(0, 0);
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + "ascent=" + this.getAscent() + ", descent=" + this.getDescent() + ", height=" + this.getHeight() + "]";
    }
}

