/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.text.CharacterIterator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import swingwt.awt.FontMetrics;
import swingwt.awt.Toolkit;
import swingwt.awt.font.FontRenderContext;
import swingwt.awt.font.GlyphVector;
import swingwt.awt.font.LineMetrics;
import swingwt.awt.font.SWTGlyphVector;
import swingwt.awt.font.TextAttribute;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class Font {
    private org.eclipse.swt.graphics.Font peer = null;
    protected boolean disposeOnFinalize = true;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    protected String name = "Dialog";
    protected int style = 0;
    protected int size = 12;
    private static Font stubFont = null;

    public Font(String name, int style, int size) {
        this.name = name;
        this.style = style;
        this.size = size;
        this.createPeer();
    }

    public Font(String name, int style, int size, boolean f) {
        this.name = name;
        this.style = style;
        this.size = size;
        this.createPeer();
    }

    public Font(Map attributes) {
        this.setAttributes(attributes);
        this.createPeer();
    }

    public Font(org.eclipse.swt.graphics.Font swtfont) {
        this.peer = swtfont;
        this.populateFromSWTFontData(swtfont.getFontData()[0]);
    }

    public Font(FontData fd) {
        this.peer = new org.eclipse.swt.graphics.Font((Device)SwingWTUtils.getDisplay(), fd);
        this.populateFromSWTFontData(fd);
    }

    public static Font getFont(Map attributes) {
        return new Font(attributes);
    }

    public static Font getStubFont() {
        if (stubFont == null) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    stubFont = new Font(SwingWTUtils.getDisplay().getSystemFont());
                }
            });
        }
        return stubFont;
    }

    protected void createPeer() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                int swtStyle = 0;
                if ((Font.this.style & 1) > 0) {
                    swtStyle |= 1;
                }
                if ((Font.this.style & 2) > 0) {
                    swtStyle |= 2;
                }
                Font.this.peer = new org.eclipse.swt.graphics.Font((Device)SwingWTUtils.getDisplay(), Font.this.name, Font.this.size, swtStyle);
                Font.this.disposeOnFinalize = true;
            }
        });
    }

    protected void populateFromSWTFontData(FontData fd) {
        this.disposeOnFinalize = false;
        this.name = fd.getName();
        this.style = 0;
        if ((fd.getStyle() & 1) > 0) {
            this.style |= 1;
        }
        if ((fd.getStyle() & 2) > 0) {
            this.style |= 2;
        }
        this.size = fd.getHeight();
    }

    public void setAttributes(Map attributes) {
        if (attributes != null) {
            Object value = attributes.get(TextAttribute.FAMILY);
            if (value == null) {
                value = attributes.get("family");
            }
            if (value != null) {
                this.name = value.toString();
            }
            if ((value = attributes.get(TextAttribute.SIZE)) == null) {
                value = attributes.get("size");
            }
            if (value != null) {
                this.size = (int)Float.parseFloat(value.toString());
            }
            if ((value = attributes.get("style")) != null) {
                this.style = Integer.parseInt(value.toString());
            }
        }
    }

    public Map getAttributes() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("family", this.name);
        ht.put("size", new Integer(this.size));
        ht.put("style", new Integer(this.style));
        return ht;
    }

    public String getName() {
        return this.name;
    }

    public String getFontName() {
        return this.name;
    }

    public String getFamily() {
        return this.name;
    }

    public String getFontName(Locale l) {
        return this.getFontName();
    }

    public String getFamily(Locale l) {
        return this.getFamily();
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.size;
    }

    public boolean isBold() {
        return (this.style & 1) > 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isItalic() {
        return (this.style & 2) > 0;
    }

    public Font deriveFont(float newSize) {
        return new Font(this.name, this.style, (int)newSize);
    }

    public Font deriveFont(int newStyle) {
        return new Font(this.name, newStyle, this.size);
    }

    public Font deriveFont(int newStyle, float newSize) {
        return new Font(this.name, newStyle, (int)newSize);
    }

    public GlyphVector createGlyphVector(FontRenderContext frc, CharacterIterator ci) {
        return new SWTGlyphVector(this);
    }

    public LineMetrics getLineMetrics(String str, FontRenderContext frc) {
        FontMetrics fm = Toolkit.getToolkit().getFontMetrics(this);
        return fm.getLineMetrics(str, null);
    }

    public LineMetrics getLineMetrics(String str, int beginIndex, int limit, FontRenderContext frc) {
        FontMetrics fm = Toolkit.getToolkit().getFontMetrics(this);
        return fm.getLineMetrics(str, beginIndex, limit, null);
    }

    public LineMetrics getLineMetrics(CharacterIterator ci, int beginIndex, int limit, FontRenderContext frc) {
        FontMetrics fm = Toolkit.getToolkit().getFontMetrics(this);
        return fm.getLineMetrics(ci.toString(), beginIndex, limit, null);
    }

    public LineMetrics getLineMetrics(char[] chars, int beginIndex, int limit, FontRenderContext frc) {
        FontMetrics fm = Toolkit.getToolkit().getFontMetrics(this);
        return fm.getLineMetrics(chars, beginIndex, limit, null);
    }

    public int canDisplayUpTo(String str) {
        return -1;
    }

    public int canDisplayUpTo(char[] text, int start, int limit) {
        return -1;
    }

    public int canDisplayUpTo(CharacterIterator iter, int start, int limit) {
        return -1;
    }

    public org.eclipse.swt.graphics.Font getSWTFont() {
        return this.peer;
    }

    public void dispose() {
        this.peer.dispose();
    }

    protected void finalize() throws Throwable {
        if (this.disposeOnFinalize) {
            this.dispose();
        }
    }
}

