/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import swingwt.awt.Paint;
import swingwt.awt.PaintContext;
import swingwt.awt.Rectangle;
import swingwt.awt.RenderingHints;
import swingwt.awt.geom.AffineTransform;
import swingwt.awt.geom.Rectangle2D;
import swingwt.awt.image.ColorModel;
import swingwtx.swing.SwingWTUtils;

public class Color
implements Paint {
    protected org.eclipse.swt.graphics.Color swtColour = null;
    public static final Color black = new Color(0, 0, 0);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color blue = new Color(0, 0, 255);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color CYAN = new Color(0, 255, 255);
    public static final Color darkGray = new Color(64, 64, 64);
    public static final Color DARK_GRAY = new Color(64, 64, 64);
    public static final Color gray = new Color(128, 128, 128);
    public static final Color GRAY = new Color(128, 128, 128);
    public static final Color green = new Color(0, 255, 0);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color lightGray = new Color(192, 192, 192);
    public static final Color LIGHT_GRAY = new Color(192, 192, 192);
    public static final Color magenta = new Color(255, 0, 255);
    public static final Color MAGENTA = new Color(255, 0, 255);
    public static final Color orange = new Color(255, 200, 0);
    public static final Color ORANGE = new Color(255, 200, 0);
    public static final Color pink = new Color(255, 175, 175);
    public static final Color PINK = new Color(255, 175, 175);
    public static final Color red = new Color(255, 0, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color white = new Color(255, 255, 255);
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color YELLOW = new Color(255, 255, 0);
    protected static final double colourScale = 0.7;

    public Color(org.eclipse.swt.graphics.Color swtColour) {
        this.swtColour = swtColour;
    }

    public Color(float r, float g, float b) {
        this((int)r, (int)g, (int)b, 0);
    }

    public Color(float r, float g, float b, float a) {
        this((int)r, (int)g, (int)b, (int)a);
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 0);
    }

    public Color(int r, int g, int b, int a) {
        this.swtColour = new org.eclipse.swt.graphics.Color((Device)SwingWTUtils.getDisplay(), new RGB(r, g, b));
    }

    public Color(int rgb) {
        int[] comps = this.breakRGBComponents(rgb);
        this.swtColour = new org.eclipse.swt.graphics.Color((Device)SwingWTUtils.getDisplay(), comps[0], comps[1], comps[2]);
    }

    public org.eclipse.swt.graphics.Color getSWTColor() {
        return this.swtColour;
    }

    public void dispose() {
        this.swtColour.dispose();
    }

    public int getRed() {
        return this.swtColour.getRed();
    }

    public int getGreen() {
        return this.swtColour.getGreen();
    }

    public int getBlue() {
        return this.swtColour.getBlue();
    }

    public int getAlpha() {
        return 0;
    }

    public int getRGB() {
        return 0xFF000000 | (this.getRed() & 0xFF) << 16 | (this.getGreen() & 0xFF) << 8 | (this.getBlue() & 0xFF) << 0;
    }

    protected int[] breakRGBComponents(int value) {
        int[] cols = new int[]{255, 255, 255};
        return cols;
    }

    public Color brighter() {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int i = 3;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.7), 255), Math.min((int)((double)g / 0.7), 255), Math.min((int)((double)b / 0.7), 255));
    }

    public Color darker() {
        return new Color(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0));
    }

    public String toString() {
        if (this.swtColour == null) {
            return "null";
        }
        return "Color: " + this.swtColour.getRed() + ", " + this.swtColour.getGreen() + ", " + this.swtColour.getBlue();
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return null;
    }

    public int getTransparency() {
        return 1;
    }

    public float[] getRGBColorComponents(float[] compArray) {
        float[] retval = compArray == null ? new float[3] : compArray;
        retval[0] = (float)this.getRed() / 255.0f;
        retval[1] = (float)this.getGreen() / 255.0f;
        retval[2] = (float)this.getBlue() / 255.0f;
        return retval;
    }

    public static Color decode(String st) throws NumberFormatException {
        int ii = Integer.decode(st);
        return new Color(ii >> 16 & 0xFF, ii >> 8 & 0xFF, ii & 0xFF);
    }

    public static Color getColor(String cl) {
        return Color.getColor(cl, null);
    }

    public static Color getColor(String cl, Color c) {
        Integer i = Integer.getInteger(cl);
        if (i == null) {
            return c;
        }
        int ii = Integer.decode(cl);
        return new Color(ii >> 16 & 0xFF, ii >> 8 & 0xFF, ii & 0xFF);
    }
}

