/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    int imageIndent;
    int background = -1;
    int foreground = -1;
    int font = -1;
    int[] cellBackground;
    int[] cellForeground;
    int[] cellFont;

    public TableItem(Table table, int n) {
        this(table, n, TableItem.checkNull(table).getItemCount(), true);
    }

    public TableItem(Table table, int n, int n2) {
        this(table, n, n2, true);
    }

    TableItem(Table table, int n, int n2, boolean bl) {
        super(table, n);
        this.parent = table;
        if (bl) {
            table.createItem(this, n2);
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.imageIndent = 0;
        this.grayed = false;
        this.checked = false;
        this.font = -1;
        this.foreground = -1;
        this.background = -1;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background == -1) {
            return this.parent.getBackground();
        }
        return Color.win32_new(this.display, this.background);
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getBackground();
        }
        int n3 = this.cellBackground != null ? this.cellBackground[n] : -1;
        return n3 == -1 ? this.getBackground() : Color.win32_new(this.display, n3);
    }

    public Rectangle getBounds() {
        int n;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = this.getBounds(n, 0, true, false, false);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public Rectangle getBounds(int n) {
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = this.getBounds(n2, n, true, true, true);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    RECT getBounds(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return this.getBounds(n, n2, bl, bl2, bl3, false, 0);
    }

    RECT getBounds(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3) {
        int n4;
        if (!bl && !bl2) {
            return new RECT();
        }
        int n5 = this.parent.getColumnCount();
        if (n2 < 0 || n2 >= Math.max(1, n5)) {
            return new RECT();
        }
        if (this.parent.fixScrollWidth) {
            this.parent.setScrollWidth(null, true);
        }
        RECT rECT = new RECT();
        int n6 = this.parent.handle;
        int n7 = OS.SendMessage(n6, 4151, 0, 0);
        if (n2 == 0 && (n7 & 0x20) == 0) {
            int n8;
            if (this.parent.explorerTheme) {
                rECT.left = 1;
                this.parent.ignoreCustomDraw = true;
                n8 = OS.SendMessage(n6, 4110, n, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n8 == 0) {
                    return new RECT();
                }
                if (bl) {
                    int n9;
                    int n10 = 0;
                    int n11 = n9 = this.cellFont != null ? this.cellFont[n2] : -1;
                    if (n9 == -1) {
                        n9 = this.font;
                    }
                    if (n9 == -1 && n3 == 0) {
                        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, true);
                        n10 = OS.SendMessage(n6, OS.LVM_GETSTRINGWIDTH, 0, tCHAR);
                    } else {
                        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, false);
                        int n12 = n3 != 0 ? n3 : OS.GetDC(n6);
                        int n13 = -1;
                        if (n3 == 0) {
                            if (n9 == -1) {
                                n9 = OS.SendMessage(n6, 49, 0, 0);
                            }
                            n13 = OS.SelectObject(n12, n9);
                        }
                        RECT rECT2 = new RECT();
                        int n14 = 3104;
                        OS.DrawText(n12, tCHAR, tCHAR.length(), rECT2, n14);
                        n10 = rECT2.right - rECT2.left;
                        if (n3 == 0) {
                            if (n13 != -1) {
                                OS.SelectObject(n12, n13);
                            }
                            OS.ReleaseDC(n6, n12);
                        }
                    }
                    if (!bl2) {
                        rECT.left = rECT.right;
                    }
                    rECT.right += n10 + 8;
                }
            } else if (bl) {
                rECT.left = 3;
                this.parent.ignoreCustomDraw = true;
                n8 = OS.SendMessage(n6, 4110, n, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n8 == 0) {
                    return new RECT();
                }
                if (!bl2) {
                    RECT rECT3 = new RECT();
                    rECT3.left = 1;
                    this.parent.ignoreCustomDraw = true;
                    n8 = OS.SendMessage(n6, 4110, n, rECT3);
                    this.parent.ignoreCustomDraw = false;
                    if (n8 != 0) {
                        rECT.left = rECT3.right;
                    }
                }
            } else {
                rECT.left = 1;
                this.parent.ignoreCustomDraw = true;
                n8 = OS.SendMessage(n6, 4110, n, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n8 == 0) {
                    return new RECT();
                }
            }
            if (bl3 || bl4) {
                RECT rECT4 = new RECT();
                int n15 = OS.SendMessage(n6, 4127, 0, 0);
                OS.SendMessage(n15, 4615, 0, rECT4);
                OS.MapWindowPoints(n15, n6, rECT4, 2);
                if (bl && bl3) {
                    rECT.right = rECT4.right;
                }
                if (bl2 && bl4) {
                    rECT.left = rECT4.left;
                }
            }
        } else {
            boolean bl5 = n2 == 0 && this.image != null || this.images != null && this.images[n2] != null;
            rECT.top = n2;
            if (bl3 || bl4 || n3 == 0) {
                RECT rECT5;
                rECT.left = bl ? 2 : 1;
                this.parent.ignoreCustomDraw = true;
                int n16 = OS.SendMessage(n6, 4152, n, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n16 == 0) {
                    return new RECT();
                }
                if (n2 == 0 && bl && bl2) {
                    rECT5 = new RECT();
                    rECT5.left = 1;
                    this.parent.ignoreCustomDraw = true;
                    n16 = OS.SendMessage(n6, 4152, n, rECT5);
                    this.parent.ignoreCustomDraw = false;
                    if (n16 != 0) {
                        rECT.left = rECT5.left;
                    }
                }
                if (bl5) {
                    if (n2 != 0 && bl && !bl2) {
                        rECT5 = new RECT();
                        rECT5.top = n2;
                        rECT5.left = 1;
                        if (OS.SendMessage(n6, 4152, n, rECT5) != 0) {
                            rECT.left = rECT5.right + 2;
                        }
                    }
                } else if (bl2 && !bl) {
                    rECT.right = rECT.left;
                }
                if (n2 == 0 && bl4) {
                    rECT5 = new RECT();
                    int n17 = OS.SendMessage(n6, 4127, 0, 0);
                    OS.SendMessage(n17, 4615, 0, rECT5);
                    OS.MapWindowPoints(n17, n6, rECT5, 2);
                    rECT.left = rECT5.left;
                }
            } else {
                rECT.left = 1;
                this.parent.ignoreCustomDraw = true;
                int n18 = OS.SendMessage(n6, 4152, n, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n18 == 0) {
                    return new RECT();
                }
                if (!bl5) {
                    rECT.right = rECT.left;
                }
                if (bl) {
                    String string;
                    String string2 = n2 == 0 ? this.text : (string = this.strings != null ? this.strings[n2] : null);
                    if (string != null) {
                        RECT rECT6 = new RECT();
                        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), string, false);
                        int n19 = 3104;
                        OS.DrawText(n3, tCHAR, tCHAR.length(), rECT6, n19);
                        rECT.right += rECT6.right - rECT6.left + 12 + 1;
                    }
                }
            }
        }
        int n20 = n4 = this.parent.getLinesVisible() ? 1 : 0;
        if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
            rECT.top -= n4;
        }
        if (n2 != 0) {
            rECT.left += n4;
        }
        rECT.right = Math.max(rECT.right, rECT.left);
        rECT.top += n4;
        rECT.bottom = Math.max(rECT.bottom - n4, rECT.top);
        return rECT;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font == -1 ? this.parent.getFont() : Font.win32_new(this.display, this.font);
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getFont();
        }
        int n3 = this.cellFont != null ? this.cellFont[n] : this.font;
        return n3 == -1 ? this.getFont() : Font.win32_new(this.display, n3);
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground == -1) {
            return this.parent.getForeground();
        }
        return Color.win32_new(this.display, this.foreground);
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getForeground();
        }
        int n3 = this.cellForeground != null ? this.cellForeground[n] : -1;
        return n3 == -1 ? this.getForeground() : Color.win32_new(this.display, n3);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getImage();
        }
        if (this.images != null && n >= 0 && n < this.images.length) {
            return this.images[n];
        }
        return null;
    }

    public Rectangle getImageBounds(int n) {
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = this.getBounds(n2, n, false, true, false);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.imageIndent;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getText();
        }
        if (this.strings != null && n >= 0 && n < this.strings.length) {
            String string = this.strings[n];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n) {
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = this.getBounds(n2, n, true, false, true);
        rECT.left += 2;
        if (n != 0) {
            rECT.left += 4;
        }
        rECT.left = Math.min(rECT.left, rECT.right);
        rECT.right -= 4;
        int n3 = Math.max(0, rECT.right - rECT.left);
        int n4 = Math.max(0, rECT.bottom - rECT.top);
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    void redraw() {
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int n = this.parent.handle;
        if (!OS.IsWindowVisible(n)) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        OS.SendMessage(n, 4117, n2, n2);
    }

    void redraw(int n, boolean bl, boolean bl2) {
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int n2 = this.parent.handle;
        if (!OS.IsWindowVisible(n2)) {
            return;
        }
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        RECT rECT = this.getBounds(n3, n, bl, bl2, true);
        OS.InvalidateRect(n2, rECT, true);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.setCustomDraw(true);
            n = color.handle;
        }
        if (this.background == n) {
            return;
        }
        this.background = n;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setBackground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = -1;
        if (color != null) {
            this.parent.setCustomDraw(true);
            n3 = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.cellBackground[n4] = -1;
                ++n4;
            }
        }
        if (this.cellBackground[n] == n3) {
            return;
        }
        this.cellBackground[n] = n3;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n, true, true);
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == bl) {
            return;
        }
        this.setChecked(bl, false);
    }

    void setChecked(boolean bl, boolean bl2) {
        this.checked = bl;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (bl2) {
            Event event = new Event();
            event.item = this;
            event.detail = 32;
            this.parent.postEvent(13, event);
        }
        this.redraw();
    }

    public void setFont(Font font) {
        int n;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = -1;
        if (font != null) {
            this.parent.setCustomDraw(true);
            n2 = font.handle;
        }
        if (this.font == n2) {
            return;
        }
        this.font = n2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if ((this.parent.style & 0x10000000) == 0 && this.cached && (n = this.parent.indexOf(this)) != -1) {
            int n3 = this.parent.handle;
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 1;
            lVITEM.iItem = n;
            lVITEM.pszText = -1;
            OS.SendMessage(n3, OS.LVM_SETITEM, 0, lVITEM);
            this.cached = false;
        }
        this.parent.setScrollWidth(this, false);
        this.redraw();
    }

    public void setFont(int n, Font font) {
        int n2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n3 - 1) {
            return;
        }
        int n4 = -1;
        if (font != null) {
            this.parent.setCustomDraw(true);
            n4 = font.handle;
        }
        if (this.cellFont == null) {
            this.cellFont = new int[n3];
            n2 = 0;
            while (n2 < n3) {
                this.cellFont[n2] = -1;
                ++n2;
            }
        }
        if (this.cellFont[n] == n4) {
            return;
        }
        this.cellFont[n] = n4;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n == 0) {
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (n2 = this.parent.indexOf(this)) != -1) {
                int n5 = this.parent.handle;
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 1;
                lVITEM.iItem = n2;
                lVITEM.pszText = -1;
                OS.SendMessage(n5, OS.LVM_SETITEM, 0, lVITEM);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(n, true, false);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.setCustomDraw(true);
            n = color.handle;
        }
        if (this.foreground == n) {
            return;
        }
        this.foreground = n;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setForeground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = -1;
        if (color != null) {
            this.parent.setCustomDraw(true);
            n3 = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.cellForeground[n4] = -1;
                ++n4;
            }
        }
        if (this.cellForeground[n] == n3) {
            return;
        }
        this.cellForeground[n] = n3;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n, true, false);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            this.setImage(n, imageArray[n]);
            ++n;
        }
    }

    public void setImage(int n, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        Image image2 = null;
        if (n == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            image2 = this.image;
            super.setImage(image);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.images == null && n != 0) {
            this.images = new Image[n2];
            this.images[0] = image;
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[n])) {
                return;
            }
            image2 = this.images[n];
            this.images[n] = image;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.parent.imageIndex(image, n);
        if (n == 0) {
            this.parent.setScrollWidth(this, false);
        }
        boolean bl = image == null && image2 != null || image != null && image2 == null;
        this.redraw(n, bl, true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.imageIndent == n) {
            return;
        }
        this.imageIndent = n;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        } else {
            int n2 = this.parent.indexOf(this);
            if (n2 != -1) {
                int n3 = this.parent.handle;
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 16;
                lVITEM.iItem = n2;
                lVITEM.iIndent = n;
                OS.SendMessage(n3, OS.LVM_SETITEM, 0, lVITEM);
            }
        }
        this.parent.setScrollWidth(this, false);
        this.redraw();
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.setText(n, string);
            }
            ++n;
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.strings == null && n != 0) {
            this.strings = new String[n2];
            this.strings[0] = this.text;
        }
        if (this.strings != null) {
            if (string.equals(this.strings[n])) {
                return;
            }
            this.strings[n] = string;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n == 0) {
            int n3;
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (n3 = this.parent.indexOf(this)) != -1) {
                int n4 = this.parent.handle;
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 1;
                lVITEM.iItem = n3;
                lVITEM.pszText = -1;
                OS.SendMessage(n4, OS.LVM_SETITEM, 0, lVITEM);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(n, true, false);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

