/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.text;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import swingwt.awt.Color;
import swingwt.awt.Font;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.DocumentEvent;
import swingwtx.swing.text.AbstractDocument;
import swingwtx.swing.text.AttributeSet;
import swingwtx.swing.text.BadLocationException;
import swingwtx.swing.text.Element;
import swingwtx.swing.text.Formatting;
import swingwtx.swing.text.GapContent;
import swingwtx.swing.text.Style;
import swingwtx.swing.text.StyleConstants;
import swingwtx.swing.text.StyledDocument;

public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    protected Hashtable styles = new Hashtable();
    protected Vector formattings = new Vector();
    protected Object retval = null;

    public DefaultStyledDocument() {
        this.content = new GapContent();
    }

    public Style addStyle(String nm, Style parent) {
        this.styles.put(nm, parent);
        return parent;
    }

    public Color getBackground(AttributeSet attr) {
        return (Color)attr.getAttribute(StyleConstants.ColorConstants.Background);
    }

    public Element getCharacterElement(int pos) {
        return null;
    }

    public Font getFont(final AttributeSet attr) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                String family = (String)attr.getAttribute(StyleConstants.FontConstants.Family);
                Integer size = (Integer)attr.getAttribute(StyleConstants.FontConstants.Size);
                int mods = 0;
                Boolean bold = (Boolean)attr.getAttribute(StyleConstants.FontConstants.Bold);
                Boolean italic = (Boolean)attr.getAttribute(StyleConstants.FontConstants.Italic);
                boolean b = false;
                boolean i = false;
                if (bold != null) {
                    b = bold;
                }
                if (italic != null) {
                    i = italic;
                }
                if (b) {
                    ++mods;
                }
                if (i) {
                    mods += 2;
                }
                org.eclipse.swt.graphics.Font f = SwingWTUtils.getDisplay().getSystemFont();
                FontData fd = f.getFontData()[0];
                if (family != null) {
                    fd.setName(family);
                }
                if (size != null) {
                    fd.setHeight(size.intValue());
                }
                fd.setStyle(mods);
                DefaultStyledDocument.this.retval = new Font(new org.eclipse.swt.graphics.Font((Device)SwingWTUtils.getDisplay(), fd));
            }
        });
        return (Font)this.retval;
    }

    public Color getForeground(AttributeSet attr) {
        return (Color)attr.getAttribute(StyleConstants.ColorConstants.Background);
    }

    public Style getLogicalStyle(int p) {
        return null;
    }

    public Style getStyle(String nm) {
        return (Style)this.styles.get(nm);
    }

    public void removeStyle(String nm) {
        this.styles.remove(nm);
    }

    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.addFormatting(offset, length, s);
        this.fireDocumentEvent(new AbstractDocument.DefaultDocumentEvent(offset, length, DocumentEvent.EventType.CHANGE));
    }

    public void setLogicalStyle(int pos, Style s) {
    }

    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.addFormatting(offset, length, s);
        this.fireDocumentEvent(new AbstractDocument.DefaultDocumentEvent(offset, length, DocumentEvent.EventType.CHANGE));
    }

    public Element getDefaultRootElement() {
        return null;
    }

    public Element getParagraphElement(int pos) {
        return null;
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.addFormatting(offset, str.length(), a);
        super.insertString(offset, str, a);
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
    }

    public void addFormatting(int offset, int length, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        if (offset < 0 || length < 0) {
            return;
        }
        Formatting f = new Formatting();
        f.offset = offset;
        f.length = length;
        f.attrs = attrs;
        this.formattings.add(f);
    }

    public Vector getFormattings() {
        return this.formattings;
    }
}

