/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import swingwt.awt.Color;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.event.KeyEvent;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.JTextComponent;

public class JTextArea
extends JTextComponent {
    protected boolean pWordWrap = false;
    private static final int DEFAULT_COLS = 8;
    private static final int DEFAULT_ROWS = 4;
    protected int pRows = 4;
    protected int pCols = 8;
    private String retVal = "";
    private int iRetVal = 0;

    public JTextArea() {
        this(null, "", 4, 8);
    }

    public JTextArea(String text) {
        this(null, text, 4, 8);
    }

    public JTextArea(int rows, int columns) {
        this(null, "", rows, columns);
    }

    public JTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public JTextArea(Document doc) {
        this(doc, "", 4, 8);
    }

    public JTextArea(Document doc, String text, int rows, int columns) {
        if (doc != null) {
            this.setDocument(doc);
        }
        if (text != null) {
            this.setText(text);
            this.view.updateModelFromComponent(this.getText());
        }
        this.pRows = rows;
        this.pCols = columns;
        this.calculateFromRowsCols();
    }

    public void setHorizontalScrollPane(boolean scroll) {
    }

    public void setVerticalScrollPane(boolean scroll) {
    }

    public boolean getHorizontalScrollPane() {
        return false;
    }

    public boolean getVerticalScrollPane() {
        return false;
    }

    public void setScrollPane(JScrollPane pane) {
    }

    public void setColumns(int columns) {
    }

    public void setRows(int rows) {
    }

    public int getColumns() {
        return 0;
    }

    public int getRows() {
        return 0;
    }

    protected void calculateFromRowsCols() {
        if (this.pRows != 0 && this.pCols != 0) {
            this.setPreferredSize(new Dimension(SwingWTUtils.getRenderStringWidth("W") * this.pCols, SwingWTUtils.getRenderStringHeight("W") * this.pRows + 6));
        } else if (this.pRows == 0 && this.pCols != 0) {
            this.setPreferredSize(new Dimension(SwingWTUtils.getRenderStringWidth("W") * this.pCols, SwingWTUtils.getRenderStringHeight("W") + 6));
        }
    }

    public void append(final String text) {
        this.pText = this.pText + text;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextArea.this.ppeer)) {
                    JTextArea.this.ppeer.append(text);
                }
            }
        });
    }

    public boolean getLineWrap() {
        return true;
    }

    public void setLineWrap(boolean b) {
    }

    public boolean getWrapStyleWord() {
        return this.pWordWrap;
    }

    public void setWrapStyleWord(boolean b) {
        this.pWordWrap = b;
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(SwingWTUtils.getRenderStringWidth("W") * this.pCols, 6 + this.pRows * SwingWTUtils.getRenderStringHeight("W"));
        this.setSize(size);
        return size;
    }

    protected Dimension computePreferredSize() {
        int smallest;
        Dimension size = new Dimension(SwingWTUtils.getRenderStringWidth(this.pText), SwingWTUtils.getRenderStringHeight(this.pText) + 4);
        int oneChar = SwingWTUtils.getRenderStringHeight("W") + 4;
        if (size.height <= oneChar) {
            size.height = oneChar * 4;
        }
        if (size.width < (smallest = SwingWTUtils.getRenderStringWidth("WWWWWWWWW"))) {
            size.width = smallest;
        }
        return size;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        int swtFlags = 2050;
        swtFlags |= this.pWordWrap ? 64 : 0;
        if (parent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            boolean useHorizontal = false;
            boolean useVertical = false;
            switch (scrollPane.getHorizontalScrollBarPolicy()) {
                case 3: {
                    useHorizontal = true;
                    break;
                }
                case 4: {
                    useHorizontal = true;
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    useHorizontal = false;
                }
            }
            switch (scrollPane.getVerticalScrollBarPolicy()) {
                case 0: {
                    useVertical = true;
                    break;
                }
                case 1: {
                    useVertical = true;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    useVertical = false;
                }
            }
            swtFlags |= useHorizontal ? 256 : 0;
            swtFlags |= useVertical ? 512 : 0;
        }
        this.ppeer = new Text(parent.getComposite(), swtFlags);
        this.ppeer.setText(this.pText);
        this.ppeer.setEditable(this.pEditable);
        this.ppeer.setTabs(0);
        this.peer = this.ppeer;
        this.ppeer.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(org.eclipse.swt.events.KeyEvent e) {
                if (e.keyCode == 97 && (e.stateMask & 0x40000) > 0) {
                    JTextArea.this.selectAll();
                    e.doit = false;
                }
                if (e.keyCode == 9 && (e.stateMask & 0x20000) > 0) {
                    JTextArea.this.ppeer.traverse(8);
                    e.doit = false;
                } else if (e.keyCode == 9) {
                    JTextArea.this.ppeer.traverse(16);
                    e.doit = false;
                }
            }
        });
        this.parent = parent;
        this.ppeer.addVerifyListener((VerifyListener)new JTextComponent.TextEventHandler(this));
        this.ppeer.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
                if (arg0.button == 2) {
                    JTextArea.this.processKeyEvent(new KeyEvent(JTextArea.this, 401));
                }
            }
        });
    }

    public void setDisabledTextColor(Color c) {
    }

    public void setTabSize(int size) {
    }

    public int getLineCount() {
        int count = 0;
        String text = this.getText();
        int l = text.length();
        if (l > 0) {
            for (int i = 0; i < l; ++i) {
                if (text.charAt(i) != '\n') continue;
                ++count;
            }
            if (text.charAt(l - 1) != '\n') {
                ++count;
            }
        }
        return count;
    }
}

