/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.InputEvent;
import swingwt.awt.event.KeyEvent;
import swingwtx.swing.AbstractButton;
import swingwtx.swing.Action;
import swingwtx.swing.Icon;
import swingwtx.swing.KeyStroke;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public abstract class JSWTMenuComponent
extends AbstractButton {
    protected MenuItem peer = null;
    protected Icon pImage = null;
    protected int pAccelerator = 0;
    protected String pNamedAccelerator = "";
    protected String pText = "";
    protected Action menuAction = null;
    private Object retval;
    protected static final int SELECTED = 0;
    protected static final int DESELECTED = 1;
    protected static final int CANCELED = 2;

    public void setIcon(final Icon icon) {
        this.pImage = icon;
        final JSWTMenuComponent pthis = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JSWTMenuComponent.this.peer)) {
                    JSWTMenuComponent.this.peer.setImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, icon));
                }
            }
        });
    }

    public int getMnemonic() {
        return this.pMnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.pMnemonic = mnemonic;
        this.showMnemonic();
    }

    public void setMnemonic(int mnemonic) {
        this.pMnemonic = (char)mnemonic;
        this.showMnemonic();
    }

    public String getLabel() {
        return this.getText();
    }

    public void setLabel(String label) {
        this.setText(label);
    }

    public String getText() {
        this.retval = "";
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JSWTMenuComponent.this.peer)) {
                    JSWTMenuComponent.this.retval = JSWTMenuComponent.this.peer.getText();
                } else {
                    JSWTMenuComponent.this.retval = JSWTMenuComponent.this.pText;
                }
            }
        });
        return this.retval.toString();
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.pText = text;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JSWTMenuComponent.this.peer)) {
                    JSWTMenuComponent.this.peer.setText(JSWTMenuComponent.this.pText);
                    JSWTMenuComponent.this.showMnemonic();
                    JSWTMenuComponent.this.showAccelerator();
                }
            }
        });
    }

    public String getToolTipText() {
        return "";
    }

    public void setToolTipText(String tip) {
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    protected void showMnemonic() {
        String mn;
        String text;
        if (this.pMnemonic == ' ') {
            return;
        }
        String string = text = this.peer == null ? this.pText : this.peer.getText();
        if (text.indexOf("&") != -1) {
            return;
        }
        String lower = text.toLowerCase();
        int pos = lower.indexOf(mn = new String(new char[]{this.pMnemonic}).toLowerCase());
        if (pos != -1) {
            text = text.substring(0, pos) + "&" + text.substring(pos, text.length());
            this.setText(text);
        }
    }

    private void showAccelerator() {
        if (this.pText.indexOf("\t") != -1) {
            return;
        }
        if (this.pNamedAccelerator == null) {
            return;
        }
        if (this.pNamedAccelerator.equals("")) {
            return;
        }
        this.pText = this.pText + "\t" + this.pNamedAccelerator;
        this.setText(this.pText);
    }

    public void setSwingWTParent(Menu parent, Shell shell) throws Exception {
        throw new Exception("Override in subclass");
    }

    public void setAccelerator(final KeyStroke k) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JSWTMenuComponent.this.peer)) {
                    JSWTMenuComponent.this.peer.setAccelerator(KeyEvent.translateAWTKey(k.getKeyCode()) + InputEvent.translateAWTModifiers(k.getModifiers()));
                } else {
                    JSWTMenuComponent.this.pAccelerator = KeyEvent.translateAWTKey(k.getKeyCode()) + InputEvent.translateAWTModifiers(k.getModifiers());
                }
            }
        });
        this.pNamedAccelerator = "";
        if ((k.getModifiers() & 2) > 0) {
            this.pNamedAccelerator = this.pNamedAccelerator + "Ctrl+";
        }
        if ((k.getModifiers() & 8) > 0) {
            this.pNamedAccelerator = this.pNamedAccelerator + "Alt+";
        }
        if ((k.getModifiers() & 0x40) > 0 || (k.getModifiers() & 1) > 0) {
            this.pNamedAccelerator = this.pNamedAccelerator + "Shift+";
        }
        this.pNamedAccelerator = k.getKeyCode() == 32 ? this.pNamedAccelerator + "Space" : (k.getKeyCode() == 112 ? this.pNamedAccelerator + "F1" : (k.getKeyCode() == 113 ? this.pNamedAccelerator + "F2" : (k.getKeyCode() == 114 ? this.pNamedAccelerator + "F3" : (k.getKeyCode() == 115 ? this.pNamedAccelerator + "F4" : (k.getKeyCode() == 116 ? this.pNamedAccelerator + "F5" : (k.getKeyCode() == 117 ? this.pNamedAccelerator + "F6" : (k.getKeyCode() == 118 ? this.pNamedAccelerator + "F7" : (k.getKeyCode() == 119 ? this.pNamedAccelerator + "F8" : (k.getKeyCode() == 120 ? this.pNamedAccelerator + "F9" : (k.getKeyCode() == 121 ? this.pNamedAccelerator + "F10" : (k.getKeyCode() == 122 ? this.pNamedAccelerator + "F11" : (k.getKeyCode() == 123 ? this.pNamedAccelerator + "F12" : this.pNamedAccelerator + new String(new char[]{(char)KeyEvent.translateAWTKey(k.getKeyCode())})))))))))))));
        this.showAccelerator();
    }

    public Widget getMenuPeer() {
        return this.peer;
    }

    public void setEnabled(final boolean b) {
        this.pEnabled = b;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JSWTMenuComponent.this.peer)) {
                    JSWTMenuComponent.this.peer.setEnabled(b);
                }
            }
        });
    }

    public boolean isEnabled() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JSWTMenuComponent.this.peer)) {
                    JSWTMenuComponent.this.retval = new Boolean(JSWTMenuComponent.this.peer.isEnabled());
                } else {
                    JSWTMenuComponent.this.retval = new Boolean(JSWTMenuComponent.this.pEnabled);
                }
            }
        });
        return (Boolean)this.retval;
    }

    public void dispose() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JSWTMenuComponent.this.peer)) {
                    JSWTMenuComponent.this.peer.dispose();
                    JSWTMenuComponent.this.peer = null;
                }
            }
        });
    }

    public void requestFocus() {
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public void processActionEvent(int id) {
        ActionEvent ae = new ActionEvent(this, id, this.getActionCommand());
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ActionListener al = (ActionListener)this.actionListeners.get(i);
            al.actionPerformed(ae);
        }
    }

    public void registerEvents() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JSWTMenuComponent.this.peer.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        JSWTMenuComponent.this.processActionEvent(0);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                JSWTMenuComponent.this.peer.addArmListener(new ArmListener(){

                    public void widgetArmed(ArmEvent e) {
                        JSWTMenuComponent.this.processItemEvent();
                    }
                });
            }
        });
    }

    public void setCachedProperties() {
        final JSWTMenuComponent pthis = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JSWTMenuComponent.this.peer.setEnabled(JSWTMenuComponent.this.pEnabled);
                if (JSWTMenuComponent.this.pImage != null) {
                    JSWTMenuComponent.this.peer.setImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, JSWTMenuComponent.this.pImage));
                }
                if (JSWTMenuComponent.this.pMnemonic != ' ') {
                    JSWTMenuComponent.this.showMnemonic();
                }
                if (JSWTMenuComponent.this.pAccelerator != 0) {
                    JSWTMenuComponent.this.peer.setAccelerator(JSWTMenuComponent.this.pAccelerator);
                    JSWTMenuComponent.this.showAccelerator();
                }
                JSWTMenuComponent.this.peer.setText(JSWTMenuComponent.this.pText);
            }
        });
    }
}

