/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.KeyListener;
import swingwt.awt.event.MouseEvent;
import swingwt.awt.event.MouseListener;
import swingwtx.swing.AbstractButton;
import swingwtx.swing.ButtonModel;
import swingwtx.swing.Icon;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JRadioButton
extends AbstractButton
implements ButtonModel,
SwingConstants {
    private boolean bRetVal;

    public JRadioButton() {
        this("");
    }

    public JRadioButton(String text) {
        this(text, false);
    }

    public JRadioButton(String text, Icon icon) {
        this(text, false);
    }

    public JRadioButton(String text, boolean selected) {
        this.pSelection = selected;
        this.pText = text;
        this.setModel(this);
        this.showMnemonic();
    }

    public void processMouseEvent(MouseEvent e) {
        Iterator i = this.mouseListeners.iterator();
        int eventID = e.getID();
        while (i.hasNext()) {
            MouseListener ml = (MouseListener)i.next();
            if (eventID == 500) {
                ml.mouseClicked(e);
                this.processItemEvent();
            }
            if (eventID == 504) {
                ml.mouseEntered(e);
            }
            if (eventID == 505) {
                ml.mouseExited(e);
            }
            if (eventID == 501) {
                ml.mousePressed(e);
            }
            if (eventID != 502) continue;
            ml.mouseReleased(e);
        }
    }

    public void processKeyEvent(KeyEvent e) {
        Iterator i = this.keyListeners.iterator();
        while (i.hasNext()) {
            KeyListener ml = (KeyListener)i.next();
            if (e.eventID == 401) {
                ml.keyTyped(e);
                this.processItemEvent();
            }
            if (e.eventID == 402) {
                ml.keyReleased(e);
            }
            if (e.eventID != 401) continue;
            ml.keyPressed(e);
        }
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(SwingWTUtils.getRenderStringWidth(this.pText) + 10, SwingWTUtils.getRenderStringHeight(this.pText) + 6);
        this.setSize(size);
        return size;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new Button(parent.getComposite(), 16);
        this.ppeer.setText(this.pText);
        this.ppeer.setSelection(this.pSelection);
        this.ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(this.pVAlign) | SwingWTUtils.translateSwingAlignmentConstant(this.pHAlign));
        this.peer = this.ppeer;
        this.parent = parent;
    }

    public boolean isSelected() {
        this.bRetVal = false;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JRadioButton.this.ppeer)) {
                    JRadioButton.this.bRetVal = JRadioButton.this.pSelection;
                } else {
                    JRadioButton.this.bRetVal = JRadioButton.this.ppeer.getSelection();
                }
            }
        });
        return this.bRetVal;
    }

    public void setSelected(final boolean b) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JRadioButton.this.ppeer)) {
                    JRadioButton.this.ppeer.setSelection(b);
                } else {
                    JRadioButton.this.pSelection = b;
                }
            }
        });
        this.processItemEvent();
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public boolean isArmed() {
        return false;
    }

    public boolean isPressed() {
        return false;
    }

    public boolean isRollover() {
        return false;
    }

    public void setArmed(boolean b) {
    }

    public void setPressed(boolean b) {
    }

    public void setRollover(boolean b) {
    }
}

