/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Frame;
import swingwtx.accessibility.Accessible;
import swingwtx.swing.Icon;
import swingwtx.swing.JDialog;
import swingwtx.swing.JFrame;
import swingwtx.swing.JInternalFrame;
import swingwtx.swing.JPanel;
import swingwtx.swing.SwingStyleInputDialog;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JOptionPane
extends JPanel
implements Accessible {
    public static final int CANCEL_OPTION = 256;
    public static final int YES_OPTION = 64;
    public static final int NO_OPTION = 128;
    public static final int OK_OPTION = 32;
    public static final int OK_CANCEL_OPTION = 288;
    public static final int CLOSED_OPTION = -1;
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 192;
    public static final int YES_NO_CANCEL_OPTION = 448;
    public static final int WARNING_MESSAGE = 8;
    public static final int QUESTION_MESSAGE = 4;
    public static final int PLAIN_MESSAGE = -1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int ERROR_MESSAGE = 1;
    public static final Object UNINITIALIZED_VALUE = "uninitializedValue";
    protected static Object lastInputDialogReturnValue = null;
    protected static int lastInputDialogReturnIndex = -1;
    private static int confRetVal = 0;
    private static boolean jobFinished = false;
    private static JFrame rootFrame = null;
    public static final String ICON_PROPERTY = "icon";
    public static final String MESSAGE_PROPERTY = "message";
    public static final String VALUE_PROPERTY = "value";
    public static final String OPTIONS_PROPERTY = "options";
    public static final String INITIAL_VALUE_PROPERTY = "initialValue";
    public static final String MESSAGE_TYPE_PROPERTY = "messageType";
    public static final String OPTION_TYPE_PROPERTY = "optionType";
    public static final String SELECTION_VALUES_PROPERTY = "selectionValues";
    public static final String INITIAL_SELECTION_VALUE_PROPERTY = "initialSelectionValue";
    public static final String INPUT_VALUE_PROPERTY = "inputValue";
    public static final String WANTS_INPUT_PROPERTY = "wantsInput";
    protected boolean wantsInput;
    protected transient Object value;
    protected transient Object initialValue;
    protected transient Object[] selectionValues;
    protected transient Object inputValue;
    protected transient Object initialSelectionValue;
    protected Object message = null;
    protected int messageType = 2;
    private int dOptionType = 0;
    private Icon dIcon = null;
    private Object[] dOptions = null;
    private Object dInitialValue = null;
    private Object dValue = null;
    private Object dInputValue = null;
    private static Shell sharedFrame = null;

    public JOptionPane() {
    }

    public JOptionPane(Object message, int messageType) {
        this(message, messageType, 0);
    }

    public JOptionPane(Object message, int messageType, int optionType) {
        this(message, messageType, optionType, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon) {
        this(message, messageType, optionType, icon, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options) {
        this(message, messageType, optionType, icon, options, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        this.message = message;
        this.messageType = messageType;
        this.dOptionType = optionType;
        this.dIcon = icon;
        this.dOptions = options;
        this.dInitialValue = initialValue;
    }

    public Object getMessage() {
        return this.message;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getOptionType() {
        return this.dOptionType;
    }

    public Icon getIcon() {
        return this.dIcon;
    }

    public Object[] getOptions() {
        return this.dOptions;
    }

    public Object getInitialValue() {
        return this.dInitialValue;
    }

    public Object getValue() {
        return this.dValue;
    }

    public Object getInputValue() {
        return this.dInputValue;
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public void setOptionType(int optionType) {
        this.dOptionType = optionType;
    }

    public void setIcon(Icon icon) {
        this.dIcon = icon;
    }

    public void setOptions(Object[] options) {
        this.dOptions = options;
    }

    public void setInitialValue(Object initialValue) {
        this.dInitialValue = initialValue;
    }

    public void setValue(Object value) {
        this.dValue = value;
    }

    public void setInputValue(Object value) {
        this.dInputValue = value;
    }

    public JDialog createDialog(Component parent, String title) {
        return null;
    }

    public JInternalFrame createInternalFrame(Component parent, String title) {
        return null;
    }

    public void setWantsInput(boolean newValue) {
        boolean oldValue = this.wantsInput;
        this.wantsInput = newValue;
    }

    public boolean getWantsInput() {
        return this.wantsInput;
    }

    public void selectInitialValue() {
    }

    public void setSelectionValues(Object[] newValues) {
        Object[] oldValues = this.selectionValues;
        this.selectionValues = newValues;
        if (this.selectionValues != null) {
            this.setWantsInput(true);
        }
    }

    public Object[] getSelectionValues() {
        return this.selectionValues;
    }

    public void setInitialSelectionValue(Object newValue) {
        Object oldValue = this.initialSelectionValue;
        this.initialSelectionValue = newValue;
    }

    public static Frame getFrameForComponent(Component parentComponent) {
        Component current;
        for (current = parentComponent; current != null && !(current instanceof Frame); current = current.getParent()) {
        }
        if (current == null) {
            return rootFrame;
        }
        return (Frame)current;
    }

    public static void setRootFrame(JFrame frame) {
        rootFrame = frame;
    }

    public static JFrame getRootFrame() {
        return rootFrame;
    }

    public static int showConfirmDialog(Container parent, Object message) {
        return JOptionPane.showConfirmDialog(parent, message, "", 4);
    }

    public static int showConfirmDialog(Container parent, Object message, String title, int messageType) {
        return JOptionPane.showConfirmDialog(parent, message, title, 0, messageType);
    }

    public static int showConfirmDialog(Container parent, Object message, String title, int messageType, int buttons) {
        return JOptionPane.showConfirmDialog(parent, message, title, buttons, messageType, null);
    }

    public static int showConfirmDialog(final Container parent, final Object message, final String title, int buttons, final int messageType, Icon icon) {
        confRetVal = 0;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                Shell container = JOptionPane.getModalParent(parent);
                MessageBox m = new MessageBox(container, messageType | 0x40 | 0x80);
                m.setMessage(JOptionPane.getOptionPaneMessage(message));
                m.setText(title);
                confRetVal = m.open();
                switch (confRetVal) {
                    case 64: {
                        confRetVal = 64;
                        break;
                    }
                    case 128: {
                        confRetVal = 128;
                    }
                }
            }
        });
        return confRetVal;
    }

    public static void showMessageDialog(Container parent, Object message) {
        JOptionPane.showMessageDialog(parent, message, "Information", 2);
    }

    public static void showMessageDialog(Component parent, Object message, String title, int messageType) {
        JOptionPane.showMessageDialog((Container)parent, message, title, messageType);
    }

    public static void showMessageDialog(final Container parent, final Object message, final String title, final int messageType) {
        SwingUtilities.invokeAsync(new Runnable(){

            public void run() {
                MessageBox m = new MessageBox(JOptionPane.getModalParent(parent), messageType | 0x20);
                m.setMessage(JOptionPane.getOptionPaneMessage(message));
                m.setText(title);
                m.open();
            }
        });
    }

    public static void showInternalMessageDialog(Container parent, Object message) {
        JOptionPane.showInternalMessageDialog(parent, message, "Information", 2);
    }

    public static void showInternalMessageDialog(Component parent, Object message, String title, int messageType) {
        JOptionPane.showInternalMessageDialog((Container)parent, message, title, messageType);
    }

    public static void showInternalMessageDialog(Container parent, Object message, String title, int messageType) {
        JOptionPane.showMessageDialog(parent, message, title, messageType);
    }

    public static String showInputDialog(Container parent, Object message) {
        SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, JOptionPane.getOptionPaneMessage(message), "Input", 0, null, null, null);
        dlg.show();
        if (lastInputDialogReturnValue == null) {
            return null;
        }
        return lastInputDialogReturnValue.toString();
    }

    public static String showInputDialog(Container parent, Object message, Object initialSelectionValue) {
        SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, JOptionPane.getOptionPaneMessage(message), "Input", 0, null, null, initialSelectionValue);
        dlg.show();
        if (lastInputDialogReturnValue == null) {
            return null;
        }
        return lastInputDialogReturnValue.toString();
    }

    public static String showInputDialog(Component parent, Object message, String title, int messageType) {
        SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, JOptionPane.getOptionPaneMessage(message), title, messageType, null, null, null);
        dlg.show();
        if (lastInputDialogReturnValue == null) {
            return null;
        }
        return lastInputDialogReturnValue.toString();
    }

    public static Object showInputDialog(final Component parent, final Object message, final String title, final int messageType, final Icon icon, final Object[] selectionValues, final Object initialSelectionValue) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, JOptionPane.getOptionPaneMessage(message), title, messageType, icon, selectionValues, initialSelectionValue);
                dlg.show();
            }
        });
        return lastInputDialogReturnValue;
    }

    public static int showOptionDialog(final Container parent, final Object message, final String title, int optionType, final int messageType, final Icon icon, final Object[] options, final Object initialValue) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, JOptionPane.getOptionPaneMessage(message), title, messageType, icon, options, initialValue);
                dlg.show();
            }
        });
        return lastInputDialogReturnIndex;
    }

    protected static String getOptionPaneMessage(Object message) {
        String out = "";
        if (message instanceof String[]) {
            String[] msgs = (String[])message;
            for (int i = 0; i < msgs.length; ++i) {
                out = out + msgs[i] + " ";
            }
        } else {
            out = message.toString();
        }
        out = SwingWTUtils.removeHTML(out);
        return out;
    }

    private static void waitToFinish() {
        while (!JOptionPane.isJobFinished()) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
    }

    protected static synchronized boolean isJobFinished() {
        return jobFinished;
    }

    protected static synchronized void setJobFinished(boolean b) {
        jobFinished = b;
    }

    private static Shell getModalParent(Container c) {
        if (c == null) {
            if (JOptionPane.getRootFrame() == null) {
                return JOptionPane.getSharedFrame();
            }
            return (Shell)JOptionPane.getRootFrame().getSWTPeer();
        }
        if (!(c.composite instanceof Shell)) {
            return c.composite.getShell();
        }
        return (Shell)c.composite;
    }

    public static Shell getSharedFrame() {
        if (sharedFrame == null) {
            sharedFrame = new Shell(SwingWTUtils.getDisplay(), 8);
        }
        return sharedFrame;
    }

    public static Object showInternalInputDialog(Container parent, String msg, String title, int type, Object tbd1, Object tbd2, String tbd3) {
        return JOptionPane.showInputDialog(parent, msg, title, type);
    }
}

