/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import swingwt.awt.Component;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.MouseEvent;
import swingwtx.swing.Action;
import swingwtx.swing.JMenuItem;
import swingwtx.swing.JPopupMenu;
import swingwtx.swing.JSWTMenuComponent;
import swingwtx.swing.JSeparator;
import swingwtx.swing.MenuElement;
import swingwtx.swing.MenuSelectionManager;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.MenuEvent;
import swingwtx.swing.event.MenuListener;

public class JMenu
extends JMenuItem
implements MenuElement {
    private Menu container = null;
    private Shell shell = null;
    protected Vector menuListeners = new Vector();
    private int iRetval;
    private Object retval;

    public JMenu() {
    }

    public JMenu(Action a) {
        this.setAction(a);
    }

    public JMenu(String text) {
        this(text, false);
    }

    public JMenu(String text, boolean isTearOff) {
        this.pText = text;
    }

    protected void registerSWTMenuComponent(final JSWTMenuComponent c) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JMenu.this.peer)) {
                    try {
                        c.setSwingWTParent(JMenu.this.container, JMenu.this.shell);
                        c.setCachedProperties();
                        c.registerEvents();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void addMenuListener(MenuListener l) {
        this.menuListeners.add(l);
    }

    public void removeMenuListener(MenuListener l) {
        this.menuListeners.remove(l);
    }

    public void processMenuEvent(int id) {
        MenuEvent me = new MenuEvent(this);
        block5: for (int i = 0; i < this.menuListeners.size(); ++i) {
            MenuListener ml = (MenuListener)this.menuListeners.get(i);
            switch (id) {
                case 0: {
                    ml.menuSelected(me);
                    continue block5;
                }
                case 1: {
                    ml.menuDeselected(me);
                    continue block5;
                }
                case 2: {
                    ml.menuCanceled(me);
                }
            }
        }
    }

    public JSWTMenuComponent add(JSWTMenuComponent c) {
        this.comps.add(c);
        this.registerSWTMenuComponent(c);
        return c;
    }

    public JSWTMenuComponent insert(JSWTMenuComponent c, int index) {
        this.comps.add(index, c);
        this.registerSWTMenuComponent(c);
        return c;
    }

    public JSWTMenuComponent add(JSWTMenuComponent c, String name) {
        return this.add(c);
    }

    public JMenu add(JMenu c) {
        return (JMenu)this.add((JSWTMenuComponent)c);
    }

    public JMenu add(JMenu c, String name) {
        return (JMenu)this.add((JSWTMenuComponent)c, name);
    }

    public JMenuItem add(JMenuItem c) {
        return (JMenuItem)this.add((JSWTMenuComponent)c);
    }

    public JMenuItem add(JMenuItem c, String name) {
        return (JMenuItem)this.add((JSWTMenuComponent)c, name);
    }

    public JMenuItem add(Action a) {
        JMenuItem jmenu = new JMenuItem(a);
        this.add(jmenu);
        return jmenu;
    }

    public JMenuItem add(String text) {
        JMenuItem jmenu = new JMenuItem(text);
        this.add(jmenu);
        return jmenu;
    }

    public Component add(Component c) {
        if (c instanceof JSWTMenuComponent) {
            return this.add((JSWTMenuComponent)c);
        }
        throw new IllegalArgumentException("Sorry, SwingWT cannot support components in menus: " + c);
    }

    public Component add(Component c, int index) {
        throw new IllegalArgumentException("Sorry, SwingWT cannot support components in menus");
    }

    public JMenuItem insert(JMenuItem item, int index) {
        return (JMenuItem)this.insert((JSWTMenuComponent)item, index);
    }

    public void remove(Component c) {
        throw new IllegalArgumentException("Sorry, SwingWT cannot support components in menus");
    }

    public void remove(JSWTMenuComponent c) {
        c.dispose();
    }

    public void remove(int index) {
        JSWTMenuComponent c = (JSWTMenuComponent)this.comps.get(index);
        this.comps.remove(index);
        c.dispose();
    }

    public void removeAll() {
        Iterator i = this.comps.iterator();
        while (i.hasNext()) {
            JSWTMenuComponent c = (JSWTMenuComponent)i.next();
            c.dispose();
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (JMenu.this.peer != null && JMenu.this.container != null) {
                    JMenu.this.container.dispose();
                    JMenu.this.container = new Menu((Decorations)JMenu.this.shell, 4);
                    JMenu.this.peer.setMenu(JMenu.this.container);
                }
            }
        });
    }

    public void registerEvents() {
        super.registerEvents();
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JMenu.this.container.addMenuListener(new org.eclipse.swt.events.MenuListener(){

                    public void menuShown(org.eclipse.swt.events.MenuEvent e) {
                        JMenu.this.processMenuEvent(0);
                    }

                    public void menuHidden(org.eclipse.swt.events.MenuEvent e) {
                        JMenu.this.processMenuEvent(1);
                    }
                });
            }
        });
    }

    public void addSeparator() {
        this.add(new JSeparator());
    }

    public JPopupMenu getPopupMenu() {
        return new JPopupMenu(this.comps);
    }

    public void setSwingWTParent(Menu parent, Shell shell) throws Exception {
        this.shell = shell;
        this.peer = new MenuItem(parent, 64);
        this.container = new Menu((Decorations)shell, 4);
        this.peer.setMenu(this.container);
        if (this.comps.size() > 0) {
            Object[] o = this.comps.toArray();
            for (int i = 0; i < o.length; ++i) {
                this.add((JSWTMenuComponent)o[i]);
            }
        }
    }

    public boolean isSelected() {
        return this.peer.getSelection();
    }

    public void setSelected(boolean b) {
        this.peer.setSelection(b);
    }

    public JMenuItem getItem(final int index) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JMenu.this.peer)) {
                    JMenu.this.retval = JMenu.this.container.getItem(index);
                } else {
                    JMenu.this.retval = JMenu.this.comps.get(index);
                }
            }
        });
        if (this.retval instanceof JMenuItem) {
            return (JMenuItem)this.retval;
        }
        return null;
    }

    public int getItemCount() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(JMenu.this.peer)) {
                    JMenu.this.iRetval = JMenu.this.container.getItemCount();
                } else {
                    JMenu.this.iRetval = JMenu.this.comps.size();
                }
            }
        });
        return this.iRetval;
    }

    public boolean isTearOff() {
        return false;
    }

    public Component getMenuComponent(int p) {
        if (p >= this.comps.size() || p < 0) {
            return null;
        }
        return (Component)this.comps.get(p);
    }

    public int getMenuComponentCount() {
        return this.getItemCount();
    }

    public Component getComponent() {
        return this;
    }

    public int countComponents() {
        return this.comps.size();
    }

    public MenuElement[] getSubElements() {
        MenuElement[] me = new MenuElement[this.comps.size()];
        for (int i = 0; i < this.comps.size(); ++i) {
            me[i] = (MenuElement)this.comps.get(i);
        }
        return me;
    }

    public void menuSelectionChanged(boolean isIncluded) {
    }

    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }
}

