/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import swingwt.awt.Color;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Point;
import swingwt.awt.Rectangle;
import swingwtx.swing.DefaultListCellRenderer;
import swingwtx.swing.DefaultListModel;
import swingwtx.swing.DefaultListSelectionModel;
import swingwtx.swing.JLabel;
import swingwtx.swing.JList;
import swingwtx.swing.JViewport;
import swingwtx.swing.ListCellRenderer;
import swingwtx.swing.ListModel;
import swingwtx.swing.ListSelectionModel;
import swingwtx.swing.Scrollable;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.ListDataEvent;
import swingwtx.swing.event.ListDataListener;
import swingwtx.swing.event.ListSelectionListener;

public class JListTable
extends JList
implements Scrollable,
ListDataListener {
    protected Table ppeer = null;
    protected String pText = "";
    protected int pSelectedIndex = -1;
    protected ListCellRenderer cellRenderer = new DefaultListCellRenderer();
    protected ListModel listModel = null;
    protected ListSelectionModel listSelectionModel = new DefaultListSelectionModel(this);
    private Object[] retVals = null;
    private int iRetVal = 0;
    private int[] iRetVals = null;
    private int fixedCellWidth = -1;

    public JListTable() {
        this.listModel = new DefaultListModel();
        this.listModel.addListDataListener(this);
    }

    public JListTable(Object[] items) {
        this.loadData(items);
    }

    public JListTable(Vector items) {
        this.loadData(items);
    }

    public JListTable(ListModel model) {
        this.listModel = model;
        this.listModel.addListDataListener(this);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listSelectionModel.addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listSelectionModel.removeListSelectionListener(l);
    }

    public void clearSelection() {
        this.ppeer.deselectAll();
    }

    public Object getSelectedValue() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            if (this.getModel().getSize() > 0) {
                return this.getModel().getElementAt(0);
            }
            return null;
        }
        return this.listModel.getElementAt(this.ppeer.getSelectionIndex());
    }

    public void setSelectedValue(final int index) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JListTable.this.ppeer)) {
                    JListTable.this.pSelectedIndex = index;
                } else {
                    JListTable.this.ppeer.select(index);
                }
            }
        });
    }

    protected int indexOf(Object value) {
        int index = -1;
        if (this.checkIsDefault()) {
            index = ((DefaultListModel)this.listModel).indexOf(value);
        } else {
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                if (!this.listModel.getElementAt(i).equals(value)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public void setSelectedValue(final Object value, boolean shouldscroll) {
        final boolean scroll = shouldscroll;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JListTable.this.ppeer)) {
                    JListTable.this.pSelectedIndex = JListTable.this.indexOf(value);
                } else {
                    JListTable.this.ppeer.select(JListTable.this.indexOf(value));
                }
                if (scroll) {
                    JListTable.this.ppeer.showSelection();
                }
            }
        });
    }

    public ListSelectionModel getSelectionModel() {
        return this.listSelectionModel;
    }

    public void setSelectionModel(ListSelectionModel l) {
        this.listSelectionModel = l;
    }

    public void setSelectionMode(int mode) {
        this.listSelectionModel.setSelectionMode(mode);
    }

    public Object[] getSelectedValues() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return null;
        }
        this.retVals = null;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JListTable.access$002(JListTable.this, new Object[JListTable.this.ppeer.getSelectionCount()]);
                for (int i = 0; i < JListTable.this.ppeer.getSelectionIndices().length; ++i) {
                    ((JListTable)JListTable.this).retVals[i] = JListTable.this.listModel.getElementAt(JListTable.this.ppeer.getSelectionIndices()[i]);
                }
            }
        });
        return this.retVals;
    }

    public void addItem(Object item) {
        if (!this.checkIsDefault()) {
            return;
        }
        ((DefaultListModel)this.listModel).addElement(item);
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JListTable.this.ppeer)) {
                    JListTable.this.updateList();
                }
            }
        });
    }

    public void insertItemAt(Object item, int index) {
        if (!this.checkIsDefault()) {
            return;
        }
        ((DefaultListModel)this.listModel).add(index, item);
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JListTable.this.ppeer)) {
                    JListTable.this.updateList();
                }
            }
        });
    }

    public int getSelectedIndex() {
        this.iRetVal = 0;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JListTable.this.ppeer)) {
                    JListTable.this.iRetVal = -1;
                } else {
                    JListTable.this.iRetVal = JListTable.this.ppeer.getSelectionIndex();
                }
            }
        });
        return this.iRetVal;
    }

    public int[] getSelectedIndices() {
        this.iRetVals = null;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JListTable.this.ppeer)) {
                    JListTable.access$202(JListTable.this, JListTable.this.ppeer.getSelectionIndices());
                } else {
                    JListTable.access$202(JListTable.this, new int[0]);
                }
            }
        });
        return this.iRetVals;
    }

    public Object getItemAt(int index) {
        return this.listModel.getElementAt(index);
    }

    public int getItemCount() {
        return this.listModel.getSize();
    }

    public void showSelection() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JListTable.this.ppeer)) {
                    JListTable.this.ppeer.showSelection();
                }
            }
        });
    }

    public void setSelectedIndex(final int index) {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.pSelectedIndex = index;
        } else {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JListTable.this.ppeer.select(index);
                }
            });
        }
    }

    public void setSelectedIndices(final int[] selection) {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JListTable.this.ppeer.select(selection);
            }
        });
    }

    public void removeAllItems() {
        this.setModel(new DefaultListModel());
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JListTable.this.ppeer.removeAll();
                    JListTable.this.updateList();
                }
            });
        }
    }

    public void removeItem(Object item) {
        if (!this.checkIsDefault()) {
            return;
        }
        final int index = ((DefaultListModel)this.listModel).indexOf(item);
        ((DefaultListModel)this.listModel).removeElement(item);
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JListTable.this.ppeer.remove(index);
                    JListTable.this.updateList();
                }
            });
        }
    }

    public void removeItemAt(final int index) {
        if (!this.checkIsDefault()) {
            return;
        }
        ((DefaultListModel)this.listModel).remove(index);
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JListTable.this.ppeer.remove(index);
                }
            });
        }
    }

    public void replaceItemAt(Object replacement, int index) {
        if (!this.checkIsDefault()) {
            return;
        }
        ((DefaultListModel)this.listModel).set(index, replacement);
        this.updateList();
    }

    public void setVisibleRowCount(int rows) {
        Dimension d = this.getPreferredSize();
        d.height = rows * SwingWTUtils.getRenderStringHeight("W");
        if (d.width == 0) {
            d.width = SwingWTUtils.getRenderStringWidth("WWWWWWWWWWWWWWWWWWW");
        }
        this.setPreferredSize(d);
    }

    public int locationToIndex(Point point) {
        return point.y / SwingWTUtils.getRenderStringHeight("W");
    }

    public void setSelectionBackground(Color color) {
    }

    public void setSelectionForeground(Color color) {
    }

    protected void updateList() {
        final JListTable list = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JListTable.this.ppeer)) {
                    return;
                }
                JListTable.this.ppeer.removeAll();
                TableColumn tc = JListTable.this.ppeer.getColumn(0);
                int maxWidth = JListTable.this.ppeer.getBounds().width - SwingWTUtils.getRenderStringWidth("WW");
                if (SwingWTUtils.isMacOSX() || SwingWTUtils.isWindows()) {
                    tc.setWidth(maxWidth);
                }
                if (JListTable.this.listModel != null) {
                    for (int i = 0; i < JListTable.this.listModel.getSize(); ++i) {
                        int thiswidth;
                        TableItem ti = new TableItem(JListTable.this.ppeer, 0);
                        JLabel renderer = (JLabel)JListTable.this.cellRenderer.getListCellRendererComponent(list, JListTable.this.listModel.getElementAt(i), i, false, false);
                        ti.setText(0, renderer.getText());
                        if (renderer.getIcon() != null) {
                            ti.setImage(0, SwingWTUtils.getSWTImageFromSwingIcon(list, renderer.getIcon()));
                        }
                        if ((thiswidth = SwingWTUtils.getRenderStringWidth(ti.getText())) > maxWidth) {
                            int iconwidth = 0;
                            if (renderer.getIcon() != null) {
                                iconwidth = renderer.getIcon().getIconWidth();
                            }
                            tc.setWidth(thiswidth + iconwidth);
                        }
                        if (renderer.getBackgroundSet() && renderer.getBackground().getSWTColor() != null) {
                            ti.setBackground(renderer.getBackground().getSWTColor());
                        }
                        if (renderer.getForegroundSet() && renderer.getForeground().getSWTColor() != null) {
                            ti.setForeground(renderer.getForeground().getSWTColor());
                        }
                        JListTable.this.ppeer.setCursor(renderer.getCursor().getSWTCursor());
                    }
                }
            }
        });
    }

    public void setListData(Object[] listData) {
        this.loadData(listData);
        this.updateList();
    }

    public void setListData(Vector listData) {
        this.loadData(listData);
        this.updateList();
    }

    protected void loadData(Vector data) {
        this.loadData(data.toArray());
    }

    protected void loadData(Object[] data) {
        this.listModel = new DefaultListModel();
        for (int i = 0; i < data.length; ++i) {
            ((DefaultListModel)this.listModel).addElement(data[i]);
        }
        this.listModel.addListDataListener(this);
    }

    public void setCellRenderer(ListCellRenderer r) {
        this.cellRenderer = r;
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public ListModel getModel() {
        return this.listModel;
    }

    public void setModel(ListModel l) {
        this.listModel = l;
        this.listModel.addListDataListener(this);
        this.updateList();
    }

    protected boolean checkIsDefault() {
        return this.listModel instanceof DefaultListModel;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new Table(parent.getComposite(), 0x800 | (this.listSelectionModel.getSelectionMode() == 2 ? 2 : 4) | 0x10000);
        TableColumn tc = new TableColumn(this.ppeer, 0);
        this.peer = this.ppeer;
        this.parent = parent;
        this.ppeer.setLinesVisible(false);
        this.registerSelectionEvents();
        this.updateList();
        if (this.pSelectedIndex != -1) {
            this.ppeer.select(this.pSelectedIndex);
            this.ppeer.showSelection();
        }
    }

    public void contentsChanged(ListDataEvent e) {
        this.updateList();
    }

    public void intervalAdded(ListDataEvent e) {
        this.updateList();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.updateList();
    }

    protected void registerSelectionEvents() {
        this.ppeer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JListTable.this.listSelectionModel instanceof DefaultListSelectionModel) {
                    if (JListTable.this.listSelectionModel.getSelectionMode() == 2) {
                        int lowest = JListTable.this.ppeer.getSelectionIndex();
                        int highest = JListTable.this.ppeer.getSelectionIndex();
                        int[] sel = JListTable.this.ppeer.getSelectionIndices();
                        for (int i = 0; i < sel.length; ++i) {
                            if (lowest > sel[i]) {
                                lowest = sel[i];
                            }
                            if (highest >= sel[i]) continue;
                            highest = sel[i];
                        }
                        ((DefaultListSelectionModel)JListTable.this.listSelectionModel).fireListSelectionEvent(JListTable.this, lowest, highest);
                    } else {
                        ((DefaultListSelectionModel)JListTable.this.listSelectionModel).fireListSelectionEvent(JListTable.this, JListTable.this.ppeer.getSelectionIndex(), JListTable.this.ppeer.getSelectionIndex());
                    }
                }
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    public boolean getScrollableTracksViewportHeight() {
        boolean retval = false;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            retval = (double)((JViewport)parent).getHeight() > this.getPreferredSize().getHeight();
        }
        return retval;
    }

    public boolean getScrollableTracksViewportWidth() {
        boolean retval = false;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            retval = (double)((JViewport)parent).getWidth() > this.getPreferredSize().getWidth();
        }
        return retval;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    public void ensureIndexIsVisible(final int selectedIndex) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JListTable.this.ppeer.select(selectedIndex);
                JListTable.this.ppeer.showSelection();
            }
        });
    }

    public boolean isSelectedIndex(int pos) {
        return this.getSelectedIndex() == pos;
    }

    public ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel(this);
    }

    protected void setSelectionInterval(int index, int index2) {
    }

    public void addSelectionInterval(int index, int index2) {
    }

    public void removeSelectionInterval(int index, int index2) {
    }

    public void setFixedCellWidth(int width) {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return;
        }
        TableColumn tc = null;
        tc = this.ppeer.getColumn(0);
        tc.setWidth(width);
    }

    static /* synthetic */ Object[] access$002(JListTable x0, Object[] x1) {
        x0.retVals = x1;
        return x1;
    }

    static /* synthetic */ int[] access$202(JListTable x0, int[] x1) {
        x0.iRetVals = x1;
        return x1;
    }
}

