/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.FlowLayout;
import swingwt.awt.Frame;
import swingwt.awt.GridLayout;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.ItemEvent;
import swingwt.awt.event.ItemListener;
import swingwt.awt.event.MouseAdapter;
import swingwt.awt.event.MouseEvent;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.JButton;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JDialog;
import swingwtx.swing.JLabel;
import swingwtx.swing.JList;
import swingwtx.swing.JListTable;
import swingwtx.swing.JPanel;
import swingwtx.swing.JTextField;
import swingwtx.swing.ListCellRenderer;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.filechooser.FileFilter;

public class JFileChooser
extends JPanel {
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int CANCEL_OPTION = 1;
    public static final String CANCEL_SELECTION = "CANCEL";
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final String ACCESSORY_CHANGED_PROPERTY = "AccessoryChangedProperty";
    public static final String ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY = "acceptAllFileFilterUsedChanged";
    public static final String DIALOG_TITLE_CHANGED_PROPERTY = "DialogTitleChangedProperty";
    public static final String DIALOG_TYPE_CHANGED_PROPERTY = "DialogTypeChangedProperty";
    public static final String CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY = "ChoosableFileFilterChangedProperty";
    public static final String FILE_VIEW_CHANGED_PROPERTY = "fileViewChanged";
    public static final String FILE_HIDING_CHANGED_PROPERTY = "FileHidingChanged";
    public static final String FILE_FILTER_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String FILE_SELECTION_MODE_CHANGED_PROPERTY = "fileSelectionChanged";
    public static final String APPROVE_BUTTON_TEXT_CHANGED_PROPERTY = "ApproveButtonTextChangedProperty";
    public static final String APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY = "ApproveButtonToolTipTextChangedProperty";
    public static final String APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY = "ApproveButtonMnemonicChangedProperty";
    public static final String CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY = "ControlButtonsAreShownChangedProperty";
    public static final String DIRECTORY_CHANGED_PROPERTY = "directoryChanged";
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "SelectedFileChangedProperty";
    public static final String SELECTED_FILES_CHANGED_PROPERTY = "SelectedFilesChangedProperty";
    public static final String MULTI_SELECTION_ENABLED_CHANGED_PROPERTY = "MultiSelectionEnabledChangedProperty";
    public static final String FILE_SYSTEM_VIEW_CHANGED_PROPERTY = "FileSystemViewChanged";
    protected int dialogType = 0;
    protected String dialogTitle = "";
    protected int fileSelection = 0;
    protected File curPath = new File("");
    protected File curFile = new File("");
    protected File[] curFiles = null;
    protected boolean multiSelect = false;
    protected String[] filters = null;
    protected String[] filterNames = null;
    protected Vector fileFilters = new Vector();
    public boolean useNative = true;
    protected JTextField location = null;
    protected JComboBox filter = null;
    protected JPanel centralPanel = null;
    protected JListTable fileList = null;
    protected JPanel buttonPanel = null;
    protected JLabel locationLabel = null;
    protected JButton okButton = null;
    protected JComponent fcAccessory = null;
    protected FileChooserDialog customDialog = null;
    protected int dialogReturnValue = 1;
    protected FileFilterWrapper allFiles = null;
    private static File lastDir = null;
    private static boolean useLastDirectory = false;
    static /* synthetic */ Class class$swingwtx$swing$JFileChooser;

    public static void setUseLastDirectory(boolean b) {
        useLastDirectory = b;
    }

    public JFileChooser() {
        this(useLastDirectory && lastDir != null ? lastDir : new File(""));
    }

    public JFileChooser(String currentDirectoryPath) {
        this(new File(currentDirectoryPath));
    }

    public JFileChooser(File currentDirectory) {
        this.curPath = currentDirectory;
        this.curFile = currentDirectory;
        this.layoutComponent();
    }

    public File getSelectedFile() {
        return this.curFile;
    }

    public void setSelectedFile(File file) {
        this.curFile = file;
        this.ensureFileIsVisible(file);
    }

    public File[] getSelectedFiles() {
        return this.curFiles;
    }

    public void setSelectedFiles(File[] selectedFiles) {
        this.curFiles = selectedFiles;
    }

    public File getCurrentDirectory() {
        return this.curPath;
    }

    public void setCurrentDirectory(File dir) {
        this.curPath = dir;
        this.ensureFileIsVisible(dir);
    }

    public void changeToParentDirectory() {
        this.setCurrentDirectory(this.curPath.getParentFile());
    }

    public void scanDrives(JComboBox driveBox) {
        if (SwingWTUtils.isWindows()) {
            driveBox.addItem(new DriveEntry(new File("A:"), "Floppy Disk (A:)"));
            this.checkDriveEntry("C:", "Disk (C:)", driveBox);
            this.checkDriveEntry("D:", "Disk (D:)", driveBox);
            this.checkDriveEntry("E:", "Disk (E:)", driveBox);
            this.checkDriveEntry("F:", "Disk (F:)", driveBox);
            this.checkDriveEntry("G:", "Network Disk (G:)", driveBox);
            this.checkDriveEntry("H:", "Network Disk (H:)", driveBox);
            this.checkDriveEntry("I:", "Network Disk (I:)", driveBox);
            this.checkDriveEntry("J:", "Network Disk (J:)", driveBox);
            this.checkDriveEntry("K:", "Network Disk (K:)", driveBox);
            this.checkDriveEntry("L:", "Network Disk (L:)", driveBox);
            this.checkDriveEntry("M:", "Network Disk (M:)", driveBox);
            this.checkDriveEntry("N:", "Network Disk (N:)", driveBox);
            this.checkDriveEntry("O:", "Network Disk (O:)", driveBox);
            this.checkDriveEntry("P:", "Network Disk (P:)", driveBox);
            this.checkDriveEntry("Q:", "Network Disk (Q:)", driveBox);
            this.checkDriveEntry("R:", "Network Disk (R:)", driveBox);
            this.checkDriveEntry("S:", "Network Disk (S:)", driveBox);
            this.checkDriveEntry("T:", "Network Disk (T:)", driveBox);
            this.checkDriveEntry("U:", "Network Disk (U:)", driveBox);
            this.checkDriveEntry("V:", "Network Disk (V:)", driveBox);
            this.checkDriveEntry("W:", "Network Disk (W:)", driveBox);
            this.checkDriveEntry("X:", "Network Disk (X:)", driveBox);
            this.checkDriveEntry("Y:", "Network Disk (Y:)", driveBox);
            this.checkDriveEntry("Z:", "Network Disk (Z:)", driveBox);
            driveBox.setSelectedIndex(1);
        } else {
            this.checkDriveEntry("/", "Root (/)", driveBox);
            this.checkDriveEntry("/mnt/auto", "Automatic Mount (/mnt/auto)", driveBox);
            this.checkDriveEntry("/floppy", "Floppy Disk (/floppy)", driveBox);
            this.checkDriveEntry("/mnt/floppy", "Floppy Disk (/mnt/floppy)", driveBox);
            this.checkDriveEntry("/mediad/floppy", "Floppy Disk (/media/floppy)", driveBox);
            this.checkDriveEntry("/cdrom", "CDROM (/cdrom)", driveBox);
            this.checkDriveEntry("/cdrom1", "CDROM (/cdrom1)", driveBox);
            this.checkDriveEntry("/media/cdrom", "CDROM (/media/cdrom)", driveBox);
            this.checkDriveEntry("/media/cdrom1", "CDROM (/media/cdrom1)", driveBox);
            this.checkDriveEntry("/mnt/cdrom", "CDROM (/mnt/cdrom)", driveBox);
            this.checkDriveEntry("/mnt/cdrom1", "CDROM (/mnt/cdrom1)", driveBox);
            this.checkDriveEntry("/mnt/dvd", "DVD ROM (/mnt/dvd)", driveBox);
            this.checkDriveEntry("/mnt/windows", "Windows Disk (/mnt/windows)", driveBox);
            this.checkDriveEntry("/mnt/win_c", "Windows Disk (/mnt/win_c)", driveBox);
            this.checkDriveEntry("/mnt/win_d", "Windows Disk (/mnt/win_d)", driveBox);
            this.checkDriveEntry("/mnt/removable", "Removable Device (/mnt/removable)", driveBox);
            this.checkDriveEntry("/mnt/zip", "Zip Disk (/mnt/zip)", driveBox);
        }
    }

    protected void checkDriveEntry(String path, String displayName, JComboBox driveBox) {
        try {
            File f = new File(path);
            if (f.exists()) {
                driveBox.addItem(new DriveEntry(f, displayName));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void rescanCurrentDirectory() {
        if (this.filter == null) {
            return;
        }
        try {
            File loc = new File(this.curFile.getAbsolutePath());
            if (!loc.isDirectory()) {
                loc = this.curFile.getParentFile();
            }
            if (loc == null) {
                return;
            }
            File[] fulldir = loc.listFiles();
            Vector<File> matches = new Vector<File>();
            FileFilterWrapper w = (FileFilterWrapper)this.filter.getSelectedItem();
            FileFilter theFilter = null;
            if (w != null) {
                theFilter = w.getFilter();
            }
            for (int i = 0; i < fulldir.length; ++i) {
                if (fulldir[i].getName().startsWith(".")) continue;
                if (theFilter == null) {
                    matches.add(fulldir[i]);
                    continue;
                }
                if (!theFilter.accept(fulldir[i])) continue;
                matches.add(fulldir[i]);
            }
            boolean needsParent = loc.getParentFile() != null;
            Object[] filteredDir = null;
            int noFiles = needsParent ? matches.size() + 1 : matches.size();
            filteredDir = new File[noFiles];
            if (needsParent) {
                filteredDir[0] = this.curFile.getAbsoluteFile().getParentFile();
            }
            for (int i = 0; i < matches.size(); ++i) {
                if (needsParent) {
                    filteredDir[i + 1] = (File)matches.get(i);
                    continue;
                }
                filteredDir[i] = (File)matches.get(i);
            }
            this.sortFiles((File[])filteredDir);
            this.fileList.setListData(filteredDir);
            this.locationLabel.setText(loc.getAbsolutePath());
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void ensureFileIsVisible(File f) {
    }

    public boolean getControlButtonsAreShown() {
        return this.buttonPanel.getParent() != null;
    }

    public void setControlButtonsAreShown(boolean b) {
        if (b) {
            this.add((Component)this.buttonPanel, "South");
        } else {
            this.remove(this.buttonPanel);
        }
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setApproveButtonToolTipText(String toolTipText) {
        this.okButton.setToolTipText(toolTipText);
    }

    public String getApproveButtonToolTipText() {
        return this.okButton.getToolTipText();
    }

    public void setApproveButtonMnemonic(int mnemonic) {
        this.okButton.setMnemonic(mnemonic);
    }

    public void setApproveButtonMnemonic(char mnemonic) {
        this.okButton.setMnemonic(mnemonic);
    }

    public void setApproveButtonText(String approveButtonText) {
        this.okButton.setText(approveButtonText);
    }

    public String getApproveButtonText() {
        return this.okButton.getText();
    }

    public JComponent getAccessory() {
        return this.fcAccessory;
    }

    public void setAccessory(JComponent newAccessory) {
        this.useNative = false;
        this.fcAccessory = newAccessory;
        this.centralPanel.add((Component)newAccessory, "East");
    }

    public void setFileSelectionMode(int mode) {
        this.fileSelection = mode;
    }

    public int getFileSelectionMode() {
        return this.fileSelection;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelection == 0 || this.fileSelection == 2;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelection == 2 || this.fileSelection == 1;
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelect = b;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelect;
    }

    public boolean isFileHidingEnabled() {
        return false;
    }

    public void setFileHidingEnabled(boolean b) {
    }

    public void setExtensionFilters(String[] extensions, String[] names) {
        this.filters = extensions;
        this.filterNames = names;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.useNative = false;
        FileFilterWrapper wrapper = new FileFilterWrapper(fileFilter);
        this.filter.addItem(wrapper);
        this.filter.setSelectedItem(wrapper);
    }

    public FileFilter getFileFilter() {
        return (FileFilter)this.filter.getSelectedItem();
    }

    public FileFilter[] getChoosableFileFilters() {
        FileFilter[] ff = new FileFilter[this.fileFilters.size()];
        for (int i = 0; i < this.fileFilters.size(); ++i) {
            ff[i] = (FileFilter)this.fileFilters.get(i);
        }
        return ff;
    }

    public void addChoosableFileFilter(FileFilter f) {
        FileFilterWrapper w = new FileFilterWrapper(f);
        this.filter.addItem(w);
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        for (int i = 0; i < this.filter.getItemCount(); ++i) {
            if (!((FileFilterWrapper)this.filter.getItemAt(i)).getFilter().equals(f)) continue;
            this.filter.removeItemAt(i);
            return true;
        }
        return false;
    }

    public void resetChoosableFileFilters() {
        this.filter.removeAllItems();
        this.fileFilters.removeAllElements();
    }

    public boolean isAcceptAllFileFilterUsed() {
        return true;
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
    }

    public int showOpenDialog(Component parent) {
        if (this.useNative) {
            return this.showNativeOpenDialog(parent);
        }
        return this.showCustomOpenDialog(parent);
    }

    public int showDialog(Component parent, String approveButtonText) {
        this.dialogType = 0;
        String dt = this.dialogTitle.equals("") ? "Open" : this.dialogTitle;
        this.okButton.setText(approveButtonText);
        this.customDialog = new FileChooserDialog(dt, this);
        this.rescanCurrentDirectory();
        this.customDialog.show();
        this.post_init();
        return this.dialogReturnValue;
    }

    public String showDirectorySelectDialog(Component parent, String message) {
        DirectoryDialog d = new DirectoryDialog(parent.getSWTPeer().getShell());
        if (this.dialogTitle.equals("")) {
            d.setText("Select a directory");
        } else {
            d.setText(this.dialogTitle);
        }
        d.setMessage(message);
        if (this.curPath == null) {
            this.curPath = new File("");
        }
        d.setFilterPath(this.curPath.getAbsolutePath());
        this.post_init();
        return d.open();
    }

    protected int showCustomOpenDialog(Component parent) {
        this.dialogType = 0;
        String dt = this.dialogTitle.equals("") ? "Open" : this.dialogTitle;
        this.customDialog = new FileChooserDialog(dt, this);
        this.rescanCurrentDirectory();
        this.customDialog.show();
        this.post_init();
        return this.dialogReturnValue;
    }

    protected int showNativeOpenDialog(Component parent) {
        String chosen;
        if (this.fileSelection == 1) {
            DirectoryDialog d = new DirectoryDialog(parent.getSWTPeer().getShell(), 0x1000 | (this.multiSelect ? 2 : 0));
            if (this.dialogTitle.equals("")) {
                d.setText("Open");
            } else {
                d.setText(this.dialogTitle);
            }
            d.setFilterPath(this.curPath.getAbsolutePath());
            String chosen2 = d.open();
            this.post_init();
            if (chosen2 == null) {
                return 1;
            }
            this.curPath = new File(chosen2);
            this.curFile = new File(chosen2);
            return 0;
        }
        this.dialogType = 0;
        FileDialog f = new FileDialog(parent.getSWTPeer().getShell(), 0x1000 | (this.multiSelect ? 2 : 0));
        if (this.dialogTitle.equals("")) {
            f.setText("Open");
        } else {
            f.setText(this.dialogTitle);
        }
        if (this.curPath == null) {
            this.curPath = new File("");
        }
        f.setFilterPath(this.curPath.getAbsolutePath());
        if (this.filters != null) {
            f.setFilterExtensions(this.filters);
            f.setFilterNames(this.filterNames);
        }
        if ((chosen = f.open()) == null) {
            return 1;
        }
        if (this.multiSelect) {
            this.curFile = new File(chosen);
            this.curFiles = new File[f.getFileNames().length];
            for (int i = 0; i < f.getFileNames().length; ++i) {
                this.curFiles[i] = new File(f.getFilterPath(), f.getFileNames()[i]);
                this.curFiles[i] = new File(this.curFiles[i].getAbsolutePath());
            }
            this.curPath = this.curFile.getParentFile();
        } else {
            this.curFile = new File(chosen);
            this.curPath = this.curFile.getParentFile();
        }
        this.post_init();
        return 0;
    }

    public int showSaveDialog(Component parent) {
        if (this.useNative) {
            return this.showNativeSaveDialog(parent);
        }
        return this.showCustomSaveDialog(parent);
    }

    protected int showNativeSaveDialog(Component parent) {
        this.dialogType = 1;
        FileDialog f = new FileDialog(parent.getSWTPeer().getShell(), 8192);
        if (this.dialogTitle.equals("")) {
            f.setText("Save As");
        } else {
            f.setText(this.dialogTitle);
        }
        f.setFilterPath(this.curPath.getAbsolutePath());
        if (this.filters != null) {
            f.setFilterExtensions(this.filters);
            f.setFilterNames(this.filterNames);
        }
        if (this.curFile == null) {
            this.curFile = new File("");
        }
        f.setFileName(this.curFile.getName());
        String chosen = f.open();
        if (chosen == null) {
            return 1;
        }
        if (this.multiSelect) {
            this.curFile = new File(chosen);
            this.curFiles = new File[f.getFileNames().length];
            for (int i = 0; i < f.getFileNames().length; ++i) {
                this.curFiles[i] = new File(f.getFileNames()[i]);
            }
            this.curPath = this.curFile.getParentFile();
        } else {
            this.curFile = new File(chosen);
            this.curPath = this.curFile.getParentFile();
        }
        this.post_init();
        return 0;
    }

    protected int showCustomSaveDialog(Component parent) {
        this.dialogType = 1;
        String dt = this.dialogTitle.equals("") ? "Save" : this.dialogTitle;
        this.customDialog = new FileChooserDialog(dt, this);
        this.rescanCurrentDirectory();
        this.customDialog.show();
        if (this.curPath.isDirectory()) {
            String newFile = this.curPath.getAbsolutePath();
            if (!newFile.endsWith(File.separator)) {
                newFile = newFile + File.separator;
            }
            this.curPath = new File(newFile + this.location.getText());
        }
        this.post_init();
        return this.dialogReturnValue;
    }

    public String getTitle() {
        return this.dialogTitle;
    }

    public void setTitle(String title) {
        this.dialogTitle = title;
    }

    public File[] sortFiles(File[] sort) {
        boolean madeAChange = true;
        while (madeAChange) {
            madeAChange = false;
            for (int i = 0; i < sort.length - 1; ++i) {
                int pos;
                if (!sort[i].isDirectory() && sort[i + 1].isDirectory()) {
                    File buf = sort[i + 1];
                    sort[i + 1] = sort[i];
                    sort[i] = buf;
                    buf = null;
                    madeAChange = true;
                }
                if ((pos = sort[i].toString().compareTo(sort[i + 1].toString())) <= 0 || sort[i].isDirectory() && !sort[i + 1].isDirectory()) continue;
                File buf = sort[i + 1];
                sort[i + 1] = sort[i];
                sort[i] = buf;
                buf = null;
                madeAChange = true;
            }
        }
        return sort;
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (int i = 0; i < this.propertyChangeListeners.size(); ++i) {
            ((PropertyChangeListener)this.propertyChangeListeners.get(i)).propertyChange(e);
        }
        this.forceRelayout();
    }

    protected void forceRelayout() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                int x = JFileChooser.this.customDialog.getSize().width;
                int y = JFileChooser.this.customDialog.getSize().height;
                JFileChooser.this.customDialog.setSize(++x, ++y);
                JFileChooser.this.customDialog.setSize(--x, --y);
            }
        });
    }

    protected void layoutComponent() {
        this.setLayout(new BorderLayout());
        JPanel pnlTool = new JPanel(new BorderLayout());
        pnlTool.add((Component)new JLabel("Drive:"), "West");
        final JComboBox drives = new JComboBox();
        drives.setPreferredSize(new Dimension(200, 25));
        pnlTool.add((Component)drives, "Center");
        this.scanDrives(drives);
        drives.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DriveEntry d = (DriveEntry)drives.getSelectedItem();
                JFileChooser.this.curFile = d.fileRef;
                JFileChooser.this.rescanCurrentDirectory();
            }
        });
        this.locationLabel = new JLabel();
        this.locationLabel.setText(this.curPath.getAbsolutePath());
        pnlTool.add((Component)this.locationLabel, "South");
        this.add((Component)pnlTool, "North");
        this.centralPanel = new JPanel();
        this.centralPanel.setLayout(new BorderLayout());
        this.fileList = new JListTable();
        this.fileList.setCellRenderer(new FileListRenderer());
        this.fileList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JFileChooser.this.curFile = null;
                if (JFileChooser.this.fileList.getSelectedIndex() == -1) {
                    return;
                }
                if (JFileChooser.this.fileList.getSelectedValue() == null) {
                    return;
                }
                JFileChooser.this.curFile = (File)JFileChooser.this.fileList.getSelectedValue();
                JFileChooser.this.curPath = JFileChooser.this.curFile.getParentFile();
                if (e.getClickCount() == 2) {
                    if (!JFileChooser.this.curFile.isDirectory()) {
                        JFileChooser.this.location.setText(JFileChooser.this.curFile.getName());
                        JFileChooser.this.firePropertyChangeEvent(JFileChooser.SELECTED_FILE_CHANGED_PROPERTY, null, JFileChooser.this.fileList.getSelectedValue());
                        JFileChooser.this.okButton.processActionEvent(0);
                    } else {
                        JFileChooser.this.rescanCurrentDirectory();
                    }
                } else if (!JFileChooser.this.curFile.isDirectory()) {
                    JFileChooser.this.location.setText(JFileChooser.this.curFile.getName());
                    JFileChooser.this.firePropertyChangeEvent(JFileChooser.SELECTED_FILE_CHANGED_PROPERTY, null, JFileChooser.this.fileList.getSelectedValue());
                }
            }
        });
        this.centralPanel.add((Component)this.fileList, "Center");
        JPanel entryBoxes = new JPanel();
        entryBoxes.setLayout(new GridLayout(2, 0));
        JPanel pnlLocation = new JPanel();
        pnlLocation.setLayout(new BorderLayout());
        JLabel lblLoc = new JLabel("Location:");
        pnlLocation.add((Component)lblLoc, "West");
        lblLoc.setPreferredSize(new Dimension(100, 25));
        this.location = new JTextField();
        pnlLocation.add((Component)this.location, "Center");
        entryBoxes.add(pnlLocation);
        JPanel pnlFilter = new JPanel();
        pnlFilter.setLayout(new BorderLayout());
        JLabel lblFilter = new JLabel("Filter:");
        pnlFilter.add((Component)lblFilter, "West");
        lblFilter.setPreferredSize(new Dimension(100, 25));
        this.filter = new JComboBox();
        pnlFilter.add((Component)this.filter, "Center");
        this.filter.setPreferredSize(new Dimension(300, 25));
        this.allFiles = new FileFilterWrapper(new AllFileFilter());
        this.filter.addItem(this.allFiles);
        this.filter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JFileChooser.this.rescanCurrentDirectory();
            }
        });
        entryBoxes.add(pnlFilter);
        this.centralPanel.add((Component)entryBoxes, "South");
        this.add((Component)this.centralPanel, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = (JButton)this.buttonPanel.add(new JButton("Ok"));
        this.okButton.setMnemonic('o');
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser.this.dialogReturnValue = 0;
                if (JFileChooser.this.multiSelect) {
                    Object[] aktFiles = JFileChooser.this.fileList.getSelectedValues();
                    int length = aktFiles.length;
                    JFileChooser.this.curFiles = new File[length];
                    for (int i = 0; i < length; ++i) {
                        JFileChooser.this.curFiles[i] = (File)aktFiles[i];
                    }
                }
                if (JFileChooser.this.customDialog != null) {
                    JFileChooser.this.customDialog.dispose();
                }
            }
        });
        JButton cancelButton = (JButton)this.buttonPanel.add(new JButton("Cancel"));
        cancelButton.setMnemonic('c');
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser.this.dialogReturnValue = 1;
                if (JFileChooser.this.customDialog != null) {
                    JFileChooser.this.customDialog.dispose();
                }
            }
        });
        this.add((Component)this.buttonPanel, "South");
    }

    private void post_init() {
        lastDir = this.getCurrentDirectory();
    }

    private class DriveEntry {
        public File fileRef = null;
        public String displayName = null;

        public DriveEntry(File file, String displayName) {
            this.fileRef = file;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private class FileFilterWrapper {
        private FileFilter filter = null;

        public FileFilterWrapper(FileFilter f) {
            this.filter = f;
        }

        public FileFilter getFilter() {
            return this.filter;
        }

        public String toString() {
            return this.filter.getDescription();
        }
    }

    private class AllFileFilter
    extends FileFilter {
        private AllFileFilter() {
        }

        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "All Files";
        }
    }

    private class FileListRenderer
    extends JLabel
    implements ListCellRenderer {
        ImageIcon dirIcon = SwingWTUtils.getPixmap(class$swingwtx$swing$JFileChooser == null ? (class$swingwtx$swing$JFileChooser = JFileChooser.class$("swingwtx.swing.JFileChooser")) : class$swingwtx$swing$JFileChooser, "dir.gif");

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            File f = (File)value;
            if (index == 0) {
                this.setText("..");
                this.setIcon(this.dirIcon);
                return this;
            }
            String name = f.getName();
            if (name.indexOf(File.separator) != -1) {
                name = name.substring(name.lastIndexOf(File.separator), name.length());
            }
            this.setText(name);
            boolean isDir = f.isDirectory();
            this.setIcon(isDir ? this.dirIcon : null);
            return this;
        }
    }

    private class FileChooserDialog
    extends JDialog {
        public FileChooserDialog(String title, JFileChooser fc) {
            super((Frame)null, title);
            this.setSize(512, 384);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)fc, "Center");
            this.setModal(true);
            this.setLocationRelativeTo(null);
        }
    }
}

