/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.ItemEvent;
import swingwt.awt.event.ItemListener;
import swingwtx.swing.ComboBoxEditor;
import swingwtx.swing.ComboBoxModel;
import swingwtx.swing.DefaultComboBoxModel;
import swingwtx.swing.JComponent;
import swingwtx.swing.ListCellRenderer;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;
import swingwtx.swing.event.ListDataEvent;
import swingwtx.swing.event.ListDataListener;
import swingwtx.swing.event.PopupMenuEvent;
import swingwtx.swing.event.PopupMenuListener;

public class JComboBox
extends JComponent
implements ListDataListener {
    protected Combo ppeer = null;
    protected String pText = "";
    protected Vector litems = null;
    protected int pSelectedIndex = -1;
    protected int pMaxRows = 8;
    protected Vector popupListeners = new Vector();
    protected Vector itemListeners = new Vector();
    protected Vector changeListeners = new Vector();
    protected ComboBoxModel model = null;
    private Object retValue = null;
    protected boolean isEditable = false;
    private ComboBoxEditor editor = null;
    protected static final int CANCELED = 0;
    protected static final int INVISIBLE = 1;
    protected static final int VISIBLE = 2;

    public JComboBox() {
        this.litems = new Vector();
        this.model = new DefaultComboBoxModel(this.litems);
    }

    public JComboBox(Object[] items) {
        this.litems = new Vector();
        for (int i = 0; i < items.length; ++i) {
            this.litems.add(items[i]);
        }
        if (!this.isEditable && this.litems.size() > 0) {
            this.pSelectedIndex = 0;
        }
        this.model = new DefaultComboBoxModel(this.litems);
    }

    public JComboBox(Vector items) {
        this.litems = items;
        if (!this.isEditable && this.litems != null && this.litems.size() > 0) {
            this.pSelectedIndex = 0;
        }
        this.model = new DefaultComboBoxModel(items);
    }

    public JComboBox(ComboBoxModel model) {
        this.model = model;
        this.copyModel();
        if (!this.isEditable && this.litems != null && this.litems.size() > 0) {
            this.pSelectedIndex = 0;
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.toArray(new ChangeListener[0]);
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.popupListeners.add(l);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.popupListeners.remove(l);
    }

    public PopupMenuListener[] getPopupMenuListener() {
        return this.popupListeners.toArray(new PopupMenuListener[0]);
    }

    public void addItemListener(ItemListener l) {
        this.itemListeners.add(l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }

    public ItemListener[] getItemListeners() {
        return this.itemListeners.toArray(new ItemListener[0]);
    }

    public void processPopupMenuEvent(int id) {
        Iterator i = this.popupListeners.iterator();
        PopupMenuEvent e = new PopupMenuEvent(this);
        while (i.hasNext()) {
            PopupMenuListener l = (PopupMenuListener)i.next();
            switch (id) {
                case 0: {
                    l.popupMenuCanceled(e);
                    break;
                }
                case 1: {
                    l.popupMenuWillBecomeInvisible(e);
                    break;
                }
                case 2: {
                    l.popupMenuWillBecomeVisible(e);
                }
            }
        }
    }

    public void processItemEvent(ItemEvent e) {
        if (this.model != null) {
            this.model.setSelectedItem(e.getItem());
        }
        for (int i = 0; i < this.itemListeners.size(); ++i) {
            ItemListener l = (ItemListener)this.itemListeners.get(i);
            l.itemStateChanged(e);
        }
    }

    public void processChangeEvent(ChangeEvent e) {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ChangeListener l = (ChangeListener)this.changeListeners.get(i);
            l.stateChanged(e);
        }
    }

    protected void copyModel() {
        if (this.model == null) {
            return;
        }
        this.litems = new Vector(this.model.getSize());
        for (int i = 0; i < this.model.getSize(); ++i) {
            this.litems.add(this.model.getElementAt(i));
        }
    }

    public Object getSelectedItem() {
        this.retValue = null;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (JComboBox.this.isEditable) {
                    if (!SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                        JComboBox.this.retValue = JComboBox.this.pText;
                    } else {
                        JComboBox.this.retValue = JComboBox.this.ppeer.getText();
                    }
                } else if (!SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer) && JComboBox.this.pSelectedIndex > -1) {
                    JComboBox.this.retValue = JComboBox.this.litems.get(JComboBox.this.pSelectedIndex);
                } else if (SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer) && JComboBox.this.ppeer.getSelectionIndex() != -1) {
                    JComboBox.this.retValue = JComboBox.this.litems.get(JComboBox.this.ppeer.getSelectionIndex());
                }
            }
        });
        return this.retValue;
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedItem()};
    }

    public void setSelectedItem(final Object text) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (JComboBox.this.isEditable) {
                    if (!SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                        JComboBox.this.pText = text.toString();
                    } else {
                        JComboBox.this.ppeer.setText(text.toString());
                    }
                } else if (JComboBox.this.litems != null) {
                    if (text instanceof String) {
                        Object[] itm = JComboBox.this.litems.toArray();
                        for (int i = 0; i < itm.length; ++i) {
                            if (!itm[i].toString().equals(text.toString())) continue;
                            JComboBox.this.setSelectedIndex(i);
                            break;
                        }
                    } else {
                        int index = JComboBox.this.litems.indexOf(text);
                        if (index != -1) {
                            JComboBox.this.setSelectedIndex(index);
                        }
                    }
                }
            }
        });
    }

    public ComboBoxModel getModel() {
        return this.model;
    }

    public void setModel(ComboBoxModel model) {
        if (this.model != null) {
            this.model.removeListDataListener(this);
        }
        model.addListDataListener(this);
        this.model = model;
        this.copyModel();
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            String[] items = new String[this.litems.size()];
            for (int i = 0; i < this.litems.size(); ++i) {
                Object o = this.litems.get(i);
                items[i] = o == null ? "" : o.toString();
                this.ppeer.add(items[i]);
            }
        }
    }

    public void addItem(final Object item) {
        if (this.litems == null) {
            this.litems = new Vector();
        }
        this.litems.add(item);
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                    JComboBox.this.ppeer.add(item.toString());
                    JComboBox.this.fixMacOffsetProblem();
                }
            }
        });
    }

    private void fixMacOffsetProblem() {
    }

    public void insertItemAt(final Object item, final int index) {
        if (this.litems == null) {
            this.litems = new Vector();
        }
        this.litems.add(index, item);
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                    JComboBox.this.ppeer.add(item.toString(), index);
                    JComboBox.this.fixMacOffsetProblem();
                }
            }
        });
    }

    public int getSelectedIndex() {
        this.retValue = null;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                    JComboBox.this.retValue = new Integer(JComboBox.this.pSelectedIndex);
                } else {
                    JComboBox.this.retValue = new Integer(JComboBox.this.ppeer.getSelectionIndex());
                }
            }
        });
        return (Integer)this.retValue;
    }

    public Object getItemAt(int index) {
        if (index == -1) {
            return null;
        }
        return this.litems.get(index);
    }

    public Component getComponent(int n) {
        return this;
    }

    public int getItemCount() {
        return this.litems.size();
    }

    public void setSelectedIndex(final int index) {
        final JComboBox me = this;
        if (this.model != null) {
            if (index != -1) {
                this.model.setSelectedItem(this.model.getElementAt(index));
            } else {
                this.model.setSelectedItem(null);
            }
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                    JComboBox.this.pSelectedIndex = index;
                } else {
                    JComboBox.this.ppeer.select(index);
                    JComboBox.this.processActionEvent(0);
                    ItemEvent ie = new ItemEvent(me, 0, JComboBox.this.getSelectedItem(), 0);
                    JComboBox.this.processItemEvent(ie);
                }
            }
        });
    }

    public void removeAllItems() {
        if (this.litems != null) {
            this.litems.removeAllElements();
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                    JComboBox.this.ppeer.removeAll();
                }
            }
        });
    }

    public void removeItem(final Object item) {
        this.litems.remove(item);
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                    JComboBox.this.ppeer.remove(item.toString());
                }
            }
        });
    }

    public void removeItemAt(final int index) {
        this.litems.remove(index);
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JComboBox.this.ppeer)) {
                    JComboBox.this.ppeer.remove(index);
                }
            }
        });
    }

    public void setEditable(boolean b) {
        this.isEditable = b;
    }

    public boolean getEditable() {
        return this.isEditable;
    }

    public int getMaximumRowCount() {
        return this.pMaxRows;
    }

    public void setMaximumRowCount(int max) {
        this.pMaxRows = max;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new Combo(parent.getComposite(), 2052);
        if (this.litems != null) {
            String[] items = new String[this.litems.size()];
            for (int i = 0; i < this.litems.size(); ++i) {
                Object o = this.litems.get(i);
                items[i] = o == null ? "" : o.toString();
                this.ppeer.add(items[i]);
            }
        }
        this.ppeer.setVisibleItemCount(this.pMaxRows);
        if (this.pSelectedIndex != -1) {
            this.ppeer.select(this.pSelectedIndex);
        } else if (this.litems != null && this.litems.size() > 0) {
            this.pSelectedIndex = 0;
            this.ppeer.select(0);
        }
        if (this.isEditable && !this.pText.equals("")) {
            this.ppeer.setText(this.pText);
        }
        this.peer = this.ppeer;
        this.parent = parent;
        this.registerComboEvents();
        this.fixMacOffsetProblem();
    }

    protected void registerComboEvents() {
        final JComboBox me = this;
        this.ppeer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JComboBox.this.ppeer.getSelectionIndex() != -1) {
                    JComboBox.this.processPopupMenuEvent(1);
                    JComboBox.this.processPopupMenuEvent(2);
                    JComboBox.this.processPopupMenuEvent(0);
                }
            }
        });
        this.ppeer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemEvent ie = new ItemEvent(me, 0, JComboBox.this.getSelectedItem(), 0);
                JComboBox.this.processItemEvent(ie);
                ChangeEvent ce = new ChangeEvent(me);
                JComboBox.this.processChangeEvent(ce);
                JComboBox.this.processActionEvent(0);
            }
        });
        this.handleComboKeyStrokes();
    }

    protected void handleComboKeyStrokes() {
        if (this.isEditable) {
            return;
        }
        this.ppeer.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                e.doit = false;
                if ((e.stateMask & 0x10000) > 0 || (e.stateMask & 0x40000) > 0) {
                    return;
                }
                int currentlySelected = JComboBox.this.getSelectedIndex();
                String curChar = "";
                String selected = "";
                if (currentlySelected != -1) {
                    selected = JComboBox.this.getSelectedItem().toString();
                }
                if (currentlySelected != -1 && selected.length() > 0) {
                    curChar = selected.substring(0, 1).toLowerCase();
                }
                boolean foundMatch = false;
                if (JComboBox.this.litems != null) {
                    for (int i = 0; i < JComboBox.this.litems.size(); ++i) {
                        String s = JComboBox.this.litems.get(i).toString();
                        if (s.length() <= 0 || !s.substring(0, 1).toLowerCase().equals(new String(new char[]{e.character}).toLowerCase())) continue;
                        if (curChar.equals(new String(new char[]{e.character}).toLowerCase())) {
                            i = currentlySelected + 1;
                        }
                        if (i >= JComboBox.this.litems.size() || !JComboBox.this.litems.get(i).toString().substring(0, 1).toLowerCase().equals(new String(new char[]{e.character}).toLowerCase())) break;
                        foundMatch = true;
                        final int matchedIndex = i;
                        SwingUtilities.invokeIn(new Runnable(){

                            public void run() {
                                JComboBox.this.setSelectedItem((this).JComboBox.this.litems.get(matchedIndex));
                            }
                        }, 1);
                        break;
                    }
                }
                if (!foundMatch) {
                    final Object selItem = JComboBox.this.getSelectedItem();
                    SwingUtilities.invokeIn(new Runnable(){

                        public void run() {
                            JComboBox.this.setSelectedItem(selItem);
                        }
                    }, 1);
                }
            }
        });
    }

    public void intervalAdded(ListDataEvent e) {
        for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
            if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) continue;
            this.addItem(this.model.getElementAt(i));
        }
    }

    public void intervalRemoved(ListDataEvent e) {
        for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
            if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) continue;
            this.removeItemAt(i);
        }
    }

    public void contentsChanged(ListDataEvent e) {
    }

    public ComboBoxEditor getEditor() {
        return new ComboBoxEditor(){

            public void addActionListener(ActionListener l) {
            }

            public Component getEditorComponent() {
                return null;
            }

            public Object getItem() {
                return null;
            }

            public void removeActionListener(ActionListener l) {
            }

            public void selectAll() {
            }

            public void setItem(Object anObject) {
            }
        };
    }

    protected void selectedItemChanged() {
    }

    public void setPrototypeDisplayValue(String proto) {
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        if (keySelectionManager != null) {
            final KeySelectionManager manager = keySelectionManager;
            final ComboBoxModel model = this.getModel();
            this.ppeer.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if ((e.stateMask & 0x10000) > 0 || (e.stateMask & 0x40000) > 0) {
                        return;
                    }
                    final int selection = manager.selectionForKey(e.character, model);
                    if (selection >= 0) {
                        SwingUtilities.invokeIn(new Runnable(){

                            public void run() {
                                JComboBox.this.setSelectedItem((this).JComboBox.this.litems.get(selection));
                            }
                        }, 1);
                    }
                }
            });
        }
    }

    public void getKeySelectionManager() {
    }

    public void setRenderer(ListCellRenderer aRenderer) {
    }

    public ActionListener[] getActionListeners() {
        int s = this.actionListeners.size();
        ActionListener[] f = new ActionListener[s];
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            f[i] = (ActionListener)this.actionListeners.elementAt(i);
        }
        return f;
    }

    public void setEditor(ComboBoxEditor editor) {
        this.editor = editor;
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }
}

