/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import swingwt.awt.Component;
import swingwt.awt.Graphics;
import swingwtx.swing.Icon;
import swingwtx.swing.SwingWTUtils;

public class ImageIcon
implements Icon {
    private String description = null;
    private swingwt.awt.Image image = null;
    private int imageLoadStatus = 0;

    public ImageIcon() {
        this.image = new swingwt.awt.Image();
    }

    public ImageIcon(swingwt.awt.Image image) {
        this.image = image;
    }

    public ImageIcon(swingwt.awt.Image image, String description) {
        this.image = image;
        this.setDescription(description);
    }

    public ImageIcon(String filename) {
        this(filename, "");
    }

    public ImageIcon(String filename, String description) {
        try {
            FileInputStream fileStream = new FileInputStream(new File(filename));
            this.image = ImageIcon.loadAWTImage(fileStream);
            fileStream.close();
            this.setDescription(description);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ImageIcon(URL location) {
        try {
            InputStream urlStream = location.openStream();
            this.image = ImageIcon.loadAWTImage(urlStream);
            urlStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ImageIcon(URL location, String description) {
        this(location);
        this.setDescription(description);
    }

    public ImageIcon(byte[] data) {
        this(data, "");
    }

    public ImageIcon(byte[] data, String description) {
        try {
            this.image = ImageIcon.loadAWTImage(new ByteArrayInputStream(data));
            this.setDescription(description);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static swingwt.awt.Image loadAWTImage(InputStream stream) {
        swingwt.awt.Image image = new swingwt.awt.Image();
        ImageData swtImageData = new ImageData(stream);
        if (swtImageData.transparentPixel != -1) {
            swtImageData.alphaData = new byte[swtImageData.width * swtImageData.height];
            int alphaIndex = 0;
            for (int y = 0; y < swtImageData.height; ++y) {
                for (int x = 0; x < swtImageData.width; ++x) {
                    int pixel = swtImageData.getPixel(x, y);
                    swtImageData.alphaData[alphaIndex] = pixel == swtImageData.transparentPixel ? 0 : -1;
                    ++alphaIndex;
                }
            }
            swtImageData.transparentPixel = -1;
        }
        image.image = new Image((Device)SwingWTUtils.getDisplay(), swtImageData);
        return image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public swingwt.awt.Image getImage() {
        return this.image;
    }

    public void setImage(swingwt.awt.Image image) {
        this.image = image;
    }

    public int getIconHeight() {
        if (this.image == null) {
            return 0;
        }
        if (this.image.image == null) {
            return 0;
        }
        return this.image.image.getBounds().height;
    }

    public int getIconWidth() {
        if (this.image == null) {
            return 0;
        }
        if (this.image.image == null) {
            return 0;
        }
        return this.image.image.getBounds().width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.image != null) {
            g.drawImage(this.image, x, y, null);
        }
    }

    public int getImageLoadStatus() {
        return 8;
    }
}

