/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Graphics;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.ItemEvent;
import swingwt.awt.event.ItemListener;
import swingwtx.swing.Action;
import swingwtx.swing.ButtonGroup;
import swingwtx.swing.ButtonModel;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JComponent;
import swingwtx.swing.JToggleButton;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public abstract class AbstractButton
extends JComponent
implements SwingConstants {
    protected Button ppeer = null;
    protected String pText = null;
    protected ButtonModel pModel;
    protected ButtonGroup pGroup;
    protected char pMnemonic = (char)32;
    protected boolean pSelection = false;
    protected int pHTextPosition = 2;
    protected int pVTextPosition = 1;
    protected int pHAlign = 2;
    protected int pVAlign = 1;
    protected Icon pIcon = null;
    protected Action pAction = null;
    protected Vector changeListeners = new Vector();
    protected Vector itemListeners = new Vector();

    public void setAction(Action a) {
        if (a == null || a.equals(this.pAction)) {
            return;
        }
        if (this.pAction != null) {
            this.removeActionListener(this.pAction);
        }
        if (a instanceof ActionListener) {
            this.addActionListener(a);
        }
        if (a.getValue("SmallIcon") != null) {
            this.setIcon((Icon)a.getValue("SmallIcon"));
        }
        if (a.getValue("Name") != null) {
            this.setText((String)a.getValue("Name"));
        }
        if (a.getValue("ShortDescription") != null) {
            this.setToolTipText((String)a.getValue("ShortDescription"));
        }
        if (a.getValue("MnemonicKey") != null) {
            this.setMnemonic((Integer)a.getValue("MnemonicKey"));
        }
        this.setEnabled(a.isEnabled());
        this.pAction = a;
    }

    protected void setAction(Action a, boolean addAsListener) {
        this.setAction(a);
        this.removeActionListener(a);
    }

    public Action getAction() {
        return this.pAction;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return this.getText();
        }
        if (this.actionCommand.equals("")) {
            return this.getText();
        }
        return this.actionCommand;
    }

    public void setIcon(Icon icon) {
    }

    public void setPressedIcon(Icon icon) {
    }

    public void setRolloverIcon(Icon icon) {
    }

    public void setRolloverSelectedIcon(Icon icon) {
    }

    public void setRolloverEnabled(boolean b) {
    }

    public boolean isRolloverEnabled() {
        return true;
    }

    public void setDisabledIcon(Icon icon) {
    }

    public void setSelectedIcon(Icon icon) {
    }

    public void setBorderPainted(boolean b) {
    }

    public void setFocusPainted(boolean b) {
    }

    public void setContentAreaFilled(boolean b) {
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void addItemListener(ItemListener l) {
        this.itemListeners.add(l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }

    protected void registerActionEvents() {
        this.ppeer.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractButton.this.processActionEvent(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setHorizontalAlignment(final int align) {
        this.pHAlign = align;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)AbstractButton.this.ppeer)) {
                    AbstractButton.this.ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(align) | SwingWTUtils.translateSwingAlignmentConstant(AbstractButton.this.pVAlign));
                }
            }
        });
    }

    public void setVerticalAlignment(final int align) {
        this.pVAlign = align;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)AbstractButton.this.ppeer)) {
                    AbstractButton.this.ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(align) | SwingWTUtils.translateSwingAlignmentConstant(AbstractButton.this.pHAlign));
                }
            }
        });
    }

    public int getHorizontalAlignment() {
        return this.pHAlign;
    }

    public int getVerticalAlignment() {
        return this.pVAlign;
    }

    public void setHorizontalTextPosition(int textpos) {
        this.setHorizontalAlignment(textpos);
    }

    public void setVerticalTextPosition(int textpos) {
        this.setVerticalAlignment(textpos);
    }

    public int getHorizontalTextPosition() {
        return this.getHorizontalAlignment();
    }

    public int getVerticalTextPosition() {
        return this.getVerticalAlignment();
    }

    public void processActionEvent(int id) {
        ActionEvent ae = new ActionEvent(this, id, this.getActionCommand());
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ActionListener al = (ActionListener)this.actionListeners.get(i);
            al.actionPerformed(ae);
        }
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ChangeListener cl = (ChangeListener)this.changeListeners.get(i);
            cl.stateChanged(ce);
        }
        this.processItemEvent();
    }

    public void processItemEvent() {
        if (this.itemListeners.size() == 0) {
            return;
        }
        boolean isSelected = this.pSelection;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            isSelected = this.ppeer.getSelection();
        }
        ItemEvent e = new ItemEvent(this, 0, this, isSelected ? 0 : 1);
        for (int i = 0; i < this.itemListeners.size(); ++i) {
            ItemListener il = (ItemListener)this.itemListeners.get(i);
            il.itemStateChanged(e);
        }
        if (isSelected && this.pGroup != null) {
            this.pGroup.setSelected(this.getModel(), true);
        }
    }

    public String getLabel() {
        return this.getText();
    }

    public void setLabel(String text) {
        this.setText(text);
    }

    public String getText() {
        return this.pText;
    }

    public void setText(String text) {
        this.pText = text;
        if (this.pText == null) {
            this.pText = "";
        }
        this.showMnemonic();
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    AbstractButton.this.ppeer.setText(AbstractButton.this.pText);
                }
            });
        }
    }

    public int getMnemonic() {
        return this.pMnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.pMnemonic = mnemonic;
        this.showMnemonic();
    }

    public void setMnemonic(int mnemonic) {
        this.pMnemonic = (char)mnemonic;
        this.showMnemonic();
    }

    protected void showMnemonic() {
        final AbstractButton me = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                String text;
                if (AbstractButton.this.pText == null) {
                    return;
                }
                if (AbstractButton.this.pText.indexOf("<") != -1) {
                    AbstractButton.this.pText = SwingWTUtils.removeHTML(AbstractButton.this.pText);
                }
                if (AbstractButton.this.pMnemonic == ' ') {
                    return;
                }
                String string = text = !SwingWTUtils.isSWTControlAvailable((Control)AbstractButton.this.ppeer) ? AbstractButton.this.pText : AbstractButton.this.ppeer.getText();
                if ((me instanceof JToggleButton || me instanceof JButton) && AbstractButton.this.pToolTipText.indexOf("(ALT+") == -1) {
                    AbstractButton.this.pToolTipText = AbstractButton.this.pToolTipText + (" (ALT+" + new String(new char[]{AbstractButton.this.pMnemonic}).toUpperCase() + ")");
                    SwingUtilities.invokeSync(new Runnable(){

                        public void run() {
                            if (SwingWTUtils.isSWTControlAvailable((this).AbstractButton.this.peer)) {
                                (this).AbstractButton.this.peer.setToolTipText(AbstractButton.this.pToolTipText);
                            }
                        }
                    });
                }
                if (text.indexOf("&") != -1) {
                    text = SwingWTUtils.replace(text, "&", "");
                }
                if (text.equals("")) {
                    AbstractButton.this.pText = "&" + new String(new char[]{AbstractButton.this.pMnemonic}).toLowerCase();
                    if (SwingWTUtils.isSWTControlAvailable((Control)AbstractButton.this.ppeer)) {
                        AbstractButton.this.ppeer.setText(text);
                    }
                } else {
                    String mn;
                    String lower = text.toLowerCase();
                    int pos = lower.indexOf(mn = new String(new char[]{AbstractButton.this.pMnemonic}).toLowerCase());
                    if (pos != -1) {
                        AbstractButton.this.pText = text = text.substring(0, pos) + "&" + text.substring(pos, text.length());
                        if (SwingWTUtils.isSWTControlAvailable((Control)AbstractButton.this.ppeer)) {
                            AbstractButton.this.ppeer.setText(text);
                        }
                    }
                }
            }
        });
    }

    public abstract boolean isSelected();

    public abstract void setSelected(boolean var1);

    public void setToolTipText(String text) {
        this.pToolTipText = text;
        if ((this instanceof JToggleButton || this instanceof JButton) && this.pMnemonic != ' ' && this.pToolTipText.indexOf("(ALT+") == -1) {
            this.pToolTipText = this.pToolTipText + " (ALT+" + new String(new char[]{this.pMnemonic}).toUpperCase() + ")";
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(AbstractButton.this.peer)) {
                    AbstractButton.this.peer.setToolTipText(AbstractButton.this.pToolTipText);
                }
            }
        });
    }

    public void setModel(ButtonModel m) {
        this.pModel = m;
    }

    public ButtonModel getModel() {
        return this.pModel;
    }

    public void setGroup(ButtonGroup g) {
        this.pGroup = g;
    }

    public void doClick() {
        this.processActionEvent(0);
    }

    public void doClick(int pressTime) {
        this.processActionEvent(0);
    }

    public ActionListener[] getActionListeners() {
        int s = this.actionListeners.size();
        ActionListener[] f = new ActionListener[s];
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            f[i] = (ActionListener)this.actionListeners.elementAt(i);
        }
        return f;
    }

    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
    }
}

