/*
 * Decompiled with CFR 0.152.
 */
package swingwt.classloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import swingwt.classloader.SwingTransformer;

public class SwingWTClassLoader
extends URLClassLoader {
    protected static SwingWTClassLoader classLoader;
    protected boolean isSearching;
    protected ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    protected Hashtable transformedClasses = new Hashtable();

    public static SwingWTClassLoader getInstance() {
        if (classLoader == null) {
            classLoader = new SwingWTClassLoader();
        }
        if (Thread.currentThread().getContextClassLoader() != classLoader) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return classLoader;
    }

    protected SwingWTClassLoader() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
    }

    public Class findClass(String name) throws ClassNotFoundException {
        String fileName = name.replace('.', '/').concat(".class");
        URL resource = this.parentClassLoader.getResource(fileName);
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return this.transform(name, resource);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    private boolean skipClass(String name) {
        return name.endsWith("SwingTransformer") || name.endsWith("ClassLoader") || name.startsWith(SwingTransformer.MY_PACKAGE_PATH) || name.startsWith("java") || name.startsWith("sun.") || name.startsWith("org.xml.sax") || name.startsWith("org.w3c") || name.startsWith("org.apache") && !name.startsWith("org.apache.batik");
    }

    private Class transform(String name, URL resource) throws IOException, ClassFormatError {
        InputStream openStream = resource.openStream();
        ClassParser parser = new ClassParser(openStream, name);
        JavaClass javaClass = parser.parse();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new SwingTransformer().transform(javaClass).dump((OutputStream)byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return this.defineClass(name, byteArray, 0, byteArray.length);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object definedClass = this.transformedClasses.get(name);
        if (this.skipClass(name)) {
            return this.parentClassLoader.loadClass(name);
        }
        if (definedClass != null) {
            return (Class)definedClass;
        }
        Class foundClass = this.findClass(name);
        this.transformedClasses.put(name, foundClass);
        return foundClass;
    }
}

