/*
 * Decompiled with CFR 0.152.
 */
package swingwt.classloader;

import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.commons.lang.StringUtils;
import swingwt.classloader.SwingWTClassLoader;

public class SwingTransformer
extends EmptyVisitor {
    public static String MY_PACKAGE_PATH = SwingTransformer.updatePackage("swingwt");
    public static String MY_AWT_PATH;
    public static String MY_SWING_PATH;
    public static String MY_AWT_PACKAGE;
    public static String MY_SWING_PACKAGE;
    public static final String AWT_PATH = "java/awt/";
    public static final String SWING_PATH = "javax/swing/";
    public static final String AWT_PACKAGE = "java.awt.";
    public static final String SWING_PACKAGE = "javax.swing.";
    private InstructionHandle instructionHandle;
    private boolean changed;
    private Instruction instruction;
    private InstructionFactory factory;
    private ConstantPoolGen constantPoolGen;

    public JavaClass transform(JavaClass javaClass) {
        String superclassName = javaClass.getSuperclassName();
        if (this.isSwingAwtClass(superclassName)) {
            javaClass.setSuperclassName(SwingTransformer.transformSwingClassName(superclassName));
        }
        javaClass.setInterfaceNames(this.transformInterfaces(javaClass.getInterfaceNames()));
        ClassGen classGen = new ClassGen(javaClass);
        this.constantPoolGen = classGen.getConstantPool();
        this.factory = new InstructionFactory(classGen);
        this.transformConstants();
        Method[] methods = classGen.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.changed = false;
            Method method = methods[i];
            Code code = method.getCode();
            if (code != null) {
                InstructionList instructionList = new InstructionList(code.getCode());
                this.instructionHandle = instructionList.getStart();
                while (this.instructionHandle != null) {
                    this.instruction = this.instructionHandle.getInstruction();
                    this.instruction.accept((Visitor)this);
                    this.instructionHandle = this.instructionHandle.getNext();
                }
                if (this.changed) {
                    code.setCode(instructionList.getByteCode());
                }
            }
            MethodGen methodGen = new MethodGen(method, javaClass.getClassName(), this.constantPoolGen);
            methodGen.setReturnType(this.trasformSwingReference(method.getReturnType()));
            methods[i] = methodGen.getMethod();
            javaClass.setMethods(methods);
        }
        javaClass.setConstantPool(this.constantPoolGen.getFinalConstantPool());
        return javaClass;
    }

    private String[] transformInterfaces(String[] aStrings) {
        for (int i = 0; i < aStrings.length; ++i) {
            aStrings[i] = SwingTransformer.transformSwingClassName(aStrings[i]);
        }
        return aStrings;
    }

    public void visitNEW(NEW obj) {
        NEW aNew = (NEW)this.instruction;
        NEW createInvoke = this.factory.createNew(new ObjectType(SwingTransformer.replaceSwing(aNew.getLoadClassType(this.constantPoolGen).getClassName())));
        this.instructionHandle.setInstruction((Instruction)createInvoke);
        this.changed = true;
    }

    private static String replaceSwing(String string) {
        string = StringUtils.replace((String)StringUtils.replace((String)string, (String)SWING_PACKAGE, (String)MY_SWING_PACKAGE), (String)SWING_PATH, (String)MY_SWING_PATH);
        return string;
    }

    private static String replaceAwt(String string) {
        string = StringUtils.replace((String)StringUtils.replace((String)string, (String)AWT_PACKAGE, (String)MY_AWT_PACKAGE), (String)AWT_PATH, (String)MY_AWT_PATH);
        return string;
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.changed = this.transformInvoke((InvokeInstruction)obj, (short)182);
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.changed = this.transformInvoke((InvokeInstruction)obj, (short)183);
    }

    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        InvokeInstruction iv = (InvokeInstruction)this.instruction;
        String methodName = iv.getMethodName(this.constantPoolGen);
        if (methodName.equals("forName")) {
            this.instructionHandle.setInstruction((Instruction)this.factory.createInvoke(((Object)((Object)this)).getClass().getName(), "forNameChanged", iv.getReturnType(this.constantPoolGen), iv.getArgumentTypes(this.constantPoolGen), (short)184));
            this.changed = true;
        } else {
            this.changed = this.transformInvoke((InvokeInstruction)obj, (short)184);
        }
    }

    private boolean isSwingAwtClass(String methodClassName) {
        return methodClassName.startsWith(SWING_PACKAGE) || methodClassName.startsWith(AWT_PACKAGE);
    }

    private void transformConstants() {
        for (int i = 0; i < this.constantPoolGen.getSize(); ++i) {
            Constant constant = this.constantPoolGen.getConstant(i);
            if (!(constant instanceof ConstantUtf8)) continue;
            ConstantUtf8 utf8 = (ConstantUtf8)constant;
            utf8.setBytes(SwingTransformer.transformSwingClassName(utf8.getBytes()));
        }
    }

    private boolean transformInvoke(InvokeInstruction iv, short invokeType) {
        String methodClassName = iv.getClassName(this.constantPoolGen);
        if (this.isSwingAwtClass(methodClassName)) {
            methodClassName = SwingTransformer.transformSwingClassName(methodClassName);
            Type returnType = this.trasformSwingReference(iv.getReturnType(this.constantPoolGen));
            Type[] argumentTypes = iv.getArgumentTypes(this.constantPoolGen);
            for (int j = 0; j < argumentTypes.length; ++j) {
                argumentTypes[j] = this.trasformSwingReference(argumentTypes[j]);
            }
            InvokeInstruction createInvoke = this.factory.createInvoke(methodClassName, iv.getMethodName(this.constantPoolGen), returnType, argumentTypes, invokeType);
            this.instructionHandle.setInstruction((Instruction)createInvoke);
            this.changed = true;
        }
        return this.changed;
    }

    public static String transformSwingClassName(String methodClassName) {
        methodClassName = SwingTransformer.replaceAwt(methodClassName);
        methodClassName = SwingTransformer.replaceSwing(methodClassName);
        return methodClassName;
    }

    private Type trasformSwingReference(Type returnType) {
        if (returnType instanceof ObjectType) {
            returnType = new ObjectType(SwingTransformer.transformSwingClassName(((ObjectType)returnType).getClassName()));
        }
        return returnType;
    }

    public static Class forNameChanged(String aString, boolean initIgnored, ClassLoader ignored) throws ClassNotFoundException {
        return SwingWTClassLoader.getInstance().loadClass(SwingTransformer.transformSwingClassName(aString));
    }

    public static Class forNameChanged(String aString) throws ClassNotFoundException {
        return SwingWTClassLoader.getInstance().loadClass(SwingTransformer.transformSwingClassName(aString));
    }

    public void visitINSTANCEOF(INSTANCEOF anIo) {
        INSTANCEOF createdInstanceOf = this.factory.createInstanceOf((ReferenceType)this.trasformSwingReference(anIo.getType(this.constantPoolGen)));
        this.instructionHandle.setInstruction((Instruction)createdInstanceOf);
        this.changed = true;
    }

    public static String updatePackage(String aNewPackage) {
        MY_PACKAGE_PATH = aNewPackage;
        MY_AWT_PATH = MY_PACKAGE_PATH + "/awt/";
        MY_SWING_PATH = MY_PACKAGE_PATH + "x/swing/";
        MY_AWT_PACKAGE = MY_PACKAGE_PATH + ".awt.";
        MY_SWING_PACKAGE = MY_PACKAGE_PATH + "x.swing.";
        return aNewPackage;
    }
}

