/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt.geom;

import swingwt.awt.geom.AffineTransform;
import swingwt.awt.geom.Line2D;
import swingwt.awt.geom.PathIterator;
import swingwt.awt.geom.Point2D;
import swingwt.awt.geom.RectangularShape;

public abstract class Rectangle2D
extends RectangularShape
implements Cloneable {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D r) {
        this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        return false;
    }

    public boolean intersectsLine(Line2D l) {
        return false;
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D p) {
        return 0;
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setRect(x, y, w, h);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.clone();
    }

    public boolean contains(double x, double y) {
        double x0 = this.getX();
        double y0 = this.getY();
        return x >= x0 && y >= y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    public boolean intersects(double x, double y, double w, double h) {
        double x0 = this.getX();
        double y0 = this.getY();
        return w > 0.0 && h > 0.0 && this.getWidth() > 0.0 && this.getHeight() > 0.0 && x < x0 + this.getWidth() && x + w > x0 && y < y0 + this.getHeight() && y + h > y0;
    }

    public boolean contains(double x, double y, double w, double h) {
        double x0 = this.getX();
        double y0 = this.getY();
        return w > 0.0 && h > 0.0 && this.getWidth() > 0.0 && this.getHeight() > 0.0 && x >= x0 && x + w <= x0 + this.getWidth() && y >= y0 && y + h <= y0 + this.getHeight();
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D src1, Rectangle2D src2, Rectangle2D dest) {
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D src1, Rectangle2D src2, Rectangle2D dest) {
        double x = Math.min(src1.getX(), src2.getX());
        double y = Math.min(src1.getY(), src2.getY());
        dest.setRect(x, y, Math.max(src1.getMaxX(), src2.getMaxX()) - x, Math.max(src1.getMaxY(), src2.getMaxY()) - y);
    }

    public void add(double newx, double newy) {
    }

    public void add(Point2D pt) {
    }

    public void add(Rectangle2D r) {
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return null;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle2D) {
            Rectangle2D r2d = (Rectangle2D)obj;
            return this.getX() == r2d.getX() && this.getY() == r2d.getY() && this.getWidth() == r2d.getWidth() && this.getHeight() == r2d.getHeight();
        }
        return false;
    }

    public abstract double getHeight();

    public abstract double getWidth();

    public abstract double getX();

    public abstract double getY();

    public abstract boolean isEmpty();

    public static class Float
    extends Rectangle2D
    implements Cloneable {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float x, float y, float w, float h) {
            this.setRect(x, y, w, h);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public void setRect(double x, double y, double w, double h) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
        }

        public void setRect(Rectangle2D r) {
            this.x = (float)r.getX();
            this.y = (float)r.getY();
            this.width = (float)r.getWidth();
            this.height = (float)r.getHeight();
        }

        public int outcode(double x, double y) {
            return 0;
        }

        public Rectangle2D createIntersection(Rectangle2D r) {
            Float retval = new Float();
            Float.intersect(this, r, retval);
            return retval;
        }

        public Rectangle2D createUnion(Rectangle2D r) {
            Float retval = new Float();
            Float.union(this, r, retval);
            return retval;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Double
    extends Rectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double x, double y, double w, double h) {
            this.setRect(x, y, w, h);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public void setRect(Rectangle2D r) {
            this.x = r.getX();
            this.y = r.getY();
            this.width = r.getWidth();
            this.height = r.getHeight();
        }

        public int outcode(double x, double y) {
            return 0;
        }

        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D r) {
            Double retval = new Double();
            Double.intersect(this, r, retval);
            return retval;
        }

        public Rectangle2D createUnion(Rectangle2D r) {
            Double retval = new Double();
            Double.union(this, r, retval);
            return retval;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }
}

