/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt.event;

import java.io.Serializable;
import swingwt.awt.Component;
import swingwt.awt.Point;
import swingwt.awt.event.InputEvent;

public class MouseEvent
extends InputEvent
implements Serializable {
    public static final int NOBUTTON = 0;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int BUTTON1_MASK = 1;
    public static final int BUTTON2_MASK = 2;
    public static final int BUTTON3_MASK = 3;
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 507;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    public int clickCount = 1;
    private int button = 0;
    private int x = 0;
    private int y = 0;
    private boolean popupTrigger = false;

    public MouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
        this(source, id, when, modifiers, x, y, clickCount, popupTrigger, 0);
    }

    public MouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger, int button) {
        super(source, id, when, modifiers);
        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.popupTrigger = popupTrigger;
        this.button = button;
    }

    public MouseEvent(Component source) {
        super(source);
    }

    public void setID(int id) {
        this.eventID = id;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isPopupTrigger() {
        return this.button == 3;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public void translatePoint(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public int translateSWTButton(int swtButton) {
        int ret = 0;
        if ((swtButton & 0x80000) > 0) {
            ret |= 1;
        }
        if ((swtButton & 0x100000) > 0) {
            ret |= 2;
        }
        if ((swtButton & 0x200000) > 0) {
            ret |= 3;
        }
        return ret;
    }

    public static int getModifiersFromButtons(int button, int swtStateMask) {
        int mods = 0;
        switch (button) {
            case 1: {
                mods += 1024;
            }
            case 2: {
                mods += 2048;
            }
            case 3: {
                mods += 4096;
            }
        }
        if ((swtStateMask & 0x40000) > 0) {
            mods += 128;
        }
        if ((swtStateMask & 0x10000) > 0) {
            mods += 512;
        }
        if ((swtStateMask & 0x20000) > 0) {
            mods += 64;
        }
        return mods;
    }

    public static int getModifiersFromSWTMask(int swtMask) {
        int ret = 0;
        if ((swtMask & 0x80000) > 0) {
            ret |= 0x400;
        }
        if ((swtMask & 0x100000) > 0) {
            ret |= 0x800;
        }
        if ((swtMask & 0x200000) > 0) {
            ret |= 0x1000;
        }
        return ret;
    }
}

