/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Hashtable;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import swingwt.awt.image.ColorModel;
import swingwt.awt.image.ImageConsumer;

class SWTImageConsumer
implements ImageConsumer {
    public ImageData imageData = null;
    public boolean imageComplete = false;
    ColorModel colorModel = null;

    SWTImageConsumer() {
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void imageComplete(int status) {
        this.imageComplete = true;
    }

    public void setColorModel(ColorModel model) {
        this.colorModel = model;
    }

    public void setDimensions(int width, int height) {
        if (this.imageData != null) {
            throw new IllegalStateException("already have image data, data might be lost");
        }
        this.imageData = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
        if (this.colorModel != null && this.colorModel.getTransparency() == 3) {
            this.imageData.alphaData = new byte[width * height];
            this.imageData.transparentPixel = -1;
        }
    }

    public void setHints(int hintflags) {
    }

    public void setProperties(Hashtable props) {
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (this.imageData == null) {
            this.imageData = new ImageData(x + w, y + h, model.getPixelSize(), new PaletteData(0xFF0000, 65280, 255));
        } else if (x + w > this.imageData.width || y + h > this.imageData.height) {
            throw new IllegalStateException("already have image data, data might be lost");
        }
        this.imageData.setPixels(x, y, w * h, pixels, 0);
        if (model != null && model.getTransparency() == 3) {
            int size = (x + w) * (y + h);
            if (this.imageData.alphaData == null) {
                this.imageData.alphaData = new byte[size];
            }
            for (int inRow = 0; inRow < h; ++inRow) {
                int outRowIndex = (y + inRow) * this.imageData.width;
                int inRowIndex = inRow * scansize + off;
                for (int inCol = 0; inCol < w; ++inCol) {
                    this.imageData.alphaData[outRowIndex + inCol + x] = (byte)model.getAlpha(pixels[inRowIndex + inCol]);
                }
            }
            this.imageData.transparentPixel = -1;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        this.imageData = new ImageData(w, h, 16, new PaletteData(255, 255, 255), scansize, pixels);
    }
}

